/*
 * The MIT License (MIT)
 *
 * Copyright (c) 1998-2015 Aspose Pty Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.aspose.examples;

import com.aspose.utils.AsposeMavenProjectManager;
import com.aspose.utils.AsposeWordsJavaAPI;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

import java.util.ResourceBundle;

/**
 * Created by Adeel Ilyas on 8/17/2015.
 */
public class AsposeExampleAction extends AnAction implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final  Project project = getEventProject(e);
        if (project == null) {
            return;
        }
        ResourceBundle bundle = ResourceBundle.getBundle("Bundle");
        AsposeMavenProjectManager asposeMavenProjectManager = AsposeMavenProjectManager.initialize(project);
        AsposeWordsJavaAPI.initialize(asposeMavenProjectManager);
        final AsposeExampleDialog dialog = new AsposeExampleDialog(bundle.getString("AsposeExamples.title"),bundle.getString("AsposeExamples.message"));
        dialog.show();
    }


}
