package DocsExamples.File_formats_and_conversions;

import DocsExamples.DocsExamplesBase;
import com.aspose.email.*;
import com.aspose.words.*;
import org.apache.commons.io.FileUtils;
import org.testng.annotations.Test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;

@Test
public class BaseConversions extends DocsExamplesBase {
    @Test
    public void docToDocx() throws Exception {
        //ExStart:LoadAndSave
        //GistId:9d2a393f6dff9d785e7747a48e590d9d
        Document doc = new Document(getMyDir() + "Document.doc");

        doc.save(getArtifactsDir() + "BaseConversions.DocToDocx.docx");
        //ExEnd:LoadAndSave
    }

    @Test
    public void docxToRtf() throws Exception {
        //ExStart:LoadAndSaveToStream
        //GistId:9d2a393f6dff9d785e7747a48e590d9d
        //ExStart:OpenFromStream
        //GistId:ae20848f6cefd3f85ab9bcbbdda340c7
        // Read only access is enough for Aspose.Words to load a document.
        FileInputStream stream = new FileInputStream(getMyDir() + "Document.docx");

        Document doc = new Document(stream);
        // You can close the stream now, it is no longer needed because the document is in memory.
        stream.close();
        //ExEnd:OpenFromStream

        // ... do something with the document.

        // Convert the document to a different format and save to stream.
        ByteArrayOutputStream dstStream = new ByteArrayOutputStream();
        doc.save(dstStream, SaveFormat.RTF);
        //ExEnd:LoadAndSaveToStream

        FileUtils.writeByteArrayToFile(new File(getArtifactsDir() + "BaseConversions.DocxToRtf.rtf"), dstStream.toByteArray());
    }

    @Test
    public void docxToPdf() throws Exception {
        //ExStart:DocxToPdf
        //GistId:b237846932dfcde42358bd0c887661a5
        Document doc = new Document(getMyDir() + "Document.docx");
        doc.save(getArtifactsDir() + "BaseConversions.DocxToPdf.pdf");
        //ExEnd:DocxToPdf
    }

    @Test
    public void docxToByte() throws Exception {
        //ExStart:DocxToByte
        //GistId:86d59d944009f305e7e24b3e276cd17d
        Document doc = new Document(getMyDir() + "Document.docx");

        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        doc.save(outStream, SaveFormat.DOCX);

        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());

        Document docFromBytes = new Document(inStream);
        //ExEnd:DocxToByte
    }

    @Test
    public void docxToEpub() throws Exception {
        //ExStart:DocxToEpub
        Document doc = new Document(getMyDir() + "Document.docx");

        doc.save(getArtifactsDir() + "BaseConversions.DocxToEpub.epub");
        //ExEnd:DocxToEpub
    }

    @Test
    public void docxToHtml() throws Exception {
        //ExStart:DocxToHtml
        //GistId:c2ec8aa36ef37670eceec8da5c612b86
        Document doc = new Document(getMyDir() + "Document.docx");

        doc.save(getArtifactsDir() + "BaseConversions.DocxToHtml.html");
        //ExEnd:DocxToHtml
    }

    @Test(enabled = false, description = "Only for example")
    public void docxToMhtml() throws Exception {
        //ExStart:DocxToMhtml
        //GistId:1bcfd5d0ec402f0f54cd747eb22d8da5
        Document doc = new Document(getMyDir() + "Document.docx");

        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        doc.save(outStream, SaveFormat.MHTML);

        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());

        // Create an Aspose.Network MIME email message from the stream.
        MailMessage message = MailMessage.load(inStream, new MhtmlLoadOptions());
        message.setFrom(MailAddress.to_MailAddress("your_from@email.com"));
        message.setTo(MailAddressCollection.to_MailAddressCollection(MailAddress.to_MailAddress("your_to@email.com")));
        message.setSubject("Aspose.Words + Aspose.Email MHTML Test Message");

        // Send the message using Aspose.Email.
        SmtpClient client = new SmtpClient();
        client.setHost("your_smtp.com");
        client.send(message);
        //ExEnd:DocxToMhtml
    }

    @Test
    public void docxToMarkdown() throws Exception {
        //ExStart:DocxToMarkdown
        //GistId:642767bbe8d8bec8eab080120b707990
        Document doc = new Document();
        DocumentBuilder builder = new DocumentBuilder(doc);

        builder.writeln("Some text!");

        doc.save(getArtifactsDir() + "BaseConversions.DocxToMarkdown.md");
        //ExEnd:DocxToMarkdown
    }

    @Test
    public void docxToTxt() throws Exception {
        //ExStart:DocxToTxt
        //GistId:1975a35426bcd195a2e7c61d20a1580c
        Document doc = new Document(getMyDir() + "Document.docx");
        doc.save(getArtifactsDir() + "BaseConversions.DocxToTxt.txt");
        //ExEnd:DocxToTxt
    }

    @Test
    public void docxToXlsx() throws Exception {
        //ExStart:DocxToXlsx
        //GistId:82fb3ee435d5abdc1472a58774ebe98c
        Document doc = new Document(getMyDir() + "Document.docx");
        doc.save(getArtifactsDir() + "BaseConversions.DocxToXlsx.xlsx");
        //ExEnd:DocxToXlsx
    }

    @Test
    public void txtToDocx() throws Exception {
        //ExStart:TxtToDocx
        // The encoding of the text file is automatically detected.
        Document doc = new Document(getMyDir() + "English text.txt");
        doc.save(getArtifactsDir() + "BaseConversions.TxtToDocx.docx");
        //ExEnd:TxtToDocx
    }

    @Test
    public void DocxToJpeg() throws Exception {
        //ExStart:DocxToJpeg
        //GistId:b237846932dfcde42358bd0c887661a5
        Document doc = new Document(getMyDir() + "Document.docx");
        doc.save(getArtifactsDir() + "BaseConversions.DocxToJpeg.jpeg");
        //ExEnd:DocxToJpeg
    }

    @Test
    public void findReplaceXlsx() throws Exception {
        //ExStart:FindReplaceXlsx
        //GistId:50971daf8f0c9ef4b0250c4a526b1652
        Document doc = new Document();
        DocumentBuilder builder = new DocumentBuilder(doc);

        builder.writeln("Ruby bought a ruby necklace.");

        // We can use a "FindReplaceOptions" object to modify the find-and-replace process.
        FindReplaceOptions options = new FindReplaceOptions();

        // Set the "MatchCase" flag to "true" to apply case sensitivity while finding strings to replace.
        // Set the "MatchCase" flag to "false" to ignore character case while searching for text to replace.
        options.setMatchCase(true);

        doc.getRange().replace("Ruby", "Jade", options);

        doc.save(getArtifactsDir() + "BaseConversions.FindReplaceXlsx.xlsx");
        //ExEnd:FindReplaceXlsx
    }

    @Test
    public void compressXlsx() throws Exception {
        //ExStart:CompressXlsx
        //GistId:50971daf8f0c9ef4b0250c4a526b1652
        Document doc = new Document(getMyDir() + "Document.docx");

        XlsxSaveOptions saveOptions = new XlsxSaveOptions();
        saveOptions.setCompressionLevel(CompressionLevel.MAXIMUM);

        doc.save(getArtifactsDir() + "BaseConversions.CompressXlsx.xlsx", saveOptions);
        //ExEnd:CompressXlsx
    }

    @Test
    public void imagesToPdf() throws Exception {
        //ExStart:ImageToPdf
        //GistId:b237846932dfcde42358bd0c887661a5
        convertImageToPdf(getImagesDir() + "Logo.jpg", getArtifactsDir() + "BaseConversions.JpgToPdf.pdf");
        convertImageToPdf(getImagesDir() + "Transparent background logo.png", getArtifactsDir() + "BaseConversions.PngToPdf.pdf");
        convertImageToPdf(getImagesDir() + "Windows MetaFile.wmf", getArtifactsDir() + "BaseConversions.WmfToPdf.pdf");
        convertImageToPdf(getImagesDir() + "Tagged Image File Format.tiff", getArtifactsDir() + "BaseConversions.TiffToPdf.pdf");
        convertImageToPdf(getImagesDir() + "Graphics Interchange Format.gif", getArtifactsDir() + "BaseConversions.GifToPdf.pdf");
        //ExEnd:ImageToPdf
    }

    //ExStart:ConvertImageToPdf
    //GistId:b237846932dfcde42358bd0c887661a5

    /**
     * Converts an image to PDF using Aspose.Words for Java.
     *
     * @param inputFileName  File name of input image file.
     * @param outputFileName Output PDF file name.
     * @throws Exception
     */
    private void convertImageToPdf(String inputFileName, String outputFileName) throws Exception {
        // Create Aspose.Words.Document and DocumentBuilder.
        // The builder makes it simple to add content to the document.
        Document doc = new Document();
        DocumentBuilder builder = new DocumentBuilder(doc);

        // Insert the image into the document and position it at the top left corner of the page.
        Shape image = builder.insertImage(inputFileName);
        image.setRelativeHorizontalPosition(RelativeHorizontalPosition.PAGE);
        image.setRelativeVerticalPosition(RelativeVerticalPosition.PAGE);
        image.setLeft(0);
        image.setTop(0);
        image.setWrapType(WrapType.NONE);

        // We want the size of the page to be the same as the size of the image.
        // Convert pixels to points to size the page to the actual image size.
        PageSetup ps = builder.getPageSetup();
        ps.setPageWidth(image.getWidth());
        ps.setPageHeight(image.getHeight());

        doc.save(outputFileName);
    }
    //ExEnd:ConvertImageToPdf
}
