/*
 * Copyright 2001-2014 Aspose Pty Ltd. All Rights Reserved.
 *
 * This file is part of Aspose.Words. The source code in this file
 * is only intended as a supplement to the documentation, and is provided
 * "as is", without warranty of any kind, either expressed or implied.
 */
package DocsExamples.Document_explorer;

import java.io.File;

public class MainForm extends javax.swing.JFrame {

    /**
     * Creates new form FrameTemplate
     */
    public MainForm() {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(MainForm.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        treeScrollPane = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        textArea = new javax.swing.JTextPane();
        jToolBar1 = new javax.swing.JToolBar();
        toolOpenDocument = new javax.swing.JButton();
        toolSaveAs = new javax.swing.JButton();
        toolExpandAll = new javax.swing.JButton();
        toolCollapseAll = new javax.swing.JButton();
        toolRemove = new javax.swing.JButton();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        menuOpen = new javax.swing.JMenuItem();
        menuSaveAs = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        menuExit = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        menuRemoveNode = new javax.swing.JMenuItem();
        jMenu3 = new javax.swing.JMenu();
        menuExpandAll = new javax.swing.JMenuItem();
        menuCollapseAll = new javax.swing.JMenuItem();
        jMenu4 = new javax.swing.JMenu();
        menuAbout = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Document Explorer");
        setIconImages(null);
        setModalExclusionType(java.awt.Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        setName("DocumentExplorer"); // NOI18N
        setPreferredSize(new java.awt.Dimension(800, 600));

        treeScrollPane.setBackground(new java.awt.Color(255, 255, 255));
        treeScrollPane.setAutoscrolls(true);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
                jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 0, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
                jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 0, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
                jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 604, Short.MAX_VALUE)
        );
        jPanel4Layout.setVerticalGroup(
                jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 31, Short.MAX_VALUE)
        );

        textArea.setEditable(false);
        jScrollPane1.setViewportView(textArea);

        jToolBar1.setRollover(true);

        String imgPath = Utils.getDataDir() + "Document explorer images" + File.separator;
        System.out.println("image path: " + imgPath);

        toolOpenDocument.setIcon(new javax.swing.ImageIcon(imgPath + "tlb_1.gif")); // NOI18N
        toolOpenDocument.setFocusable(false);
        toolOpenDocument.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        toolOpenDocument.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(toolOpenDocument);

        toolSaveAs.setIcon(new javax.swing.ImageIcon(imgPath + "tlb_2.gif")); // NOI18N
        toolSaveAs.setEnabled(false);
        toolSaveAs.setFocusable(false);
        toolSaveAs.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        toolSaveAs.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(toolSaveAs);

        toolExpandAll.setIcon(new javax.swing.ImageIcon(imgPath + "tlb_3.gif")); // NOI18N
        toolExpandAll.setEnabled(false);
        toolExpandAll.setFocusable(false);
        toolExpandAll.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        toolExpandAll.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(toolExpandAll);

        toolCollapseAll.setIcon(new javax.swing.ImageIcon(imgPath + "tlb_4.gif")); // NOI18N
        toolCollapseAll.setEnabled(false);
        toolCollapseAll.setFocusable(false);
        toolCollapseAll.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        toolCollapseAll.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(toolCollapseAll);

        toolRemove.setIcon(new javax.swing.ImageIcon(imgPath + "tlb_5.gif")); // NOI18N
        toolRemove.setEnabled(false);
        toolRemove.setFocusable(false);
        toolRemove.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        toolRemove.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(toolRemove);

        jMenu1.setMnemonic('F');
        jMenu1.setText("File");

        menuOpen.setMnemonic('O');
        menuOpen.setText("Open");
        jMenu1.add(menuOpen);

        menuSaveAs.setMnemonic('A');
        menuSaveAs.setText("Save As");
        menuSaveAs.setEnabled(false);
        jMenu1.add(menuSaveAs);
        jMenu1.add(jSeparator1);

        menuExit.setMnemonic('X');
        menuExit.setText("Exit");
        jMenu1.add(menuExit);

        jMenuBar1.add(jMenu1);

        jMenu2.setMnemonic('E');
        jMenu2.setText("Edit");

        menuRemoveNode.setText("Remove Node");
        menuRemoveNode.setEnabled(false);
        jMenu2.add(menuRemoveNode);

        jMenuBar1.add(jMenu2);

        jMenu3.setMnemonic('V');
        jMenu3.setText("View");

        menuExpandAll.setMnemonic('E');
        menuExpandAll.setText("Expand All");
        menuExpandAll.setEnabled(false);
        jMenu3.add(menuExpandAll);

        menuCollapseAll.setMnemonic('C');
        menuCollapseAll.setText("Collapse All");
        menuCollapseAll.setEnabled(false);
        jMenu3.add(menuCollapseAll);

        jMenuBar1.add(jMenu3);

        jMenu4.setMnemonic('H');
        jMenu4.setText("Help");

        menuAbout.setMnemonic('A');
        menuAbout.setText("About");
        jMenu4.add(menuAbout);

        jMenuBar1.add(jMenu4);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGap(316, 316, 316)
                                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(layout.createSequentialGroup()
                                                .addGap(15, 15, 15)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addGroup(layout.createSequentialGroup()
                                                                .addComponent(treeScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 209, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                                .addGap(18, 18, 18)
                                                                .addComponent(jScrollPane1))
                                                        .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                                .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                                .addGap(0, 0, 0)))
                                .addContainerGap())
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 34, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(17, 17, 17)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(treeScrollPane)
                                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 135, Short.MAX_VALUE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(0, 0, 0))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenu jMenu4;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JPanel jPanel1;
    protected javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JToolBar jToolBar1;
    protected javax.swing.JMenuItem menuAbout;
    protected javax.swing.JMenuItem menuCollapseAll;
    protected javax.swing.JMenuItem menuExit;
    protected javax.swing.JMenuItem menuExpandAll;
    protected javax.swing.JMenuItem menuOpen;
    protected javax.swing.JMenuItem menuRemoveNode;
    protected javax.swing.JMenuItem menuSaveAs;
    protected javax.swing.JTextPane textArea;
    protected javax.swing.JButton toolCollapseAll;
    protected javax.swing.JButton toolExpandAll;
    protected javax.swing.JButton toolOpenDocument;
    protected javax.swing.JButton toolRemove;
    protected javax.swing.JButton toolSaveAs;
    protected javax.swing.JScrollPane treeScrollPane;
    // End of variables declaration//GEN-END:variables
}
