package Examples;

//////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2025 Aspose Pty Ltd. All Rights Reserved.
//
// This file is part of Aspose.Words. The source code in this file
// is only intended as a supplement to the documentation, and is provided
// "as is", without warranty of any kind, either expressed or implied.
//////////////////////////////////////////////////////////////////////////

import com.aspose.words.*;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class ExAbsolutePositionTab extends ApiExampleBase {
    //ExStart
    //ExFor:AbsolutePositionTab
    //ExFor:AbsolutePositionTab.Accept(DocumentVisitor)
    //ExFor:DocumentVisitor.VisitAbsolutePositionTab
    //ExFor:Body.Accept(DocumentVisitor)
    //ExFor:Body.AcceptStart(DocumentVisitor)
    //ExFor:Body.AcceptEnd(DocumentVisitor)
    //ExFor:VisitorAction
    //ExSummary:Shows how to process absolute position tab characters with a document visitor.
    @Test //ExSkip
    public void documentToTxt() throws Exception {
        Document doc = new Document(getMyDir() + "Absolute position tab.docx");

        // Extract the text contents of our document by accepting this custom document visitor.
        DocTextExtractor myDocTextExtractor = new DocTextExtractor();
        Section fisrtSection = doc.getFirstSection();
        fisrtSection.getBody().accept(myDocTextExtractor);
        // Visit only start of the document body.
        fisrtSection.getBody().acceptStart(myDocTextExtractor);
        // Visit only end of the document body.
        fisrtSection.getBody().acceptEnd(myDocTextExtractor);

        // The absolute position tab, which has no equivalent in string form, has been explicitly converted to a tab character.
        Assert.assertEquals("Before AbsolutePositionTab\tAfter AbsolutePositionTab", myDocTextExtractor.getText());

        // An AbsolutePositionTab can accept a DocumentVisitor by itself too.
        AbsolutePositionTab absPositionTab = (AbsolutePositionTab) doc.getFirstSection().getBody().getFirstParagraph().getChild(NodeType.SPECIAL_CHAR, 0, true);

        myDocTextExtractor = new DocTextExtractor();
        absPositionTab.accept(myDocTextExtractor);

        Assert.assertEquals("\t", myDocTextExtractor.getText());
    }

    /// <summary>
    /// Collects the text contents of all runs in the visited document. Replaces all absolute tab characters with ordinary tabs.
    /// </summary>
    public static class DocTextExtractor extends DocumentVisitor {
        public DocTextExtractor() {
            mBuilder = new StringBuilder();
        }

        /// <summary>
        /// Called when a Run node is encountered in the document.
        /// </summary>
        public int visitRun(final Run run) {
            appendText(run.getText());
            return VisitorAction.CONTINUE;
        }

        /// <summary>
        /// Called when an AbsolutePositionTab node is encountered in the document.
        /// </summary>
        public int visitAbsolutePositionTab(final AbsolutePositionTab tab) {
            mBuilder.append("\t");

            return VisitorAction.CONTINUE;
        }

        /// <summary>
        /// Adds text to the current output. Honors the enabled/disabled output flag.
        /// </summary>
        public void appendText(final String text) {
            mBuilder.append(text);
        }

        /// <summary>
        /// Plain text of the document that was accumulated by the visitor.
        /// </summary>
        public String getText() {
            return mBuilder.toString();
        }

        private final StringBuilder mBuilder;
    }
    //ExEnd
}
