<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# v1

```go
import "github.com/slok/sloth/pkg/prometheus/alertwindows/v1"
```

## Index

- [Constants](<#constants>)
- [type AlertWindows](<#AlertWindows>)
- [type PageWindow](<#PageWindow>)
- [type QuickSlowWindow](<#QuickSlowWindow>)
- [type Spec](<#Spec>)
- [type TicketWindow](<#TicketWindow>)
- [type Window](<#Window>)


## Constants

<a name="APIVersion"></a>

```go
const APIVersion = "sloth.slok.dev/v1"
```

<a name="Kind"></a>

```go
const Kind = "AlertWindows"
```

<a name="AlertWindows"></a>
## type [AlertWindows](<https://github.com/slok/sloth/blob/main/pkg/prometheus/alertwindows/v1/v1.go#L12-L16>)



```go
type AlertWindows struct {
    Kind       string `yaml:"kind"`
    APIVersion string `yaml:"apiVersion"`
    Spec       Spec   `yaml:"spec"`
}
```

<a name="PageWindow"></a>
## type [PageWindow](<https://github.com/slok/sloth/blob/main/pkg/prometheus/alertwindows/v1/v1.go#L29-L31>)

PageWindow represents the configuration for page alerting.

```go
type PageWindow struct {
    QuickSlowWindow `yaml:",inline"`
}
```

<a name="QuickSlowWindow"></a>
## type [QuickSlowWindow](<https://github.com/slok/sloth/blob/main/pkg/prometheus/alertwindows/v1/v1.go#L38-L43>)



```go
type QuickSlowWindow struct {
    // Quick represents the windows for the quick alerting trigger.
    Quick Window `yaml:"quick"`
    // Slow represents the windows for the slow alerting trigger.
    Slow Window `yaml:"slow"`
}
```

<a name="Spec"></a>
## type [Spec](<https://github.com/slok/sloth/blob/main/pkg/prometheus/alertwindows/v1/v1.go#L19-L26>)

Spec represents the root type of the Alerting window.

```go
type Spec struct {
    // SLOPeriod is the full slo period used for this windows.
    SLOPeriod prometheusmodel.Duration `yaml:"sloPeriod"`
    // Page represents the configuration for the page alerting windows.
    Page PageWindow `yaml:"page"`
    // Ticket represents the configuration for the ticket alerting windows.
    Ticket TicketWindow `yaml:"ticket"`
}
```

<a name="TicketWindow"></a>
## type [TicketWindow](<https://github.com/slok/sloth/blob/main/pkg/prometheus/alertwindows/v1/v1.go#L34-L36>)

PageWindow represents the configuration for ticket alerting.

```go
type TicketWindow struct {
    QuickSlowWindow `yaml:",inline"`
}
```

<a name="Window"></a>
## type [Window](<https://github.com/slok/sloth/blob/main/pkg/prometheus/alertwindows/v1/v1.go#L45-L53>)



```go
type Window struct {
    // ErrorBudgetPercent is the max error budget consumption allowed in the window.
    ErrorBudgetPercent float64 `yaml:"errorBudgetPercent"`
    // Shortwindow is the window that will stop the alerts when a huge amount of
    // error budget has been consumed but the error has already gone.
    ShortWindow prometheusmodel.Duration `yaml:"shortWindow"`
    // Longwindow is the window used to get the error budget for all the window.
    LongWindow prometheusmodel.Duration `yaml:"longWindow"`
}
```

Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
