// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	http "net/http"

	slothv1 "github.com/slok/sloth/pkg/kubernetes/api/sloth/v1"
	scheme "github.com/slok/sloth/pkg/kubernetes/gen/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type SlothV1Interface interface {
	RESTClient() rest.Interface
	PrometheusServiceLevelsGetter
}

// SlothV1Client is used to interact with features provided by the sloth.slok.dev group.
type SlothV1Client struct {
	restClient rest.Interface
}

func (c *SlothV1Client) PrometheusServiceLevels(namespace string) PrometheusServiceLevelInterface {
	return newPrometheusServiceLevels(c, namespace)
}

// NewForConfig creates a new SlothV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*SlothV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new SlothV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*SlothV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &SlothV1Client{client}, nil
}

// NewForConfigOrDie creates a new SlothV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *SlothV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new SlothV1Client for the given RESTClient.
func New(c rest.Interface) *SlothV1Client {
	return &SlothV1Client{c}
}

func setConfigDefaults(config *rest.Config) {
	gv := slothv1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *SlothV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
