<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# v1

```go
import "github.com/slok/sloth/pkg/kubernetes/api/sloth/v1"
```

## Index

- [Variables](<#variables>)
- [func Kind\(kind string\) schema.GroupKind](<#Kind>)
- [func Resource\(resource string\) schema.GroupResource](<#Resource>)
- [func VersionKind\(kind string\) schema.GroupVersionKind](<#VersionKind>)
- [type Alert](<#Alert>)
  - [func \(in \*Alert\) DeepCopy\(\) \*Alert](<#Alert.DeepCopy>)
  - [func \(in \*Alert\) DeepCopyInto\(out \*Alert\)](<#Alert.DeepCopyInto>)
- [type Alerting](<#Alerting>)
  - [func \(in \*Alerting\) DeepCopy\(\) \*Alerting](<#Alerting.DeepCopy>)
  - [func \(in \*Alerting\) DeepCopyInto\(out \*Alerting\)](<#Alerting.DeepCopyInto>)
- [type PrometheusServiceLevel](<#PrometheusServiceLevel>)
  - [func \(in \*PrometheusServiceLevel\) DeepCopy\(\) \*PrometheusServiceLevel](<#PrometheusServiceLevel.DeepCopy>)
  - [func \(in \*PrometheusServiceLevel\) DeepCopyInto\(out \*PrometheusServiceLevel\)](<#PrometheusServiceLevel.DeepCopyInto>)
  - [func \(in \*PrometheusServiceLevel\) DeepCopyObject\(\) runtime.Object](<#PrometheusServiceLevel.DeepCopyObject>)
- [type PrometheusServiceLevelList](<#PrometheusServiceLevelList>)
  - [func \(in \*PrometheusServiceLevelList\) DeepCopy\(\) \*PrometheusServiceLevelList](<#PrometheusServiceLevelList.DeepCopy>)
  - [func \(in \*PrometheusServiceLevelList\) DeepCopyInto\(out \*PrometheusServiceLevelList\)](<#PrometheusServiceLevelList.DeepCopyInto>)
  - [func \(in \*PrometheusServiceLevelList\) DeepCopyObject\(\) runtime.Object](<#PrometheusServiceLevelList.DeepCopyObject>)
- [type PrometheusServiceLevelSpec](<#PrometheusServiceLevelSpec>)
  - [func \(in \*PrometheusServiceLevelSpec\) DeepCopy\(\) \*PrometheusServiceLevelSpec](<#PrometheusServiceLevelSpec.DeepCopy>)
  - [func \(in \*PrometheusServiceLevelSpec\) DeepCopyInto\(out \*PrometheusServiceLevelSpec\)](<#PrometheusServiceLevelSpec.DeepCopyInto>)
- [type PrometheusServiceLevelStatus](<#PrometheusServiceLevelStatus>)
  - [func \(in \*PrometheusServiceLevelStatus\) DeepCopy\(\) \*PrometheusServiceLevelStatus](<#PrometheusServiceLevelStatus.DeepCopy>)
  - [func \(in \*PrometheusServiceLevelStatus\) DeepCopyInto\(out \*PrometheusServiceLevelStatus\)](<#PrometheusServiceLevelStatus.DeepCopyInto>)
- [type SLI](<#SLI>)
  - [func \(in \*SLI\) DeepCopy\(\) \*SLI](<#SLI.DeepCopy>)
  - [func \(in \*SLI\) DeepCopyInto\(out \*SLI\)](<#SLI.DeepCopyInto>)
- [type SLIEvents](<#SLIEvents>)
  - [func \(in \*SLIEvents\) DeepCopy\(\) \*SLIEvents](<#SLIEvents.DeepCopy>)
  - [func \(in \*SLIEvents\) DeepCopyInto\(out \*SLIEvents\)](<#SLIEvents.DeepCopyInto>)
- [type SLIPlugin](<#SLIPlugin>)
  - [func \(in \*SLIPlugin\) DeepCopy\(\) \*SLIPlugin](<#SLIPlugin.DeepCopy>)
  - [func \(in \*SLIPlugin\) DeepCopyInto\(out \*SLIPlugin\)](<#SLIPlugin.DeepCopyInto>)
- [type SLIRaw](<#SLIRaw>)
  - [func \(in \*SLIRaw\) DeepCopy\(\) \*SLIRaw](<#SLIRaw.DeepCopy>)
  - [func \(in \*SLIRaw\) DeepCopyInto\(out \*SLIRaw\)](<#SLIRaw.DeepCopyInto>)
- [type SLO](<#SLO>)
  - [func \(in \*SLO\) DeepCopy\(\) \*SLO](<#SLO.DeepCopy>)
  - [func \(in \*SLO\) DeepCopyInto\(out \*SLO\)](<#SLO.DeepCopyInto>)
- [type SLOPlugin](<#SLOPlugin>)
  - [func \(in \*SLOPlugin\) DeepCopy\(\) \*SLOPlugin](<#SLOPlugin.DeepCopy>)
  - [func \(in \*SLOPlugin\) DeepCopyInto\(out \*SLOPlugin\)](<#SLOPlugin.DeepCopyInto>)
- [type SLOPlugins](<#SLOPlugins>)
  - [func \(in \*SLOPlugins\) DeepCopy\(\) \*SLOPlugins](<#SLOPlugins.DeepCopy>)
  - [func \(in \*SLOPlugins\) DeepCopyInto\(out \*SLOPlugins\)](<#SLOPlugins.DeepCopyInto>)


## Variables

<a name="SchemeBuilder"></a>

```go
var (
    // SchemeBuilder initializes a scheme builder.
    SchemeBuilder = runtime.NewSchemeBuilder(addKnownTypes)
    // AddToScheme is a global function that registers this API group & version to a scheme.
    AddToScheme = SchemeBuilder.AddToScheme
)
```

<a name="SchemeGroupVersion"></a>SchemeGroupVersion is group version used to register these objects.

```go
var SchemeGroupVersion = schema.GroupVersion{Group: sloth.GroupName, Version: version}
```

<a name="Kind"></a>
## func [Kind](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/register.go#L19>)

```go
func Kind(kind string) schema.GroupKind
```

Kind takes an unqualified kind and returns back a Group qualified GroupKind.

<a name="Resource"></a>
## func [Resource](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/register.go#L29>)

```go
func Resource(resource string) schema.GroupResource
```

Resource takes an unqualified resource and returns a Group qualified GroupResource.

<a name="VersionKind"></a>
## func [VersionKind](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/register.go#L24>)

```go
func VersionKind(kind string) schema.GroupVersionKind
```

VersionKind takes an unqualified kind and returns back a Group qualified GroupVersionKind.

<a name="Alert"></a>
## type [Alert](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L167-L180>)

Alert configures specific SLO alert.

```go
type Alert struct {
    // Disable disables the alert and makes Sloth not generating this alert. This
    // can be helpful for example to disable ticket(warning) alerts.
    Disable bool `json:"disable,omitempty"`

    // Labels are the Prometheus labels for the specific alert. For example can be
    // useful to route the Page alert to specific Slack channel.
    // +optional
    Labels map[string]string `json:"labels,omitempty"`

    // Annotations are the Prometheus annotations for the specific alert.
    // +optional
    Annotations map[string]string `json:"annotations,omitempty"`
}
```

<a name="Alert.DeepCopy"></a>
### func \(\*Alert\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L35>)

```go
func (in *Alert) DeepCopy() *Alert
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Alert.

<a name="Alert.DeepCopyInto"></a>
### func \(\*Alert\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L15>)

```go
func (in *Alert) DeepCopyInto(out *Alert)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="Alerting"></a>
## type [Alerting](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L145-L164>)

Alerting wraps all the configuration required by the SLO alerts.

```go
type Alerting struct {
    // Name is the name used by the alerts generated for this SLO.
    // +optional
    Name string `json:"name,omitempty"`

    // Labels are the Prometheus labels that will have all the alerts generated by this SLO.
    // +optional
    Labels map[string]string `json:"labels,omitempty"`

    // Annotations are the Prometheus annotations that will have all the alerts generated by
    // this SLO.
    // +optional
    Annotations map[string]string `json:"annotations,omitempty"`

    // Page alert refers to the critical alert (check multiwindow-multiburn alerts).
    PageAlert Alert `json:"pageAlert,omitempty"`

    // TicketAlert alert refers to the warning alert (check multiwindow-multiburn alerts).
    TicketAlert Alert `json:"ticketAlert,omitempty"`
}
```

<a name="Alerting.DeepCopy"></a>
### func \(\*Alerting\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L67>)

```go
func (in *Alerting) DeepCopy() *Alerting
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Alerting.

<a name="Alerting.DeepCopyInto"></a>
### func \(\*Alerting\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L45>)

```go
func (in *Alerting) DeepCopyInto(out *Alerting)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="PrometheusServiceLevel"></a>
## type [PrometheusServiceLevel](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L24-L30>)

\+genclient \+k8s:deepcopy\-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object \+kubebuilder:subresource:status \+kubebuilder:printcolumn:name="SERVICE",type="string",JSONPath=".spec.service" \+kubebuilder:printcolumn:name="DESIRED SLOs",type="integer",JSONPath=".status.processedSLOs" \+kubebuilder:printcolumn:name="READY SLOs",type="integer",JSONPath=".status.promOpRulesGeneratedSLOs" \+kubebuilder:printcolumn:name="GEN OK",type="boolean",JSONPath=".status.promOpRulesGenerated" \+kubebuilder:printcolumn:name="GEN AGE",type="date",JSONPath=".status.lastPromOpRulesSuccessfulGenerated" \+kubebuilder:printcolumn:name="AGE",type="date",JSONPath=".metadata.creationTimestamp" \+kubebuilder:resource:singular=prometheusservicelevel,path=prometheusservicelevels,shortName=psl;pslo,scope=Namespaced,categories=slo;slos;sli;slis

PrometheusServiceLevel is the expected service quality level using Prometheus as the backend used by Sloth.

```go
type PrometheusServiceLevel struct {
    metav1.TypeMeta   `json:",inline"`
    metav1.ObjectMeta `json:"metadata,omitempty"`

    Spec   PrometheusServiceLevelSpec   `json:"spec,omitempty"`
    Status PrometheusServiceLevelStatus `json:"status,omitempty"`
}
```

<a name="PrometheusServiceLevel.DeepCopy"></a>
### func \(\*PrometheusServiceLevel\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L87>)

```go
func (in *PrometheusServiceLevel) DeepCopy() *PrometheusServiceLevel
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusServiceLevel.

<a name="PrometheusServiceLevel.DeepCopyInto"></a>
### func \(\*PrometheusServiceLevel\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L77>)

```go
func (in *PrometheusServiceLevel) DeepCopyInto(out *PrometheusServiceLevel)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="PrometheusServiceLevel.DeepCopyObject"></a>
### func \(\*PrometheusServiceLevel\) [DeepCopyObject](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L97>)

```go
func (in *PrometheusServiceLevel) DeepCopyObject() runtime.Object
```

DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.

<a name="PrometheusServiceLevelList"></a>
## type [PrometheusServiceLevelList](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L239-L244>)

\+k8s:deepcopy\-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

PrometheusServiceLevelList is a list of PrometheusServiceLevel resources.

```go
type PrometheusServiceLevelList struct {
    metav1.TypeMeta `json:",inline"`
    metav1.ListMeta `json:"metadata"`

    Items []PrometheusServiceLevel `json:"items"`
}
```

<a name="PrometheusServiceLevelList.DeepCopy"></a>
### func \(\*PrometheusServiceLevelList\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L120>)

```go
func (in *PrometheusServiceLevelList) DeepCopy() *PrometheusServiceLevelList
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusServiceLevelList.

<a name="PrometheusServiceLevelList.DeepCopyInto"></a>
### func \(\*PrometheusServiceLevelList\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L105>)

```go
func (in *PrometheusServiceLevelList) DeepCopyInto(out *PrometheusServiceLevelList)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="PrometheusServiceLevelList.DeepCopyObject"></a>
### func \(\*PrometheusServiceLevelList\) [DeepCopyObject](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L130>)

```go
func (in *PrometheusServiceLevelList) DeepCopyObject() runtime.Object
```

DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.

<a name="PrometheusServiceLevelSpec"></a>
## type [PrometheusServiceLevelSpec](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L33-L51>)

ServiceLevelSpec is the spec for a PrometheusServiceLevel.

```go
type PrometheusServiceLevelSpec struct {
    // +kubebuilder:validation:Required
    //
    // Service is the application of the SLOs.
    Service string `json:"service"`

    // Labels are the Prometheus labels that will have all the recording
    // and alerting rules generated for the service SLOs.
    Labels map[string]string `json:"labels,omitempty"`

    // SLOPlugins will be added to the SLO generation plugin chain of all SLOs.
    // +optional
    SLOPlugins *SLOPlugins `json:"sloPlugins,omitempty"`

    // +kubebuilder:validation:MinItems=1
    //
    // SLOs are the SLOs of the service.
    SLOs []SLO `json:"slos,omitempty"`
}
```

<a name="PrometheusServiceLevelSpec.DeepCopy"></a>
### func \(\*PrometheusServiceLevelSpec\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L163>)

```go
func (in *PrometheusServiceLevelSpec) DeepCopy() *PrometheusServiceLevelSpec
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusServiceLevelSpec.

<a name="PrometheusServiceLevelSpec.DeepCopyInto"></a>
### func \(\*PrometheusServiceLevelSpec\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L138>)

```go
func (in *PrometheusServiceLevelSpec) DeepCopyInto(out *PrometheusServiceLevelSpec)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="PrometheusServiceLevelStatus"></a>
## type [PrometheusServiceLevelStatus](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L220-L234>)



```go
type PrometheusServiceLevelStatus struct {
    // PromOpRulesGeneratedSLOs tells how many SLOs have been processed and generated for Prometheus operator successfully.
    PromOpRulesGeneratedSLOs int `json:"promOpRulesGeneratedSLOs"`
    // ProcessedSLOs tells how many SLOs haven been processed for Prometheus operator.
    ProcessedSLOs int `json:"processedSLOs"`
    // PromOpRulesGenerated tells if the rules for prometheus operator CRD have been generated.
    PromOpRulesGenerated bool `json:"promOpRulesGenerated"`
    // LastPromOpRulesGeneration tells the last atemp made for a successful SLO rules generate.
    // +optional
    LastPromOpRulesSuccessfulGenerated *metav1.Time `json:"lastPromOpRulesSuccessfulGenerated,omitempty"`
    // ObservedGeneration tells the generation was acted on, normally this is required to stop an
    // infinite loop when the status is updated because it sends a watch updated event to the watchers
    // of the K8s object.
    ObservedGeneration int64 `json:"observedGeneration"`
}
```

<a name="PrometheusServiceLevelStatus.DeepCopy"></a>
### func \(\*PrometheusServiceLevelStatus\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L183>)

```go
func (in *PrometheusServiceLevelStatus) DeepCopy() *PrometheusServiceLevelStatus
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusServiceLevelStatus.

<a name="PrometheusServiceLevelStatus.DeepCopyInto"></a>
### func \(\*PrometheusServiceLevelStatus\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L173>)

```go
func (in *PrometheusServiceLevelStatus) DeepCopyInto(out *PrometheusServiceLevelStatus)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="SLI"></a>
## type [SLI](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L99-L111>)

SLI will tell what is good or bad for the SLO. All SLIs will be get based on time windows, that's why Sloth needs the queries to use \`\{\{.window\}\}\` template variable.

Only one of the SLI types can be used.

```go
type SLI struct {
    // Raw is the raw SLI type.
    // +optional
    Raw *SLIRaw `json:"raw,omitempty"`

    // Events is the events SLI type.
    // +optional
    Events *SLIEvents `json:"events,omitempty"`

    // Plugin is the pluggable SLI type.
    // +optional
    Plugin *SLIPlugin `json:"plugin,omitempty"`
}
```

<a name="SLI.DeepCopy"></a>
### func \(\*SLI\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L214>)

```go
func (in *SLI) DeepCopy() *SLI
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SLI.

<a name="SLI.DeepCopyInto"></a>
### func \(\*SLI\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L193>)

```go
func (in *SLI) DeepCopyInto(out *SLI)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="SLIEvents"></a>
## type [SLIEvents](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L122-L132>)

SLIEvents is an SLI that is calculated as the division of bad events and total events, giving a ratio SLI. Normally this is the most common ratio type.

```go
type SLIEvents struct {
    // ErrorQuery is a Prometheus query that will get the number/count of events
    // that we consider that are bad for the SLO (e.g "http 5xx", "latency > 250ms"...).
    // Requires the usage of `{{.window}}` template variable.
    ErrorQuery string `json:"errorQuery"`

    // TotalQuery is a Prometheus query that will get the total number/count of events
    // for the SLO (e.g "all http requests"...).
    // Requires the usage of `{{.window}}` template variable.
    TotalQuery string `json:"totalQuery"`
}
```

<a name="SLIEvents.DeepCopy"></a>
### func \(\*SLIEvents\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L230>)

```go
func (in *SLIEvents) DeepCopy() *SLIEvents
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SLIEvents.

<a name="SLIEvents.DeepCopyInto"></a>
### func \(\*SLIEvents\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L224>)

```go
func (in *SLIEvents) DeepCopyInto(out *SLIEvents)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="SLIPlugin"></a>
## type [SLIPlugin](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L135-L142>)

SLIPlugin will use the SLI returned by the SLI plugin selected along with the options.

```go
type SLIPlugin struct {
    // Name is the name of the plugin that needs to load.
    ID  string `json:"id"`

    // Options are the options used for the plugin.
    // +optional
    Options map[string]string `json:"options,omitempty"`
}
```

<a name="SLIPlugin.DeepCopy"></a>
### func \(\*SLIPlugin\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L253>)

```go
func (in *SLIPlugin) DeepCopy() *SLIPlugin
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SLIPlugin.

<a name="SLIPlugin.DeepCopyInto"></a>
### func \(\*SLIPlugin\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L240>)

```go
func (in *SLIPlugin) DeepCopyInto(out *SLIPlugin)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="SLIRaw"></a>
## type [SLIRaw](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L115-L118>)

SLIRaw is a error ratio SLI already calculated. Normally this will be used when the SLI is already calculated by other recording rule, system...

```go
type SLIRaw struct {
    // ErrorRatioQuery is a Prometheus query that will get the raw error ratio (0-1) for the SLO.
    ErrorRatioQuery string `json:"errorRatioQuery"`
}
```

<a name="SLIRaw.DeepCopy"></a>
### func \(\*SLIRaw\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L269>)

```go
func (in *SLIRaw) DeepCopy() *SLIRaw
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SLIRaw.

<a name="SLIRaw.DeepCopyInto"></a>
### func \(\*SLIRaw\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L263>)

```go
func (in *SLIRaw) DeepCopyInto(out *SLIRaw)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="SLO"></a>
## type [SLO](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L55-L92>)

SLO is the configuration/declaration of the service level objective of a service.

```go
type SLO struct {
    // +kubebuilder:validation:Required
    // +kubebuilder:validation:MaxLength=128
    //
    // Name is the name of the SLO.
    Name string `json:"name"`

    // Description is the description of the SLO.
    // +optional
    Description string `json:"description,omitempty"`

    // +kubebuilder:validation:Required
    //
    // Objective is target of the SLO the percentage (0, 100] (e.g 99.9).
    Objective float64 `json:"objective"`

    // Plugins will be added along the group SLO plugins declared in the spec root level
    // and Sloth default plugins.
    // +optional
    Plugins *SLOPlugins `json:"plugins,omitempty"`

    // Labels are the Prometheus labels that will have all the recording and
    // alerting rules for this specific SLO. These labels are merged with the
    // previous level labels.
    // +optional
    Labels map[string]string `json:"labels,omitempty"`

    // +kubebuilder:validation:Required
    //
    // SLI is the indicator (service level indicator) for this specific SLO.
    SLI SLI `json:"sli"`

    // +kubebuilder:validation:Required
    //
    // Alerting is the configuration with all the things related with the SLO
    // alerts.
    Alerting Alerting `json:"alerting"`
}
```

<a name="SLO.DeepCopy"></a>
### func \(\*SLO\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L299>)

```go
func (in *SLO) DeepCopy() *SLO
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SLO.

<a name="SLO.DeepCopyInto"></a>
### func \(\*SLO\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L279>)

```go
func (in *SLO) DeepCopyInto(out *SLO)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="SLOPlugin"></a>
## type [SLOPlugin](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L198-L218>)

SLOPlugin is a plugin that will be used on the chain of plugins for the SLO generation.

```go
type SLOPlugin struct {
    // ID is the ID of the plugin to load .
    ID  string `json:"id"`

    // +kubebuilder:validation:Schemaless
    // +kubebuilder:pruning:PreserveUnknownFields
    // +kubebuilder:validation:Type=object
    //
    // Config is the configuration used on the plugin instance creation.
    // +optional
    Config json.RawMessage `json:"config,omitempty"`

    // Priority is the priority of the plugin in the chain. The lower the number
    // the higher the priority. The first plugin will be the one with the lowest
    // priority.
    // The default plugins loaded by Sloth use `0` priority. If you want to
    // execute plugins before the default ones, you can use negative priority.
    // It is recommended to use round gaps of numbers like 10, 100, 1000, -200, -1000...
    // +optional
    Priority int `json:"priority,omitempty"`
}
```

<a name="SLOPlugin.DeepCopy"></a>
### func \(\*SLOPlugin\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L320>)

```go
func (in *SLOPlugin) DeepCopy() *SLOPlugin
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SLOPlugin.

<a name="SLOPlugin.DeepCopyInto"></a>
### func \(\*SLOPlugin\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L309>)

```go
func (in *SLOPlugin) DeepCopyInto(out *SLOPlugin)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

<a name="SLOPlugins"></a>
## type [SLOPlugins](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/types.go#L184-L195>)

SLOPlugins are the list plugins that will be used on the process of SLOs for the rules generation.

```go
type SLOPlugins struct {
    // OverridePrevious will override the previous SLO plugins declared.
    // Depending on where is this SLO plugins block declared will override:
    // - If declared at SLO group level: Overrides the default plugins.
    // - If declared at SLO level: Overrides the default + SLO group plugins.
    // The declaration order is default plugins -> SLO Group plugins -> SLO plugins.
    // +optional
    OverridePrevious bool `json:"overridePrevious,omitempty"`

    // chain ths the list of plugin chain to add to the SLO generation.
    Chain []SLOPlugin `json:"chain"`
}
```

<a name="SLOPlugins.DeepCopy"></a>
### func \(\*SLOPlugins\) [DeepCopy](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L343>)

```go
func (in *SLOPlugins) DeepCopy() *SLOPlugins
```

DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SLOPlugins.

<a name="SLOPlugins.DeepCopyInto"></a>
### func \(\*SLOPlugins\) [DeepCopyInto](<https://github.com/slok/sloth/blob/main/pkg/kubernetes/api/sloth/v1/zz_generated.deepcopy.go#L330>)

```go
func (in *SLOPlugins) DeepCopyInto(out *SLOPlugins)
```

DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non\-nil.

Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
