/*
 * Decompiled with CFR 0.152.
 */
package cn.tealc.wwt.export;

import cn.tealc.wutheringwavestool.model.CardInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader {
    /*
     * Enabled aggressive exception aggregation
     */
    public Pair<String, Map<String, List<CardInfo>>> readExcel(File file) {
        LinkedHashMap map = new LinkedHashMap();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Pair pair;
            try (XSSFWorkbook workbook = new XSSFWorkbook(fileInputStream);){
                for (int i = 0; i < workbook.getNumberOfSheets() - 1; ++i) {
                    Sheet sheet = workbook.getSheetAt(i);
                    String sheetName = sheet.getSheetName();
                    ArrayList<CardInfo> cardInfoList = new ArrayList<CardInfo>();
                    if (!map.containsKey(sheetName)) {
                        map.put(sheetName, cardInfoList);
                    }
                    for (int rowIndex = 1; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                        Row row = sheet.getRow(rowIndex);
                        if (row == null) continue;
                        CardInfo cardInfo = new CardInfo();
                        cardInfo.setName(ExcelReader.getCellValue(row.getCell(0)));
                        cardInfo.setResourceType(ExcelReader.getCellValue(row.getCell(1)));
                        cardInfo.setQualityLevel((int)row.getCell(2).getNumericCellValue());
                        cardInfo.setTime(ExcelReader.getCellValue(row.getCell(3)));
                        cardInfo.setCount((int)row.getCell(4).getNumericCellValue());
                        cardInfo.setResourceId((int)row.getCell(5).getNumericCellValue());
                        cardInfo.setCardPoolType(ExcelReader.getCellValue(row.getCell(6)));
                        cardInfoList.add(cardInfo);
                    }
                }
                Sheet sheet = workbook.getSheetAt(workbook.getNumberOfSheets() - 1);
                String playerId = sheet.getSheetName();
                pair = new Pair((Object)playerId, map);
            }
            return pair;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
        }
        return "";
    }
}

