/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.openani.mediamp.io.BufferedSeekableInputKt;
import org.openani.mediamp.io.SeekableInput;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH$\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H$\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001f\u0010\fJ\u000f\u0010 \u001a\u00020\bH\u0016\u00a2\u0006\u0004\b \u0010\fJ\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00068\u0004@\u0004X\u0084\f\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00068\u0004@\u0004X\u0084\f\u00a2\u0006\u0006\n\u0004\b&\u0010%R\u001a\u0010'\u001a\u00020\u00188\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R*\u0010\u0007\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00068\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010%\u001a\u0004\b,\u0010-\"\u0004\b.\u0010\nR\u0011\u00100\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0016\u00102\u001a\u0002018\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103"}, d2={"Lorg/openani/mediamp/io/BufferedSeekableInput;", "Lorg/openani/mediamp/io/SeekableInput;", "", "bufferSize", "<init>", "(I)V", "", "position", "", "seekTo", "(J)V", "fillBuffer", "()V", "readStart", "readEnd", "fillBufferRange", "(JJ)V", "fileOffset", "bufferOffset", "length", "readFileToBuffer", "(JII)I", "readFileToBufferChecked", "(JII)V", "", "buffer", "offset", "read", "([BII)I", "readFromBuffer", "(I[BI)I", "checkClosed", "close", "", "toString", "()Ljava/lang/String;", "bufferedOffsetStart", "J", "bufferedOffsetEndExcl", "buf", "[B", "getBuf", "()[B", "value", "getPosition", "()J", "setPosition", "getBytesRemaining", "bytesRemaining", "", "closed", "Z"})
@SourceDebugExtension(value={"SMAP\nBufferedSeekableInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedSeekableInput.kt\norg/openani/mediamp/io/BufferedSeekableInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public abstract class BufferedSeekableInput
implements SeekableInput {
    protected long bufferedOffsetStart = -1L;
    protected long bufferedOffsetEndExcl;
    private final byte[] buf;
    private long position;
    @JvmField
    protected volatile boolean closed;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BufferedSeekableInput(int bufferSize) {
        void var1_1;
        this.buf = new byte[var1_1 << 1];
    }

    protected final byte[] getBuf() {
        return this.buf;
    }

    public final long getPosition() {
        return this.position;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setPosition(long value2) {
        void var1_1;
        if (!(value2 >= 0L)) {
            String value2 = "position must be non-negative, but was " + value2;
            throw new IllegalArgumentException(value2.toString());
        }
        this.position = var1_1;
    }

    public final long getBytesRemaining() {
        return RangesKt.coerceAtLeast((long)(this.getSize() - this.position), (long)0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void seekTo(long position) {
        void var1_1;
        void var3_3;
        if (!(position >= 0L)) {
            String string = "offset must be non-negative, but was " + position;
            throw new IllegalArgumentException(string.toString());
        }
        this.checkClosed();
        long lastPos = this.position;
        if (position == var3_3) {
            return;
        }
        this.setPosition((long)var1_1);
    }

    protected abstract void fillBuffer();

    /*
     * WARNING - void declaration
     */
    protected final void fillBufferRange(long readStart, long readEnd) {
        void var3_2;
        void var1_1;
        int readLength = BufferedSeekableInputKt.coerceToInt(readEnd - readStart);
        long bufferedStart = this.bufferedOffsetStart;
        long bufferedEnd = this.bufferedOffsetEndExcl;
        if (bufferedStart != -1L) {
            boolean bl = bufferedStart <= readStart ? readStart < bufferedEnd : false;
            if (bl) {
                ArraysKt.copyInto((byte[])this.buf, (byte[])this.buf, (int)0, (int)BufferedSeekableInputKt.checkToInt(readStart - bufferedStart), (int)BufferedSeekableInputKt.checkToInt(bufferedEnd - bufferedStart));
                long l = bufferedEnd;
                this.readFileToBufferChecked(l, BufferedSeekableInputKt.checkToInt(l - readStart), BufferedSeekableInputKt.coerceToInt(readEnd - bufferedEnd));
            } else {
                boolean bl2 = bufferedStart + 1L <= readEnd ? readEnd <= bufferedEnd : false;
                if (bl2) {
                    ArraysKt.copyInto((byte[])this.buf, (byte[])this.buf, (int)BufferedSeekableInputKt.checkToInt(bufferedStart - readStart), (int)0, (int)BufferedSeekableInputKt.checkToInt(readEnd - bufferedStart));
                    this.readFileToBufferChecked(readStart, 0, BufferedSeekableInputKt.coerceToInt(bufferedStart - readStart));
                } else {
                    this.readFileToBufferChecked(readStart, 0, readLength);
                }
            }
        } else {
            this.readFileToBufferChecked(readStart, 0, readLength);
        }
        this.bufferedOffsetStart = var1_1;
        this.bufferedOffsetEndExcl = var3_2;
    }

    protected abstract int readFileToBuffer(long var1, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    private final void readFileToBufferChecked(long fileOffset, int bufferOffset, int length) {
        int read = this.readFileToBuffer(fileOffset, bufferOffset, length);
        if (!(read == length)) {
            void var1_1;
            void var3_3;
            String string = "readFileToBufferExact: Expected to read " + length + " bytes, but read " + (int)var3_3 + " bytes, fileOffset=" + (long)var1_1;
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(byte[] buffer, int offset, int length) {
        void var2_2;
        String string;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(offset >= 0)) {
            buffer = "offset must be non-negative, but was " + offset;
            throw new IllegalArgumentException(buffer.toString());
        }
        if (!(length >= 0)) {
            buffer = "length must be non-negative, but was " + length;
            throw new IllegalArgumentException(buffer.toString());
        }
        if (!(offset + length <= ((byte[])buffer).length)) {
            buffer = "offset + length must be less than or equal to buffer size, but was " + (offset + length) + " > " + ((Object)buffer).length;
            throw new IllegalArgumentException(buffer.toString());
        }
        this.checkClosed();
        if (this.position >= this.getSize()) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int read = this.readFromBuffer(length, (byte[])buffer, offset);
        if (read != -1) {
            return read;
        }
        this.fillBuffer();
        read = this.readFromBuffer((int)var3_3, (byte[])string, (int)var2_2);
        if (!(read != -1)) {
            string = "fillBuffer did not fill for " + this.position;
            throw new IllegalStateException(string.toString());
        }
        return read;
    }

    /*
     * WARNING - void declaration
     */
    private final int readFromBuffer(int length, byte[] buffer, int offset) {
        long bufStart = this.bufferedOffsetStart;
        long bufEnd = this.bufferedOffsetEndExcl;
        long pos = this.position;
        if (bufStart != -1L) {
            boolean bl = bufStart <= pos ? pos < bufEnd : false;
            if (bl) {
                void var1_1;
                void var3_3;
                void var2_2;
                int sizeToRead = RangesKt.coerceAtMost((int)Math.min(length, BufferedSeekableInputKt.coerceToInt(bufEnd - pos)), (int)BufferedSeekableInputKt.coerceToInt(this.getSize() - pos));
                long offsetInBuf = pos - bufStart;
                ArraysKt.copyInto((byte[])this.buf, (byte[])var2_2, (int)var3_3, (int)BufferedSeekableInputKt.checkToInt(offsetInBuf), (int)BufferedSeekableInputKt.checkToInt(offsetInBuf + (long)sizeToRead));
                BufferedSeekableInput bufferedSeekableInput = this;
                bufferedSeekableInput.setPosition(bufferedSeekableInput.position + (long)sizeToRead);
                return (int)var1_1;
            }
        }
        return -1;
    }

    private final void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("This BufferedSeekableInput is closed");
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return "BufferedSeekableInput(position=" + this.position + ", bytesRemaining=" + this.getBytesRemaining() + ')';
    }
}

