/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.io;

import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.openani.mediamp.io.BufferedSeekableInput;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\b\u0010\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/openani/mediamp/io/BufferedFileInput;", "Lorg/openani/mediamp/io/BufferedSeekableInput;", "Ljava/io/RandomAccessFile;", "file", "", "bufferSize", "Lkotlin/Function0;", "", "onFillBuffer", "<init>", "(Ljava/io/RandomAccessFile;ILkotlin/jvm/functions/Function0;)V", "fillBuffer", "()V", "", "fileOffset", "bufferOffset", "length", "readFileToBuffer", "(JII)I", "", "toString", "()Ljava/lang/String;", "close", "Ljava/io/RandomAccessFile;", "I", "Lkotlin/jvm/functions/Function0;", "size", "J", "getSize", "()J"})
public class BufferedFileInput
extends BufferedSeekableInput {
    private final RandomAccessFile file;
    private final int bufferSize;
    private final Function0<Unit> onFillBuffer;
    private final long size;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BufferedFileInput(RandomAccessFile file, int bufferSize, Function0<Unit> onFillBuffer) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(bufferSize);
        this.file = var1_1;
        this.bufferSize = var2_2;
        this.onFillBuffer = var3_3;
        this.size = this.file.length();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fillBuffer() {
        void var1_1;
        void var3_2;
        Function0<Unit> function0 = this.onFillBuffer;
        if (function0 != null) {
            function0.invoke();
        }
        long fileLength = this.getSize();
        long pos = this.getPosition();
        long readStart = RangesKt.coerceAtLeast((long)(pos - (long)this.bufferSize), (long)0L);
        long readEnd = RangesKt.coerceAtMost((long)(var3_2 + (long)this.bufferSize), (long)var1_1);
        this.fillBufferRange(readStart, readEnd);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int readFileToBuffer(long fileOffset, int bufferOffset, int length) {
        void var3_2;
        void var1_1;
        RandomAccessFile file = this.file;
        file.seek((long)var1_1);
        file.readFully(this.getBuf(), (int)var3_2, length);
        return length;
    }

    @Override
    public String toString() {
        return "BufferedFileInput(file=" + this.file + ", position=" + this.getPosition() + ", bytesRemaining=" + this.getBytesRemaining() + ')';
    }

    @Override
    public void close() {
        super.close();
        this.file.close();
    }
}

