/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    private static final long serialVersionUID = -2849567615646933777L;
    private final String name;
    private final List<Marker> referenceList = new CopyOnWriteArrayList<Marker>();
    private static final String OPEN = "[ ";
    private static final String CLOSE = " ]";
    private static final String SEP = ", ";

    /*
     * WARNING - void declaration
     */
    BasicMarker(String name) {
        void var1_1;
        if (name == null) {
            throw new IllegalArgumentException("A marker name cannot be null");
        }
        this.name = var1_1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(Marker reference) {
        void var1_1;
        if (reference == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
        }
        if (this.contains(reference)) {
            return;
        }
        if (reference.contains(this)) {
            return;
        }
        this.referenceList.add((Marker)var1_1);
    }

    @Override
    public boolean hasReferences() {
        return this.referenceList.size() > 0;
    }

    @Override
    @Deprecated
    public boolean hasChildren() {
        return this.hasReferences();
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.referenceList.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Marker referenceToRemove) {
        void var1_1;
        return this.referenceList.remove(var1_1);
    }

    @Override
    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.equals(other)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker marker : this.referenceList) {
                if (!marker.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker marker : this.referenceList) {
                if (!marker.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(var1_1.getName());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var3_2;
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator<Marker> it = this.iterator();
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            void var2_3;
            Marker reference = it.next();
            sb.append(var2_3.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return var3_2.toString();
    }
}

