/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.WString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class Pointer {
    public static final Pointer NULL = null;
    protected long peer;

    public static final Pointer createConstant(long peer) {
        long l;
        return new Opaque(l);
    }

    public static final Pointer createConstant(int peer) {
        int n;
        return new Opaque((long)n & 0xFFFFFFFFL);
    }

    Pointer() {
    }

    /*
     * WARNING - void declaration
     */
    public Pointer(long peer) {
        void var1_1;
        this.peer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Pointer share(long offset) {
        void var1_1;
        return this.share((long)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public Pointer share(long offset, long sz) {
        void var1_1;
        if (offset == 0L) {
            return this;
        }
        return new Pointer(this.peer + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void clear(long size) {
        void var1_1;
        this.setMemory(0L, (long)var1_1, (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof Pointer && ((Pointer)var1_1).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFL));
    }

    /*
     * WARNING - void declaration
     */
    public long indexOf(long offset, byte value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        return Native.indexOf(pointer, pointer.peer, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void read(long offset, byte[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, (long)var1_1, (byte[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void read(long offset, short[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, (long)var1_1, (short[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void read(long offset, char[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, (long)var1_1, (char[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void read(long offset, int[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, (long)var1_1, (int[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void read(long offset, long[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, (long)var1_1, (long[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void read(long offset, float[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, (long)var1_1, (float[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void read(long offset, double[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.read(pointer, pointer.peer, (long)var1_1, (double[])var3_2, index, length);
    }

    public void read(long offset, Pointer[] buf, int index, int length) {
        for (int i = 0; i < length; ++i) {
            Pointer p = this.getPointer(offset + (long)(i * Native.POINTER_SIZE));
            Pointer oldp = buf[i + index];
            if (oldp != null && p != null && p.peer == oldp.peer) continue;
            buf[i + index] = p;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(long offset, byte[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, (long)var1_1, (byte[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void write(long offset, short[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, (long)var1_1, (short[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void write(long offset, char[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, (long)var1_1, (char[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void write(long offset, int[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, (long)var1_1, (int[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void write(long offset, long[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, (long)var1_1, (long[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void write(long offset, float[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, (long)var1_1, (float[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    public void write(long offset, double[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.write(pointer, pointer.peer, (long)var1_1, (double[])var3_2, index, length);
    }

    public void write(long bOff, Pointer[] buf, int index, int length) {
        for (int i = 0; i < length; ++i) {
            this.setPointer(bOff + (long)(i * Native.POINTER_SIZE), buf[index + i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    Object getValue(long offset, Class<?> type, Object currentValue) {
        Object object;
        void oldfp2;
        Callback cb;
        Object oldp;
        Object result = null;
        if (Structure.class.isAssignableFrom(type)) {
            Structure s = (Structure)currentValue;
            if (Structure.ByReference.class.isAssignableFrom(type)) {
                s = Structure.updateStructureByReference(type, s, this.getPointer(offset));
            } else {
                s.useMemory(this, (int)offset, true);
                s.read();
            }
            result = s;
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            result = Function.valueOf(this.getInt(offset) != 0);
        } else if (type == Byte.TYPE || type == Byte.class) {
            result = this.getByte(offset);
        } else if (type == Short.TYPE || type == Short.class) {
            result = this.getShort(offset);
        } else if (type == Character.TYPE || type == Character.class) {
            result = Character.valueOf(this.getChar(offset));
        } else if (type == Integer.TYPE || type == Integer.class) {
            result = this.getInt(offset);
        } else if (type == Long.TYPE || type == Long.class) {
            result = this.getLong(offset);
        } else if (type == Float.TYPE || type == Float.class) {
            result = Float.valueOf(this.getFloat(offset));
        } else if (type == Double.TYPE || type == Double.class) {
            result = this.getDouble(offset);
        } else if (Pointer.class.isAssignableFrom(type)) {
            Pointer p = this.getPointer(offset);
            if (p != null) {
                oldp = currentValue instanceof Pointer ? (Pointer)currentValue : null;
                if (oldp == null || p.peer != ((Pointer)oldp).peer) {
                    oldp = p;
                }
            }
        } else if (type == String.class) {
            Pointer p = this.getPointer(offset);
            oldp = p != null ? p.getString(0L) : null;
        } else if (type == WString.class) {
            Pointer p = this.getPointer(offset);
            oldp = p != null ? new WString(p.getWideString(0L)) : null;
        } else if (Callback.class.isAssignableFrom(type)) {
            Pointer fp = this.getPointer(offset);
            if (fp == null) {
                oldp = null;
            } else {
                cb = (Callback)currentValue;
                Pointer oldfp2 = CallbackReference.getFunctionPointer(cb);
                if (!fp.equals(oldfp2)) {
                    cb = CallbackReference.getCallback(type, fp);
                }
            }
        } else if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type)) {
            Pointer bp = this.getPointer((long)oldfp2);
            if (bp == null) {
                cb = null;
            } else {
                Object oldbp = currentValue == null ? null : Native.getDirectBufferPointer((Buffer)currentValue);
                if (oldbp == null || !((Pointer)oldbp).equals(bp)) {
                    throw new IllegalStateException("Can't autogenerate a direct buffer on memory read");
                }
                oldbp = currentValue;
            }
        } else if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMapped nm = (NativeMapped)currentValue;
            if (nm != null) {
                Object value = this.getValue((long)oldfp2, nm.nativeType(), null);
                if (nm.equals(value = nm.fromNative(value, new FromNativeContext(type)))) {
                    value = nm;
                }
            } else {
                void var1_3;
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
                Object value = this.getValue((long)oldfp2, tc.nativeType(), null);
                object = tc.fromNative(var1_3, new FromNativeContext(type));
            }
        } else if (type.isArray()) {
            void var1_1;
            object = currentValue;
            if (object == null) {
                throw new IllegalStateException("Need an initialized array");
            }
            this.readArray((long)var1_1, object, type.getComponentType());
        } else {
            void var3_4;
            throw new IllegalArgumentException("Reading \"" + var3_4 + "\" from memory is not supported");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void readArray(long offset, Object o, Class<?> cls) {
        Structure[] tmp;
        Structure first;
        Structure[] sarray;
        void result;
        int length = Array.getLength(o);
        if (cls == Byte.TYPE) {
            this.read(offset, (byte[])result, 0, length);
            return;
        }
        if (cls == Short.TYPE) {
            this.read(offset, (short[])result, 0, length);
            return;
        }
        if (cls == Character.TYPE) {
            this.read(offset, (char[])result, 0, length);
            return;
        }
        if (cls == Integer.TYPE) {
            this.read(offset, (int[])result, 0, length);
            return;
        }
        if (cls == Long.TYPE) {
            this.read(offset, (long[])result, 0, length);
            return;
        }
        if (cls == Float.TYPE) {
            this.read(offset, (float[])result, 0, length);
            return;
        }
        if (cls == Double.TYPE) {
            this.read(offset, (double[])result, 0, length);
            return;
        }
        if (Pointer.class.isAssignableFrom(cls)) {
            this.read(offset, (Pointer[])result, 0, length);
            return;
        }
        if (Structure.class.isAssignableFrom(cls)) {
            sarray = (Structure[])result;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] parray = this.getPointerArray(offset, sarray.length);
                int i = 0;
                while (true) {
                    if (i >= sarray.length) {
                        return;
                    }
                    sarray[i] = Structure.updateStructureByReference(cls, sarray[i], parray[i]);
                    ++i;
                }
            }
            first = sarray[0];
            if (first == null) {
                first = Structure.newInstance(cls, this.share(offset));
                first.conditionalAutoRead();
                sarray[0] = first;
            } else {
                first.useMemory(this, (int)offset, true);
                first.read();
            }
        } else {
            if (!NativeMapped.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException("Reading array of " + cls + " from memory not supported");
            }
            NativeMapped[] array = (NativeMapped[])tmp;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            int size = Native.getNativeSize(tmp.getClass(), tmp) / array.length;
            int i = 0;
            while (true) {
                if (i >= array.length) {
                    return;
                }
                Object value = this.getValue(offset + (long)(size * i), tc.nativeType(), array[i]);
                array[i] = (NativeMapped)tc.fromNative(value, new FromNativeContext(cls));
                ++i;
            }
        }
        tmp = first.toArray(sarray.length);
        int i = 1;
        while (i < sarray.length) {
            if (sarray[i] == null) {
                sarray[i] = tmp[i];
            } else {
                sarray[i].useMemory(this, (int)(offset + (long)(i * sarray[i].size())), true);
                sarray[i].read();
            }
            ++i;
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getByte(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public char getChar(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getChar(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public short getShort(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getShort(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getInt(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getLong(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public NativeLong getNativeLong(long offset) {
        void var1_1;
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(offset) : (long)this.getInt((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getFloat(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getDouble(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Pointer getPointer(long offset) {
        void var1_1;
        return Native.getPointer(this.peer + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer getByteBuffer(long offset, long length) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        return Native.getDirectByteBuffer(pointer, pointer.peer, (long)var1_1, (long)var3_2).order(ByteOrder.nativeOrder());
    }

    /*
     * WARNING - void declaration
     */
    public String getWideString(long offset) {
        void var1_1;
        Pointer pointer = this;
        return Native.getWideString(pointer, pointer.peer, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getString(long offset) {
        void var1_1;
        return this.getString((long)var1_1, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public String getString(long offset, String encoding) {
        void var3_2;
        void var1_1;
        return Native.getString(this, (long)var1_1, (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getByteArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        byte[] buf = new byte[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public char[] getCharArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        char[] buf = new char[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public short[] getShortArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        short[] buf = new short[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getIntArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        int[] buf = new int[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public long[] getLongArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        long[] buf = new long[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public float[] getFloatArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        float[] buf = new float[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public double[] getDoubleArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        double[] buf = new double[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public Pointer[] getPointerArray(long offset) {
        void var3_2;
        ArrayList<Pointer> array = new ArrayList<Pointer>();
        int addOffset = 0;
        Pointer p = this.getPointer(offset);
        while (p != null) {
            array.add(p);
            p = this.getPointer(offset + (long)(addOffset += Native.POINTER_SIZE));
        }
        return var3_2.toArray(new Pointer[0]);
    }

    /*
     * WARNING - void declaration
     */
    public Pointer[] getPointerArray(long offset, int arraySize) {
        void var3_2;
        void var1_1;
        Pointer[] buf = new Pointer[arraySize];
        this.read((long)var1_1, buf, 0, (int)var3_2);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getStringArray(long offset) {
        void var1_1;
        return this.getStringArray((long)var1_1, -1, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public String[] getStringArray(long offset, String encoding) {
        void var3_2;
        void var1_1;
        return this.getStringArray((long)var1_1, -1, (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getStringArray(long offset, int length) {
        void var3_2;
        void var1_1;
        return this.getStringArray((long)var1_1, (int)var3_2, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public String[] getWideStringArray(long offset) {
        void var1_1;
        return this.getWideStringArray((long)var1_1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getWideStringArray(long offset, int length) {
        void var3_2;
        void var1_1;
        return this.getStringArray((long)var1_1, (int)var3_2, "--WIDE-STRING--");
    }

    public String[] getStringArray(long offset, int length, String encoding) {
        ArrayList<String> strings = new ArrayList<String>();
        int addOffset = 0;
        if (length != -1) {
            Pointer p = this.getPointer(offset);
            int count = 0;
            while (count++ < length) {
                String s = p == null ? null : ("--WIDE-STRING--".equals(encoding) ? p.getWideString(0L) : p.getString(0L, encoding));
                strings.add(s);
                if (count >= length) continue;
                p = this.getPointer(offset + (long)(addOffset += Native.POINTER_SIZE));
            }
        } else {
            Pointer p;
            while ((p = this.getPointer(offset + (long)addOffset)) != null) {
                String s = "--WIDE-STRING--".equals(encoding) ? p.getWideString(0L) : p.getString(0L, encoding);
                strings.add(s);
                addOffset += Native.POINTER_SIZE;
            }
        }
        return strings.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    void setValue(long offset, Object value, Class<?> type) {
        Structure s;
        block18: {
            void var4_3;
            block15: {
                block17: {
                    block16: {
                        if (type == Boolean.TYPE || type == Boolean.class) {
                            this.setInt(offset, Boolean.TRUE.equals(value) ? -1 : 0);
                            return;
                        }
                        if (type == Byte.TYPE || type == Byte.class) {
                            this.setByte(offset, value == null ? (byte)0 : (Byte)value);
                            return;
                        }
                        if (type == Short.TYPE || type == Short.class) {
                            this.setShort(offset, value == null ? (short)0 : (Short)value);
                            return;
                        }
                        if (type == Character.TYPE || type == Character.class) {
                            this.setChar(offset, value == null ? (char)'\u0000' : ((Character)value).charValue());
                            return;
                        }
                        if (type == Integer.TYPE || type == Integer.class) {
                            this.setInt(offset, value == null ? 0 : (Integer)value);
                            return;
                        }
                        if (type == Long.TYPE || type == Long.class) {
                            this.setLong(offset, value == null ? 0L : (Long)value);
                            return;
                        }
                        if (type == Float.TYPE || type == Float.class) {
                            this.setFloat(offset, value == null ? 0.0f : ((Float)value).floatValue());
                            return;
                        }
                        if (type == Double.TYPE || type == Double.class) {
                            this.setDouble(offset, value == null ? 0.0 : (Double)value);
                            return;
                        }
                        if (type == Pointer.class) {
                            this.setPointer(offset, (Pointer)value);
                            return;
                        }
                        if (type == String.class) {
                            this.setPointer(offset, (Pointer)value);
                            return;
                        }
                        if (type == WString.class) {
                            this.setPointer(offset, (Pointer)value);
                            return;
                        }
                        if (!Structure.class.isAssignableFrom(type)) break block15;
                        s = (Structure)value;
                        if (!Structure.ByReference.class.isAssignableFrom(type)) break block16;
                        this.setPointer(offset, s == null ? null : s.getPointer());
                        if (s == null) break block17;
                        break block18;
                    }
                    s.useMemory(this, (int)offset, true);
                    s.write();
                }
                return;
            }
            if (Callback.class.isAssignableFrom(type)) {
                this.setPointer(offset, CallbackReference.getFunctionPointer((Callback)value));
                return;
            }
            if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type)) {
                Pointer p = value == null ? null : Native.getDirectBufferPointer((Buffer)value);
                this.setPointer(offset, p);
                return;
            }
            if (NativeMapped.class.isAssignableFrom(type)) {
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
                Class<?> nativeType = tc.nativeType();
                this.setValue(offset, tc.toNative(value, new ToNativeContext()), nativeType);
                return;
            }
            if (var4_3.isArray()) {
                void var3_2;
                void var1_1;
                this.writeArray((long)var1_1, var3_2, var4_3.getComponentType());
                return;
            }
            throw new IllegalArgumentException("Writing " + var4_3 + " to memory is not supported");
        }
        s.autoWrite();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void writeArray(long offset, Object value, Class<?> cls) {
        Structure[] tmp;
        Structure first;
        Structure[] sbuf;
        block18: {
            block20: {
                void i;
                block19: {
                    if (cls == Byte.TYPE) {
                        byte[] buf = (byte[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (cls == Short.TYPE) {
                        short[] buf = (short[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (cls == Character.TYPE) {
                        char[] buf = (char[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (cls == Integer.TYPE) {
                        int[] buf = (int[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (cls == Long.TYPE) {
                        long[] buf = (long[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (cls == Float.TYPE) {
                        float[] buf = (float[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (cls == Double.TYPE) {
                        double[] buf = (double[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (Pointer.class.isAssignableFrom(cls)) {
                        Pointer[] buf = (Pointer[])value;
                        this.write(offset, buf, 0, buf.length);
                        return;
                    }
                    if (!Structure.class.isAssignableFrom(cls)) break block19;
                    sbuf = (Structure[])value;
                    if (Structure.ByReference.class.isAssignableFrom(cls)) break block20;
                    first = sbuf[0];
                    if (first == null) {
                        void i2;
                        sbuf[0] = first = Structure.newInstance(i2, this.share(offset));
                        break block18;
                    } else {
                        first.useMemory(this, (int)offset, true);
                    }
                    break block18;
                }
                if (!NativeMapped.class.isAssignableFrom((Class<?>)tmp)) void var4_5;
                throw new IllegalArgumentException("Writing array of " + var4_5 + " to memory not supported");
                NativeMapped[] buf = (NativeMapped[])i;
                NativeMappedConverter tc = NativeMappedConverter.getInstance(tmp);
                Class<?> nativeType = tc.nativeType();
                int size = Native.getNativeSize(i.getClass(), i) / buf.length;
                int i3 = 0;
                while (i3 < buf.length) {
                    Object element = tc.toNative(buf[i3], new ToNativeContext());
                    this.setValue(offset + (long)(i3 * size), element, nativeType);
                    ++i3;
                }
                return;
            }
            Pointer[] buf = new Pointer[sbuf.length];
            int i2 = 0;
            while (true) {
                if (i2 >= sbuf.length) {
                    this.write(offset, buf, 0, buf.length);
                    return;
                }
                if (sbuf[i2] == null) {
                    buf[i2] = null;
                } else {
                    buf[i2] = sbuf[i2].getPointer();
                    sbuf[i2].write();
                }
                ++i2;
            }
        }
        first.write();
        tmp = first.toArray(sbuf.length);
        int i = 1;
        while (i < sbuf.length) {
            if (sbuf[i] == null) {
                sbuf[i] = tmp[i];
            } else {
                sbuf[i].useMemory(this, (int)(offset + (long)(i * sbuf[i].size())), true);
            }
            sbuf[i].write();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMemory(long offset, long length, byte value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setMemory(pointer, pointer.peer, (long)var1_1, (long)var3_2, value);
    }

    /*
     * WARNING - void declaration
     */
    public void setByte(long offset, byte value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setByte(pointer, pointer.peer, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setShort(long offset, short value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setShort(pointer, pointer.peer, (long)var1_1, (short)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setChar(long offset, char value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setChar(pointer, pointer.peer, (long)var1_1, (char)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setInt(long offset, int value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setInt(pointer, pointer.peer, (long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setLong(long offset, long value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setLong(pointer, pointer.peer, (long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setNativeLong(long offset, NativeLong value) {
        void var3_2;
        void var1_1;
        if (NativeLong.SIZE == 8) {
            this.setLong(offset, value.longValue());
            return;
        }
        this.setInt((long)var1_1, var3_2.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public void setFloat(long offset, float value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setFloat(pointer, pointer.peer, (long)var1_1, (float)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setDouble(long offset, double value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setDouble(pointer, pointer.peer, (long)var1_1, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setPointer(long offset, Pointer value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setPointer(pointer, pointer.peer, (long)var1_1, value != null ? var3_2.peer : 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void setWideString(long offset, String value) {
        void var3_2;
        void var1_1;
        Pointer pointer = this;
        Native.setWideString(pointer, pointer.peer, (long)var1_1, (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setString(long offset, WString value) {
        void var3_2;
        void var1_1;
        this.setWideString((long)var1_1, value == null ? null : var3_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void setString(long offset, String value) {
        void var3_2;
        void var1_1;
        this.setString((long)var1_1, (String)var3_2, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public void setString(long offset, String value, String encoding) {
        void var3_2;
        void var1_1;
        byte[] data = Native.getBytes(value, encoding);
        this.write(offset, data, 0, data.length);
        this.setByte((long)(var1_1 + (long)((void)var3_2).length), (byte)0);
    }

    public String dump(long offset, int size) {
        StringWriter sw = new StringWriter(11 + 2 + (size << 1) + (size / 4 << 2));
        PrintWriter out = new PrintWriter(sw);
        out.println("memory dump");
        for (int i = 0; i < size; ++i) {
            byte b = this.getByte(offset + (long)i);
            if (i % 4 == 0) {
                out.print("[");
            }
            if (b >= 0 && b < 16) {
                out.print("0");
            }
            out.print(Integer.toHexString(b & 0xFF));
            if (i % 4 != 3 || i >= size - 1) continue;
            out.println("]");
        }
        if (sw.getBuffer().charAt(sw.getBuffer().length() - 2) != ']') {
            out.println("]");
        }
        return sw.toString();
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    public static long nativeValue(Pointer p) {
        Pointer pointer;
        if (p == null) {
            return 0L;
        }
        return pointer.peer;
    }

    /*
     * WARNING - void declaration
     */
    public static void nativeValue(Pointer p, long value) {
        void var1_1;
        p.peer = var1_1;
    }

    private static class Opaque
    extends Pointer {
        private final String MSG = "This pointer is opaque: " + this;

        /*
         * WARNING - void declaration
         */
        private Opaque(long peer) {
            super((long)var1_1);
            void var1_1;
        }

        @Override
        public Pointer share(long offset, long size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void clear(long size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long indexOf(long offset, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, byte[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, char[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, short[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, int[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, long[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, float[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, double[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void read(long bOff, Pointer[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, byte[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, char[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, short[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, int[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, long[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, float[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, double[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void write(long bOff, Pointer[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public ByteBuffer getByteBuffer(long offset, long length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public byte getByte(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public char getChar(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public short getShort(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public int getInt(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public long getLong(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public float getFloat(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public double getDouble(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public Pointer getPointer(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getString(long bOff, String encoding) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String getWideString(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setByte(long bOff, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setChar(long bOff, char value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setShort(long bOff, short value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setInt(long bOff, int value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setLong(long bOff, long value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setFloat(long bOff, float value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setDouble(long bOff, double value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setPointer(long offset, Pointer value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setString(long offset, String value, String encoding) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setWideString(long offset, String value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public void setMemory(long offset, long size, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String dump(long offset, int size) {
            throw new UnsupportedOperationException(this.MSG);
        }

        @Override
        public String toString() {
            return "const@0x" + Long.toHexString(this.peer);
        }
    }
}

