/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackParameterContext;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackResultContext;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.internal.Cleaner;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class CallbackReference
extends WeakReference<Callback>
implements Closeable {
    static final Map<Callback, CallbackReference> callbackMap = new WeakHashMap<Callback, CallbackReference>();
    static final Map<Callback, CallbackReference> directCallbackMap = new WeakHashMap<Callback, CallbackReference>();
    static final Map<Pointer, Reference<Callback>[]> pointerCallbackMap = new WeakHashMap<Pointer, Reference<Callback>[]>();
    static final Map<Object, Object> allocations = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Long, Reference<CallbackReference>> allocatedMemory = new ConcurrentHashMap<Long, Reference<CallbackReference>>();
    private static final Method PROXY_CALLBACK_METHOD;
    private static final Class<?> DLL_CALLBACK_CLASS;
    private static final Map<Callback, CallbackThreadInitializer> initializers;
    Cleaner.Cleanable cleanable;
    Pointer cbstruct;
    Pointer trampoline;
    CallbackProxy proxy;
    Method method;
    int callingConvention;

    /*
     * WARNING - void declaration
     */
    static CallbackThreadInitializer setCallbackThreadInitializer(Callback cb, CallbackThreadInitializer initializer) {
        Map<Callback, CallbackThreadInitializer> map = initializers;
        synchronized (map) {
            Callback callback;
            if (initializer != null) {
                void var1_2;
                return initializers.put(cb, (CallbackThreadInitializer)var1_2);
            }
            return initializers.remove(callback);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ThreadGroup initializeThread(Callback cb, AttachOptions args) {
        CallbackThreadInitializer init;
        if (cb instanceof DefaultCallbackProxy) {
            cb = ((DefaultCallbackProxy)cb).getCallback();
        }
        Map<Callback, CallbackThreadInitializer> map = initializers;
        synchronized (map) {
            init = initializers.get(cb);
        }
        ThreadGroup group = null;
        if (init != null) {
            void var1_2;
            Callback callback;
            void var2_4;
            group = init.getThreadGroup(cb);
            args.name = init.getName(cb);
            args.daemon = init.isDaemon(cb);
            args.detach = var2_4.detach(callback);
            var1_2.write();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static Callback getCallback(Class<?> type, Pointer p) {
        void var1_1;
        return CallbackReference.getCallback(type, (Pointer)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private static Callback getCallback(Class<?> type, Pointer p, boolean direct) {
        if (p == null) {
            return null;
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Callback type must be an interface");
        }
        Map<Callback, CallbackReference> map = direct ? directCallbackMap : callbackMap;
        Map<Pointer, Reference<Callback>[]> map2 = pointerCallbackMap;
        synchronized (map2) {
            void var2_4;
            void var1_2;
            Class<?> clazz;
            Reference<Callback>[] array = pointerCallbackMap.get(p);
            Callback cb = CallbackReference.getTypeAssignableCallback(type, array);
            if (cb != null) {
                return cb;
            }
            cb = CallbackReference.createCallback(clazz, p);
            pointerCallbackMap.put((Pointer)var1_2, CallbackReference.addCallbackToArray(cb, array));
            var2_4.remove(cb);
            return cb;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Callback getTypeAssignableCallback(Class<?> type, Reference<Callback>[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                void var3_3;
                Callback cb = array[i].get();
                if (cb == null || !type.isAssignableFrom(cb.getClass())) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Reference<Callback>[] addCallbackToArray(Callback cb, Reference<Callback>[] array) {
        void var3_4;
        Callback callback;
        int reqArraySize = 1;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i].get() == null) {
                    array[i] = null;
                    continue;
                }
                ++reqArraySize;
            }
        }
        Reference[] newArray = new Reference[reqArraySize];
        int nidx = 0;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                newArray[nidx++] = array[i];
            }
        }
        newArray[var2_2] = new WeakReference<Callback>(callback);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static Callback createCallback(Class<?> type, Pointer p) {
        void var1_1;
        Class<?> clazz;
        void var3_3;
        void var2_2;
        int ctype = AltCallingConvention.class.isAssignableFrom(type) ? 63 : 0;
        HashMap<String, Object> foptions = new HashMap<String, Object>(Native.getLibraryOptions(type));
        foptions.put("invoking-method", CallbackReference.getCallbackMethod(type));
        NativeFunctionHandler h = new NativeFunctionHandler(p, (int)var2_2, (Map<String, ?>)var3_3);
        return (Callback)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{clazz}, (InvocationHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private CallbackReference(Callback callback, int callingConvention, boolean direct) {
        super(callback);
        long peer;
        TypeMapper mapper = Native.getTypeMapper(callback.getClass());
        this.callingConvention = callingConvention;
        boolean ppc = Platform.isPPC();
        if (direct) {
            Method m = CallbackReference.getCallbackMethod(callback);
            Class<?>[] ptypes = m.getParameterTypes();
            for (int i = 0; i < ptypes.length; ++i) {
                if (ppc && (ptypes[i] == Float.TYPE || ptypes[i] == Double.TYPE)) {
                    direct = false;
                    break;
                }
                if (mapper == null || mapper.getFromNativeConverter(ptypes[i]) == null) continue;
                direct = false;
                break;
            }
            if (mapper != null && mapper.getToNativeConverter(m.getReturnType()) != null) {
                direct = false;
            }
        }
        String encoding = Native.getStringEncoding(callback.getClass());
        if (direct) {
            this.method = CallbackReference.getCallbackMethod(callback);
            Class<?>[] nativeParamTypes = this.method.getParameterTypes();
            Class<?> returnType = this.method.getReturnType();
            int flags = 1;
            if (DLL_CALLBACK_CLASS != null && DLL_CALLBACK_CLASS.isInstance(callback)) {
                flags = 3;
            }
            peer = Native.createNativeCallback(callback, this.method, nativeParamTypes, returnType, callingConvention, flags, encoding);
        } else {
            void var2_2;
            void var3_5;
            void var1_1;
            this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new DefaultCallbackProxy(CallbackReference.getCallbackMethod(callback), mapper, encoding);
            Class<?>[] nativeParamTypes = this.proxy.getParameterTypes();
            Class<?> returnType = this.proxy.getReturnType();
            if (mapper != null) {
                for (int i = 0; i < nativeParamTypes.length; ++i) {
                    FromNativeConverter rc = mapper.getFromNativeConverter(nativeParamTypes[i]);
                    if (rc == null) continue;
                    nativeParamTypes[i] = rc.nativeType();
                }
                ToNativeConverter tn = mapper.getToNativeConverter(returnType);
                if (tn != null) {
                    returnType = tn.nativeType();
                }
            }
            for (int i = 0; i < nativeParamTypes.length; ++i) {
                nativeParamTypes[i] = this.getNativeType(nativeParamTypes[i]);
                if (CallbackReference.isAllowableNativeType(nativeParamTypes[i])) continue;
                String msg = "Callback argument " + nativeParamTypes[i] + " requires custom type conversion";
                throw new IllegalArgumentException(msg);
            }
            if (!CallbackReference.isAllowableNativeType(returnType = this.getNativeType(returnType))) {
                String msg = "Callback return type " + returnType + " requires custom type conversion";
                throw new IllegalArgumentException(msg);
            }
            int flags = DLL_CALLBACK_CLASS != null && DLL_CALLBACK_CLASS.isInstance(var1_1) ? 2 : 0;
            peer = Native.createNativeCallback(this.proxy, PROXY_CALLBACK_METHOD, var3_5, returnType, (int)var2_2, flags, encoding);
        }
        Pointer pointer = this.cbstruct = peer != 0L ? new Pointer(peer) : null;
        if (peer != 0L) {
            allocatedMemory.put(peer, new WeakReference<CallbackReference>(this));
            this.cleanable = Cleaner.getCleaner().register(this, new CallbackReferenceDisposer(this.cbstruct));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> getNativeType(Class<?> cls) {
        void var1_1;
        if (Structure.class.isAssignableFrom(cls)) {
            Structure.validate(cls);
            if (!Structure.ByValue.class.isAssignableFrom(cls)) {
                return Pointer.class;
            }
        } else {
            if (NativeMapped.class.isAssignableFrom(cls)) {
                return NativeMappedConverter.getInstance(cls).nativeType();
            }
            if (cls == String.class || cls == WString.class || cls == String[].class || cls == WString[].class || Callback.class.isAssignableFrom(cls)) {
                return Pointer.class;
            }
        }
        return var1_1;
    }

    private static Method checkMethod(Method m) {
        String string;
        if (m.getParameterTypes().length > 256) {
            String msg = "Method signature exceeds the maximum parameter count: " + m;
            throw new UnsupportedOperationException(string);
        }
        return string;
    }

    static Class<?> findCallbackClass(Class<?> type) {
        Class<?> clazz;
        while (true) {
            if (!Callback.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException(type.getName() + " is not derived from com.sun.jna.Callback");
            }
            if (type.isInterface()) {
                return type;
            }
            Class<?>[] ifaces = type.getInterfaces();
            for (int i = 0; i < ifaces.length; ++i) {
                if (!Callback.class.isAssignableFrom(ifaces[i])) continue;
                try {
                    CallbackReference.getCallbackMethod(ifaces[i]);
                    return ifaces[i];
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break;
                }
            }
            if (!Callback.class.isAssignableFrom(type.getSuperclass())) break;
            type = type.getSuperclass();
        }
        return clazz;
    }

    private static Method getCallbackMethod(Callback callback) {
        return CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
    }

    /*
     * WARNING - void declaration
     */
    private static Method getCallbackMethod(Class<?> cls) {
        void var2_4;
        Method[] pubMethods = cls.getDeclaredMethods();
        Method[] classMethods = cls.getMethods();
        HashSet<Method> pmethods = new HashSet<Method>(Arrays.asList(pubMethods));
        pmethods.retainAll(Arrays.asList(classMethods));
        Method[] i = pmethods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!Callback.FORBIDDEN_NAMES.contains(m.getName())) continue;
            i.remove();
        }
        Method[] methods = pmethods.toArray(new Method[0]);
        if (methods.length == 1) {
            return CallbackReference.checkMethod((Method)methods[0]);
        }
        for (int i2 = 0; i2 < methods.length; ++i2) {
            void var1_1;
            Object m = methods[i2];
            if (!"callback".equals(((Method)m).getName())) continue;
            return CallbackReference.checkMethod((Method)var1_1);
        }
        String msg = "Callback must implement a single public method, or one public method named 'callback'";
        throw new IllegalArgumentException((String)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    private void setCallbackOptions(int options) {
        void var1_1;
        this.cbstruct.setInt(Native.POINTER_SIZE, (int)var1_1);
    }

    public Pointer getTrampoline() {
        if (this.trampoline == null) {
            this.trampoline = this.cbstruct.getPointer(0L);
        }
        return this.trampoline;
    }

    @Override
    public void close() {
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
        this.cbstruct = null;
    }

    @Deprecated
    protected void dispose() {
        this.close();
    }

    static void disposeAll() {
        Object object = new LinkedList<Reference<CallbackReference>>(allocatedMemory.values());
        object = object.iterator();
        while (object.hasNext()) {
            Reference reference = (Reference)object.next();
            CallbackReference ref = (CallbackReference)reference.get();
            if (ref == null) continue;
            ((CallbackReference)reference).close();
        }
    }

    private Callback getCallback() {
        return (Callback)this.get();
    }

    private static Pointer getNativeFunctionPointer(Callback cb) {
        Object handler;
        if (Proxy.isProxyClass(cb.getClass()) && (handler = Proxy.getInvocationHandler(cb)) instanceof NativeFunctionHandler) {
            Object object;
            return ((NativeFunctionHandler)object).getPointer();
        }
        return null;
    }

    public static Pointer getFunctionPointer(Callback cb) {
        return CallbackReference.getFunctionPointer(cb, false);
    }

    /*
     * WARNING - void declaration
     */
    private static Pointer getFunctionPointer(Callback cb, boolean direct) {
        if (cb == null) {
            return null;
        }
        Pointer fp = CallbackReference.getNativeFunctionPointer(cb);
        if (fp != null) {
            return fp;
        }
        Map<String, Object> options = Native.getLibraryOptions(cb.getClass());
        int callingConvention = cb instanceof AltCallingConvention ? 63 : (options != null && options.containsKey("calling-convention") ? (Integer)options.get("calling-convention") : 0);
        Map<Callback, CallbackReference> map = direct ? directCallbackMap : callbackMap;
        Map<Pointer, Reference<Callback>[]> map2 = pointerCallbackMap;
        synchronized (map2) {
            CallbackReference cbref = map.get(cb);
            if (cbref == null || cbref.cbstruct == null) {
                Callback callback;
                void var3_5;
                void var1_2;
                void var2_4;
                cbref = new CallbackReference(cb, (int)var2_4, (boolean)var1_2);
                var3_5.put(cb, cbref);
                pointerCallbackMap.put(cbref.getTrampoline(), CallbackReference.addCallbackToArray(cb, null));
                if (initializers.containsKey(callback)) {
                    cbref.setCallbackOptions(1);
                }
            }
            return cbref.getTrampoline();
        }
    }

    private static boolean isAllowableNativeType(Class<?> cls) {
        Class<?> clazz;
        return cls == Void.TYPE || cls == Void.class || cls == Boolean.TYPE || cls == Boolean.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Character.TYPE || cls == Character.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == Float.TYPE || cls == Float.class || cls == Double.TYPE || cls == Double.class || Structure.ByValue.class.isAssignableFrom(cls) && Structure.class.isAssignableFrom(cls) || Pointer.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    private static Pointer getNativeString(Object value, boolean wide) {
        if (value != null) {
            void var1_2;
            Object object;
            NativeString ns = new NativeString(value.toString(), wide);
            allocations.put(object, ns);
            return var1_2.getPointer();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Pointer access$100(Object x0, boolean x1) {
        void var1_1;
        return CallbackReference.getNativeString(x0, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            PROXY_CALLBACK_METHOD = CallbackProxy.class.getMethod("callback", Object[].class);
        }
        catch (Exception exception) {
            throw new Error("Error looking up CallbackProxy.callback() method");
        }
        if (Platform.isWindows()) {
            try {
                DLL_CALLBACK_CLASS = Class.forName("com.sun.jna.win32.DLLCallback");
            }
            catch (ClassNotFoundException e) {
                void var0;
                throw new Error("Error loading DLLCallback class", (Throwable)var0);
            }
        } else {
            DLL_CALLBACK_CLASS = null;
        }
        initializers = new WeakHashMap<Callback, CallbackThreadInitializer>();
    }

    private class DefaultCallbackProxy
    implements CallbackProxy {
        private final Method callbackMethod;
        private ToNativeConverter toNative;
        private final FromNativeConverter[] fromNative;
        private final String encoding;

        /*
         * WARNING - void declaration
         */
        public DefaultCallbackProxy(Method callbackMethod, TypeMapper mapper, String encoding) {
            this.callbackMethod = callbackMethod;
            this.encoding = encoding;
            Class<?>[] argTypes = callbackMethod.getParameterTypes();
            Class<?> returnType = callbackMethod.getReturnType();
            this.fromNative = new FromNativeConverter[argTypes.length];
            if (NativeMapped.class.isAssignableFrom(returnType)) {
                this.toNative = NativeMappedConverter.getInstance(returnType);
            } else if (mapper != null) {
                this.toNative = mapper.getToNativeConverter(returnType);
            }
            for (int i = 0; i < this.fromNative.length; ++i) {
                if (NativeMapped.class.isAssignableFrom(argTypes[i])) {
                    this.fromNative[i] = new NativeMappedConverter(argTypes[i]);
                    continue;
                }
                if (mapper == null) continue;
                this.fromNative[i] = mapper.getFromNativeConverter(argTypes[i]);
            }
            if (!callbackMethod.isAccessible()) {
                try {
                    callbackMethod.setAccessible(true);
                    return;
                }
                catch (SecurityException securityException) {
                    void var2_2;
                    throw new IllegalArgumentException("Callback method is inaccessible, make sure the interface is public: " + var2_2);
                }
            }
        }

        public Callback getCallback() {
            return CallbackReference.this.getCallback();
        }

        private Object invokeCallback(Object[] args) {
            Class<?>[] paramTypes = this.callbackMethod.getParameterTypes();
            Object[] callbackArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                CallbackParameterContext context;
                Class<?> type = paramTypes[i];
                Object arg = args[i];
                if (this.fromNative[i] != null) {
                    context = new CallbackParameterContext(type, this.callbackMethod, args, i);
                    callbackArgs[i] = this.fromNative[i].fromNative(arg, context);
                    continue;
                }
                callbackArgs[i] = this.convertArgument(arg, (Class<?>)((Object)context));
            }
            Object result = null;
            Callback cb = this.getCallback();
            if (cb != null) {
                try {
                    DefaultCallbackProxy defaultCallbackProxy = this;
                    result = defaultCallbackProxy.convertResult(defaultCallbackProxy.callbackMethod.invoke((Object)cb, callbackArgs));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Native.getCallbackExceptionHandler().uncaughtException(cb, e);
                }
                catch (InvocationTargetException e) {
                    Native.getCallbackExceptionHandler().uncaughtException(cb, e.getTargetException());
                }
            }
            for (int i = 0; i < callbackArgs.length; ++i) {
                if (!(callbackArgs[i] instanceof Structure) || callbackArgs[i] instanceof Structure.ByValue) continue;
                ((Structure)callbackArgs[i]).autoWrite();
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object callback(Object[] args) {
            try {
                return this.invokeCallback(args);
            }
            catch (Throwable t) {
                void var1_2;
                Native.getCallbackExceptionHandler().uncaughtException(this.getCallback(), (Throwable)var1_2);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private Object convertArgument(Object value, Class<?> dstType) {
            void var1_1;
            void var2_2;
            if (value instanceof Pointer) {
                if (dstType == String.class) {
                    value = ((Pointer)value).getString(0L, this.encoding);
                } else if (dstType == WString.class) {
                    value = new WString(((Pointer)value).getWideString(0L));
                } else if (dstType == String[].class) {
                    value = ((Pointer)value).getStringArray(0L, this.encoding);
                } else if (dstType == WString[].class) {
                    value = ((Pointer)value).getWideStringArray(0L);
                } else if (Callback.class.isAssignableFrom(dstType)) {
                    value = CallbackReference.getCallback(dstType, (Pointer)value);
                } else if (Structure.class.isAssignableFrom(dstType)) {
                    Object s;
                    if (Structure.ByValue.class.isAssignableFrom(dstType)) {
                        void var3_3;
                        s = Structure.newInstance(dstType);
                        byte[] buf = new byte[((Structure)s).size()];
                        ((Pointer)value).read(0L, buf, 0, buf.length);
                        ((Structure)s).getPointer().write(0L, buf, 0, ((void)var3_3).length);
                        ((Structure)s).read();
                        value = s;
                    } else {
                        s = Structure.newInstance(s, (Pointer)value);
                        ((Structure)s).conditionalAutoRead();
                        value = var2_2;
                    }
                }
            } else if ((Boolean.TYPE == var2_2 || Boolean.class == var2_2) && value instanceof Number) {
                value = Function.valueOf(((Number)value).intValue() != 0);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Object convertResult(Object value) {
            void var1_1;
            void var2_2;
            if (this.toNative != null) {
                value = this.toNative.toNative(value, new CallbackResultContext(this.callbackMethod));
            }
            if (value == null) {
                return null;
            }
            Class<?> cls = value.getClass();
            if (Structure.class.isAssignableFrom(cls)) {
                if (Structure.ByValue.class.isAssignableFrom(cls)) {
                    return value;
                }
                return ((Structure)value).getPointer();
            }
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                if (Boolean.TRUE.equals(value)) {
                    return Function.INTEGER_TRUE;
                }
                return Function.INTEGER_FALSE;
            }
            if (cls == String.class || cls == WString.class) {
                return CallbackReference.access$100(value, cls == WString.class);
            }
            if (cls == String[].class || cls == WString[].class) {
                StringArray sa = cls == String[].class ? new StringArray((String[])value, this.encoding) : new StringArray((WString[])value);
                allocations.put(value, sa);
                return var2_2;
            }
            if (Callback.class.isAssignableFrom((Class<?>)var2_2)) {
                return CallbackReference.getFunctionPointer((Callback)value);
            }
            return var1_1;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.callbackMethod.getParameterTypes();
        }

        @Override
        public Class<?> getReturnType() {
            return this.callbackMethod.getReturnType();
        }
    }

    static class AttachOptions
    extends Structure {
        public static final List<String> FIELDS = AttachOptions.createFieldsOrder("daemon", "detach", "name");
        public boolean daemon;
        public boolean detach;
        public String name;

        AttachOptions() {
            this.setStringEncoding("utf8");
        }

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }
    }

    private static class NativeFunctionHandler
    implements InvocationHandler {
        private final Function function;
        private final Map<String, ?> options;

        /*
         * WARNING - void declaration
         */
        public NativeFunctionHandler(Pointer address, int callingConvention, Map<String, ?> options) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.options = options;
            this.function = new Function((Pointer)var1_1, (int)var2_2, (String)var3_3.get("string-encoding"));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            void var3_3;
            void var2_2;
            if (Library.Handler.OBJECT_TOSTRING.equals(method)) {
                String str = "Proxy interface to " + this.function;
                method = (Method)this.options.get("invoking-method");
                Class<?> cls = CallbackReference.findCallbackClass(method.getDeclaringClass());
                str = str + " (" + var2_2.getName() + ")";
                return str;
            }
            if (Library.Handler.OBJECT_HASHCODE.equals(var2_2)) {
                return this.hashCode();
            }
            if (Library.Handler.OBJECT_EQUALS.equals(var2_2)) {
                Object o = args[0];
                if (o != null && Proxy.isProxyClass(o.getClass())) {
                    void var1_1;
                    return Function.valueOf(Proxy.getInvocationHandler(var1_1) == this);
                }
                return Boolean.FALSE;
            }
            if (Function.isVarArgs((Method)var2_2)) {
                args = Function.concatenateVarArgs(args);
            }
            return this.function.invoke(var2_2.getReturnType(), (Object[])var3_3, this.options);
        }

        public Pointer getPointer() {
            return this.function;
        }
    }

    private static final class CallbackReferenceDisposer
    implements Runnable {
        private Pointer cbstruct;

        /*
         * WARNING - void declaration
         */
        public CallbackReferenceDisposer(Pointer cbstruct) {
            void var1_1;
            this.cbstruct = var1_1;
        }

        @Override
        public final synchronized void run() {
            if (this.cbstruct != null) {
                try {
                    Native.freeNativeCallback(this.cbstruct.peer);
                    return;
                }
                finally {
                    allocatedMemory.remove(this.cbstruct.peer);
                    this.cbstruct.peer = 0L;
                    this.cbstruct = null;
                }
            }
        }
    }
}

