/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionHelpersKt;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010 \u001a\u0004\b#\u0010\"R\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b$\u0010\"R\u0017\u0010\b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b%\u0010\"R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010&\u001a\u0004\b'\u0010(R\u0011\u0010*\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001cR\u0011\u0010,\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\"R\u0011\u00100\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00104\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00106\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00103"}, d2={"Landroidx/compose/foundation/text/selection/SelectableInfo;", "", "", "selectableId", "", "slot", "rawStartHandleOffset", "rawEndHandleOffset", "rawPreviousHandleOffset", "Landroidx/compose/ui/text/TextLayoutResult;", "textLayoutResult", "<init>", "(JIIIILandroidx/compose/ui/text/TextLayoutResult;)V", "other", "", "shouldRecomputeSelection", "(Landroidx/compose/foundation/text/selection/SelectableInfo;)Z", "offset", "Landroidx/compose/foundation/text/selection/Selection$AnchorInfo;", "anchorForOffset", "(I)Landroidx/compose/foundation/text/selection/Selection$AnchorInfo;", "start", "end", "Landroidx/compose/foundation/text/selection/Selection;", "makeSingleLayoutSelection", "(II)Landroidx/compose/foundation/text/selection/Selection;", "", "toString", "()Ljava/lang/String;", "J", "getSelectableId", "()J", "I", "getSlot", "()I", "getRawStartHandleOffset", "getRawEndHandleOffset", "getRawPreviousHandleOffset", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "getInputText", "inputText", "getTextLength", "textLength", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getRawCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "rawCrossStatus", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getStartRunDirection", "()Landroidx/compose/ui/text/style/ResolvedTextDirection;", "startRunDirection", "getEndRunDirection", "endRunDirection"})
public final class SelectableInfo {
    private final long selectableId;
    private final int slot;
    private final int rawStartHandleOffset;
    private final int rawEndHandleOffset;
    private final int rawPreviousHandleOffset;
    private final TextLayoutResult textLayoutResult;
    public static final int $stable = TextLayoutResult.$stable;

    /*
     * WARNING - void declaration
     */
    public SelectableInfo(long selectableId, int slot, int rawStartHandleOffset, int rawEndHandleOffset, int rawPreviousHandleOffset, TextLayoutResult textLayoutResult) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        this.selectableId = var1_1;
        this.slot = var3_2;
        this.rawStartHandleOffset = rawStartHandleOffset;
        this.rawEndHandleOffset = rawEndHandleOffset;
        this.rawPreviousHandleOffset = rawPreviousHandleOffset;
        this.textLayoutResult = textLayoutResult;
    }

    public final long getSelectableId() {
        return this.selectableId;
    }

    public final int getSlot() {
        return this.slot;
    }

    public final int getRawStartHandleOffset() {
        return this.rawStartHandleOffset;
    }

    public final int getRawEndHandleOffset() {
        return this.rawEndHandleOffset;
    }

    public final int getRawPreviousHandleOffset() {
        return this.rawPreviousHandleOffset;
    }

    public final TextLayoutResult getTextLayoutResult() {
        return this.textLayoutResult;
    }

    public final String getInputText() {
        return this.textLayoutResult.getLayoutInput().getText().getText();
    }

    public final int getTextLength() {
        return this.getInputText().length();
    }

    public final CrossStatus getRawCrossStatus() {
        if (this.rawStartHandleOffset < this.rawEndHandleOffset) {
            return CrossStatus.NOT_CROSSED;
        }
        if (this.rawStartHandleOffset > this.rawEndHandleOffset) {
            return CrossStatus.CROSSED;
        }
        return CrossStatus.COLLAPSED;
    }

    private final ResolvedTextDirection getStartRunDirection() {
        return SelectionHelpersKt.getTextDirectionForOffset(this.textLayoutResult, this.rawStartHandleOffset);
    }

    private final ResolvedTextDirection getEndRunDirection() {
        return SelectionHelpersKt.getTextDirectionForOffset(this.textLayoutResult, this.rawEndHandleOffset);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean shouldRecomputeSelection(SelectableInfo other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.selectableId != other.selectableId || this.rawStartHandleOffset != other.rawStartHandleOffset || this.rawEndHandleOffset != var1_1.rawEndHandleOffset;
    }

    /*
     * WARNING - void declaration
     */
    public final Selection.AnchorInfo anchorForOffset(int offset) {
        void var1_1;
        return new Selection.AnchorInfo(SelectionHelpersKt.getTextDirectionForOffset(this.textLayoutResult, offset), (int)var1_1, this.selectableId);
    }

    /*
     * WARNING - void declaration
     */
    public final Selection makeSingleLayoutSelection(int start, int end) {
        void var2_2;
        void var1_1;
        return new Selection(this.anchorForOffset(start), this.anchorForOffset(end), var1_1 > var2_2);
    }

    public final String toString() {
        return "SelectionInfo(id=" + this.selectableId + ", range=(" + this.rawStartHandleOffset + "-" + this.getStartRunDirection() + "," + this.rawEndHandleOffset + "-" + this.getEndRunDirection() + "), prevOffset=" + this.rawPreviousHandleOffset + ")";
    }
}

