/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.platform.SynchronizedObject;
import androidx.compose.foundation.text.TextLayoutHelperKt;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegateKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutBuilder;
import androidx.compose.foundation.text.selection.TextSelectionDelegateKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0011\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020!H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020(2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b)\u0010*R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010+\u001a\u0004\b,\u0010-R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010.R\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010.R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0018\u00102\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0018\u00107\u001a\u00020!*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u00106"}, d2={"Landroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate;", "Landroidx/compose/foundation/text/selection/Selectable;", "", "selectableId", "Lkotlin/Function0;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "coordinatesCallback", "Landroidx/compose/ui/text/TextLayoutResult;", "layoutResultCallback", "<init>", "(JLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "Landroidx/compose/foundation/text/selection/SelectionLayoutBuilder;", "builder", "", "appendSelectableInfoToBuilder", "(Landroidx/compose/foundation/text/selection/SelectionLayoutBuilder;)V", "Landroidx/compose/foundation/text/selection/Selection;", "getSelectAllSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "selection", "", "isStartHandle", "Landroidx/compose/ui/geometry/Offset;", "getHandlePosition-dBAh8RU", "(Landroidx/compose/foundation/text/selection/Selection;Z)J", "getHandlePosition", "getLayoutCoordinates", "()Landroidx/compose/ui/layout/LayoutCoordinates;", "textLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "Landroidx/compose/ui/text/AnnotatedString;", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "", "offset", "Landroidx/compose/ui/geometry/Rect;", "getBoundingBox", "(I)Landroidx/compose/ui/geometry/Rect;", "getLastVisibleOffset", "()I", "", "getLineHeight", "(I)F", "J", "getSelectableId", "()J", "Lkotlin/jvm/functions/Function0;", "Landroidx/compose/foundation/platform/SynchronizedObject;", "lock", "Landroidx/compose/foundation/platform/SynchronizedObject;", "_previousTextLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "_previousLastVisibleOffset", "I", "(Landroidx/compose/ui/text/TextLayoutResult;)I", "lastVisibleOffset"})
@SourceDebugExtension(value={"SMAP\nMultiWidgetSelectionDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiWidgetSelectionDelegate.kt\nandroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate\n+ 2 Synchronization.skiko.kt\nandroidx/compose/foundation/platform/SynchronizationKt\n+ 3 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n*L\n1#1,366:1\n28#2:367\n34#2:368\n59#3:369\n59#3:371\n90#4:370\n90#4:372\n278#5:373\n*S KotlinDebug\n*F\n+ 1 MultiWidgetSelectionDelegate.kt\nandroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate\n*L\n36#1:367\n52#1:368\n59#1:369\n68#1:371\n59#1:370\n68#1:372\n87#1:373\n*E\n"})
public final class MultiWidgetSelectionDelegate
implements Selectable {
    private final long selectableId;
    private final Function0<LayoutCoordinates> coordinatesCallback;
    private final Function0<TextLayoutResult> layoutResultCallback;
    private final SynchronizedObject lock;
    private TextLayoutResult _previousTextLayoutResult;
    private int _previousLastVisibleOffset;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public MultiWidgetSelectionDelegate(long selectableId, Function0<? extends LayoutCoordinates> coordinatesCallback, Function0<TextLayoutResult> layoutResultCallback) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectableId = var1_1;
        this.coordinatesCallback = var3_2;
        this.layoutResultCallback = layoutResultCallback;
        this.lock = new SynchronizedObject();
        this._previousLastVisibleOffset = -1;
    }

    @Override
    public final long getSelectableId() {
        return this.selectableId;
    }

    /*
     * WARNING - void declaration
     */
    private final int getLastVisibleOffset(TextLayoutResult $this$lastVisibleOffset) {
        SynchronizedObject synchronizedObject = this.lock;
        SynchronizedObject synchronizedObject2 = synchronizedObject;
        synchronizedObject2 = synchronizedObject;
        synchronized (synchronizedObject) {
            if (this._previousTextLayoutResult != $this$lastVisibleOffset) {
                void var1_1;
                void var3_7;
                int n;
                if (!$this$lastVisibleOffset.getDidOverflowHeight() || $this$lastVisibleOffset.getMultiParagraph().getDidExceedMaxLines()) {
                    n = $this$lastVisibleOffset.getLineCount() - 1;
                } else {
                    int finalVisibleLine;
                    long l;
                    long l2 = l = $this$lastVisibleOffset.getSize-YbymL2g();
                    for (finalVisibleLine = RangesKt.coerceAtMost((int)(v287267).getLineForVerticalPosition((float)((int)l)), (int)($this$lastVisibleOffset.getLineCount() - 1)); finalVisibleLine >= 0; --finalVisibleLine) {
                        long l3;
                        l2 = l = $this$lastVisibleOffset.getSize-YbymL2g();
                        if (!($this$lastVisibleOffset.getLineTop(finalVisibleLine) >= (float)((int)l3))) break;
                    }
                    n = RangesKt.coerceAtLeast((int)finalVisibleLine, (int)0);
                }
                int lastVisibleLine = n;
                this._previousLastVisibleOffset = $this$lastVisibleOffset.getLineEnd((int)var3_7, true);
                this._previousTextLayoutResult = var1_1;
            }
            int n = this._previousLastVisibleOffset;
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void appendSelectableInfoToBuilder(SelectionLayoutBuilder builder) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long relativePosition = builder.getContainerCoordinates().localPositionOf-R5De75A((LayoutCoordinates)var2_2, Offset.Companion.getZero-F1C5BW0());
        long localPosition = Offset.minus-MK-Hz9U((long)builder.getCurrentPosition-F1C5BW0(), (long)relativePosition);
        long l = builder.getPreviousHandlePosition-F1C5BW0();
        long localPreviousHandlePosition = (l & 0x7FFFFFFF7FFFFFFFL) == 9205357640488583168L ? Offset.Companion.getUnspecified-F1C5BW0() : Offset.minus-MK-Hz9U((long)builder.getPreviousHandlePosition-F1C5BW0(), (long)relativePosition);
        MultiWidgetSelectionDelegateKt.appendSelectableInfo-Parwq6A((SelectionLayoutBuilder)var1_1, (TextLayoutResult)var3_3, localPosition, localPreviousHandlePosition, this.getSelectableId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Selection getSelectAllSelection() {
        void var2_2;
        void var1_1;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int end = textLayoutResult.getLayoutInput().getText().length();
        return new Selection(new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(0), 0, this.getSelectableId()), new Selection.AnchorInfo(var1_1.getBidiRunDirection(Math.max(end - 1, 0)), (int)var2_2, this.getSelectableId()), false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getHandlePosition-dBAh8RU(Selection selection, boolean isStartHandle) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (isStartHandle && selection.getStart().getSelectableId() != this.getSelectableId() || !isStartHandle && selection.getEnd().getSelectableId() != this.getSelectableId()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int n = isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset();
        int coercedOffset = RangesKt.coerceIn((int)n, (int)0, (int)this.getLastVisibleOffset(textLayoutResult2));
        return TextSelectionDelegateKt.getSelectionHandleCoordinates((TextLayoutResult)var3_3, coercedOffset, (boolean)var2_2, var1_1.getHandlesCrossed());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LayoutCoordinates getLayoutCoordinates() {
        void var1_1;
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return var1_1;
    }

    @Override
    public final TextLayoutResult textLayoutResult() {
        return (TextLayoutResult)this.layoutResultCallback.invoke();
    }

    @Override
    public final AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, 2, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult.getLayoutInput().getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Rect getBoundingBox(int offset) {
        void var3_3;
        void var1_1;
        void var2_2;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult.getLayoutInput().getText().length();
        if (textLength <= 0) {
            return Rect.Companion.getZero();
        }
        return var2_2.getBoundingBox(RangesKt.coerceIn((int)var1_1, (int)0, (int)(var3_3 - true)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getLastVisibleOffset() {
        void var1_1;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return this.getLastVisibleOffset((TextLayoutResult)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getLineHeight(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult != null) {
            void var1_1;
            return TextLayoutHelperKt.getLineHeight(textLayoutResult, (int)var1_1);
        }
        return 0.0f;
    }
}

