/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongIntMap;
import androidx.collection.LongObjectMap;
import androidx.collection.LongObjectMapKt;
import androidx.collection.MutableLongObjectMap;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0003\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0013\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0016\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u001a\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ9\u0010\"\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\f0\u001e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010)\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010,\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b,\u0010*J\u0017\u0010/\u001a\u00020\u00072\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b/\u00100R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u00101R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0006\u00102R\u001a\u0010\b\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u00103\u001a\u0004\b4\u00105R\u001a\u0010\t\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u00103\u001a\u0004\b6\u00105R\u001a\u0010\u000b\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u00107\u001a\u0004\b\u000b\u00108R\u001c\u0010\r\u001a\u0004\u0018\u00010\f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u00109\u001a\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u00105R\u0014\u0010A\u001a\u00020>8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0014\u0010D\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0014\u0010F\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010CR\u0014\u0010H\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010CR\u0014\u0010J\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010CR\u0014\u0010L\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010C"}, d2={"Landroidx/compose/foundation/text/selection/MultiSelectionLayout;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "Landroidx/collection/LongIntMap;", "selectableIdToInfoListIndex", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "infoList", "", "startSlot", "endSlot", "", "isStartHandle", "Landroidx/compose/foundation/text/selection/Selection;", "previousSelection", "<init>", "(Landroidx/collection/LongIntMap;Ljava/util/List;IIZLandroidx/compose/foundation/text/selection/Selection;)V", "Lkotlin/Function1;", "", "block", "forEachMiddleInfo", "(Lkotlin/jvm/functions/Function1;)V", "other", "shouldRecomputeSelection", "(Landroidx/compose/foundation/text/selection/SelectionLayout;)Z", "shouldAnyInfoRecomputeSelection", "(Landroidx/compose/foundation/text/selection/MultiSelectionLayout;)Z", "selection", "Landroidx/collection/LongObjectMap;", "createSubSelections", "(Landroidx/compose/foundation/text/selection/Selection;)Landroidx/collection/LongObjectMap;", "Landroidx/collection/MutableLongObjectMap;", "info", "minOffset", "maxOffset", "createAndPutSubSelection", "(Landroidx/collection/MutableLongObjectMap;Landroidx/compose/foundation/text/selection/Selection;Landroidx/compose/foundation/text/selection/SelectableInfo;II)V", "", "toString", "()Ljava/lang/String;", "slot", "isStartSlot", "startOrEndSlotToIndex", "(IZ)I", "isMinimumSlot", "slotToIndex", "", "id", "getInfoListIndexBySelectableId", "(J)I", "Landroidx/collection/LongIntMap;", "Ljava/util/List;", "I", "getStartSlot", "()I", "getEndSlot", "Z", "()Z", "Landroidx/compose/foundation/text/selection/Selection;", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "getSize", "size", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "crossStatus", "getStartInfo", "()Landroidx/compose/foundation/text/selection/SelectableInfo;", "startInfo", "getEndInfo", "endInfo", "getCurrentInfo", "currentInfo", "getFirstInfo", "firstInfo", "getLastInfo", "lastInfo"})
@SourceDebugExtension(value={"SMAP\nSelectionLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,739:1\n51#2,4:740\n51#2,4:744\n51#2,4:749\n1#3:748\n71#4,5:753\n*S KotlinDebug\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n*L\n147#1:740,4\n224#1:744,4\n264#1:749,4\n281#1:753,5\n*E\n"})
final class MultiSelectionLayout
implements SelectionLayout {
    public final LongIntMap selectableIdToInfoListIndex;
    public final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    private final Selection previousSelection;

    /*
     * WARNING - void declaration
     */
    public MultiSelectionLayout(LongIntMap selectableIdToInfoListIndex, List<SelectableInfo> infoList, int startSlot, int endSlot, boolean isStartHandle, Selection previousSelection) {
        void var3_4;
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)selectableIdToInfoListIndex, (String)"selectableIdToInfoListIndex");
        Intrinsics.checkNotNullParameter(infoList, (String)"infoList");
        this.selectableIdToInfoListIndex = var1_1;
        this.infoList = var2_3;
        this.startSlot = var3_4;
        this.endSlot = endSlot;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        boolean bl = this.infoList.size() > 1;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + ".");
        }
    }

    @Override
    public final int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public final int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public final boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    public final Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public final int getSize() {
        return this.infoList.size();
    }

    @Override
    public final CrossStatus getCrossStatus() {
        if (this.getStartSlot() < this.getEndSlot()) {
            return CrossStatus.NOT_CROSSED;
        }
        if (this.getStartSlot() > this.getEndSlot()) {
            return CrossStatus.CROSSED;
        }
        return this.infoList.get(this.getStartSlot() / 2).getRawCrossStatus();
    }

    @Override
    public final SelectableInfo getStartInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.getStartSlot(), true));
    }

    @Override
    public final SelectableInfo getEndInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.getEndSlot(), false));
    }

    @Override
    public final SelectableInfo getCurrentInfo() {
        if (this.isStartHandle()) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final SelectableInfo getFirstInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getEndInfo();
        }
        return this.getStartInfo();
    }

    public final SelectableInfo getLastInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final void forEachMiddleInfo(Function1<? super SelectableInfo, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MultiSelectionLayout multiSelectionLayout = this;
        int minIndex = multiSelectionLayout.getInfoListIndexBySelectableId(multiSelectionLayout.getFirstInfo().getSelectableId());
        MultiSelectionLayout multiSelectionLayout2 = this;
        int maxIndex = multiSelectionLayout2.getInfoListIndexBySelectableId(multiSelectionLayout2.getLastInfo().getSelectableId());
        if (minIndex + 1 >= maxIndex) {
            return;
        }
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            block.invoke((Object)this.infoList.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean shouldRecomputeSelection(SelectionLayout other) {
        void var1_1;
        return this.getPreviousSelection() == null || other == null || !(other instanceof MultiSelectionLayout) || this.isStartHandle() != ((MultiSelectionLayout)other).isStartHandle() || this.getStartSlot() != ((MultiSelectionLayout)other).getStartSlot() || this.getEndSlot() != ((MultiSelectionLayout)other).getEndSlot() || this.shouldAnyInfoRecomputeSelection((MultiSelectionLayout)var1_1);
    }

    private final boolean shouldAnyInfoRecomputeSelection(MultiSelectionLayout other) {
        if (this.getSize() != other.getSize()) {
            return true;
        }
        int n = ((Collection)this.infoList).size();
        for (int i = 0; i < n; ++i) {
            SelectableInfo otherInfo;
            SelectableInfo thisInfo = this.infoList.get(i);
            if (!thisInfo.shouldRecomputeSelection(otherInfo = other.infoList.get(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LongObjectMap<Selection> createSubSelections(Selection selection) {
        void var1_1;
        void var3_4;
        MutableLongObjectMap mutableLongObjectMap;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            boolean bl = selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset();
            if (!bl) {
                InlineClassHelperKt.throwIllegalStateException("unexpectedly miss-crossed selection: " + selection);
            }
            return LongObjectMapKt.longObjectMapOf((long)selection.getStart().getSelectableId(), (Object)selection);
        }
        MutableLongObjectMap $this$createSubSelections_u24lambda_u245 = mutableLongObjectMap = LongObjectMapKt.mutableLongObjectMapOf();
        Selection $this$createSubSelections_u24lambda_u245_u24lambda_u242 = selection;
        Selection.AnchorInfo minAnchor = $this$createSubSelections_u24lambda_u245_u24lambda_u242.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u245_u24lambda_u242.getEnd() : $this$createSubSelections_u24lambda_u245_u24lambda_u242.getStart();
        this.createAndPutSubSelection((MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u245, selection, this.getFirstInfo(), minAnchor.getOffset(), this.getFirstInfo().getTextLength());
        MultiSelectionLayout multiSelectionLayout = this;
        multiSelectionLayout.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)arg_0 -> MultiSelectionLayout.createSubSelections$lambda$5$lambda$3(multiSelectionLayout, $this$createSubSelections_u24lambda_u245, selection, arg_0)));
        Selection $this$createSubSelections_u24lambda_u245_u24lambda_u244 = selection;
        Selection.AnchorInfo maxAnchor = $this$createSubSelections_u24lambda_u245_u24lambda_u244.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u245_u24lambda_u244.getStart() : $this$createSubSelections_u24lambda_u245_u24lambda_u244.getEnd();
        this.createAndPutSubSelection((MutableLongObjectMap<Selection>)var3_4, (Selection)var1_1, this.getLastInfo(), 0, maxAnchor.getOffset());
        return (LongObjectMap)mutableLongObjectMap;
    }

    /*
     * WARNING - void declaration
     */
    private final void createAndPutSubSelection(MutableLongObjectMap<Selection> $this$createAndPutSubSelection, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        void var2_2;
        void var3_3;
        void var1_1;
        Selection subSelection = selection.getHandlesCrossed() ? info.makeSingleLayoutSelection(maxOffset, minOffset) : info.makeSingleLayoutSelection(minOffset, maxOffset);
        boolean bl = minOffset <= maxOffset;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("minOffset should be less than or equal to maxOffset: " + subSelection);
        }
        var1_1.put(var3_3.getSelectableId(), (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void $this$toString_u24lambda_u248;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        CrossStatus crossStatus = this.getCrossStatus();
        float f = (float)(this.getEndSlot() + 1) / 2.0f;
        float f2 = (float)(this.getStartSlot() + 1) / 2.0f;
        boolean bl = this.isStartHandle();
        $this$toString_u24lambda_u248.append("[\n\t");
        boolean first = true;
        List<SelectableInfo> $this$fastForEachIndexed$iv = this.infoList;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void info;
            SelectableInfo item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            if (first) {
                first = false;
            } else {
                $this$toString_u24lambda_u248.append(",\n\t");
            }
            $this$toString_u24lambda_u248.append(index + 1 + " -> " + (SelectableInfo)info);
        }
        stringBuilder2.append("\n]");
        return "MultiSelectionLayout(isStartHandle=" + bl + ", startPosition=" + f2 + ", endPosition=" + f + ", crossed=" + crossStatus + ", infos=" + stringBuilder.toString() + ")";
    }

    /*
     * WARNING - void declaration
     */
    private final int startOrEndSlotToIndex(int slot, boolean isStartSlot) {
        void var1_1;
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = isStartSlot;
                break;
            }
            case 3: {
                void var2_2;
                if (var2_2 == false) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.slotToIndex((int)var1_1, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final int slotToIndex(int slot, boolean isMinimumSlot) {
        void var2_2;
        void var1_1;
        boolean slotAdjustment = !isMinimumSlot;
        return (int)((var1_1 - var2_2) / 2);
    }

    /*
     * WARNING - void declaration
     */
    private final int getInfoListIndexBySelectableId(long id) {
        int n;
        try {
            n = this.selectableIdToInfoListIndex.get(id);
        }
        catch (NoSuchElementException e) {
            void var3_3;
            void var1_1;
            throw new IllegalStateException("Invalid selectableId: " + (long)var1_1, (Throwable)var3_3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createSubSelections$lambda$5$lambda$3(MultiSelectionLayout this$0, MutableLongObjectMap $this_apply, Selection $selection, SelectableInfo info) {
        void var3_3;
        void var2_2;
        void var1_1;
        MultiSelectionLayout multiSelectionLayout;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        multiSelectionLayout.createAndPutSubSelection((MutableLongObjectMap<Selection>)var1_1, (Selection)var2_2, info, 0, var3_3.getTextLength());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

