/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.modifiers.SelectionController_jvmKt;
import androidx.compose.foundation.text.modifiers.StaticTextSelectionParams;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegate;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.input.pointer.PointerIconKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0015\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001fR\u0018\u0010!\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020#8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'"}, d2={"Landroidx/compose/foundation/text/modifiers/SelectionController;", "Landroidx/compose/runtime/RememberObserver;", "", "selectableId", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;", "selectionRegistrar", "Landroidx/compose/ui/graphics/Color;", "backgroundSelectionColor", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "params", "<init>", "(JLandroidx/compose/foundation/text/selection/SelectionRegistrar;JLandroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "onRemembered", "()V", "onForgotten", "onAbandoned", "Landroidx/compose/ui/text/TextLayoutResult;", "textLayoutResult", "updateTextLayout", "(Landroidx/compose/ui/text/TextLayoutResult;)V", "Landroidx/compose/ui/layout/LayoutCoordinates;", "coordinates", "updateGlobalPosition", "(Landroidx/compose/ui/layout/LayoutCoordinates;)V", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "drawScope", "draw", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)V", "J", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "Landroidx/compose/foundation/text/selection/Selectable;", "selectable", "Landroidx/compose/foundation/text/selection/Selectable;", "Landroidx/compose/ui/Modifier;", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;"})
@SourceDebugExtension(value={"SMAP\nSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,365:1\n202#2,4:366\n206#2:373\n207#2,3:376\n249#2,14:379\n57#3:370\n61#3:374\n60#4:371\n70#4:375\n22#5:372\n*S KotlinDebug\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n*L\n163#1:366,4\n163#1:373\n163#1:376,3\n163#1:379,14\n163#1:370\n163#1:374\n163#1:371\n163#1:375\n163#1:372\n*E\n"})
public final class SelectionController
implements RememberObserver {
    private final long selectableId;
    private final SelectionRegistrar selectionRegistrar;
    private final long backgroundSelectionColor;
    private StaticTextSelectionParams params;
    private Selectable selectable;
    private final Modifier modifier;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private SelectionController(long selectableId, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)selectionRegistrar, (String)"selectionRegistrar");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.selectableId = var1_1;
        this.selectionRegistrar = var3_2;
        this.backgroundSelectionColor = backgroundSelectionColor;
        this.params = params;
        this.modifier = PointerIconKt.pointerHoverIcon$default((Modifier)SelectionController_jvmKt.makeSelectionModifier(this.selectionRegistrar, this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)() -> SelectionController.modifier$lambda$0(this))), (PointerIcon)PointerIcon.Companion.getText(), (boolean)false, (int)2, null);
    }

    public /* synthetic */ SelectionController(long l, SelectionRegistrar selectionRegistrar, long l2, StaticTextSelectionParams staticTextSelectionParams, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            staticTextSelectionParams = StaticTextSelectionParams.Companion.getEmpty();
        }
        this(l, selectionRegistrar, l2, staticTextSelectionParams, null);
    }

    public final Modifier getModifier() {
        return this.modifier;
    }

    public final void onRemembered() {
        this.selectable = this.selectionRegistrar.subscribe(new MultiWidgetSelectionDelegate(this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)() -> SelectionController.onRemembered$lambda$1(this)), (Function0<TextLayoutResult>)((Function0)() -> SelectionController.onRemembered$lambda$2(this))));
    }

    /*
     * WARNING - void declaration
     */
    public final void onForgotten() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            void var1_1;
            this.selectionRegistrar.unsubscribe((Selectable)var1_1);
            this.selectable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onAbandoned() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            void var1_1;
            this.selectionRegistrar.unsubscribe((Selectable)var1_1);
            this.selectable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTextLayout(TextLayoutResult textLayoutResult) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        TextLayoutResult prevTextLayoutResult = this.params.getTextLayoutResult();
        if (prevTextLayoutResult != null && !Intrinsics.areEqual((Object)var2_2.getLayoutInput().getText(), (Object)textLayoutResult.getLayoutInput().getText())) {
            this.selectionRegistrar.notifySelectableChange(this.selectableId);
        }
        this.params = StaticTextSelectionParams.copy$default(this.params, null, (TextLayoutResult)var1_1, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateGlobalPosition(LayoutCoordinates coordinates) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.params = StaticTextSelectionParams.copy$default(this.params, (LayoutCoordinates)var1_1, null, 2, null);
        this.selectionRegistrar.notifyPositionChange(this.selectableId);
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(DrawScope drawScope) {
        DrawTransform drawTransform;
        int end;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Selection selection = (Selection)this.selectionRegistrar.getSubselections().get(this.selectableId);
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        int start = !selection.getHandlesCrossed() ? selection2.getStart().getOffset() : selection2.getEnd().getOffset();
        int n = end = !selection2.getHandlesCrossed() ? selection2.getEnd().getOffset() : selection2.getStart().getOffset();
        if (start == end) {
            return;
        }
        Selectable selectable = this.selectable;
        int lastOffset = selectable != null ? selectable.getLastVisibleOffset() : 0;
        int clippedStart = RangesKt.coerceAtMost((int)start, (int)lastOffset);
        int clippedEnd = RangesKt.coerceAtMost((int)end, (int)lastOffset);
        Path path = this.params.getPathForRange(clippedStart, clippedEnd);
        if (path == null) {
            return;
        }
        Path selectionPath = path;
        if (this.params.getShouldClip()) {
            long l;
            void $this$draw_u24lambda_u244;
            void $this$clipRect_u2drOu3jXo_u24default$iv = $this$draw_u24lambda_u244;
            long l2 = l = $this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc();
            clippedStart = (int)(l >> 32);
            float right$iv = Float.intBitsToFloat(clippedStart);
            l2 = l = $this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc();
            clippedStart = (int)l;
            float bottom$iv = Float.intBitsToFloat(clippedStart);
            int clipOp$iv = ClipOp.Companion.getIntersect-rtfAjoo();
            void $this$withTransform$iv$iv = drawTransform;
            DrawContext $this$withTransform_u24lambda_u246$iv$iv = $this$withTransform$iv$iv.getDrawContext();
            long previousSize$iv$iv = $this$withTransform_u24lambda_u246$iv$iv.getSize-NH-jbRc();
            $this$withTransform_u24lambda_u246$iv$iv.getCanvas().save();
            try {
                void var3_7;
                drawTransform = $this$withTransform_u24lambda_u246$iv$iv.getTransform();
                drawTransform.clipRect-N_I0leg(0.0f, 0.0f, right$iv, (float)var3_7, clipOp$iv);
                drawTransform = $this$withTransform$iv$iv;
                DrawScope.drawPath-LG529CI$default((DrawScope)drawTransform, (Path)selectionPath, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
            }
            finally {
                $this$withTransform_u24lambda_u246$iv$iv.getCanvas().restore();
                $this$withTransform_u24lambda_u246$iv$iv.setSize-uvyYCjk(previousSize$iv$iv);
            }
        } else {
            void var2_5;
            DrawScope.drawPath-LG529CI$default((DrawScope)drawTransform, (Path)var2_5, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
        }
    }

    private static final LayoutCoordinates modifier$lambda$0(SelectionController this$0) {
        return this$0.params.getLayoutCoordinates();
    }

    private static final LayoutCoordinates onRemembered$lambda$1(SelectionController this$0) {
        return this$0.params.getLayoutCoordinates();
    }

    private static final TextLayoutResult onRemembered$lambda$2(SelectionController this$0) {
        return this$0.params.getTextLayoutResult();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ SelectionController(long selectableId, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params, DefaultConstructorMarker $constructor_marker) {
        this((long)var1_1, (SelectionRegistrar)var3_2, backgroundSelectionColor, params);
        void var3_2;
        void var1_1;
    }
}

