/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.CoreTextFieldKt;
import androidx.compose.foundation.text.LegacyTextFieldState;
import androidx.compose.foundation.text.TextFieldDelegate;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.TextFieldSelectionManager;
import androidx.compose.ui.autofill.ContentDataType;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import androidx.compose.ui.text.input.TransformedText;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002BW\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0019\u001a\u00020\u0018*\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ]\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001b\u0010\u0016J/\u0010\u001e\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u0004\u0010 R\u0016\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u0006\u0010!R\u0016\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\b\u0010\"R\u0016\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\n\u0010#R\u0016\u0010\u000b\u001a\u00020\t8\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u000b\u0010#R\u0016\u0010\f\u001a\u00020\t8\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\f\u0010#R\u0016\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u000e\u0010$R\u0016\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u0010\u0010%R\u0016\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u0012\u0010&R\u0016\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u0014\u0010'R\u0014\u0010*\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)"}, d2={"Landroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode;", "Landroidx/compose/ui/node/DelegatingNode;", "Landroidx/compose/ui/node/SemanticsModifierNode;", "Landroidx/compose/ui/text/input/TransformedText;", "transformedText", "Landroidx/compose/ui/text/input/TextFieldValue;", "value", "Landroidx/compose/foundation/text/LegacyTextFieldState;", "state", "", "readOnly", "enabled", "isPassword", "Landroidx/compose/ui/text/input/OffsetMapping;", "offsetMapping", "Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "manager", "Landroidx/compose/ui/text/input/ImeOptions;", "imeOptions", "Landroidx/compose/ui/focus/FocusRequester;", "focusRequester", "<init>", "(Landroidx/compose/ui/text/input/TransformedText;Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/foundation/text/LegacyTextFieldState;ZZZLandroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;Landroidx/compose/ui/text/input/ImeOptions;Landroidx/compose/ui/focus/FocusRequester;)V", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "", "applySemantics", "(Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;)V", "updateNodeSemantics", "", "text", "handleTextUpdateFromSemantics", "(Landroidx/compose/foundation/text/LegacyTextFieldState;Ljava/lang/String;ZZ)V", "Landroidx/compose/ui/text/input/TransformedText;", "Landroidx/compose/ui/text/input/TextFieldValue;", "Landroidx/compose/foundation/text/LegacyTextFieldState;", "Z", "Landroidx/compose/ui/text/input/OffsetMapping;", "Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "Landroidx/compose/ui/text/input/ImeOptions;", "Landroidx/compose/ui/focus/FocusRequester;", "getShouldMergeDescendantSemantics", "()Z", "shouldMergeDescendantSemantics"})
@SourceDebugExtension(value={"SMAP\nCoreTextFieldSemanticsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTextFieldSemanticsModifier.kt\nandroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1#2:338\n*E\n"})
public final class CoreTextFieldSemanticsModifierNode
extends DelegatingNode
implements SemanticsModifierNode {
    public TransformedText transformedText;
    public TextFieldValue value;
    public LegacyTextFieldState state;
    public boolean readOnly;
    public boolean enabled;
    public boolean isPassword;
    public OffsetMapping offsetMapping;
    public TextFieldSelectionManager manager;
    public ImeOptions imeOptions;
    public FocusRequester focusRequester;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public CoreTextFieldSemanticsModifierNode(TransformedText transformedText, TextFieldValue value, LegacyTextFieldState state, boolean readOnly, boolean enabled, boolean isPassword, OffsetMapping offsetMapping, TextFieldSelectionManager manager, ImeOptions imeOptions, FocusRequester focusRequester) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        this.transformedText = var1_1;
        this.value = var2_2;
        this.state = var3_3;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.isPassword = isPassword;
        this.offsetMapping = offsetMapping;
        this.manager = manager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        this.manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode._init_$lambda$0(this)));
    }

    public final boolean getShouldMergeDescendantSemantics() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void applySemantics(SemanticsPropertyReceiver $this$applySemantics) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        SemanticsPropertiesKt.setInputText((SemanticsPropertyReceiver)$this$applySemantics, (AnnotatedString)this.value.getAnnotatedString());
        SemanticsPropertiesKt.setEditableText((SemanticsPropertyReceiver)$this$applySemantics, (AnnotatedString)this.transformedText.getText());
        SemanticsPropertiesKt.setTextSelectionRange-FDrldGo((SemanticsPropertyReceiver)$this$applySemantics, (long)this.value.getSelection-d9O1mEE());
        SemanticsPropertiesKt.setContentDataType((SemanticsPropertyReceiver)$this$applySemantics, (ContentDataType)ContentDataType.Companion.getText());
        SemanticsPropertiesKt.onAutofillText$default((SemanticsPropertyReceiver)$this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$1(this, arg_0), (int)1, null);
        if (!this.enabled) {
            SemanticsPropertiesKt.disabled((SemanticsPropertyReceiver)$this$applySemantics);
        }
        if (this.isPassword) {
            SemanticsPropertiesKt.password((SemanticsPropertyReceiver)$this$applySemantics);
        }
        boolean editable = this.enabled && !this.readOnly;
        SemanticsPropertiesKt.setEditable((SemanticsPropertyReceiver)$this$applySemantics, (boolean)editable);
        SemanticsPropertiesKt.getTextLayoutResult$default((SemanticsPropertyReceiver)$this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$2(this, arg_0), (int)1, null);
        if (var2_2 != false) {
            SemanticsPropertiesKt.setText$default((SemanticsPropertyReceiver)$this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$3(this, arg_0), (int)1, null);
            SemanticsPropertiesKt.insertTextAtCursor$default((SemanticsPropertyReceiver)$this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$6(this, $this$applySemantics, arg_0), (int)1, null);
        }
        SemanticsPropertiesKt.setSelection$default((SemanticsPropertyReceiver)$this$applySemantics, null, (arg_0, arg_1, arg_2) -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$7(this, arg_0, arg_1, arg_2), (int)1, null);
        SemanticsPropertiesKt.onImeAction-9UiTYpY$default((SemanticsPropertyReceiver)$this$applySemantics, (int)this.imeOptions.getImeAction-eUduSuo(), null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$8(this), (int)2, null);
        SemanticsPropertiesKt.onClick$default((SemanticsPropertyReceiver)$this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$9(this), (int)1, null);
        SemanticsPropertiesKt.onLongClick$default((SemanticsPropertyReceiver)$this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$10(this), (int)1, null);
        if (!TextRange.getCollapsed-impl((long)this.value.getSelection-d9O1mEE()) && !this.isPassword) {
            SemanticsPropertiesKt.copyText$default((SemanticsPropertyReceiver)$this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$11(this), (int)1, null);
            if (this.enabled && !this.readOnly) {
                SemanticsPropertiesKt.cutText$default((SemanticsPropertyReceiver)$this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$12(this), (int)1, null);
            }
        }
        if (this.enabled && !this.readOnly) {
            void var1_1;
            SemanticsPropertiesKt.pasteText$default((SemanticsPropertyReceiver)var1_1, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$13(this), (int)1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateNodeSemantics(TransformedText transformedText, TextFieldValue value, LegacyTextFieldState state, boolean readOnly, boolean enabled, boolean isPassword, OffsetMapping offsetMapping, TextFieldSelectionManager manager, ImeOptions imeOptions, FocusRequester focusRequester) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        boolean previousEditable = this.enabled && !this.readOnly;
        boolean previousEnabled = this.enabled;
        boolean previousIsPassword = this.isPassword;
        ImeOptions previousImeOptions = this.imeOptions;
        TextFieldSelectionManager previousManager = this.manager;
        boolean editable = enabled && !readOnly;
        this.transformedText = var1_1;
        this.value = value;
        this.state = var3_3;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.offsetMapping = offsetMapping;
        this.manager = manager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        if (enabled != previousEnabled || editable != previousEditable || !Intrinsics.areEqual((Object)imeOptions, (Object)previousImeOptions) || isPassword != previousIsPassword || !TextRange.getCollapsed-impl((long)var2_2.getSelection-d9O1mEE())) {
            SemanticsModifierNodeKt.invalidateSemantics((SemanticsModifierNode)this);
        }
        if (!Intrinsics.areEqual((Object)manager, (Object)previousManager)) {
            manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode.updateNodeSemantics$lambda$14(this)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleTextUpdateFromSemantics(LegacyTextFieldState state, String text, boolean readOnly, boolean enabled) {
        void var1_1;
        void var2_2;
        if (readOnly || !enabled) {
            return;
        }
        TextInputSession textInputSession = state.getInputSession();
        if (textInputSession != null) {
            void var3_4;
            TextInputSession session2 = textInputSession;
            Object[] objectArray = new EditCommand[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = new DeleteAllCommand();
            objectArray2[1] = new CommitTextCommand(text, 1);
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray2), state.getProcessor(), state.getOnValueChange(), (TextInputSession)var3_4);
            return;
        }
        void v2 = var2_2;
        var1_1.getOnValueChange().invoke((Object)new TextFieldValue((String)v2, TextRangeKt.TextRange((int)v2.length()), null, 4, null));
    }

    private static final Unit _init_$lambda$0(CoreTextFieldSemanticsModifierNode this$0) {
        DelegatableNodeKt.requestAutofill((DelegatableNode)((DelegatableNode)this$0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean applySemantics$lambda$1(CoreTextFieldSemanticsModifierNode this$0, AnnotatedString text) {
        CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this$0.state.setJustAutofilled(true);
        this$0.state.setAutofillHighlightOn(true);
        CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode2 = this$0;
        coreTextFieldSemanticsModifierNode2.handleTextUpdateFromSemantics(coreTextFieldSemanticsModifierNode2.state, var1_1.getText(), this$0.readOnly, coreTextFieldSemanticsModifierNode.enabled);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean applySemantics$lambda$2(CoreTextFieldSemanticsModifierNode this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getLayoutResult() != null) {
            void var1_1;
            CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode;
            TextLayoutResultProxy textLayoutResultProxy = coreTextFieldSemanticsModifierNode.state.getLayoutResult();
            Intrinsics.checkNotNull((Object)textLayoutResultProxy);
            var1_1.add(textLayoutResultProxy.getValue());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean applySemantics$lambda$3(CoreTextFieldSemanticsModifierNode this$0, AnnotatedString text) {
        CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode2 = this$0;
        coreTextFieldSemanticsModifierNode2.handleTextUpdateFromSemantics(coreTextFieldSemanticsModifierNode2.state, var1_1.getText(), this$0.readOnly, coreTextFieldSemanticsModifierNode.enabled);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean applySemantics$lambda$6(CoreTextFieldSemanticsModifierNode this$0, SemanticsPropertyReceiver $this_applySemantics, AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this$0.readOnly || !this$0.enabled) {
            return false;
        }
        TextInputSession textInputSession = this$0.state.getInputSession();
        if (textInputSession != null) {
            TextInputSession session2 = textInputSession;
            Object[] objectArray = new EditCommand[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = new FinishComposingTextCommand();
            objectArray2[1] = new CommitTextCommand(text, 1);
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray2), this$0.state.getProcessor(), this$0.state.getOnValueChange(), session2);
        } else {
            void var1_3;
            CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode;
            void var2_4;
            String string = this$0.value.getText();
            int session2 = TextRange.getStart-impl((long)this$0.value.getSelection-d9O1mEE());
            int n = TextRange.getEnd-impl((long)this$0.value.getSelection-d9O1mEE());
            String newText = ((Object)StringsKt.replaceRange((CharSequence)string, (int)session2, (int)n, (CharSequence)((CharSequence)text))).toString();
            long newCursor = TextRangeKt.TextRange((int)(TextRange.getStart-impl((long)this$0.value.getSelection-d9O1mEE()) + var2_4.length()));
            coreTextFieldSemanticsModifierNode.state.getOnValueChange().invoke((Object)new TextFieldValue((String)var1_3, newCursor, null, 4, null));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean applySemantics$lambda$7(CoreTextFieldSemanticsModifierNode this$0, int selectionStart, int selectionEnd, boolean relativeToOriginalText) {
        CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode;
        int end;
        int start = relativeToOriginalText ? selectionStart : this$0.offsetMapping.transformedToOriginal(selectionStart);
        int n = end = relativeToOriginalText ? selectionEnd : this$0.offsetMapping.transformedToOriginal(selectionEnd);
        if (!this$0.enabled) {
            return false;
        }
        if (start == TextRange.getStart-impl((long)this$0.value.getSelection-d9O1mEE()) && end == TextRange.getEnd-impl((long)this$0.value.getSelection-d9O1mEE())) {
            return false;
        }
        if (Math.min(start, end) >= 0 && Math.max(start, end) <= this$0.value.getAnnotatedString().length()) {
            void var2_2;
            void var1_1;
            void var3_3;
            if (var3_3 != false || start == end) {
                this$0.manager.exitSelectionMode$foundation();
            } else {
                TextFieldSelectionManager.enterSelectionMode$foundation$default(this$0.manager, false, 1, null);
            }
            this$0.state.getOnValueChange().invoke((Object)new TextFieldValue(this$0.value.getAnnotatedString(), TextRangeKt.TextRange((int)var1_1, (int)var2_2), null, 4, null));
            return true;
        }
        coreTextFieldSemanticsModifierNode.manager.exitSelectionMode$foundation();
        return false;
    }

    private static final boolean applySemantics$lambda$8(CoreTextFieldSemanticsModifierNode this$0) {
        CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode;
        this$0.state.getOnImeActionPerformed().invoke((Object)ImeAction.box-impl((int)coreTextFieldSemanticsModifierNode.imeOptions.getImeAction-eUduSuo()));
        return true;
    }

    private static final boolean applySemantics$lambda$9(CoreTextFieldSemanticsModifierNode this$0) {
        CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode;
        CoreTextFieldKt.requestFocusAndShowKeyboardIfNeeded(this$0.state, this$0.focusRequester, !coreTextFieldSemanticsModifierNode.readOnly);
        return true;
    }

    private static final boolean applySemantics$lambda$10(CoreTextFieldSemanticsModifierNode this$0) {
        TextFieldSelectionManager.enterSelectionMode$foundation$default(this$0.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$11(CoreTextFieldSemanticsModifierNode this$0) {
        TextFieldSelectionManager.copy$foundation$default(this$0.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$12(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.manager.cut$foundation();
        return true;
    }

    private static final boolean applySemantics$lambda$13(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.manager.paste$foundation();
        return true;
    }

    private static final Unit updateNodeSemantics$lambda$14(CoreTextFieldSemanticsModifierNode this$0) {
        DelegatableNodeKt.requestAutofill((DelegatableNode)((DelegatableNode)this$0));
        return Unit.INSTANCE;
    }
}

