/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.MutatePriority;
import androidx.compose.foundation.OverscrollEffect;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.ScrollableKt;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.gestures.ScrollableStateKt;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.foundation.text.HorizontalScrollLayoutModifier;
import androidx.compose.foundation.text.TextFieldCursor_desktopKt;
import androidx.compose.foundation.text.TextFieldScrollKt;
import androidx.compose.foundation.text.TextFieldScrollerPosition;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.ValidatingOffsetMappingKt;
import androidx.compose.foundation.text.VerticalScrollLayoutModifier;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.ComposedModifierKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.ClipKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.platform.CompositionLocalsKt;
import androidx.compose.ui.platform.InspectableValueKt;
import androidx.compose.ui.platform.InspectorInfo;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.input.VisualTransformation;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a7\u0010\t\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a;\u0010\u0012\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a=\u0010\u001e\u001a\u00020\u001d*\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001f"}, d2={"Landroidx/compose/ui/Modifier;", "Landroidx/compose/foundation/text/TextFieldScrollerPosition;", "scrollerPosition", "Landroidx/compose/foundation/interaction/MutableInteractionSource;", "interactionSource", "", "enabled", "Landroidx/compose/foundation/OverscrollEffect;", "overscrollEffect", "textFieldScrollable", "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/text/TextFieldScrollerPosition;Landroidx/compose/foundation/interaction/MutableInteractionSource;ZLandroidx/compose/foundation/OverscrollEffect;)Landroidx/compose/ui/Modifier;", "Landroidx/compose/ui/text/input/TextFieldValue;", "textFieldValue", "Landroidx/compose/ui/text/input/VisualTransformation;", "visualTransformation", "Lkotlin/Function0;", "Landroidx/compose/foundation/text/TextLayoutResultProxy;", "textLayoutResultProvider", "defaultTextFieldScroll", "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/text/TextFieldScrollerPosition;Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/input/VisualTransformation;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;", "Landroidx/compose/ui/unit/Density;", "", "cursorOffset", "Landroidx/compose/ui/text/input/TransformedText;", "transformedText", "Landroidx/compose/ui/text/TextLayoutResult;", "textLayoutResult", "rtl", "textFieldWidth", "Landroidx/compose/ui/geometry/Rect;", "getCursorRectInScroller", "(Landroidx/compose/ui/unit/Density;ILandroidx/compose/ui/text/input/TransformedText;Landroidx/compose/ui/text/TextLayoutResult;ZI)Landroidx/compose/ui/geometry/Rect;"})
@SourceDebugExtension(value={"SMAP\nTextFieldScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldScroll.kt\nandroidx/compose/foundation/text/TextFieldScrollKt\n+ 2 InspectableValue.kt\nandroidx/compose/ui/platform/InspectableValueKt\n+ 3 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,399:1\n110#2:400\n75#3:401\n862#4,6:402\n862#4,6:408\n*S KotlinDebug\n*F\n+ 1 TextFieldScroll.kt\nandroidx/compose/foundation/text/TextFieldScrollKt\n*L\n69#1:400\n77#1:401\n79#1:402,6\n94#1:408,6\n*E\n"})
public final class TextFieldScrollKt {
    /*
     * WARNING - void declaration
     */
    public static final Modifier textFieldScrollable(Modifier $this$textFieldScrollable, TextFieldScrollerPosition scrollerPosition, MutableInteractionSource interactionSource, boolean enabled, OverscrollEffect overscrollEffect) {
        void var2_2;
        void var3_3;
        void var1_1;
        Modifier modifier2;
        Intrinsics.checkNotNullParameter((Object)$this$textFieldScrollable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scrollerPosition, (String)"scrollerPosition");
        return ComposedModifierKt.composed((Modifier)modifier2, (Function1)(InspectableValueKt.isDebugInspectorInfoEnabled() ? (Function1)new Function1<InspectorInfo, Unit>(scrollerPosition, interactionSource, enabled){
            final /* synthetic */ TextFieldScrollerPosition $scrollerPosition$inlined;
            final /* synthetic */ MutableInteractionSource $interactionSource$inlined;
            final /* synthetic */ boolean $enabled$inlined;
            {
                this.$scrollerPosition$inlined = textFieldScrollerPosition;
                this.$interactionSource$inlined = mutableInteractionSource;
                this.$enabled$inlined = bl;
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(InspectorInfo inspectorInfo) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)inspectorInfo, (String)"<this>");
                InspectorInfo $this$textFieldScrollable_u24lambda_u240 = inspectorInfo;
                $this$textFieldScrollable_u24lambda_u240.setName("textFieldScrollable");
                $this$textFieldScrollable_u24lambda_u240.getProperties().set("scrollerPosition", (Object)this.$scrollerPosition$inlined);
                $this$textFieldScrollable_u24lambda_u240.getProperties().set("interactionSource", (Object)this.$interactionSource$inlined);
                var1_1.getProperties().set("enabled", (Object)this.$enabled$inlined);
            }
        } : InspectableValueKt.getNoInspectorInfo()), (arg_0, arg_1, arg_2) -> TextFieldScrollKt.textFieldScrollable$lambda$4((TextFieldScrollerPosition)var1_1, (boolean)var3_3, overscrollEffect, (MutableInteractionSource)var2_2, arg_0, arg_1, arg_2));
    }

    /*
     * WARNING - void declaration
     */
    public static final Modifier defaultTextFieldScroll(Modifier $this$defaultTextFieldScroll, TextFieldScrollerPosition scrollerPosition, TextFieldValue textFieldValue, VisualTransformation visualTransformation, Function0<TextLayoutResultProxy> textLayoutResultProvider) {
        void var1_1;
        Modifier modifier2;
        LayoutModifier layoutModifier;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$defaultTextFieldScroll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scrollerPosition, (String)"scrollerPosition");
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
        Intrinsics.checkNotNullParameter((Object)visualTransformation, (String)"visualTransformation");
        Intrinsics.checkNotNullParameter(textLayoutResultProvider, (String)"textLayoutResultProvider");
        Orientation orientation = scrollerPosition.getOrientation();
        int cursorOffset = scrollerPosition.getOffsetToFollow-5zc-tL8(textFieldValue.getSelection-d9O1mEE());
        scrollerPosition.setPreviousSelection-5zc-tL8(textFieldValue.getSelection-d9O1mEE());
        TransformedText transformedText = ValidatingOffsetMappingKt.filterWithValidation((VisualTransformation)var3_3, textFieldValue.getAnnotatedString());
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                layoutModifier = new VerticalScrollLayoutModifier(scrollerPosition, cursorOffset, transformedText, textLayoutResultProvider);
                break;
            }
            case 2: {
                void var2_2;
                layoutModifier = new HorizontalScrollLayoutModifier(scrollerPosition, cursorOffset, (TransformedText)var2_2, textLayoutResultProvider);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        LayoutModifier layout2 = layoutModifier;
        return ClipKt.clipToBounds((Modifier)modifier2).then((Modifier)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Rect getCursorRectInScroller(Density $this$getCursorRectInScroller, int cursorOffset, TransformedText transformedText, TextLayoutResult textLayoutResult, boolean rtl, int textFieldWidth) {
        void var0_2;
        void var2_6;
        void var1_4;
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        if (textLayoutResult2 == null || (textLayoutResult2 = textLayoutResult2.getCursorRect(transformedText.getOffsetMapping().originalToTransformed(cursorOffset))) == null) {
            textLayoutResult2 = Rect.Companion.getZero();
        }
        TextLayoutResult cursorRect = textLayoutResult2;
        int thickness = $this$getCursorRectInScroller.roundToPx-0680j_4(TextFieldCursor_desktopKt.getDefaultCursorThickness());
        float cursorLeft = rtl ? (float)textFieldWidth - cursorRect.getLeft() - (float)thickness : cursorRect.getLeft();
        float cursorRight = rtl ? (float)textFieldWidth - cursorRect.getLeft() : cursorRect.getLeft() + (float)thickness;
        return Rect.copy$default((Rect)var1_4, (float)var2_6, (float)0.0f, (float)var0_2, (float)0.0f, (int)10, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final float textFieldScrollable$lambda$4$lambda$2$lambda$1(TextFieldScrollerPosition $scrollerPosition, float delta) {
        void var1_1;
        TextFieldScrollerPosition textFieldScrollerPosition;
        float consumedDelta;
        void var2_2;
        float f;
        float newOffset = $scrollerPosition.getOffset() + delta;
        consumedDelta = f > $scrollerPosition.getMaximum() ? $scrollerPosition.getMaximum() - $scrollerPosition.getOffset() : (var2_2 < 0.0f ? -$scrollerPosition.getOffset() : consumedDelta);
        TextFieldScrollerPosition textFieldScrollerPosition2 = textFieldScrollerPosition;
        textFieldScrollerPosition2.setOffset(textFieldScrollerPosition2.getOffset() + consumedDelta);
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static final Modifier textFieldScrollable$lambda$4(TextFieldScrollerPosition $scrollerPosition, boolean $enabled, OverscrollEffect $overscrollEffect, MutableInteractionSource $interactionSource, Modifier $this$composed, Composer $composer, int $changed2) {
        void var3_3;
        void var2_2;
        TextFieldScrollerPosition textFieldScrollerPosition;
        void var1_1;
        Object object;
        ScrollableState value$iv;
        void $this$cache$iv;
        Object object2;
        Function1 $this$cache$iv2;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$composed, (String)"$this$composed");
        $composer.startReplaceGroup(-2137546592);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-2137546592, (int)$changed2, (int)-1, (String)"androidx.compose.foundation.text.textFieldScrollable.<anonymous> (TextFieldScroll.kt:76)");
        }
        $this$composed = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        Composer $changed2 = $composer;
        Object object3 = $changed2.consume((CompositionLocal)this_$iv);
        boolean rtl = object3 == LayoutDirection.Rtl;
        boolean reverseDirection = $scrollerPosition.getOrientation() == Orientation.Vertical || !rtl;
        $changed2 = $composer;
        boolean invalid$iv = $composer.changed((Object)$scrollerPosition);
        Object it$iv = $this$cache$iv2.rememberedValue();
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            Function1 value$iv2 = arg_0 -> TextFieldScrollKt.textFieldScrollable$lambda$4$lambda$2$lambda$1($scrollerPosition, arg_0);
            $this$cache$iv2.updateRememberedValue((Object)value$iv2);
            object2 = value$iv2;
        } else {
            object2 = it$iv;
        }
        $this$cache$iv2 = (Function1)object2;
        ScrollableState scrollableState = ScrollableStateKt.rememberScrollableState((Function1<? super Float, Float>)$this$cache$iv2, $composer, 0);
        Composer value$iv2 = $composer;
        boolean invalid$iv2 = $composer.changed((Object)scrollableState) | $composer.changed((Object)$scrollerPosition);
        it$iv = $this$cache$iv.rememberedValue();
        if (invalid$iv2 || it$iv == Composer.Companion.getEmpty()) {
            value$iv = new ScrollableState(scrollableState, $scrollerPosition){
                private final /* synthetic */ ScrollableState $$delegate_0;
                private final State canScrollForward$delegate;
                private final State canScrollBackward$delegate;
                {
                    void var2_2;
                    void var1_1;
                    this.$$delegate_0 = var1_1;
                    this.canScrollForward$delegate = SnapshotStateKt.derivedStateOf(() -> textFieldScrollable.2.wrappedScrollableState.1.1.canScrollForward_delegate$lambda$0($scrollerPosition));
                    this.canScrollBackward$delegate = SnapshotStateKt.derivedStateOf(() -> textFieldScrollable.2.wrappedScrollableState.1.1.canScrollBackward_delegate$lambda$1((TextFieldScrollerPosition)var2_2));
                }

                public final boolean getCanScrollForward() {
                    State state = this.canScrollForward$delegate;
                    return (Boolean)state.getValue();
                }

                public final boolean getCanScrollBackward() {
                    State state = this.canScrollBackward$delegate;
                    return (Boolean)state.getValue();
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object scroll(MutatePriority scrollPriority, Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object> block, Continuation<? super Unit> $completion) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    return this.$$delegate_0.scroll((MutatePriority)var1_1, (Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object>)var2_2, (Continuation<? super Unit>)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                public final float dispatchRawDelta(float delta) {
                    void var1_1;
                    return this.$$delegate_0.dispatchRawDelta((float)var1_1);
                }

                public final boolean isScrollInProgress() {
                    return this.$$delegate_0.isScrollInProgress();
                }

                private static final boolean canScrollForward_delegate$lambda$0(TextFieldScrollerPosition $scrollerPosition) {
                    TextFieldScrollerPosition textFieldScrollerPosition;
                    return $scrollerPosition.getOffset() < textFieldScrollerPosition.getMaximum();
                }

                private static final boolean canScrollBackward_delegate$lambda$1(TextFieldScrollerPosition $scrollerPosition) {
                    return $scrollerPosition.getOffset() > 0.0f;
                }
            };
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        value$iv = object;
        textFieldScrollable.2.wrappedScrollableState.1.1 wrappedScrollableState2 = value$iv;
        Modifier.Companion companion = Modifier.Companion;
        Orientation orientation = $scrollerPosition.getOrientation();
        boolean bl = var1_1 != false && !(textFieldScrollerPosition.getMaximum() == 0.0f);
        Modifier scroll2 = ScrollableKt.scrollable$default((Modifier)companion, wrappedScrollableState2, orientation, (OverscrollEffect)var2_2, bl, reverseDirection, null, (MutableInteractionSource)var3_3, null, 160, null);
        $composer.endReplaceGroup();
        return scroll2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Rect access$getCursorRectInScroller(Density $receiver, int cursorOffset, TransformedText transformedText, TextLayoutResult textLayoutResult, boolean rtl, int textFieldWidth) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TextFieldScrollKt.getCursorRectInScroller($receiver, (int)var1_1, (TransformedText)var2_2, (TextLayoutResult)var3_3, rtl, textFieldWidth);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.Vertical.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Orientation.Horizontal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

