/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.TextDelegateKt;
import androidx.compose.foundation.text.TextLayoutHelperKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u0000 H2\u00020\u0001:\u0001HBe\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010!\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010&\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010-\u001a\u0004\b.\u0010/R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010-\u001a\u0004\b0\u0010/R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u00101\u001a\u0004\b2\u00103R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010-\u001a\u0004\b4\u0010/R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u00105\u001a\u0004\b6\u00107R\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u00108\u001a\u0004\b9\u0010:R#\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010;\u001a\u0004\b<\u0010=R\u0018\u0010?\u001a\u0004\u0018\u00010>8\u0000@\u0000X\u0080\f\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0018\u0010A\u001a\u0004\u0018\u00010\u00178\u0000@\u0000X\u0080\f\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0014\u0010E\u001a\u00020>8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0011\u0010G\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bF\u0010/"}, d2={"Landroidx/compose/foundation/text/TextDelegate;", "", "Landroidx/compose/ui/text/AnnotatedString;", "text", "Landroidx/compose/ui/text/TextStyle;", "style", "", "maxLines", "minLines", "", "softWrap", "Landroidx/compose/ui/text/style/TextOverflow;", "overflow", "Landroidx/compose/ui/unit/Density;", "density", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "fontFamilyResolver", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "placeholders", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;IIZILandroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;Ljava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "Landroidx/compose/ui/unit/LayoutDirection;", "layoutDirection", "", "layoutIntrinsics", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "Landroidx/compose/ui/unit/Constraints;", "constraints", "Landroidx/compose/ui/text/MultiParagraph;", "layoutText-K40F9xA", "(JLandroidx/compose/ui/unit/LayoutDirection;)Landroidx/compose/ui/text/MultiParagraph;", "layoutText", "Landroidx/compose/ui/text/TextLayoutResult;", "prevResult", "layout-NN6Ew-U", "(JLandroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/text/TextLayoutResult;)Landroidx/compose/ui/text/TextLayoutResult;", "layout", "Landroidx/compose/ui/text/AnnotatedString;", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "Landroidx/compose/ui/text/TextStyle;", "getStyle", "()Landroidx/compose/ui/text/TextStyle;", "I", "getMaxLines", "()I", "getMinLines", "Z", "getSoftWrap", "()Z", "getOverflow-gIe3tQ8", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "getFontFamilyResolver", "()Landroidx/compose/ui/text/font/FontFamily$Resolver;", "Ljava/util/List;", "getPlaceholders", "()Ljava/util/List;", "Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "paragraphIntrinsics", "Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "intrinsicsLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getNonNullIntrinsics", "()Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "nonNullIntrinsics", "getMaxIntrinsicWidth", "maxIntrinsicWidth", "Companion"})
@SourceDebugExtension(value={"SMAP\nTextDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextDelegate.kt\nandroidx/compose/foundation/text/TextDelegate\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,356:1\n97#2,4:357\n97#2,4:361\n97#2,4:365\n30#3:369\n30#3:371\n80#4:370\n80#4:372\n*S KotlinDebug\n*F\n+ 1 TextDelegate.kt\nandroidx/compose/foundation/text/TextDelegate\n*L\n116#1:357,4\n117#1:361,4\n118#1:365,4\n252#1:369\n265#1:371\n252#1:370\n265#1:372\n*E\n"})
public final class TextDelegate {
    public static final Companion Companion = new Companion(null);
    private final AnnotatedString text;
    private final TextStyle style;
    private final int maxLines;
    private final int minLines;
    private final boolean softWrap;
    private final int overflow;
    private final Density density;
    private final FontFamily.Resolver fontFamilyResolver;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    public MultiParagraphIntrinsics paragraphIntrinsics;
    public LayoutDirection intrinsicsLayoutDirection;

    /*
     * WARNING - void declaration
     */
    private TextDelegate(AnnotatedString text, TextStyle style, int maxLines, int minLines, boolean softWrap, int overflow, Density density, FontFamily.Resolver fontFamilyResolver, List<AnnotatedString.Range<Placeholder>> placeholders) {
        void var3_4;
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        this.text = var1_1;
        this.style = var2_3;
        this.maxLines = var3_4;
        this.minLines = minLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.fontFamilyResolver = fontFamilyResolver;
        this.placeholders = placeholders;
        boolean bl = this.maxLines > 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("no maxLines");
        }
        if (!(bl = this.minLines > 0)) {
            InlineClassHelperKt.throwIllegalArgumentException("no minLines");
        }
        if (!(bl = this.minLines <= this.maxLines)) {
            InlineClassHelperKt.throwIllegalArgumentException("minLines greater than maxLines");
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, int n, int n2, boolean bl, int n3, Density density, FontFamily.Resolver resolver, List list, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n4 & 8) != 0) {
            n2 = 1;
        }
        if ((n4 & 0x10) != 0) {
            bl = true;
        }
        if ((n4 & 0x20) != 0) {
            n3 = TextOverflow.Companion.getClip-gIe3tQ8();
        }
        if ((n4 & 0x100) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(annotatedString, textStyle, n, n2, bl, n3, density, resolver, list, null);
    }

    public final AnnotatedString getText() {
        return this.text;
    }

    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final int getMinLines() {
        return this.minLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    public final int getOverflow-gIe3tQ8() {
        return this.overflow;
    }

    public final Density getDensity() {
        return this.density;
    }

    public final FontFamily.Resolver getFontFamilyResolver() {
        return this.fontFamilyResolver;
    }

    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    private final MultiParagraphIntrinsics getNonNullIntrinsics() {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.paragraphIntrinsics;
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutIntrinsics must be called first");
        }
        return multiParagraphIntrinsics;
    }

    public final int getMaxIntrinsicWidth() {
        return TextDelegateKt.ceilToIntPx(this.getNonNullIntrinsics().getMaxIntrinsicWidth());
    }

    /*
     * WARNING - void declaration
     */
    public final void layoutIntrinsics(LayoutDirection layoutDirection) {
        void var1_1;
        MultiParagraphIntrinsics multiParagraphIntrinsics;
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        MultiParagraphIntrinsics localIntrinsics = this.paragraphIntrinsics;
        if (localIntrinsics == null || layoutDirection != this.intrinsicsLayoutDirection || localIntrinsics.getHasStaleResolvedFonts()) {
            this.intrinsicsLayoutDirection = layoutDirection;
            localIntrinsics = this.text;
            layoutDirection = TextStyleKt.resolveDefaults((TextStyle)this.style, (LayoutDirection)layoutDirection);
            Density density = this.density;
            FontFamily.Resolver resolver = this.fontFamilyResolver;
            List<AnnotatedString.Range<Placeholder>> list = this.placeholders;
            multiParagraphIntrinsics = new MultiParagraphIntrinsics((AnnotatedString)localIntrinsics, (TextStyle)layoutDirection, list, density, resolver);
        } else {
            void var2_2;
            multiParagraphIntrinsics = var2_2;
        }
        void intrinsics = multiParagraphIntrinsics;
        this.paragraphIntrinsics = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final MultiParagraph layoutText-K40F9xA(long constraints, LayoutDirection layoutDirection) {
        void var1_1;
        void var3_3;
        this.layoutIntrinsics(layoutDirection);
        int minWidth = Constraints.getMinWidth-impl((long)constraints);
        boolean bl = this.softWrap || TextOverflow.equals-impl0((int)this.overflow, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int maxWidth = bl && Constraints.getHasBoundedWidth-impl((long)constraints) ? Constraints.getMaxWidth-impl((long)constraints) : Integer.MAX_VALUE;
        boolean bl2 = !this.softWrap && TextOverflow.equals-impl0((int)this.overflow, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int finalMaxLines = bl2 ? 1 : this.maxLines;
        int width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((int)this.getMaxIntrinsicWidth(), (int)minWidth, (int)maxWidth);
        return new MultiParagraph(this.getNonNullIntrinsics(), Constraints.Companion.fitPrioritizingWidth-Zbe2FdA(0, (int)var3_3, 0, Constraints.getMaxHeight-impl((long)var1_1)), finalMaxLines, this.overflow, null);
    }

    /*
     * WARNING - void declaration
     */
    public final TextLayoutResult layout-NN6Ew-U(long constraints2, LayoutDirection layoutDirection, TextLayoutResult prevResult) {
        void var3_3;
        void val1$iv$iv;
        int height$iv;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        if (prevResult != null && TextLayoutHelperKt.canReuse-7_7YC6M(prevResult, this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.fontFamilyResolver, constraints2)) {
            void var1_2;
            void width$iv;
            TextLayoutResult $this$layout_NN6Ew_U_u24lambda_u243 = prevResult;
            int n = TextDelegateKt.ceilToIntPx($this$layout_NN6Ew_U_u24lambda_u243.getMultiParagraph().getWidth());
            int height$iv2 = TextDelegateKt.ceilToIntPx($this$layout_NN6Ew_U_u24lambda_u243.getMultiParagraph().getHeight());
            void constraints2 = width$iv;
            int val2$iv$iv = height$iv2;
            return $this$layout_NN6Ew_U_u24lambda_u243.copy-O0kMr_c(new TextLayoutInput($this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getText(), this.style, $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getPlaceholders(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getMaxLines(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getSoftWrap(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getOverflow-gIe3tQ8(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getDensity(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getLayoutDirection(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getFontFamilyResolver(), constraints2, null), ConstraintsKt.constrain-4WqzIAM((long)constraints2, (long)IntSize.constructor-impl((long)((long)var1_2 << 32 | (long)val2$iv$iv & 0xFFFFFFFFL))));
        }
        MultiParagraph multiParagraph = this.layoutText-K40F9xA((long)var1_1, layoutDirection);
        int val2$iv$iv = TextDelegateKt.ceilToIntPx(multiParagraph.getWidth());
        int val2$iv$iv2 = height$iv = TextDelegateKt.ceilToIntPx(multiParagraph.getHeight());
        long size = ConstraintsKt.constrain-4WqzIAM((long)var1_1, (long)IntSize.constructor-impl((long)((long)val1$iv$iv << 32 | (long)val2$iv$iv2 & 0xFFFFFFFFL)));
        return new TextLayoutResult(new TextLayoutInput(this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, (LayoutDirection)var3_3, this.fontFamilyResolver, (long)var1_1, null), multiParagraph, size, null);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ TextDelegate(AnnotatedString text, TextStyle style, int maxLines, int minLines, boolean softWrap, int overflow, Density density, FontFamily.Resolver fontFamilyResolver, List placeholders, DefaultConstructorMarker $constructor_marker) {
        this((AnnotatedString)var1_1, (TextStyle)var2_2, (int)var3_3, minLines, softWrap, overflow, density, fontFamilyResolver, placeholders);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/compose/foundation/text/TextDelegate$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

