/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutItemProviderKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLazyLayoutItemProvider;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotIntStateKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0012J\u0015\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR+\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00028F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u001dR+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00048F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010\u001aR\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010-\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0017\u00100\u001a\u00020/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103"}, d2={"Landroidx/compose/foundation/pager/PagerScrollPosition;", "", "", "currentPage", "", "currentPageOffsetFraction", "Landroidx/compose/foundation/pager/PagerState;", "state", "<init>", "(IFLandroidx/compose/foundation/pager/PagerState;)V", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "measureResult", "", "updateFromMeasureResult", "(Landroidx/compose/foundation/pager/PagerMeasureResult;)V", "index", "offsetFraction", "requestPositionAndForgetLastKnownKey", "(IF)V", "Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;", "itemProvider", "matchPageWithKey", "(Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;I)I", "page", "update", "updateCurrentPageOffsetFraction", "(F)V", "delta", "applyScrollDelta", "(I)V", "Landroidx/compose/foundation/pager/PagerState;", "<set-?>", "currentPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "getCurrentPage", "()I", "setCurrentPage", "currentPageOffsetFraction$delegate", "Landroidx/compose/runtime/MutableFloatState;", "getCurrentPageOffsetFraction", "()F", "setCurrentPageOffsetFraction", "", "hadFirstNotEmptyLayout", "Z", "lastKnownCurrentPageKey", "Ljava/lang/Object;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "nearestRangeState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getNearestRangeState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;"})
@SourceDebugExtension(value={"SMAP\nPagerScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 4 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPositionKt\n*L\n1#1,137:1\n78#2:138\n111#2,2:139\n81#3:141\n114#3,2:142\n127#4,4:144\n*S KotlinDebug\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n*L\n37#1:138\n37#1:139,2\n40#1:141\n40#1:142,2\n106#1:144,4\n*E\n"})
public final class PagerScrollPosition {
    public final PagerState state;
    private final MutableIntState currentPage$delegate;
    private final MutableFloatState currentPageOffsetFraction$delegate;
    private boolean hadFirstNotEmptyLayout;
    private Object lastKnownCurrentPageKey;
    private final LazyLayoutNearestRangeState nearestRangeState;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PagerScrollPosition(int currentPage, float currentPageOffsetFraction, PagerState state) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = var3_3;
        this.currentPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)currentPage);
        this.currentPageOffsetFraction$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf((float)var2_2);
        this.nearestRangeState = new LazyLayoutNearestRangeState((int)var1_1, 30, 100);
    }

    public final int getCurrentPage() {
        IntState intState = (IntState)this.currentPage$delegate;
        return intState.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPage(int n) {
        void var1_1;
        MutableIntState mutableIntState = this.currentPage$delegate;
        mutableIntState.setIntValue((int)var1_1);
    }

    public final float getCurrentPageOffsetFraction() {
        FloatState floatState = (FloatState)this.currentPageOffsetFraction$delegate;
        return floatState.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPageOffsetFraction(float f) {
        void var1_1;
        MutableFloatState mutableFloatState = this.currentPageOffsetFraction$delegate;
        mutableFloatState.setFloatValue((float)var1_1);
    }

    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateFromMeasureResult(PagerMeasureResult measureResult) {
        Intrinsics.checkNotNullParameter((Object)measureResult, (String)"measureResult");
        MeasuredPage measuredPage = measureResult.getCurrentPage();
        Object object = this.lastKnownCurrentPageKey = measuredPage != null ? measuredPage.getKey() : null;
        if (this.hadFirstNotEmptyLayout || !((Collection)measureResult.getVisiblePagesInfo()).isEmpty()) {
            void var1_1;
            this.hadFirstNotEmptyLayout = true;
            MeasuredPage measuredPage2 = measureResult.getCurrentPage();
            this.update(measuredPage2 != null ? measuredPage2.getIndex() : 0, var1_1.getCurrentPageOffsetFraction());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void requestPositionAndForgetLastKnownKey(int index, float offsetFraction) {
        void var2_2;
        void var1_1;
        this.update((int)var1_1, (float)var2_2);
        this.lastKnownCurrentPageKey = null;
    }

    /*
     * WARNING - void declaration
     */
    public final int matchPageWithKey(PagerLazyLayoutItemProvider itemProvider, int index) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)itemProvider, (String)"itemProvider");
        int newIndex = LazyLayoutItemProviderKt.findIndexByKey(itemProvider, this.lastKnownCurrentPageKey, index);
        if (index != newIndex) {
            void var2_3;
            this.setCurrentPage(newIndex);
            this.nearestRangeState.update((int)var2_3);
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void update(int page, float offsetFraction) {
        void var2_2;
        void var1_1;
        this.setCurrentPage(page);
        this.nearestRangeState.update((int)var1_1);
        this.setCurrentPageOffsetFraction((float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCurrentPageOffsetFraction(float offsetFraction) {
        void var1_1;
        this.setCurrentPageOffsetFraction((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void applyScrollDelta(int $i$f$debugLog) {
        void var1_2;
        float fractionUpdate = this.state.getPageSizeWithSpacing$foundation() == 0 ? 0.0f : (float)$i$f$debugLog / (float)this.state.getPageSizeWithSpacing$foundation();
        PagerScrollPosition pagerScrollPosition = this;
        pagerScrollPosition.setCurrentPageOffsetFraction(pagerScrollPosition.getCurrentPageOffsetFraction() + var1_2);
    }
}

