/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.CacheWindowScope;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.ui.unit.Density;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J7\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u0014\u0010*\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010,\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0015R\u0014\u0010.\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0015R\u0014\u00100\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0015R\u0014\u00102\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0015R\u0014\u00104\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0015R\u0016\u00108\u001a\u0004\u0018\u0001058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010:\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0015"}, d2={"Landroidx/compose/foundation/pager/PagerCacheWindowScope;", "Landroidx/compose/foundation/lazy/layout/CacheWindowScope;", "Lkotlin/Function0;", "", "itemCount", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "lineIndex", "Lkotlin/Function2;", "", "onItemPrefetched", "", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "schedulePrefetch", "(ILkotlin/jvm/functions/Function2;)Ljava/util/List;", "indexInVisibleLines", "getVisibleItemSize", "(I)I", "getVisibleItemLine", "getLastIndexInLine", "getLastLineIndex", "()I", "Lkotlin/jvm/functions/Function0;", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "layoutInfo", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "getLayoutInfo", "()Landroidx/compose/foundation/pager/PagerMeasureResult;", "setLayoutInfo", "(Landroidx/compose/foundation/pager/PagerMeasureResult;)V", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "state", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "getState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "setState", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;)V", "getTotalItemsCount", "totalItemsCount", "", "getHasVisibleItems", "()Z", "hasVisibleItems", "getMainAxisExtraSpaceStart", "mainAxisExtraSpaceStart", "getMainAxisExtraSpaceEnd", "mainAxisExtraSpaceEnd", "getFirstVisibleLineIndex", "firstVisibleLineIndex", "getLastVisibleLineIndex", "lastVisibleLineIndex", "getMainAxisViewportSize", "mainAxisViewportSize", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "density", "getVisibleLineCount", "visibleLineCount"})
final class PagerCacheWindowScope
implements CacheWindowScope {
    public final Function0<Integer> itemCount;
    public PagerMeasureResult layoutInfo;
    public LazyLayoutPrefetchState state;

    /*
     * WARNING - void declaration
     */
    public PagerCacheWindowScope(Function0<Integer> itemCount) {
        void var1_1;
        Intrinsics.checkNotNullParameter(itemCount, (String)"itemCount");
        this.itemCount = var1_1;
    }

    public final PagerMeasureResult getLayoutInfo() {
        PagerMeasureResult pagerMeasureResult = this.layoutInfo;
        if (pagerMeasureResult != null) {
            return pagerMeasureResult;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutInfo");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLayoutInfo(PagerMeasureResult pagerMeasureResult) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)pagerMeasureResult, (String)"<set-?>");
        this.layoutInfo = var1_1;
    }

    public final LazyLayoutPrefetchState getState() {
        LazyLayoutPrefetchState lazyLayoutPrefetchState = this.state;
        if (lazyLayoutPrefetchState != null) {
            return lazyLayoutPrefetchState;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setState(LazyLayoutPrefetchState lazyLayoutPrefetchState) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)lazyLayoutPrefetchState, (String)"<set-?>");
        this.state = var1_1;
    }

    @Override
    public final int getTotalItemsCount() {
        return ((Number)this.itemCount.invoke()).intValue();
    }

    @Override
    public final boolean getHasVisibleItems() {
        return !((Collection)this.getLayoutInfo().getVisiblePagesInfo()).isEmpty();
    }

    @Override
    public final int getMainAxisExtraSpaceStart() {
        MeasuredPage measuredPage = (MeasuredPage)CollectionsKt.first(this.getLayoutInfo().getVisiblePagesInfo());
        int n = RangesKt.coerceAtMost((int)(measuredPage.getOffset() + this.getLayoutInfo().getBeforeContentPadding()), (int)0);
        return Math.abs(n);
    }

    @Override
    public final int getMainAxisExtraSpaceEnd() {
        MeasuredPage measuredPage = (MeasuredPage)CollectionsKt.last(this.getLayoutInfo().getVisiblePagesInfo());
        int n = measuredPage.getOffset() + this.getLayoutInfo().getPageSize() + this.getLayoutInfo().getPageSpacing();
        return Math.abs(n - this.getLayoutInfo().getViewportEndOffset());
    }

    @Override
    public final int getFirstVisibleLineIndex() {
        return RangesKt.coerceAtLeast((int)(((MeasuredPage)CollectionsKt.first(this.getLayoutInfo().getVisiblePagesInfo())).getIndex() - this.getLayoutInfo().getBeyondViewportPageCount()), (int)0);
    }

    @Override
    public final int getLastVisibleLineIndex() {
        return RangesKt.coerceAtMost((int)(((MeasuredPage)CollectionsKt.last(this.getLayoutInfo().getVisiblePagesInfo())).getIndex() + this.getLayoutInfo().getBeyondViewportPageCount()), (int)(this.getTotalItemsCount() - 1));
    }

    @Override
    public final int getMainAxisViewportSize() {
        return PagerLayoutInfoKt.getMainAxisViewportSize(this.getLayoutInfo());
    }

    @Override
    public final Density getDensity() {
        return this.getLayoutInfo().getDensity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<LazyLayoutPrefetchState.PrefetchHandle> schedulePrefetch(int lineIndex, Function2<? super Integer, ? super Integer, Unit> onItemPrefetched) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(onItemPrefetched, (String)"onItemPrefetched");
        long childConstraints = this.getLayoutInfo().getChildConstraints-msEJaDk();
        return CollectionsKt.listOf((Object)this.getState().schedulePrecompositionAndPremeasure-_EkL_-Y$foundation((int)var1_1, (long)var3_3, true, (Function1<? super LazyLayoutPrefetchState.PrefetchResultScope, Unit>)((Function1)arg_0 -> PagerCacheWindowScope.schedulePrefetch$lambda$0((Function2)var2_2, this, arg_0))));
    }

    @Override
    public final int getVisibleLineCount() {
        return this.getLayoutInfo().getExtraPagesBefore().size() + this.getLayoutInfo().getVisiblePagesInfo().size() + this.getLayoutInfo().getExtraPagesAfter().size();
    }

    @Override
    public final int getVisibleItemSize(int indexInVisibleLines) {
        return this.getLayoutInfo().getPageSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getVisibleItemLine(int indexInVisibleLines) {
        int extraPagesBeforeCount = this.getLayoutInfo().getExtraPagesBefore().size();
        int visiblePagesCount = this.getLayoutInfo().getVisiblePagesInfo().size();
        if (indexInVisibleLines < extraPagesBeforeCount) {
            return this.getLayoutInfo().getExtraPagesBefore().get(indexInVisibleLines).getIndex();
        }
        if (indexInVisibleLines >= extraPagesBeforeCount && indexInVisibleLines < extraPagesBeforeCount + visiblePagesCount) {
            return this.getLayoutInfo().getVisiblePagesInfo().get(indexInVisibleLines - extraPagesBeforeCount).getIndex();
        }
        if (indexInVisibleLines >= extraPagesBeforeCount + visiblePagesCount) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.getLayoutInfo().getExtraPagesAfter().get((int)(var1_1 - var2_2 - var3_3)).getIndex();
        }
        return -1;
    }

    @Override
    public final int getLastIndexInLine(int lineIndex) {
        return lineIndex;
    }

    @Override
    public final int getLastLineIndex() {
        if (this.getTotalItemsCount() == 0) {
            return -1;
        }
        return this.getTotalItemsCount() - 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit schedulePrefetch$lambda$0(Function2 $onItemPrefetched, PagerCacheWindowScope this$0, LazyLayoutPrefetchState.PrefetchResultScope $this$schedulePrecompositionAndPremeasure) {
        void var1_1;
        void var2_2;
        Function2 function2;
        Intrinsics.checkNotNullParameter((Object)$this$schedulePrecompositionAndPremeasure, (String)"$this$schedulePrecompositionAndPremeasure");
        function2.invoke((Object)var2_2.getIndex(), (Object)var1_1.getLayoutInfo().getPageSize());
        return Unit.INSTANCE;
    }
}

