/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.pager.PagerState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u00018\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0011"}, d2={"Landroidx/compose/foundation/pager/PagerBringIntoViewSpec;", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "Landroidx/compose/foundation/pager/PagerState;", "pagerState", "defaultBringIntoViewSpec", "<init>", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/BringIntoViewSpec;)V", "", "offset", "size", "containerSize", "calculateScrollDistance", "(FFF)F", "proposedOffsetMove", "overrideProposedOffsetMove", "(F)F", "Landroidx/compose/foundation/pager/PagerState;", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;"})
final class PagerBringIntoViewSpec
implements BringIntoViewSpec {
    public final PagerState pagerState;
    public final BringIntoViewSpec defaultBringIntoViewSpec;

    /*
     * WARNING - void declaration
     */
    public PagerBringIntoViewSpec(PagerState pagerState, BringIntoViewSpec defaultBringIntoViewSpec) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)defaultBringIntoViewSpec, (String)"defaultBringIntoViewSpec");
        this.pagerState = var1_1;
        this.defaultBringIntoViewSpec = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float calculateScrollDistance(float offset, float size, float containerSize) {
        float f;
        void var2_5;
        boolean isItemOutView;
        float proposedOffsetMove = this.defaultBringIntoViewSpec.calculateScrollDistance(offset, size, containerSize);
        boolean bl = offset > 0.0f ? offset + size > containerSize : (isItemOutView = offset + var2_5 <= 0.0f);
        if (!(Math.abs(proposedOffsetMove) == 0.0f) && isItemOutView) {
            f = this.overrideProposedOffsetMove(proposedOffsetMove);
        } else if ((double)Math.abs(this.pagerState.getFirstVisiblePageOffset$foundation()) < 1.0E-6) {
            f = 0.0f;
        } else {
            void var3_6;
            void var1_3;
            float reversedFirstPageScroll = -((float)this.pagerState.getFirstVisiblePageOffset$foundation());
            f = RangesKt.coerceIn((float)(this.pagerState.getLastScrolledForward() ? reversedFirstPageScroll + (float)this.pagerState.getPageSizeWithSpacing$foundation() : var1_3), (float)(-containerSize), (float)var3_6);
        }
        float f2 = f;
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private final float overrideProposedOffsetMove(float proposedOffsetMove) {
        void var2_2;
        float correctedOffset;
        for (correctedOffset = -((float)this.pagerState.getFirstVisiblePageOffset$foundation()); proposedOffsetMove > 0.0f && correctedOffset < proposedOffsetMove; correctedOffset += (float)this.pagerState.getPageSizeWithSpacing$foundation()) {
        }
        while (proposedOffsetMove < 0.0f && correctedOffset > proposedOffsetMove) {
            correctedOffset -= (float)this.pagerState.getPageSizeWithSpacing$foundation();
        }
        return (float)var2_2;
    }
}

