/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutBeyondBoundsState;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerState;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\nR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000bR\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\t"}, d2={"Landroidx/compose/foundation/pager/PagerBeyondBoundsState;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutBeyondBoundsState;", "Landroidx/compose/foundation/pager/PagerState;", "state", "", "beyondViewportPageCount", "<init>", "(Landroidx/compose/foundation/pager/PagerState;I)V", "itemsPerViewport", "()I", "Landroidx/compose/foundation/pager/PagerState;", "I", "getItemCount", "itemCount", "", "getHasVisibleItems", "()Z", "hasVisibleItems", "getFirstPlacedIndex", "firstPlacedIndex", "getLastPlacedIndex", "lastPlacedIndex"})
public final class PagerBeyondBoundsState
implements LazyLayoutBeyondBoundsState {
    private final PagerState state;
    private final int beyondViewportPageCount;

    /*
     * WARNING - void declaration
     */
    public PagerBeyondBoundsState(PagerState state, int beyondViewportPageCount) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = var1_1;
        this.beyondViewportPageCount = var2_2;
    }

    @Override
    public final int getItemCount() {
        return this.state.getPageCount();
    }

    @Override
    public final boolean getHasVisibleItems() {
        return !((Collection)this.state.getLayoutInfo().getVisiblePagesInfo()).isEmpty();
    }

    @Override
    public final int getFirstPlacedIndex() {
        return Math.max(0, this.state.getFirstVisiblePage$foundation() - this.beyondViewportPageCount);
    }

    @Override
    public final int getLastPlacedIndex() {
        return Math.min(this.getItemCount() - 1, ((PageInfo)CollectionsKt.last(this.state.getLayoutInfo().getVisiblePagesInfo())).getIndex() + this.beyondViewportPageCount);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int itemsPerViewport() {
        void var2_2;
        int n = this.state.getLayoutInfo().getVisiblePagesInfo().size();
        if (n == 0) {
            return 0;
        }
        int viewportSize = PagerLayoutInfoKt.getMainAxisViewportSize(this.state.getLayoutInfo());
        int averageItemSize = this.state.getLayoutInfo().getPageSize() + this.state.getLayoutInfo().getPageSpacing();
        if (averageItemSize == 0) {
            return 1;
        }
        return RangesKt.coerceAtLeast((int)(n / var2_2), (int)1);
    }
}

