/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.staggeredgrid;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 +2\u00020\u0001:\u0002,+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u001d\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010\"\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010\tR\u0016\u0010#\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo;", "", "<init>", "()V", "", "itemIndex", "lane", "", "setLane", "(II)V", "getLane", "(I)I", "targetLane", "", "assignedToLane", "(II)Z", "upperBound", "()I", "lowerBound", "reset", "findPreviousItemIndex", "(II)I", "findNextItemIndex", "requestedIndex", "ensureValidIndex", "(I)V", "", "gaps", "setGaps", "(I[I)V", "getGaps", "(I)[I", "capacity", "newOffset", "ensureCapacity", "anchor", "I", "lanes", "[I", "Lkotlin/collections/ArrayDeque;", "Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "spannedItems", "Lkotlin/collections/ArrayDeque;", "Companion", "SpannedItem"})
@SourceDebugExtension(value={"SMAP\nLazyStaggeredGridLaneInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyStaggeredGridLaneInfo.kt\nandroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 Collections.kt\nkotlin/collections/CollectionsKt__CollectionsKt\n*L\n1#1,206:1\n97#2,4:207\n97#2,4:225\n404#3,7:211\n404#3,7:218\n*S KotlinDebug\n*F\n+ 1 LazyStaggeredGridLaneInfo.kt\nandroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo\n*L\n36#1:207,4\n190#1:225,4\n165#1:211,7\n185#1:218,7\n*E\n"})
public final class LazyStaggeredGridLaneInfo {
    public static final Companion Companion = new Companion(null);
    private int anchor;
    private int[] lanes = new int[16];
    private final ArrayDeque<SpannedItem> spannedItems = new ArrayDeque();
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public final void setLane(int itemIndex, int lane) {
        void var2_2;
        boolean bl = itemIndex >= 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("Negative lanes are not supported");
        }
        this.ensureValidIndex(itemIndex);
        this.lanes[var1_1 - this.anchor] = var2_2 + true;
    }

    /*
     * WARNING - void declaration
     */
    public final int getLane(int itemIndex) {
        void var1_1;
        if (itemIndex < this.lowerBound() || itemIndex >= this.upperBound()) {
            return -1;
        }
        return this.lanes[var1_1 - this.anchor] - 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean assignedToLane(int itemIndex, int targetLane) {
        void var1_1;
        void var2_2;
        int lane = this.getLane(itemIndex);
        return lane == var2_2 || lane == -1 || var1_1 == -2;
    }

    public final int upperBound() {
        return this.anchor + this.lanes.length;
    }

    public final int lowerBound() {
        return this.anchor;
    }

    public final void reset() {
        ArraysKt.fill$default((int[])this.lanes, (int)0, (int)0, (int)0, (int)6, null);
        this.spannedItems.clear();
    }

    public final int findPreviousItemIndex(int itemIndex, int targetLane) {
        for (int i = itemIndex - 1; i >= 0; --i) {
            if (!this.assignedToLane(i, targetLane)) continue;
            return i;
        }
        return -1;
    }

    public final int findNextItemIndex(int itemIndex, int targetLane) {
        int n = this.upperBound();
        for (int i = itemIndex + 1; i < n; ++i) {
            if (!this.assignedToLane(i, targetLane)) continue;
            return i;
        }
        return this.upperBound();
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureValidIndex(int requestedIndex) {
        int requestedCapacity = requestedIndex - this.anchor;
        boolean bl = requestedCapacity >= 0 ? requestedCapacity < 131072 : false;
        if (bl) {
            LazyStaggeredGridLaneInfo.ensureCapacity$default(this, requestedCapacity + 1, 0, 2, null);
        } else {
            void var2_2;
            int oldAnchor = this.anchor;
            this.anchor = Math.max(requestedIndex - this.lanes.length / 2, 0);
            int delta = this.anchor - var2_2;
            if (delta >= 0) {
                if (delta < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)0, (int)delta, (int)this.lanes.length);
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)Math.max(0, this.lanes.length - delta), (int)this.lanes.length);
            } else if (this.lanes.length + (delta = -delta) < 131072) {
                LazyStaggeredGridLaneInfo lazyStaggeredGridLaneInfo = this;
                lazyStaggeredGridLaneInfo.ensureCapacity(lazyStaggeredGridLaneInfo.lanes.length + delta + 1, delta);
            } else {
                void var1_1;
                if (delta < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)delta, (int)0, (int)(this.lanes.length - delta));
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)0, (int)Math.min(this.lanes.length, (int)var1_1));
            }
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.first()).getIndex() < this.lowerBound()) {
            this.spannedItems.removeFirst();
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.last()).getIndex() > this.upperBound()) {
            this.spannedItems.removeLast();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setGaps(int itemIndex, int[] gaps) {
        void var2_2;
        void var3_4;
        void $this$binarySearchBy_u24default$iv;
        List list = (List)this.spannedItems;
        Comparable key$iv = Integer.valueOf(itemIndex);
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        int foundIndex = CollectionsKt.binarySearch((List)$this$binarySearchBy_u24default$iv, (int)0, (int)toIndex$iv, (Function1)((Function1)new Function1<SpannedItem, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                void var1_1;
                this.$key = var1_1;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                SpannedItem spannedItem = (SpannedItem)it;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(spannedItem.getIndex()), (Comparable)this.$key);
            }
        }));
        if (foundIndex < 0) {
            void var1_1;
            if (gaps == null) {
                return;
            }
            int insertionIndex = -(foundIndex + 1);
            this.spannedItems.add((int)var3_4, (Object)new SpannedItem((int)var1_1, gaps));
            return;
        }
        if (gaps == null) {
            this.spannedItems.remove((int)var3_4);
            return;
        }
        ((SpannedItem)this.spannedItems.get((int)var3_4)).setGaps((int[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int[] getGaps(int itemIndex) {
        void var1_3;
        void var3_5;
        void $this$binarySearchBy_u24default$iv;
        List list = (List)this.spannedItems;
        Comparable key$iv = Integer.valueOf(itemIndex);
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        int foundIndex = CollectionsKt.binarySearch((List)list, (int)0, (int)var3_5, (Function1)((Function1)new Function1<SpannedItem, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                void var1_1;
                this.$key = var1_1;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                SpannedItem spannedItem = (SpannedItem)it;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(spannedItem.getIndex()), (Comparable)this.$key);
            }
        }));
        SpannedItem spannedItem = (SpannedItem)CollectionsKt.getOrNull((List)((List)this.spannedItems), (int)var1_3);
        if (spannedItem != null) {
            return spannedItem.getGaps();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int capacity, int newOffset) {
        int n = capacity <= 131072 ? 1 : 0;
        if (n == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("Requested item capacity " + capacity + " is larger than max supported: 131072!");
        }
        if (this.lanes.length < capacity) {
            void var2_2;
            for (int newSize = this.lanes.length; newSize < capacity; newSize <<= 1) {
            }
            this.lanes = ArraysKt.copyInto$default((int[])this.lanes, (int[])new int[n], (int)var2_2, (int)0, (int)0, (int)12, null);
        }
    }

    static /* synthetic */ void ensureCapacity$default(LazyStaggeredGridLaneInfo lazyStaggeredGridLaneInfo, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        lazyStaggeredGridLaneInfo.ensureCapacity(n, n2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "", "", "index", "", "gaps", "<init>", "(I[I)V", "I", "getIndex", "()I", "[I", "getGaps", "()[I", "setGaps", "([I)V"})
    private static final class SpannedItem {
        private final int index;
        private int[] gaps;

        /*
         * WARNING - void declaration
         */
        public SpannedItem(int index, int[] gaps) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)gaps, (String)"gaps");
            this.index = var1_1;
            this.gaps = var2_2;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int[] getGaps() {
            return this.gaps;
        }

        /*
         * WARNING - void declaration
         */
        public final void setGaps(int[] nArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.gaps = var1_1;
        }
    }
}

