/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.LazyGridSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchScope;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.runtime.collection.MutableVector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\f\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u000e\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0012\u001a\u00020\u000b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0017\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u0019\u001a\u00020\u0002*\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u0002*\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010\u001eR\u0016\u0010'\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010("}, d2={"Landroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy;", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchStrategy;", "", "initialNestedPrefetchItemCount", "<init>", "(I)V", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "", "delta", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "layoutInfo", "", "onScroll", "(Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;FLandroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;)V", "onVisibleItemsUpdated", "(Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;)V", "Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;", "firstVisibleItemIndex", "onNestedPrefetch", "(Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;I)V", "currentPrefetchingLineIndex", "", "scrollingForward", "evaluatePrefetchForCancellation", "(Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;IZ)V", "calculateLineIndexToPrefetch", "(Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;Z)I", "calculateClosestNextItemToPrefetch", "resetPrefetchState", "()V", "I", "lineToPrefetch", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "currentLinePrefetchHandles", "Landroidx/compose/runtime/collection/MutableVector;", "wasScrollingForward", "Z", "previousPassItemCount", "previousPassDelta", "F"})
@SourceDebugExtension(value={"SMAP\nLazyGridPrefetchStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,341:1\n1107#2:342\n1085#2,2:343\n424#3,8:345\n136#3:353\n424#3,8:354\n424#3,8:362\n136#3:370\n424#3,8:371\n*S KotlinDebug\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n*L\n164#1:342\n164#1:343,2\n192#1:345,8\n197#1:353\n208#1:354,8\n217#1:362,8\n246#1:370\n303#1:371,8\n*E\n"})
final class DefaultLazyGridPrefetchStrategy
implements LazyGridPrefetchStrategy {
    private final int initialNestedPrefetchItemCount;
    private int lineToPrefetch;
    private final MutableVector<LazyLayoutPrefetchState.PrefetchHandle> currentLinePrefetchHandles;
    private boolean wasScrollingForward;
    private int previousPassItemCount;
    private float previousPassDelta;

    /*
     * WARNING - void declaration
     */
    public DefaultLazyGridPrefetchStrategy(int initialNestedPrefetchItemCount) {
        void var1_1;
        this.initialNestedPrefetchItemCount = var1_1;
        this.lineToPrefetch = -1;
        this.currentLinePrefetchHandles = new MutableVector((Object[])new LazyLayoutPrefetchState.PrefetchHandle[16], 0);
        this.previousPassItemCount = -1;
    }

    public /* synthetic */ DefaultLazyGridPrefetchStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onScroll(LazyGridPrefetchScope $this$onScroll, float delta, LazyGridLayoutInfo layoutInfo) {
        void var2_4;
        Intrinsics.checkNotNullParameter((Object)$this$onScroll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (!((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            boolean scrollingForward = delta < 0.0f;
            int lineToPrefetch = this.calculateLineIndexToPrefetch(layoutInfo, scrollingForward);
            int closestNextItemToPrefetch = this.calculateClosestNextItemToPrefetch(layoutInfo, scrollingForward);
            boolean bl = closestNextItemToPrefetch >= 0 ? closestNextItemToPrefetch < layoutInfo.getTotalItemsCount() : false;
            if (bl) {
                if (lineToPrefetch != this.lineToPrefetch && lineToPrefetch >= 0) {
                    void this_$iv;
                    if (this.wasScrollingForward != scrollingForward) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv2 = this.currentLinePrefetchHandles;
                        Object[] content$iv = this_$iv2.content;
                        int size$iv = this_$iv2.getSize();
                        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            prefetchHandle.cancel();
                        }
                    }
                    this.wasScrollingForward = scrollingForward;
                    this.lineToPrefetch = lineToPrefetch;
                    this.currentLinePrefetchHandles.clear();
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> size$iv = this.currentLinePrefetchHandles;
                    List<LazyLayoutPrefetchState.PrefetchHandle> elements$iv = $this$onScroll.scheduleLinePrefetch(lineToPrefetch);
                    void v1 = this_$iv;
                    v1.addAll(v1.getSize(), elements$iv);
                }
                if (scrollingForward) {
                    int n;
                    LazyGridItemInfo lastItem = (LazyGridItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                    int itemSize = LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis(lastItem, layoutInfo.getOrientation());
                    int itemSpacing = layoutInfo.getMainAxisItemSpacing();
                    int n2 = LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(lastItem, layoutInfo.getOrientation()) + itemSize + itemSpacing - layoutInfo.getViewportEndOffset();
                    if ((float)n < -delta) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                        Object[] content$iv = this_$iv.content;
                        int size$iv = this_$iv.getSize();
                        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            prefetchHandle.markAsUrgent();
                        }
                    }
                } else {
                    int n;
                    LazyLayoutPrefetchState.PrefetchHandle prefetchHandle;
                    LazyGridItemInfo firstItem = (LazyGridItemInfo)CollectionsKt.first(prefetchHandle.getVisibleItemsInfo());
                    int i$iv = prefetchHandle.getViewportStartOffset() - LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(firstItem, prefetchHandle.getOrientation());
                    if ((float)n < delta) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                        Object[] content$iv = this_$iv.content;
                        int size$iv = this_$iv.getSize();
                        for (int i$iv2 = 0; i$iv2 < size$iv; ++i$iv2) {
                            prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv2];
                            prefetchHandle.markAsUrgent();
                        }
                    }
                }
            }
        }
        this.previousPassDelta = var2_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onVisibleItemsUpdated(LazyGridPrefetchScope $this$onVisibleItemsUpdated, LazyGridLayoutInfo layoutInfo) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$onVisibleItemsUpdated, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        this.evaluatePrefetchForCancellation((LazyGridLayoutInfo)layoutInfo, this.lineToPrefetch, this.wasScrollingForward);
        int currentPassItemCount = layoutInfo.getTotalItemsCount();
        if (this.previousPassItemCount != -1 && !(this.previousPassDelta == 0.0f) && this.previousPassItemCount != currentPassItemCount && !((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int lineToPrefetch = this.calculateLineIndexToPrefetch((LazyGridLayoutInfo)layoutInfo, this.previousPassDelta < 0.0f);
            int closestNextItemToPrefetch = this.calculateClosestNextItemToPrefetch((LazyGridLayoutInfo)layoutInfo, this.previousPassDelta < 0.0f);
            boolean bl = closestNextItemToPrefetch >= 0 ? closestNextItemToPrefetch < layoutInfo.getTotalItemsCount() : false;
            if (bl && lineToPrefetch != this.lineToPrefetch && lineToPrefetch >= 0) {
                void var1_1;
                void var2_2;
                this.lineToPrefetch = lineToPrefetch;
                this.currentLinePrefetchHandles.clear();
                layoutInfo = this.currentLinePrefetchHandles;
                List<LazyLayoutPrefetchState.PrefetchHandle> elements$iv = $this$onVisibleItemsUpdated.scheduleLinePrefetch(lineToPrefetch);
                void v1 = var2_2;
                v1.addAll(v1.getSize(), (List)var1_1);
            }
        }
        this.previousPassItemCount = var3_3;
    }

    @Override
    public final void onNestedPrefetch(NestedPrefetchScope $this$onNestedPrefetch, int firstVisibleItemIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$onNestedPrefetch, (String)"<this>");
        int resolvedNestedPrefetchItemCount = $this$onNestedPrefetch.getNestedPrefetchItemCount() == -1 ? this.initialNestedPrefetchItemCount : $this$onNestedPrefetch.getNestedPrefetchItemCount();
        int n = 0;
        while (n < resolvedNestedPrefetchItemCount) {
            int i = n++;
            $this$onNestedPrefetch.schedulePrecomposition(firstVisibleItemIndex + i);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void evaluatePrefetchForCancellation(LazyGridLayoutInfo $this$evaluatePrefetchForCancellation, int currentPrefetchingLineIndex, boolean scrollingForward) {
        if (currentPrefetchingLineIndex != -1 && !((Collection)$this$evaluatePrefetchForCancellation.getVisibleItemsInfo()).isEmpty()) {
            void var1_2;
            void var2_3;
            void var3_4;
            int expectedLineToPrefetch = this.calculateLineIndexToPrefetch($this$evaluatePrefetchForCancellation, (boolean)var3_4);
            if (var2_3 != var1_2) {
                this.resetPrefetchState();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateLineIndexToPrefetch(LazyGridLayoutInfo $this$calculateLineIndexToPrefetch, boolean scrollingForward) {
        void var2_4;
        void var1_1;
        if (scrollingForward) {
            LazyGridItemInfo it = (LazyGridItemInfo)CollectionsKt.last($this$calculateLineIndexToPrefetch.getVisibleItemsInfo());
            return ($this$calculateLineIndexToPrefetch.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn()) + 1;
        }
        LazyGridItemInfo it = (LazyGridItemInfo)CollectionsKt.first($this$calculateLineIndexToPrefetch.getVisibleItemsInfo());
        return (var1_1.getOrientation() == Orientation.Vertical ? it.getRow() : var2_4.getColumn()) - 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateClosestNextItemToPrefetch(LazyGridLayoutInfo $this$calculateClosestNextItemToPrefetch, boolean scrollingForward) {
        void var1_1;
        if (scrollingForward) {
            return ((LazyGridItemInfo)CollectionsKt.last($this$calculateClosestNextItemToPrefetch.getVisibleItemsInfo())).getIndex() + 1;
        }
        return ((LazyGridItemInfo)CollectionsKt.first(var1_1.getVisibleItemsInfo())).getIndex() - 1;
    }

    private final void resetPrefetchState() {
        this.lineToPrefetch = -1;
        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
        Object[] content$iv = this_$iv.content;
        int size$iv = this_$iv.getSize();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
            prefetchHandle.cancel();
        }
        this.currentLinePrefetchHandles.clear();
    }

    public DefaultLazyGridPrefetchStrategy() {
        this(0, 1, null);
    }
}

