/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.DragEvent;
import androidx.compose.foundation.gestures.DraggableKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.TouchInputEventSmoother;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.indirect.IndirectTouchEvent;
import androidx.compose.ui.input.indirect.IndirectTouchEventType;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.platform.ViewConfiguration;
import androidx.compose.ui.unit.VelocityKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0018R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u00058\u0006\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0016\u0010\"\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010 R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%"}, d2={"Landroidx/compose/foundation/gestures/IndirectTouchEventProcessor;", "", "Lkotlin/Function0;", "", "startGestureTrigger", "Lkotlin/Function1;", "Landroidx/compose/foundation/gestures/DragEvent;", "onDragEvent", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "requireVelocityTracker", "()Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "Landroidx/compose/ui/input/indirect/IndirectTouchEvent;", "event", "Landroidx/compose/foundation/gestures/Orientation;", "orientation", "Landroidx/compose/ui/platform/ViewConfiguration;", "viewConfiguration", "", "processIndirectTouchEvent", "(Landroidx/compose/ui/input/indirect/IndirectTouchEvent;Landroidx/compose/foundation/gestures/Orientation;Landroidx/compose/ui/platform/ViewConfiguration;)Z", "resetProcessor", "()V", "Lkotlin/jvm/functions/Function0;", "Lkotlin/jvm/functions/Function1;", "velocityTracker", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "hasCrossedTouchSlop", "Z", "Landroidx/compose/ui/geometry/Offset;", "previousIndirectTouchPosition", "J", "positionAccumulator", "startEventPosition", "Landroidx/compose/foundation/gestures/TouchInputEventSmoother;", "touchInputEventSmoother", "Landroidx/compose/foundation/gestures/TouchInputEventSmoother;", "Companion"})
@SourceDebugExtension(value={"SMAP\nDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Draggable.kt\nandroidx/compose/foundation/gestures/IndirectTouchEventProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,1338:1\n1#2:1339\n30#3:1340\n30#3:1344\n53#4,3:1341\n53#4,3:1345\n*S KotlinDebug\n*F\n+ 1 Draggable.kt\nandroidx/compose/foundation/gestures/IndirectTouchEventProcessor\n*L\n1202#1:1340\n1203#1:1344\n1202#1:1341,3\n1203#1:1345,3\n*E\n"})
final class IndirectTouchEventProcessor {
    public static final Companion Companion = new Companion(null);
    public final Function0<Unit> startGestureTrigger;
    public final Function1<DragEvent, Unit> onDragEvent;
    private VelocityTracker velocityTracker;
    private boolean hasCrossedTouchSlop;
    private long previousIndirectTouchPosition;
    private long positionAccumulator;
    private long startEventPosition;
    private TouchInputEventSmoother touchInputEventSmoother;

    /*
     * WARNING - void declaration
     */
    public IndirectTouchEventProcessor(Function0<Unit> startGestureTrigger, Function1<? super DragEvent, Unit> onDragEvent) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(startGestureTrigger, (String)"startGestureTrigger");
        Intrinsics.checkNotNullParameter(onDragEvent, (String)"onDragEvent");
        this.startGestureTrigger = var1_1;
        this.onDragEvent = var2_2;
        this.previousIndirectTouchPosition = Offset.Companion.getZero-F1C5BW0();
        this.positionAccumulator = Offset.Companion.getZero-F1C5BW0();
        this.startEventPosition = Offset.Companion.getZero-F1C5BW0();
        this.touchInputEventSmoother = new TouchInputEventSmoother();
    }

    private final VelocityTracker requireVelocityTracker() {
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker == null) {
            String string = "VelocityTracker was not initialized.";
            throw new IllegalArgumentException(string.toString());
        }
        return velocityTracker;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean processIndirectTouchEvent(IndirectTouchEvent event, Orientation orientation, ViewConfiguration viewConfiguration) {
        boolean consumed;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)viewConfiguration, (String)"viewConfiguration");
        if (this.velocityTracker == null) {
            this.velocityTracker = new VelocityTracker();
        }
        long smoothedEventPosition = this.touchInputEventSmoother.smoothEventPosition-dBAh8RU(event, orientation);
        int n = event.getType-LxEHWp8();
        if (IndirectTouchEventType.equals-impl0((int)n, (int)IndirectTouchEventType.Companion.getPress-LxEHWp8())) {
            this.resetProcessor();
            this.requireVelocityTracker().addPosition-Uv8p0NA(event.getUptimeMillis(), smoothedEventPosition);
            this.previousIndirectTouchPosition = smoothedEventPosition;
            this.startEventPosition = smoothedEventPosition;
            return false;
        }
        if (IndirectTouchEventType.equals-impl0((int)n, (int)IndirectTouchEventType.Companion.getMove-LxEHWp8())) {
            void var2_2;
            long delta = Offset.minus-MK-Hz9U((long)smoothedEventPosition, (long)this.previousIndirectTouchPosition);
            consumed = false;
            this.positionAccumulator = Offset.plus-MK-Hz9U((long)this.positionAccumulator, (long)delta);
            if (!this.hasCrossedTouchSlop && Math.abs(DraggableKt.access$toFloat-3MmeM6k(this.positionAccumulator, orientation)) > viewConfiguration.getTouchSlop()) {
                long l;
                long v2$iv$iv;
                long v1$iv$iv;
                this.hasCrossedTouchSlop = true;
                this.startGestureTrigger.invoke();
                float postSlopDelta = (Math.abs(DraggableKt.access$toFloat-3MmeM6k(this.positionAccumulator, orientation)) - viewConfiguration.getTouchSlop()) * Math.signum(DraggableKt.access$toFloat-3MmeM6k(this.positionAccumulator, orientation));
                if (orientation == Orientation.Horizontal) {
                    float f = postSlopDelta;
                    postSlopDelta = f;
                    postSlopDelta = f;
                    v1$iv$iv = Float.floatToRawIntBits(f);
                    v2$iv$iv = Float.floatToRawIntBits(0.0f);
                    l = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
                } else {
                    void var3_4;
                    float val2$iv$iv = postSlopDelta;
                    v1$iv$iv = Float.floatToRawIntBits(0.0f);
                    v2$iv$iv = Float.floatToRawIntBits((float)var3_4);
                    l = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
                }
                delta = l;
                this.onDragEvent.invoke((Object)new DragEvent.DragStarted(this.startEventPosition, null));
                consumed = true;
            }
            if (this.hasCrossedTouchSlop && Math.abs(DraggableKt.access$toFloat-3MmeM6k(delta, (Orientation)var2_2)) > 2.0f) {
                void var1_1;
                this.requireVelocityTracker().addPosition-Uv8p0NA(var1_1.getUptimeMillis(), smoothedEventPosition);
                consumed = true;
                this.onDragEvent.invoke((Object)new DragEvent.DragDelta(delta, true, null));
            }
            this.previousIndirectTouchPosition = smoothedEventPosition;
            return consumed;
        }
        if (IndirectTouchEventType.equals-impl0((int)(consumed ? 1 : 0), (int)IndirectTouchEventType.Companion.getRelease-LxEHWp8())) {
            boolean bl;
            if (this.hasCrossedTouchSlop) {
                void var3_3;
                float maxVelocity;
                float f = maxVelocity = var3_3.getMaximumFlingVelocity();
                DragEvent.DragStopped event2 = new DragEvent.DragStopped(this.requireVelocityTracker().calculateVelocity-AH228Gc(VelocityKt.Velocity((float)f, (float)f)), true, null);
                this.onDragEvent.invoke((Object)event2);
                bl = true;
            } else {
                bl = false;
            }
            boolean consumed2 = bl;
            this.resetProcessor();
            return consumed2;
        }
        this.onDragEvent.invoke((Object)DragEvent.DragCancelled.INSTANCE);
        this.resetProcessor();
        return false;
    }

    public final void resetProcessor() {
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker != null) {
            velocityTracker.resetTracking();
        }
        this.hasCrossedTouchSlop = false;
        this.previousIndirectTouchPosition = Offset.Companion.getZero-F1C5BW0();
        this.positionAccumulator = Offset.Companion.getZero-F1C5BW0();
        this.startEventPosition = Offset.Companion.getZero-F1C5BW0();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/compose/foundation/gestures/IndirectTouchEventProcessor$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

