/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core;

import androidx.datastore.core.FileStorageConnection;
import androidx.datastore.core.InterProcessCoordinator;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.Storage;
import androidx.datastore.core.StorageConnection;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u0013*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002:\u0001\u0013B9\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0010R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0011R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0012"}, d2={"Landroidx/datastore/core/FileStorage;", "T", "Landroidx/datastore/core/Storage;", "Landroidx/datastore/core/Serializer;", "serializer", "Lkotlin/Function1;", "Ljava/io/File;", "Landroidx/datastore/core/InterProcessCoordinator;", "coordinatorProducer", "Lkotlin/Function0;", "produceFile", "<init>", "(Landroidx/datastore/core/Serializer;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "Landroidx/datastore/core/StorageConnection;", "createConnection", "()Landroidx/datastore/core/StorageConnection;", "Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function0;", "Landroidx/datastore/core/Serializer;", "Companion"})
public final class FileStorage<T>
implements Storage<T> {
    public static final Companion Companion = new Companion(null);
    private final Serializer<T> serializer;
    private final Function1<File, InterProcessCoordinator> coordinatorProducer;
    private final Function0<File> produceFile;
    private static final Set<String> activeFiles = new LinkedHashSet();
    private static final Object activeFilesLock = new Object();

    /*
     * WARNING - void declaration
     */
    public FileStorage(Serializer<T> serializer, Function1<? super File, ? extends InterProcessCoordinator> coordinatorProducer, Function0<? extends File> produceFile) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(coordinatorProducer, (String)"coordinatorProducer");
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        this.serializer = var1_1;
        this.coordinatorProducer = var2_2;
        this.produceFile = var3_3;
    }

    public /* synthetic */ FileStorage(Serializer serializer, Function1 function1, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(serializer, (Function1<? super File, ? extends InterProcessCoordinator>)function1, (Function0<? extends File>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final StorageConnection<T> createConnection() {
        void var1_1;
        Object file = ((File)this.produceFile.invoke()).getCanonicalFile();
        Object object = activeFilesLock;
        synchronized (object) {
            void var3_4;
            String path = ((File)file).getAbsolutePath();
            if (!(!activeFiles.contains(path))) {
                file = "There are multiple DataStores active for the same file: " + path + ". You should either maintain your DataStore as a singleton or confirm that there is no two DataStore's active on the same file (by confirming that the scope is cancelled).";
                throw new IllegalStateException(file.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            activeFiles.add((String)var3_4);
        }
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return new FileStorageConnection<T>((File)file, this.serializer, (InterProcessCoordinator)this.coordinatorProducer.invoke(file), (Function0<Unit>)((Function0)new Function0<Unit>((File)var1_1){
            final /* synthetic */ File $file;
            {
                void var1_1;
                this.$file = var1_1;
                super(0);
            }

            public final void invoke() {
                Object object = FileStorage.Companion.getActiveFilesLock$datastore_core();
                File file = this.$file;
                synchronized (object) {
                    FileStorage.Companion.getActiveFiles$datastore_core().remove(file.getAbsolutePath());
                    return;
                }
            }
        }));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00018\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Landroidx/datastore/core/FileStorage$Companion;", "", "<init>", "()V", "", "", "activeFiles", "Ljava/util/Set;", "getActiveFiles$datastore_core", "()Ljava/util/Set;", "activeFilesLock", "Ljava/lang/Object;", "getActiveFilesLock$datastore_core", "()Ljava/lang/Object;"})
    public static final class Companion {
        private Companion() {
        }

        public final Set<String> getActiveFiles$datastore_core() {
            return activeFiles;
        }

        public final Object getActiveFilesLock$datastore_core() {
            return activeFilesLock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

