/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import java.io.IOException;

public final class WireFormat {
    static final int FIXED32_SIZE = 4;
    static final int FIXED64_SIZE = 8;
    static final int MAX_VARINT32_SIZE = 5;
    static final int MAX_VARINT64_SIZE = 10;
    static final int MAX_VARINT_SIZE = 10;
    public static final int WIRETYPE_VARINT = 0;
    public static final int WIRETYPE_FIXED64 = 1;
    public static final int WIRETYPE_LENGTH_DELIMITED = 2;
    public static final int WIRETYPE_START_GROUP = 3;
    public static final int WIRETYPE_END_GROUP = 4;
    public static final int WIRETYPE_FIXED32 = 5;
    static final int TAG_TYPE_BITS = 3;
    static final int TAG_TYPE_MASK = 7;
    static final int MESSAGE_SET_ITEM = 1;
    static final int MESSAGE_SET_TYPE_ID = 2;
    static final int MESSAGE_SET_MESSAGE = 3;
    static final int MESSAGE_SET_ITEM_TAG = WireFormat.makeTag(1, 3);
    static final int MESSAGE_SET_ITEM_END_TAG = WireFormat.makeTag(1, 4);
    static final int MESSAGE_SET_TYPE_ID_TAG = WireFormat.makeTag(2, 0);
    static final int MESSAGE_SET_MESSAGE_TAG = WireFormat.makeTag(3, 2);

    private WireFormat() {
    }

    public static int getTagWireType(int tag) {
        return tag & 7;
    }

    public static int getTagFieldNumber(int tag) {
        return tag >>> 3;
    }

    /*
     * WARNING - void declaration
     */
    static int makeTag(int fieldNumber, int wireType) {
        void var1_1;
        return fieldNumber << 3 | var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static Object readPrimitiveField(CodedInputStream input, FieldType type, Utf8Validation utf8Validation) throws IOException {
        void var1_1;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var1_1.ordinal()]) {
            case 1: {
                return input.readDouble();
            }
            case 2: {
                return Float.valueOf(input.readFloat());
            }
            case 3: {
                return input.readInt64();
            }
            case 4: {
                return input.readUInt64();
            }
            case 5: {
                return input.readInt32();
            }
            case 6: {
                return input.readFixed64();
            }
            case 7: {
                return input.readFixed32();
            }
            case 8: {
                return input.readBool();
            }
            case 9: {
                return input.readBytes();
            }
            case 10: {
                return input.readUInt32();
            }
            case 11: {
                return input.readSFixed32();
            }
            case 12: {
                return input.readSFixed64();
            }
            case 13: {
                return input.readSInt32();
            }
            case 14: {
                return input.readSInt64();
            }
            case 15: {
                CodedInputStream codedInputStream;
                void var2_2;
                return var2_2.readString(codedInputStream);
            }
            case 16: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case 17: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case 18: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    static enum Utf8Validation {
        LOOSE{

            @Override
            final Object readString(CodedInputStream input) throws IOException {
                return input.readString();
            }
        }
        ,
        STRICT{

            @Override
            final Object readString(CodedInputStream input) throws IOException {
                return input.readStringRequireUtf8();
            }
        }
        ,
        LAZY{

            @Override
            final Object readString(CodedInputStream input) throws IOException {
                return input.readBytes();
            }
        };


        abstract Object readString(CodedInputStream var1) throws IOException;
    }

    public static enum FieldType {
        DOUBLE(JavaType.DOUBLE, 1),
        FLOAT(JavaType.FLOAT, 5),
        INT64(JavaType.LONG, 0),
        UINT64(JavaType.LONG, 0),
        INT32(JavaType.INT, 0),
        FIXED64(JavaType.LONG, 1),
        FIXED32(JavaType.INT, 5),
        BOOL(JavaType.BOOLEAN, 0),
        STRING(JavaType.STRING, 2){
            {
                void var3_3;
            }

            @Override
            public final boolean isPackable() {
                return false;
            }
        }
        ,
        GROUP(JavaType.MESSAGE, 3){
            {
                void var3_3;
            }

            @Override
            public final boolean isPackable() {
                return false;
            }
        }
        ,
        MESSAGE(JavaType.MESSAGE, 2){
            {
                void var3_3;
            }

            @Override
            public final boolean isPackable() {
                return false;
            }
        }
        ,
        BYTES(JavaType.BYTE_STRING, 2){
            {
                void var3_3;
            }

            @Override
            public final boolean isPackable() {
                return false;
            }
        }
        ,
        UINT32(JavaType.INT, 0),
        ENUM(JavaType.ENUM, 0),
        SFIXED32(JavaType.INT, 5),
        SFIXED64(JavaType.LONG, 1),
        SINT32(JavaType.INT, 0),
        SINT64(JavaType.LONG, 0);

        private final JavaType javaType;
        private final int wireType;

        /*
         * WARNING - void declaration
         */
        private FieldType(JavaType javaType, int wireType) {
            void var3_3;
            this.javaType = var3_3;
            this.wireType = wireType;
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public int getWireType() {
            return this.wireType;
        }

        public boolean isPackable() {
            return true;
        }
    }

    public static enum JavaType {
        INT(0),
        LONG(0L),
        FLOAT(Float.valueOf(0.0f)),
        DOUBLE(0.0),
        BOOLEAN(Boolean.FALSE),
        STRING(""),
        BYTE_STRING(ByteString.EMPTY),
        ENUM(null),
        MESSAGE(null);

        private final Object defaultDefault;

        /*
         * WARNING - void declaration
         */
        private JavaType(Object defaultDefault) {
            void var3_3;
            this.defaultDefault = var3_3;
        }

        final Object getDefaultDefault() {
            return this.defaultDefault;
        }
    }
}

