/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.ListValue;
import androidx.datastore.preferences.protobuf.NullValue;
import androidx.datastore.preferences.protobuf.Parser;
import androidx.datastore.preferences.protobuf.Struct;
import androidx.datastore.preferences.protobuf.ValueOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class Value
extends GeneratedMessageLite<Value, Builder>
implements ValueOrBuilder {
    private int kindCase_ = 0;
    private Object kind_;
    public static final int NULL_VALUE_FIELD_NUMBER = 1;
    public static final int NUMBER_VALUE_FIELD_NUMBER = 2;
    public static final int STRING_VALUE_FIELD_NUMBER = 3;
    public static final int BOOL_VALUE_FIELD_NUMBER = 4;
    public static final int STRUCT_VALUE_FIELD_NUMBER = 5;
    public static final int LIST_VALUE_FIELD_NUMBER = 6;
    private static final Value DEFAULT_INSTANCE;
    private static volatile Parser<Value> PARSER;

    private Value() {
    }

    @Override
    public final KindCase getKindCase() {
        return KindCase.forNumber(this.kindCase_);
    }

    private void clearKind() {
        this.kindCase_ = 0;
        this.kind_ = null;
    }

    @Override
    public final boolean hasNullValue() {
        return this.kindCase_ == 1;
    }

    @Override
    public final int getNullValueValue() {
        if (this.kindCase_ == 1) {
            return (Integer)this.kind_;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final NullValue getNullValue() {
        if (this.kindCase_ == 1) {
            void var1_1;
            NullValue result = NullValue.forNumber((Integer)this.kind_);
            if (result == null) {
                return NullValue.UNRECOGNIZED;
            }
            return var1_1;
        }
        return NullValue.NULL_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private void setNullValueValue(int value) {
        void var1_1;
        this.kindCase_ = 1;
        this.kind_ = (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setNullValue(NullValue value) {
        void var1_1;
        this.kind_ = var1_1.getNumber();
        this.kindCase_ = 1;
    }

    private void clearNullValue() {
        if (this.kindCase_ == 1) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public final boolean hasNumberValue() {
        return this.kindCase_ == 2;
    }

    @Override
    public final double getNumberValue() {
        if (this.kindCase_ == 2) {
            return (Double)this.kind_;
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private void setNumberValue(double value) {
        void var1_1;
        this.kindCase_ = 2;
        this.kind_ = (double)var1_1;
    }

    private void clearNumberValue() {
        if (this.kindCase_ == 2) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public final boolean hasStringValue() {
        return this.kindCase_ == 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getStringValue() {
        void var1_1;
        String ref = "";
        if (this.kindCase_ == 3) {
            ref = (String)this.kind_;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString getStringValueBytes() {
        void var1_1;
        String ref = "";
        if (this.kindCase_ == 3) {
            ref = (String)this.kind_;
        }
        return ByteString.copyFromUtf8((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setStringValue(String value) {
        void var1_1;
        value.getClass();
        this.kindCase_ = 3;
        this.kind_ = var1_1;
    }

    private void clearStringValue() {
        if (this.kindCase_ == 3) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setStringValueBytes(ByteString value) {
        void var1_1;
        Value.checkByteStringIsUtf8(value);
        this.kind_ = var1_1.toStringUtf8();
        this.kindCase_ = 3;
    }

    @Override
    public final boolean hasBoolValue() {
        return this.kindCase_ == 4;
    }

    @Override
    public final boolean getBoolValue() {
        if (this.kindCase_ == 4) {
            return (Boolean)this.kind_;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void setBoolValue(boolean value) {
        void var1_1;
        this.kindCase_ = 4;
        this.kind_ = (boolean)var1_1;
    }

    private void clearBoolValue() {
        if (this.kindCase_ == 4) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public final boolean hasStructValue() {
        return this.kindCase_ == 5;
    }

    @Override
    public final Struct getStructValue() {
        if (this.kindCase_ == 5) {
            return (Struct)this.kind_;
        }
        return Struct.getDefaultInstance();
    }

    /*
     * WARNING - void declaration
     */
    private void setStructValue(Struct value) {
        void var1_1;
        value.getClass();
        this.kind_ = var1_1;
        this.kindCase_ = 5;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeStructValue(Struct value) {
        void var1_1;
        value.getClass();
        this.kind_ = this.kindCase_ == 5 && this.kind_ != Struct.getDefaultInstance() ? ((Struct.Builder)Struct.newBuilder((Struct)this.kind_).mergeFrom(value)).buildPartial() : var1_1;
        this.kindCase_ = 5;
    }

    private void clearStructValue() {
        if (this.kindCase_ == 5) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public final boolean hasListValue() {
        return this.kindCase_ == 6;
    }

    @Override
    public final ListValue getListValue() {
        if (this.kindCase_ == 6) {
            return (ListValue)this.kind_;
        }
        return ListValue.getDefaultInstance();
    }

    /*
     * WARNING - void declaration
     */
    private void setListValue(ListValue value) {
        void var1_1;
        value.getClass();
        this.kind_ = var1_1;
        this.kindCase_ = 6;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeListValue(ListValue value) {
        void var1_1;
        value.getClass();
        this.kind_ = this.kindCase_ == 6 && this.kind_ != ListValue.getDefaultInstance() ? ((ListValue.Builder)ListValue.newBuilder((ListValue)this.kind_).mergeFrom(value)).buildPartial() : var1_1;
        this.kindCase_ = 6;
    }

    private void clearListValue() {
        if (this.kindCase_ == 6) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    public static Value parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        ByteBuffer byteBuffer;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    public static Value parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        void var1_1;
        ByteBuffer byteBuffer;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, byteBuffer, (ExtensionRegistryLite)var1_1);
    }

    public static Value parseFrom(ByteString data) throws InvalidProtocolBufferException {
        ByteString byteString;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, byteString);
    }

    /*
     * WARNING - void declaration
     */
    public static Value parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        void var1_1;
        ByteString byteString;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, byteString, (ExtensionRegistryLite)var1_1);
    }

    public static Value parseFrom(byte[] data) throws InvalidProtocolBufferException {
        byte[] byArray;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static Value parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        void var1_1;
        byte[] byArray;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, byArray, (ExtensionRegistryLite)var1_1);
    }

    public static Value parseFrom(InputStream input) throws IOException {
        InputStream inputStream;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, inputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Value parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        InputStream inputStream;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, inputStream, (ExtensionRegistryLite)var1_1);
    }

    public static Value parseDelimitedFrom(InputStream input) throws IOException {
        InputStream inputStream;
        return Value.parseDelimitedFrom(DEFAULT_INSTANCE, inputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Value parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        InputStream inputStream;
        return Value.parseDelimitedFrom(DEFAULT_INSTANCE, inputStream, (ExtensionRegistryLite)var1_1);
    }

    public static Value parseFrom(CodedInputStream input) throws IOException {
        CodedInputStream codedInputStream;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, codedInputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Value parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        CodedInputStream codedInputStream;
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, codedInputStream, (ExtensionRegistryLite)var1_1);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.createBuilder();
    }

    public static Builder newBuilder(Value prototype) {
        Value value;
        return (Builder)DEFAULT_INSTANCE.createBuilder(value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new Value();
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case BUILD_MESSAGE_INFO: {
                Class<Value> clazz;
                Object[] objects = new Object[]{"kind_", "kindCase_", Struct.class, ListValue.class};
                return Value.newMessageInfo(DEFAULT_INSTANCE, clazz, objects);
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                void var1_1;
                Parser<Value> parser = PARSER;
                if (parser != null) return var1_1;
                Class<Value> clazz = Value.class;
                synchronized (Value.class) {
                    parser = PARSER;
                    if (parser != null) return var1_1;
                    PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser<Value>(DEFAULT_INSTANCE);
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return var1_1;
                }
            }
            case GET_MEMOIZED_IS_INITIALIZED: {
                return (byte)1;
            }
            case SET_MEMOIZED_IS_INITIALIZED: {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Value getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Value> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Value x0, int x1) {
        void var1_1;
        x0.setNullValueValue((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(Value x0, NullValue x1) {
        void var1_1;
        x0.setNullValue((NullValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(Value x0, double x1) {
        void var1_1;
        x0.setNumberValue((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(Value x0, String x1) {
        void var1_1;
        x0.setStringValue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(Value x0, ByteString x1) {
        void var1_1;
        x0.setStringValueBytes((ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(Value x0, boolean x1) {
        void var1_1;
        x0.setBoolValue((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(Value x0, Struct x1) {
        void var1_1;
        x0.setStructValue((Struct)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1300(Value x0, Struct x1) {
        void var1_1;
        x0.mergeStructValue((Struct)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1500(Value x0, ListValue x1) {
        void var1_1;
        x0.setListValue((ListValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1600(Value x0, ListValue x1) {
        void var1_1;
        x0.mergeListValue((ListValue)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Value defaultInstance;
        DEFAULT_INSTANCE = defaultInstance = new Value();
        GeneratedMessageLite.registerDefaultInstance(Value.class, var0);
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<Value, Builder>
    implements ValueOrBuilder {
        private Builder() {
            super(DEFAULT_INSTANCE);
        }

        @Override
        public final KindCase getKindCase() {
            return ((Value)this.instance).getKindCase();
        }

        public final Builder clearKind() {
            this.copyOnWrite();
            ((Value)this.instance).clearKind();
            return this;
        }

        @Override
        public final boolean hasNullValue() {
            return ((Value)this.instance).hasNullValue();
        }

        @Override
        public final int getNullValueValue() {
            return ((Value)this.instance).getNullValueValue();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setNullValueValue(int value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$200((Value)this.instance, (int)var1_1);
            return this;
        }

        @Override
        public final NullValue getNullValue() {
            return ((Value)this.instance).getNullValue();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setNullValue(NullValue value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$300((Value)this.instance, (NullValue)var1_1);
            return this;
        }

        public final Builder clearNullValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearNullValue();
            return this;
        }

        @Override
        public final boolean hasNumberValue() {
            return ((Value)this.instance).hasNumberValue();
        }

        @Override
        public final double getNumberValue() {
            return ((Value)this.instance).getNumberValue();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setNumberValue(double value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$500((Value)this.instance, (double)var1_1);
            return this;
        }

        public final Builder clearNumberValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearNumberValue();
            return this;
        }

        @Override
        public final boolean hasStringValue() {
            return ((Value)this.instance).hasStringValue();
        }

        @Override
        public final String getStringValue() {
            return ((Value)this.instance).getStringValue();
        }

        @Override
        public final ByteString getStringValueBytes() {
            return ((Value)this.instance).getStringValueBytes();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setStringValue(String value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$700((Value)this.instance, (String)var1_1);
            return this;
        }

        public final Builder clearStringValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearStringValue();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setStringValueBytes(ByteString value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$900((Value)this.instance, (ByteString)var1_1);
            return this;
        }

        @Override
        public final boolean hasBoolValue() {
            return ((Value)this.instance).hasBoolValue();
        }

        @Override
        public final boolean getBoolValue() {
            return ((Value)this.instance).getBoolValue();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setBoolValue(boolean value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$1000((Value)this.instance, (boolean)var1_1);
            return this;
        }

        public final Builder clearBoolValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearBoolValue();
            return this;
        }

        @Override
        public final boolean hasStructValue() {
            return ((Value)this.instance).hasStructValue();
        }

        @Override
        public final Struct getStructValue() {
            return ((Value)this.instance).getStructValue();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setStructValue(Struct value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$1200((Value)this.instance, (Struct)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setStructValue(Struct.Builder builderForValue) {
            void var1_1;
            this.copyOnWrite();
            Value.access$1200((Value)this.instance, (Struct)var1_1.build());
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder mergeStructValue(Struct value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$1300((Value)this.instance, (Struct)var1_1);
            return this;
        }

        public final Builder clearStructValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearStructValue();
            return this;
        }

        @Override
        public final boolean hasListValue() {
            return ((Value)this.instance).hasListValue();
        }

        @Override
        public final ListValue getListValue() {
            return ((Value)this.instance).getListValue();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setListValue(ListValue value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$1500((Value)this.instance, (ListValue)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setListValue(ListValue.Builder builderForValue) {
            void var1_1;
            this.copyOnWrite();
            Value.access$1500((Value)this.instance, (ListValue)var1_1.build());
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder mergeListValue(ListValue value) {
            void var1_1;
            this.copyOnWrite();
            Value.access$1600((Value)this.instance, (ListValue)var1_1);
            return this;
        }

        public final Builder clearListValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearListValue();
            return this;
        }
    }

    public static enum KindCase {
        NULL_VALUE(1),
        NUMBER_VALUE(2),
        STRING_VALUE(3),
        BOOL_VALUE(4),
        STRUCT_VALUE(5),
        LIST_VALUE(6),
        KIND_NOT_SET(0);

        private final int value;

        /*
         * WARNING - void declaration
         */
        private KindCase(int value) {
            void var3_3;
            this.value = var3_3;
        }

        @Deprecated
        public static KindCase valueOf(int value) {
            return KindCase.forNumber(value);
        }

        public static KindCase forNumber(int value) {
            switch (value) {
                case 1: {
                    return NULL_VALUE;
                }
                case 2: {
                    return NUMBER_VALUE;
                }
                case 3: {
                    return STRING_VALUE;
                }
                case 4: {
                    return BOOL_VALUE;
                }
                case 5: {
                    return STRUCT_VALUE;
                }
                case 6: {
                    return LIST_VALUE;
                }
                case 0: {
                    return KIND_NOT_SET;
                }
            }
            return null;
        }

        public final int getNumber() {
            return this.value;
        }
    }
}

