/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Android;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.Java8Compatibility;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class Utf8 {
    private static final Processor processor = UnsafeProcessor.isAvailable() && !Android.isOnAndroidDevice() ? new UnsafeProcessor() : new SafeProcessor();
    private static final long ASCII_MASK_LONG = -9187201950435737472L;
    static final int MAX_BYTES_PER_CHAR = 3;
    static final int COMPLETE = 0;
    static final int MALFORMED = -1;
    private static final int UNSAFE_COUNT_ASCII_THRESHOLD = 16;

    static boolean isValidUtf8(byte[] bytes) {
        byte[] byArray;
        return processor.isValidUtf8(bytes, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isValidUtf8(byte[] bytes, int index, int limit) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return processor.isValidUtf8(byArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return processor.partialIsValidUtf8(n, (byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    private static int incompleteStateFor(int byte1) {
        int n;
        if (byte1 > -12) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static int incompleteStateFor(int byte1, int byte2) {
        void var1_1;
        int n;
        if (byte1 > -12 || byte2 > -65) {
            return -1;
        }
        return n ^ var1_1 << 8;
    }

    /*
     * WARNING - void declaration
     */
    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        void var2_2;
        void var1_1;
        int n;
        if (byte1 > -12 || byte2 > -65 || byte3 > -65) {
            return -1;
        }
        return n ^ var1_1 << 8 ^ var2_2 << 16;
    }

    /*
     * WARNING - void declaration
     */
    private static int incompleteStateFor(byte[] bytes, int index, int limit) {
        void var2_2;
        byte byte1 = bytes[index - 1];
        switch (var2_2 - index) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, bytes[index]);
            }
            case 2: {
                void var1_1;
                byte[] byArray;
                void var3_3;
                return Utf8.incompleteStateFor((int)var3_3, (int)bytes[index], (int)byArray[var1_1 + true]);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    private static int incompleteStateFor(ByteBuffer buffer, int byte1, int index, int remaining) {
        switch (remaining) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, buffer.get(index));
            }
            case 2: {
                void var2_2;
                ByteBuffer byteBuffer;
                void var1_1;
                return Utf8.incompleteStateFor((int)var1_1, (int)buffer.get(index), (int)byteBuffer.get((int)(var2_2 + true)));
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    static int encodedLength(String string) {
        void var2_2;
        void var1_1;
        int i;
        int utf16Length;
        int utf8Length = utf16Length = string.length();
        for (i = 0; i < utf16Length && string.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = string.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(string, i);
                break;
            }
            ++i;
        }
        if (utf8Length < var1_1) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int encodedLengthGeneral(String string, int start) {
        void var3_3;
        void i;
        int utf16Length = string.length();
        int utf8Length = 0;
        while (i < utf16Length) {
            char c = string.charAt((int)i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += 2;
                if ('\ud800' <= c && c <= '\udfff') {
                    int n = Character.codePointAt(string, (int)i);
                    if (n < 65536) {
                        throw new UnpairedSurrogateException((int)i, utf16Length);
                    }
                    ++i;
                }
            }
            ++i;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static int encode(String in, byte[] out, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return processor.encodeUtf8(string, (byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    static boolean isValidUtf8(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = buffer;
        return processor.isValidUtf8(byteBuffer2, byteBuffer2.position(), byteBuffer.remaining());
    }

    /*
     * WARNING - void declaration
     */
    static int partialIsValidUtf8(int state, ByteBuffer buffer, int index, int limit) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return processor.partialIsValidUtf8(n, (ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String decodeUtf8(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer;
        return processor.decodeUtf8(byteBuffer, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return processor.decodeUtf8(byArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void encodeUtf8(String in, ByteBuffer out) {
        void var1_1;
        String string;
        processor.encodeUtf8(string, (ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int estimateConsecutiveAscii(ByteBuffer buffer, int index, int limit) {
        void var1_1;
        void var3_3;
        int lim = limit - 7;
        for (int i = index; i < lim && (buffer.getLong(i) & 0x8080808080808080L) == 0L; i += 8) {
        }
        return (int)(var3_3 - var1_1);
    }

    private Utf8() {
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(int x0, int x1) {
        void var1_1;
        return Utf8.incompleteStateFor(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(int x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return Utf8.incompleteStateFor(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$200(ByteBuffer x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return Utf8.estimateConsecutiveAscii(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$300(ByteBuffer x0, int x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Utf8.incompleteStateFor(x0, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1100(byte[] x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return Utf8.incompleteStateFor(x0, (int)var1_1, (int)var2_2);
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte b) {
            return b >= 0;
        }

        private static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        private static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        private static void handleOneByte(byte byte1, char[] resultArr, int resultPos) {
            byte by;
            resultArr[var2_2] = (char)by;
        }

        /*
         * WARNING - void declaration
         */
        private static void handleTwoBytes(byte byte1, byte byte2, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            void var1_1;
            byte by;
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            var2_2[var3_3] = (char)((by & 0x1F) << 6 | DecodeUtil.trailingByteValue((byte)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private static void handleThreeBytes(byte byte1, byte byte2, byte byte3, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            byte by;
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            var3_3[resultPos] = (char)((by & 0xF) << 12 | DecodeUtil.trailingByteValue((byte)var1_1) << 6 | DecodeUtil.trailingByteValue((byte)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        private static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            byte by;
            void var3_3;
            void var2_2;
            void var1_1;
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            byte codepoint = (byte)((byte1 & 7) << 18 | DecodeUtil.trailingByteValue((byte)var1_1) << 12 | DecodeUtil.trailingByteValue((byte)var2_2) << 6 | DecodeUtil.trailingByteValue((byte)var3_3));
            resultArr[resultPos] = DecodeUtil.highSurrogate(codepoint);
            resultArr[resultPos + 1] = DecodeUtil.lowSurrogate(by);
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            int n;
            return (char)(55232 + (n >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            int n;
            return (char)(56320 + (n & 0x3FF));
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$500(byte x0, char[] x1, int x2) {
            void var2_2;
            void var1_1;
            DecodeUtil.handleOneByte(x0, (char[])var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$700(byte x0, byte x1, char[] x2, int x3) throws InvalidProtocolBufferException {
            void var3_3;
            void var2_2;
            void var1_1;
            DecodeUtil.handleTwoBytes(x0, (byte)var1_1, (char[])var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$900(byte x0, byte x1, byte x2, char[] x3, int x4) throws InvalidProtocolBufferException {
            void var3_3;
            void var2_2;
            void var1_1;
            DecodeUtil.handleThreeBytes(x0, (byte)var1_1, (byte)var2_2, (char[])var3_3, x4);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1000(byte x0, byte x1, byte x2, byte x3, char[] x4, int x5) throws InvalidProtocolBufferException {
            void var3_3;
            void var2_2;
            void var1_1;
            DecodeUtil.handleFourBytes(x0, (byte)var1_1, (byte)var2_2, (byte)var3_3, x4, x5);
        }
    }

    static final class UnsafeProcessor
    extends Processor {
        UnsafeProcessor() {
        }

        static boolean isAvailable() {
            return UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
            void var2_2;
            if ((index | limit | bytes.length - limit) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", bytes.length, index, limit));
            }
            long offset = index;
            long offsetLimit = limit;
            if (state != 0) {
                byte byte2;
                if (offset >= offsetLimit) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || UnsafeUtil.getByte(bytes, offset++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(bytes, offset++);
                        if (offset >= offsetLimit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || UnsafeUtil.getByte(bytes, offset++) > -65) {
                        return -1;
                    }
                } else {
                    void var3_3;
                    byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(bytes, offset++);
                        if (offset >= offsetLimit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    } else {
                        void var1_1;
                        byte3 = (byte)(var1_1 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = UnsafeUtil.getByte(bytes, offset++);
                        if (offset >= offsetLimit) {
                            return Utf8.access$100(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (var3_3 << 28) + (byte2 - -112) >> 30 != false || byte3 > -65 || UnsafeUtil.getByte(bytes, offset++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8((byte[])var2_2, offset, (int)(offsetLimit - offset));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int partialIsValidUtf8Direct(int state, ByteBuffer buffer, int index, int limit) {
            if ((index | limit | buffer.limit() - limit) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index, limit));
            }
            long address = UnsafeUtil.addressOffset(buffer) + (long)index;
            long addressLimit = address + (long)(limit - index);
            if (state != 0) {
                byte byte2;
                if (address >= addressLimit) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || UnsafeUtil.getByte(address++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(address++);
                        if (address >= addressLimit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || UnsafeUtil.getByte(address++) > -65) {
                        return -1;
                    }
                } else {
                    void var3_4;
                    void var2_3;
                    byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(address++);
                        if (address >= addressLimit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    } else {
                        void var1_1;
                        byte3 = (byte)(var1_1 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = UnsafeUtil.getByte(address++);
                        if (address >= addressLimit) {
                            return Utf8.access$100(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (var2_3 << 28) + (var3_4 - -112) >> 30 != false || byte3 > -65 || UnsafeUtil.getByte(address++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(address, (int)(addressLimit - address));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
            void var3_3;
            void var1_1;
            void var2_2;
            String s = new String(bytes, index, size, Internal.UTF_8);
            if (s.indexOf(65533) < 0) {
                return s;
            }
            void v0 = var2_2;
            if (Arrays.equals(s.getBytes(Internal.UTF_8), Arrays.copyOfRange((byte[])var1_1, (int)v0, (int)(v0 + var3_3)))) {
                return s;
            }
            throw InvalidProtocolBufferException.invalidUtf8();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String decodeUtf8Direct(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            byte b;
            long address;
            if ((index | size | buffer.limit() - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index, size));
            }
            long addressLimit = address + (long)size;
            char[] resultArr = new char[size];
            int resultPos = 0;
            for (address = UnsafeUtil.addressOffset(buffer) + (long)index; address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.getByte(address)); ++address) {
                DecodeUtil.access$500(b, resultArr, resultPos++);
            }
            while (address < addressLimit) {
                void var3_3;
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.getByte(address++))) {
                    DecodeUtil.access$500(byte1, resultArr, resultPos++);
                    while (address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.getByte(address))) {
                        ++address;
                        DecodeUtil.access$500((byte)var3_3, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes((byte)var3_3)) {
                    if (address >= addressLimit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$700((byte)var3_3, UnsafeUtil.getByte(address++), resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes((byte)var3_3)) {
                    if (address >= addressLimit - 1L) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$900((byte)var3_3, UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), resultArr, resultPos++);
                    continue;
                }
                if (address >= addressLimit - 2L) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.access$1000((byte)var3_3, UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), resultArr, resultPos++);
                ++resultPos;
            }
            return new String((char[])var1_1, 0, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int encodeUtf8(String in, byte[] out, int offset, int length) {
            char c;
            int inIx;
            long outIx = offset;
            long outLimit = outIx + (long)length;
            int inLimit = in.length();
            if (inLimit > length || out.length - length < offset) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + (offset + length));
            }
            for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                UnsafeUtil.putByte(out, outIx++, (byte)c);
            }
            if (inIx == inLimit) {
                return (int)outIx;
            }
            while (inIx < inLimit) {
                c = in.charAt(inIx);
                if (c < '\u0080' && outIx < outLimit) {
                    UnsafeUtil.putByte(out, outIx++, (byte)c);
                } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
                } else if (outIx <= outLimit - 4L) {
                    char low;
                    if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx - 1, inLimit);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    UnsafeUtil.putByte(out, outIx++, (byte)(0xF0 | codePoint >>> 18));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint));
                } else {
                    void var4_4;
                    if (!(55296 > var4_4 || var4_4 > 57343 || inIx + 1 != inLimit && Character.isSurrogatePair((char)var4_4, in.charAt(inIx + 1)))) {
                        throw new UnpairedSurrogateException(inIx, inLimit);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + (char)var4_4 + " at index " + outIx);
                }
                ++inIx;
            }
            return (int)outIx;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void encodeUtf8Direct(String in, ByteBuffer out) {
            void var3_3;
            void var2_2;
            char c;
            int inIx;
            long address = UnsafeUtil.addressOffset(out);
            long outIx = address + (long)out.position();
            long outLimit = address + (long)out.limit();
            int inLimit = in.length();
            if ((long)inLimit > outLimit - outIx) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + out.limit());
            }
            for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                UnsafeUtil.putByte(outIx++, (byte)c);
            }
            if (inIx == inLimit) {
                Java8Compatibility.position(out, (int)(outIx - address));
                return;
            }
            while (inIx < inLimit) {
                c = in.charAt(inIx);
                if (c < '\u0080' && outIx < outLimit) {
                    UnsafeUtil.putByte(outIx++, (byte)c);
                } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                    UnsafeUtil.putByte(outIx++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                    UnsafeUtil.putByte(outIx++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
                } else if (outIx <= outLimit - 4L) {
                    char low;
                    if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx - 1, inLimit);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    UnsafeUtil.putByte(outIx++, (byte)(0xF0 | codePoint >>> 18));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint));
                } else {
                    void var11_8;
                    if (!(55296 > var11_8 || var11_8 > 57343 || inIx + 1 != inLimit && Character.isSurrogatePair((char)var11_8, in.charAt(inIx + 1)))) {
                        throw new UnpairedSurrogateException(inIx, inLimit);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + (char)var11_8 + " at index " + outIx);
                }
                ++inIx;
            }
            Java8Compatibility.position((Buffer)var2_2, (int)(outIx - var3_3));
        }

        /*
         * WARNING - void declaration
         */
        private static int unsafeEstimateConsecutiveAscii(byte[] bytes, long offset, int maxChars) {
            void var3_2;
            int i;
            if (maxChars < 16) {
                return 0;
            }
            int unaligned = 8 - ((int)offset & 7);
            for (i = 0; i < unaligned; ++i) {
                if (UnsafeUtil.getByte(bytes, offset++) >= 0) continue;
                return i;
            }
            while (i + 8 <= maxChars && (UnsafeUtil.getLong((Object)bytes, UnsafeUtil.BYTE_ARRAY_BASE_OFFSET + offset) & 0x8080808080808080L) == 0L) {
                offset += 8L;
                i += 8;
            }
            while (i < maxChars) {
                if (UnsafeUtil.getByte(bytes, offset++) < 0) {
                    return i;
                }
                ++i;
            }
            return (int)var3_2;
        }

        /*
         * WARNING - void declaration
         */
        private static int unsafeEstimateConsecutiveAscii(long address, int maxChars) {
            void var3_2;
            void var2_1;
            int unaligned;
            int remaining = maxChars;
            if (remaining < 16) {
                return 0;
            }
            for (int j = unaligned = (int)(-address & 7L); j > 0; --j) {
                if (UnsafeUtil.getByte(address++) >= 0) continue;
                return unaligned - j;
            }
            remaining -= unaligned;
            while (remaining >= 8 && (UnsafeUtil.getLong(address) & 0x8080808080808080L) == 0L) {
                address += 8L;
                remaining -= 8;
            }
            return (int)(var2_1 - var3_2);
        }

        private static int partialIsValidUtf8(byte[] bytes, long offset, int remaining) {
            int skipped = UnsafeProcessor.unsafeEstimateConsecutiveAscii(bytes, offset, remaining);
            remaining -= skipped;
            offset += (long)skipped;
            while (true) {
                byte byte2;
                int byte1 = 0;
                while (remaining > 0) {
                    byte by = UnsafeUtil.getByte(bytes, offset++);
                    byte1 = by;
                    if (by < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (byte1 < -32) {
                    if (remaining == 0) {
                        return byte1;
                    }
                    --remaining;
                    if (byte1 >= -62 && UnsafeUtil.getByte(bytes, offset++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(bytes, byte1, offset, remaining);
                    }
                    remaining -= 2;
                    if (!((byte2 = UnsafeUtil.getByte(bytes, offset++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && UnsafeUtil.getByte(bytes, offset++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(bytes, byte1, offset, remaining);
                }
                remaining -= 3;
                if ((byte2 = UnsafeUtil.getByte(bytes, offset++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || UnsafeUtil.getByte(bytes, offset++) > -65 || UnsafeUtil.getByte(bytes, offset++) > -65) break;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        private static int partialIsValidUtf8(long address, int remaining) {
            int skipped = UnsafeProcessor.unsafeEstimateConsecutiveAscii(address, remaining);
            address += (long)skipped;
            remaining -= skipped;
            while (true) {
                void var3_2;
                byte byte2;
                int byte1 = 0;
                while (remaining > 0) {
                    byte by = UnsafeUtil.getByte(address++);
                    byte1 = by;
                    if (by < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (byte1 < -32) {
                    if (remaining == 0) {
                        return byte1;
                    }
                    --remaining;
                    if (byte1 >= -62 && UnsafeUtil.getByte(address++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(address, byte1, remaining);
                    }
                    remaining -= 2;
                    if (!((byte2 = UnsafeUtil.getByte(address++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && UnsafeUtil.getByte(address++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(address, byte1, remaining);
                }
                remaining -= 3;
                if ((byte2 = UnsafeUtil.getByte(address++)) > -65 || (var3_2 << 28) + (byte2 - -112) >> 30 != false || UnsafeUtil.getByte(address++) > -65 || UnsafeUtil.getByte(address++) > -65) break;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        private static int unsafeIncompleteStateFor(byte[] bytes, int byte1, long offset, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.access$000(byte1, UnsafeUtil.getByte(bytes, offset));
                }
                case 2: {
                    void var2_2;
                    byte[] byArray;
                    void var1_1;
                    return Utf8.access$100((int)var1_1, UnsafeUtil.getByte(bytes, offset), UnsafeUtil.getByte(byArray, (long)(var2_2 + 1L)));
                }
            }
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        private static int unsafeIncompleteStateFor(long address, int byte1, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.access$000(byte1, UnsafeUtil.getByte(address));
                }
                case 2: {
                    long l;
                    void var2_1;
                    return Utf8.access$100((int)var2_1, UnsafeUtil.getByte(address), UnsafeUtil.getByte(l + 1L));
                }
            }
            throw new AssertionError();
        }
    }

    static final class SafeProcessor
    extends Processor {
        SafeProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
            void var3_3;
            void var2_2;
            if (state != 0) {
                if (index >= limit) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || bytes[index++] > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = bytes[index++];
                        if (index >= limit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || bytes[index++] > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = bytes[index++];
                        if (index >= limit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    } else {
                        void var1_1;
                        byte3 = (byte)(var1_1 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = bytes[index++];
                        if (index >= limit) {
                            return Utf8.access$100(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || bytes[index++] > -65) {
                        return -1;
                    }
                }
            }
            return SafeProcessor.partialIsValidUtf8((byte[])var2_2, (int)var3_3, limit);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int partialIsValidUtf8Direct(int state, ByteBuffer buffer, int index, int limit) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.partialIsValidUtf8Default((int)var1_1, (ByteBuffer)var2_2, (int)var3_3, limit);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
            void var3_4;
            byte b;
            int offset;
            if ((index | size | bytes.length - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes.length, index, size));
            }
            int limit = offset + size;
            char[] resultArr = new char[size];
            int resultPos = 0;
            for (offset = index; offset < limit && DecodeUtil.isOneByte(b = bytes[offset]); ++offset) {
                DecodeUtil.access$500(b, resultArr, resultPos++);
            }
            while (offset < limit) {
                void var6_7;
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = bytes[offset++])) {
                    DecodeUtil.access$500(byte1, resultArr, resultPos++);
                    while (offset < limit && DecodeUtil.isOneByte(b = bytes[offset])) {
                        ++offset;
                        DecodeUtil.access$500(b, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes((byte)var6_7)) {
                    if (offset >= limit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$700((byte)var6_7, bytes[offset++], resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes((byte)var6_7)) {
                    if (offset >= limit - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$900((byte)var6_7, bytes[offset++], bytes[offset++], resultArr, resultPos++);
                    continue;
                }
                if (offset >= limit - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.access$1000((byte)var6_7, bytes[offset++], bytes[offset++], bytes[offset++], resultArr, resultPos++);
                ++resultPos;
            }
            return new String((char[])var3_4, 0, resultPos);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String decodeUtf8Direct(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.decodeUtf8Default((ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int encodeUtf8(String in, byte[] out, int offset, int length) {
            char c;
            int i;
            int utf16Length = in.length();
            int j = offset;
            int limit = offset + length;
            for (i = 0; i < utf16Length && i + j < limit && (c = in.charAt(i)) < '\u0080'; ++i) {
                out[j + i] = (byte)c;
            }
            if (i == utf16Length) {
                return j + utf16Length;
            }
            j += i;
            while (i < utf16Length) {
                c = in.charAt(i);
                if (c < '\u0080' && j < limit) {
                    out[j++] = (byte)c;
                } else if (c < '\u0800' && j <= limit - 2) {
                    out[j++] = (byte)(0x3C0 | c >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & c);
                } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                    out[j++] = (byte)(0x1E0 | c >>> 12);
                    out[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & c);
                } else if (j <= limit - 4) {
                    char low;
                    if (i + 1 == in.length() || !Character.isSurrogatePair(c, low = in.charAt(++i))) {
                        throw new UnpairedSurrogateException(i - 1, utf16Length);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    out[j++] = (byte)(0xF0 | codePoint >>> 18);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint);
                } else {
                    void var4_4;
                    if (!(55296 > var4_4 || var4_4 > 57343 || i + 1 != in.length() && Character.isSurrogatePair((char)var4_4, in.charAt(i + 1)))) {
                        throw new UnpairedSurrogateException(i, utf16Length);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + (char)var4_4 + " at index " + j);
                }
                ++i;
            }
            return j;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void encodeUtf8Direct(String in, ByteBuffer out) {
            void var2_2;
            void var1_1;
            this.encodeUtf8Default((String)var1_1, (ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static int partialIsValidUtf8(byte[] bytes, int index, int limit) {
            void var2_2;
            void var1_1;
            byte[] byArray;
            while (index < limit && bytes[index] >= 0) {
                ++index;
            }
            if (index >= limit) {
                return 0;
            }
            return SafeProcessor.partialIsValidUtf8NonAscii(byArray, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static int partialIsValidUtf8NonAscii(byte[] bytes, int index, int limit) {
            while (true) {
                void var3_3;
                byte byte2;
                byte byte1;
                if (index >= limit) {
                    return 0;
                }
                if ((byte1 = bytes[index++]) >= 0) continue;
                if (byte1 < -32) {
                    if (index >= limit) {
                        return byte1;
                    }
                    if (byte1 >= -62 && bytes[index++] <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (index >= limit - 1) {
                        return Utf8.access$1100(bytes, index, limit);
                    }
                    if (!((byte2 = bytes[index++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && bytes[index++] <= -65) continue;
                    return -1;
                }
                if (index >= limit - 2) {
                    return Utf8.access$1100(bytes, index, limit);
                }
                if ((byte2 = bytes[index++]) > -65 || (var3_3 << 28) + (byte2 - -112) >> 30 != false || bytes[index++] > -65 || bytes[index++] > -65) break;
            }
            return -1;
        }
    }

    static abstract class Processor {
        Processor() {
        }

        /*
         * WARNING - void declaration
         */
        final boolean isValidUtf8(byte[] bytes, int index, int limit) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.partialIsValidUtf8(0, (byte[])var1_1, (int)var2_2, (int)var3_3) == 0;
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        /*
         * WARNING - void declaration
         */
        final boolean isValidUtf8(ByteBuffer buffer, int index, int limit) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.partialIsValidUtf8(0, (ByteBuffer)var1_1, (int)var2_2, (int)var3_3) == 0;
        }

        /*
         * WARNING - void declaration
         */
        final int partialIsValidUtf8(int state, ByteBuffer buffer, int index, int limit) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (buffer.hasArray()) {
                int offset = buffer.arrayOffset();
                return this.partialIsValidUtf8(state, buffer.array(), offset + index, offset + limit);
            }
            if (buffer.isDirect()) {
                return this.partialIsValidUtf8Direct(state, buffer, index, limit);
            }
            return this.partialIsValidUtf8Default((int)var1_1, (ByteBuffer)var2_2, (int)var3_3, limit);
        }

        abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

        /*
         * WARNING - void declaration
         */
        final int partialIsValidUtf8Default(int state, ByteBuffer buffer, int index, int limit) {
            void var3_3;
            void var2_2;
            if (state != 0) {
                if (index >= limit) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || buffer.get(index++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = buffer.get(index++);
                        if (index >= limit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || buffer.get(index++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = buffer.get(index++);
                        if (index >= limit) {
                            return Utf8.access$000(byte1, byte2);
                        }
                    } else {
                        void var1_1;
                        byte3 = (byte)(var1_1 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = buffer.get(index++);
                        if (index >= limit) {
                            return Utf8.access$100(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || buffer.get(index++) > -65) {
                        return -1;
                    }
                }
            }
            return Processor.partialIsValidUtf8((ByteBuffer)var2_2, (int)var3_3, limit);
        }

        /*
         * WARNING - void declaration
         */
        private static int partialIsValidUtf8(ByteBuffer buffer, int index, int limit) {
            index += Utf8.access$200(buffer, index, limit);
            while (true) {
                void var3_3;
                byte byte2;
                byte byte1;
                if (index >= limit) {
                    return 0;
                }
                if ((byte1 = buffer.get(index++)) >= 0) continue;
                if (byte1 < -32) {
                    if (index >= limit) {
                        return byte1;
                    }
                    if (byte1 < -62 || buffer.get(index) > -65) {
                        return -1;
                    }
                    ++index;
                    continue;
                }
                if (byte1 < -16) {
                    if (index >= limit - 1) {
                        return Utf8.access$300(buffer, byte1, index, limit - index);
                    }
                    if ((byte2 = buffer.get(index++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || buffer.get(index) > -65) {
                        return -1;
                    }
                    ++index;
                    continue;
                }
                if (index >= limit - 2) {
                    return Utf8.access$300(buffer, byte1, index, limit - index);
                }
                if ((byte2 = buffer.get(index++)) > -65 || (var3_3 << 28) + (byte2 - -112) >> 30 != false || buffer.get(index++) > -65 || buffer.get(index++) > -65) break;
            }
            return -1;
        }

        abstract String decodeUtf8(byte[] var1, int var2, int var3) throws InvalidProtocolBufferException;

        /*
         * WARNING - void declaration
         */
        final String decodeUtf8(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            void var3_3;
            void var2_2;
            void var1_1;
            if (buffer.hasArray()) {
                int offset = buffer.arrayOffset();
                return this.decodeUtf8(buffer.array(), offset + index, size);
            }
            if (buffer.isDirect()) {
                return this.decodeUtf8Direct(buffer, index, size);
            }
            return this.decodeUtf8Default((ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
        }

        abstract String decodeUtf8Direct(ByteBuffer var1, int var2, int var3) throws InvalidProtocolBufferException;

        /*
         * WARNING - void declaration
         */
        final String decodeUtf8Default(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            void var3_4;
            byte b;
            int offset;
            if ((index | size | buffer.limit() - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index, size));
            }
            int limit = offset + size;
            char[] resultArr = new char[size];
            int resultPos = 0;
            for (offset = index; offset < limit && DecodeUtil.isOneByte(b = buffer.get(offset)); ++offset) {
                DecodeUtil.access$500(b, resultArr, resultPos++);
            }
            while (offset < limit) {
                void var6_7;
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = buffer.get(offset++))) {
                    DecodeUtil.access$500(byte1, resultArr, resultPos++);
                    while (offset < limit && DecodeUtil.isOneByte(b = buffer.get(offset))) {
                        ++offset;
                        DecodeUtil.access$500(b, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes((byte)var6_7)) {
                    if (offset >= limit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$700((byte)var6_7, buffer.get(offset++), resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes((byte)var6_7)) {
                    if (offset >= limit - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$900((byte)var6_7, buffer.get(offset++), buffer.get(offset++), resultArr, resultPos++);
                    continue;
                }
                if (offset >= limit - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.access$1000((byte)var6_7, buffer.get(offset++), buffer.get(offset++), buffer.get(offset++), resultArr, resultPos++);
                ++resultPos;
            }
            return new String((char[])var3_4, 0, resultPos);
        }

        abstract int encodeUtf8(String var1, byte[] var2, int var3, int var4);

        /*
         * WARNING - void declaration
         */
        final void encodeUtf8(String in, ByteBuffer out) {
            void var2_3;
            void var1_1;
            if (out.hasArray()) {
                void var3_4;
                void var1_2;
                int offset = out.arrayOffset();
                int endIndex = Utf8.encode(in, out.array(), offset + out.position(), out.remaining());
                Java8Compatibility.position(out, (int)(var1_2 - var3_4));
                return;
            }
            if (out.isDirect()) {
                this.encodeUtf8Direct((String)var1_1, out);
                return;
            }
            this.encodeUtf8Default((String)var1_1, (ByteBuffer)var2_3);
        }

        abstract void encodeUtf8Direct(String var1, ByteBuffer var2);

        /*
         * WARNING - void declaration
         */
        final void encodeUtf8Default(String in, ByteBuffer out) {
            int inIx;
            int inLength = in.length();
            int outIx = out.position();
            try {
                char c;
                for (inIx = 0; inIx < inLength && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                    out.put(outIx + inIx, (byte)c);
                }
                if (inIx == inLength) {
                    Java8Compatibility.position(out, outIx + inIx);
                    return;
                }
                outIx += inIx;
                while (inIx < inLength) {
                    c = in.charAt(inIx);
                    if (c < '\u0080') {
                        out.put(outIx, (byte)c);
                    } else if (c < '\u0800') {
                        out.put(outIx++, (byte)(0xC0 | c >>> 6));
                        out.put(outIx, (byte)(0x80 | 0x3F & c));
                    } else if (c < '\ud800' || '\udfff' < c) {
                        out.put(outIx++, (byte)(0xE0 | c >>> 12));
                        out.put(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                        out.put(outIx, (byte)(0x80 | 0x3F & c));
                    } else {
                        char low;
                        if (inIx + 1 == inLength || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                            throw new UnpairedSurrogateException(inIx, inLength);
                        }
                        int codePoint = Character.toCodePoint(c, low);
                        out.put(outIx++, (byte)(0xF0 | codePoint >>> 18));
                        out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                        out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                        out.put(outIx, (byte)(0x80 | 0x3F & codePoint));
                    }
                    ++inIx;
                    ++outIx;
                }
                Java8Compatibility.position(out, outIx);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                void var1_1;
                void var2_2;
                int badWriteIndex = out.position() + Math.max(inIx, outIx - var2_2.position() + 1);
                throw new ArrayIndexOutOfBoundsException("Failed writing " + var1_1.charAt(inIx) + " at index " + badWriteIndex);
            }
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        /*
         * WARNING - void declaration
         */
        UnpairedSurrogateException(int index, int length) {
            super("Unpaired surrogate at index " + (int)var1_1 + " of " + (int)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

