/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Android;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final Class<?> MEMORY_CLASS = Android.getMemoryClass();
    private static final boolean IS_ANDROID_64 = UnsafeUtil.determineAndroidSupportByAddressSize(Long.TYPE);
    private static final boolean IS_ANDROID_32 = UnsafeUtil.determineAndroidSupportByAddressSize(Integer.TYPE);
    private static final MemoryAccessor MEMORY_ACCESSOR = UnsafeUtil.getMemoryAccessor();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    static final long BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    private static final long BOOLEAN_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(boolean[].class);
    private static final long BOOLEAN_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(boolean[].class);
    private static final long INT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(int[].class);
    private static final long INT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(int[].class);
    private static final long LONG_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(long[].class);
    private static final long LONG_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(long[].class);
    private static final long FLOAT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(float[].class);
    private static final long FLOAT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(float[].class);
    private static final long DOUBLE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(double[].class);
    private static final long DOUBLE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(double[].class);
    private static final long OBJECT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(Object[].class);
    private static final long OBJECT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(Object[].class);
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.bufferAddressField());
    private static final int STRIDE = 8;
    private static final int STRIDE_ALIGNMENT_MASK = 7;
    private static final int BYTE_ARRAY_ALIGNMENT = (int)(BYTE_ARRAY_BASE_OFFSET & 7L);
    static final boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static boolean isAndroid64() {
        return IS_ANDROID_64;
    }

    /*
     * WARNING - void declaration
     */
    static <T> T allocateInstance(Class<T> clazz) {
        try {
            return (T)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    static long objectFieldOffset(Field field) {
        Field field2;
        return MEMORY_ACCESSOR.objectFieldOffset(field2);
    }

    private static int arrayBaseOffset(Class<?> clazz) {
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            Class<?> clazz2;
            return MEMORY_ACCESSOR.arrayBaseOffset(clazz2);
        }
        return -1;
    }

    private static int arrayIndexScale(Class<?> clazz) {
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            Class<?> clazz2;
            return MEMORY_ACCESSOR.arrayIndexScale(clazz2);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    static byte getByte(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getByte(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putByte(Object target, long offset, byte value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putByte(object, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getInt(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putInt(Object target, long offset, int value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putInt(object, (long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static long getLong(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getLong(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putLong(Object target, long offset, long value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putLong(object, (long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static boolean getBoolean(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getBoolean(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putBoolean(Object target, long offset, boolean value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putBoolean(object, (long)var1_1, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static float getFloat(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getFloat(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putFloat(Object target, long offset, float value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putFloat(object, (long)var1_1, (float)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static double getDouble(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getDouble(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putDouble(Object target, long offset, double value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putDouble(object, (long)var1_1, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static Object getObject(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getObject(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putObject(Object target, long offset, Object value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putObject(object, (long)var1_1, var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static byte getByte(byte[] target, long index) {
        void var1_1;
        byte[] byArray;
        return MEMORY_ACCESSOR.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putByte(byte[] target, long index, byte value) {
        void var3_2;
        void var1_1;
        byte[] byArray;
        MEMORY_ACCESSOR.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(int[] target, long index) {
        void var1_1;
        int[] nArray;
        return MEMORY_ACCESSOR.getInt(nArray, INT_ARRAY_BASE_OFFSET + var1_1 * INT_ARRAY_INDEX_SCALE);
    }

    /*
     * WARNING - void declaration
     */
    static void putInt(int[] target, long index, int value) {
        void var3_2;
        void var1_1;
        int[] nArray;
        MEMORY_ACCESSOR.putInt(nArray, INT_ARRAY_BASE_OFFSET + var1_1 * INT_ARRAY_INDEX_SCALE, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static long getLong(long[] target, long index) {
        void var1_1;
        long[] lArray;
        return MEMORY_ACCESSOR.getLong(lArray, LONG_ARRAY_BASE_OFFSET + var1_1 * LONG_ARRAY_INDEX_SCALE);
    }

    /*
     * WARNING - void declaration
     */
    static void putLong(long[] target, long index, long value) {
        void var3_2;
        void var1_1;
        long[] lArray;
        MEMORY_ACCESSOR.putLong(lArray, LONG_ARRAY_BASE_OFFSET + var1_1 * LONG_ARRAY_INDEX_SCALE, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static boolean getBoolean(boolean[] target, long index) {
        void var1_1;
        boolean[] blArray;
        return MEMORY_ACCESSOR.getBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + var1_1 * BOOLEAN_ARRAY_INDEX_SCALE);
    }

    /*
     * WARNING - void declaration
     */
    static void putBoolean(boolean[] target, long index, boolean value) {
        void var3_2;
        void var1_1;
        boolean[] blArray;
        MEMORY_ACCESSOR.putBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + var1_1 * BOOLEAN_ARRAY_INDEX_SCALE, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static float getFloat(float[] target, long index) {
        void var1_1;
        float[] fArray;
        return MEMORY_ACCESSOR.getFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + var1_1 * FLOAT_ARRAY_INDEX_SCALE);
    }

    /*
     * WARNING - void declaration
     */
    static void putFloat(float[] target, long index, float value) {
        void var3_2;
        void var1_1;
        float[] fArray;
        MEMORY_ACCESSOR.putFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + var1_1 * FLOAT_ARRAY_INDEX_SCALE, (float)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static double getDouble(double[] target, long index) {
        void var1_1;
        double[] dArray;
        return MEMORY_ACCESSOR.getDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + var1_1 * DOUBLE_ARRAY_INDEX_SCALE);
    }

    /*
     * WARNING - void declaration
     */
    static void putDouble(double[] target, long index, double value) {
        void var3_2;
        void var1_1;
        double[] dArray;
        MEMORY_ACCESSOR.putDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + var1_1 * DOUBLE_ARRAY_INDEX_SCALE, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static Object getObject(Object[] target, long index) {
        void var1_1;
        Object[] objectArray;
        return MEMORY_ACCESSOR.getObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + var1_1 * OBJECT_ARRAY_INDEX_SCALE);
    }

    /*
     * WARNING - void declaration
     */
    static void putObject(Object[] target, long index, Object value) {
        void var3_2;
        void var1_1;
        Object[] objectArray;
        MEMORY_ACCESSOR.putObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + var1_1 * OBJECT_ARRAY_INDEX_SCALE, var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static void copyMemory(byte[] src, long srcIndex, long targetOffset, long length) {
        void var3_2;
        void var1_1;
        byte[] byArray;
        MEMORY_ACCESSOR.copyMemory(byArray, (long)var1_1, (long)var3_2, length);
    }

    /*
     * WARNING - void declaration
     */
    static void copyMemory(long srcOffset, byte[] target, long targetIndex, long length) {
        void var3_2;
        void var2_1;
        long l;
        MEMORY_ACCESSOR.copyMemory(l, (byte[])var2_1, (long)var3_2, length);
    }

    /*
     * WARNING - void declaration
     */
    static void copyMemory(byte[] src, long srcIndex, byte[] target, long targetIndex, long length) {
        void var3_2;
        void var1_1;
        System.arraycopy(src, (int)var1_1, var3_2, (int)targetIndex, (int)length);
    }

    static byte getByte(long address) {
        long l;
        return MEMORY_ACCESSOR.getByte(l);
    }

    /*
     * WARNING - void declaration
     */
    static void putByte(long address, byte value) {
        void var2_1;
        long l;
        MEMORY_ACCESSOR.putByte(l, (byte)var2_1);
    }

    static int getInt(long address) {
        long l;
        return MEMORY_ACCESSOR.getInt(l);
    }

    /*
     * WARNING - void declaration
     */
    static void putInt(long address, int value) {
        void var2_1;
        long l;
        MEMORY_ACCESSOR.putInt(l, (int)var2_1);
    }

    static long getLong(long address) {
        long l;
        return MEMORY_ACCESSOR.getLong(l);
    }

    /*
     * WARNING - void declaration
     */
    static void putLong(long address, long value) {
        void var2_1;
        long l;
        MEMORY_ACCESSOR.putLong(l, (long)var2_1);
    }

    static long addressOffset(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        return MEMORY_ACCESSOR.getLong(byteBuffer, BUFFER_ADDRESS_OFFSET);
    }

    static Object getStaticObject(Field field) {
        Field field2;
        return MEMORY_ACCESSOR.getStaticObject(field2);
    }

    /*
     * WARNING - void declaration
     */
    static Unsafe getUnsafe() {
        void var0;
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : Unsafe.class.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {}
        return var0;
    }

    private static MemoryAccessor getMemoryAccessor() {
        if (UNSAFE == null) {
            return null;
        }
        if (Android.isOnAndroidDevice()) {
            if (IS_ANDROID_64) {
                return new Android64MemoryAccessor(UNSAFE);
            }
            if (IS_ANDROID_32) {
                return new Android32MemoryAccessor(UNSAFE);
            }
            return null;
        }
        return new JvmMemoryAccessor(UNSAFE);
    }

    private static boolean supportsUnsafeArrayOperations() {
        if (MEMORY_ACCESSOR == null) {
            return false;
        }
        return MEMORY_ACCESSOR.supportsUnsafeArrayOperations();
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        if (MEMORY_ACCESSOR == null) {
            return false;
        }
        return MEMORY_ACCESSOR.supportsUnsafeByteBufferOperations();
    }

    /*
     * WARNING - void declaration
     */
    static boolean determineAndroidSupportByAddressSize(Class<?> addressClass) {
        if (!Android.isOnAndroidDevice()) {
            return false;
        }
        try {
            Class<?> clazz;
            void var1_1;
            Class<?> clazz2 = MEMORY_CLASS;
            clazz2.getMethod("peekLong", addressClass, Boolean.TYPE);
            clazz2.getMethod("pokeLong", addressClass, Long.TYPE, Boolean.TYPE);
            clazz2.getMethod("pokeInt", addressClass, Integer.TYPE, Boolean.TYPE);
            clazz2.getMethod("peekInt", addressClass, Boolean.TYPE);
            clazz2.getMethod("pokeByte", addressClass, Byte.TYPE);
            clazz2.getMethod("peekByte", addressClass);
            clazz2.getMethod("pokeByteArray", addressClass, byte[].class, Integer.TYPE, Integer.TYPE);
            var1_1.getMethod("peekByteArray", clazz, byte[].class, Integer.TYPE, Integer.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Field bufferAddressField() {
        Field field;
        if (Android.isOnAndroidDevice() && (field = UnsafeUtil.field(Buffer.class, "effectiveDirectAddress")) != null) {
            return field;
        }
        field = UnsafeUtil.field(Buffer.class, "address");
        if (field != null && field.getType() == Long.TYPE) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static int firstDifferingByteIndexNativeEndian(long left, long right) {
        void var2_2;
        long l;
        int n = IS_BIG_ENDIAN ? Long.numberOfLeadingZeros(left ^ right) : Long.numberOfTrailingZeros(l ^ var2_2);
        return n >> 3;
    }

    static int mismatch(byte[] left, int leftOff, byte[] right, int rightOff, int length) {
        if (leftOff < 0 || rightOff < 0 || length < 0 || leftOff + length > left.length || rightOff + length > right.length) {
            throw new IndexOutOfBoundsException();
        }
        int index = 0;
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            int leftAlignment = BYTE_ARRAY_ALIGNMENT + leftOff & 7;
            while (index < length && (leftAlignment & 7) != 0) {
                if (left[leftOff + index] != right[rightOff + index]) {
                    return index;
                }
                ++index;
                ++leftAlignment;
            }
            int strideLength = (length - index & 0xFFFFFFF8) + index;
            while (index < strideLength) {
                long rightLongWord;
                long leftLongWord = UnsafeUtil.getLong((Object)left, BYTE_ARRAY_BASE_OFFSET + (long)leftOff + (long)index);
                if (leftLongWord != (rightLongWord = UnsafeUtil.getLong((Object)right, BYTE_ARRAY_BASE_OFFSET + (long)rightOff + (long)index))) {
                    return index + UnsafeUtil.firstDifferingByteIndexNativeEndian(leftLongWord, rightLongWord);
                }
                index += 8;
            }
        }
        while (index < length) {
            if (left[leftOff + index] != right[rightOff + index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static long fieldOffset(Field field) {
        Field field2;
        if (field == null || MEMORY_ACCESSOR == null) {
            return -1L;
        }
        return MEMORY_ACCESSOR.objectFieldOffset(field2);
    }

    /*
     * WARNING - void declaration
     */
    private static Field field(Class<?> clazz, String fieldName) {
        AnnotatedElement annotatedElement;
        AnnotatedElement field;
        try {
            void var1_1;
            field = clazz.getDeclaredField((String)var1_1);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return annotatedElement;
    }

    /*
     * WARNING - void declaration
     */
    private static byte getByteBigEndian(Object target, long offset) {
        void var1_1;
        return (byte)(UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL) >>> (int)(((var1_1 ^ 0xFFFFFFFFFFFFFFFFL) & 3L) << 3));
    }

    /*
     * WARNING - void declaration
     */
    private static byte getByteLittleEndian(Object target, long offset) {
        void var1_1;
        return (byte)(UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL) >>> (int)((var1_1 & 3L) << 3));
    }

    /*
     * WARNING - void declaration
     */
    private static void putByteBigEndian(Object target, long offset, byte value) {
        void var3_2;
        void var1_1;
        Object object;
        int intValue = UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL);
        int shift = (~((int)offset) & 3) << 3;
        int output = intValue & ~(255 << shift) | (0xFF & value) << shift;
        UnsafeUtil.putInt(object, (long)(var1_1 & 0xFFFFFFFFFFFFFFFCL), (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void putByteLittleEndian(Object target, long offset, byte value) {
        void var3_2;
        void var1_1;
        Object object;
        int intValue = UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL);
        int shift = ((int)offset & 3) << 3;
        int output = intValue & ~(255 << shift) | (0xFF & value) << shift;
        UnsafeUtil.putInt(object, (long)(var1_1 & 0xFFFFFFFFFFFFFFFCL), (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getBooleanBigEndian(Object target, long offset) {
        void var1_1;
        return UnsafeUtil.getByteBigEndian(target, (long)var1_1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getBooleanLittleEndian(Object target, long offset) {
        void var1_1;
        return UnsafeUtil.getByteLittleEndian(target, (long)var1_1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private static void putBooleanBigEndian(Object target, long offset, boolean value) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putByteBigEndian(target, (long)var1_1, (byte)(var3_2 != false ? 1 : 0));
    }

    /*
     * WARNING - void declaration
     */
    private static void putBooleanLittleEndian(Object target, long offset, boolean value) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putByteLittleEndian(target, (long)var1_1, (byte)(var3_2 != false ? 1 : 0));
    }

    private static void logMissingMethod(Throwable e) {
        Throwable throwable;
        Logger.getLogger(UnsafeUtil.class.getName()).log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte access$200(Object x0, long x1) {
        void var1_1;
        return UnsafeUtil.getByteBigEndian(x0, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte access$300(Object x0, long x1) {
        void var1_1;
        return UnsafeUtil.getByteLittleEndian(x0, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(Object x0, long x1, byte x2) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putByteBigEndian(x0, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(Object x0, long x1, byte x2) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putByteLittleEndian(x0, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$600(Object x0, long x1) {
        void var1_1;
        return UnsafeUtil.getBooleanBigEndian(x0, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$700(Object x0, long x1) {
        void var1_1;
        return UnsafeUtil.getBooleanLittleEndian(x0, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(Object x0, long x1, boolean x2) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putBooleanBigEndian(x0, (long)var1_1, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(Object x0, long x1, boolean x2) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putBooleanLittleEndian(x0, (long)var1_1, (boolean)var3_2);
    }

    private static final class Android32MemoryAccessor
    extends MemoryAccessor {
        private static final long SMALL_ADDRESS_MASK = -1L;

        private static int smallAddress(long address) {
            long l;
            return (int)(0xFFFFFFFFFFFFFFFFL & l);
        }

        /*
         * WARNING - void declaration
         */
        Android32MemoryAccessor(Unsafe unsafe) {
            super((Unsafe)var1_1);
            void var1_1;
        }

        @Override
        public final Object getStaticObject(Field field) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$200(target, offset);
            }
            return UnsafeUtil.access$300(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putByte(Object target, long offset, byte value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$400(target, offset, value);
                return;
            }
            UnsafeUtil.access$500(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getBoolean(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$600(target, offset);
            }
            return UnsafeUtil.access$700(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putBoolean(Object target, long offset, boolean value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$800(target, offset, value);
                return;
            }
            UnsafeUtil.access$900(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final float getFloat(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Float.intBitsToFloat(this.getInt(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putFloat(Object target, long offset, float value) {
            void var2_2;
            void var1_1;
            this.putInt(var1_1, (long)var2_2, Float.floatToIntBits(value));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double getDouble(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Double.longBitsToDouble(this.getLong(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putDouble(Object target, long offset, double value) {
            void var2_2;
            void var1_1;
            this.putLong(var1_1, (long)var2_2, Double.doubleToLongBits(value));
        }

        @Override
        public final boolean supportsUnsafeByteBufferOperations() {
            return false;
        }

        @Override
        public final byte getByte(long address) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putByte(long address, byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int getInt(long address) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putInt(long address, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final long getLong(long address) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putLong(long address, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyMemory(long srcOffset, byte[] target, long targetIndex, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyMemory(byte[] src, long srcIndex, long targetOffset, long length) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Android64MemoryAccessor
    extends MemoryAccessor {
        /*
         * WARNING - void declaration
         */
        Android64MemoryAccessor(Unsafe unsafe) {
            super((Unsafe)var1_1);
            void var1_1;
        }

        @Override
        public final Object getStaticObject(Field field) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$200(target, offset);
            }
            return UnsafeUtil.access$300(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putByte(Object target, long offset, byte value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$400(target, offset, value);
                return;
            }
            UnsafeUtil.access$500(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getBoolean(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$600(target, offset);
            }
            return UnsafeUtil.access$700(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putBoolean(Object target, long offset, boolean value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$800(target, offset, value);
                return;
            }
            UnsafeUtil.access$900(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final float getFloat(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Float.intBitsToFloat(this.getInt(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putFloat(Object target, long offset, float value) {
            void var2_2;
            void var1_1;
            this.putInt(var1_1, (long)var2_2, Float.floatToIntBits(value));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double getDouble(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Double.longBitsToDouble(this.getLong(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putDouble(Object target, long offset, double value) {
            void var2_2;
            void var1_1;
            this.putLong(var1_1, (long)var2_2, Double.doubleToLongBits(value));
        }

        @Override
        public final boolean supportsUnsafeByteBufferOperations() {
            return false;
        }

        @Override
        public final byte getByte(long address) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putByte(long address, byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int getInt(long address) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putInt(long address, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final long getLong(long address) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putLong(long address, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyMemory(long srcOffset, byte[] target, long targetIndex, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyMemory(byte[] src, long srcIndex, long targetOffset, long length) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class JvmMemoryAccessor
    extends MemoryAccessor {
        /*
         * WARNING - void declaration
         */
        JvmMemoryAccessor(Unsafe unsafe) {
            super((Unsafe)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object getStaticObject(Field field) {
            void var1_1;
            JvmMemoryAccessor jvmMemoryAccessor = this;
            return jvmMemoryAccessor.getObject(jvmMemoryAccessor.unsafe.staticFieldBase(field), this.unsafe.staticFieldOffset((Field)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean supportsUnsafeArrayOperations() {
            if (!super.supportsUnsafeArrayOperations()) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("getByte", Object.class, Long.TYPE);
                clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                clazz.getMethod("getBoolean", Object.class, Long.TYPE);
                clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                clazz.getMethod("getFloat", Object.class, Long.TYPE);
                clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
                clazz.getMethod("getDouble", Object.class, Long.TYPE);
                var1_1.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
                return true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getByte(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putByte(Object target, long offset, byte value) {
            void var2_2;
            void var1_1;
            this.unsafe.putByte(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getBoolean(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getBoolean(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putBoolean(Object target, long offset, boolean value) {
            void var2_2;
            void var1_1;
            this.unsafe.putBoolean(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final float getFloat(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getFloat(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putFloat(Object target, long offset, float value) {
            void var2_2;
            void var1_1;
            this.unsafe.putFloat(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double getDouble(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getDouble(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putDouble(Object target, long offset, double value) {
            void var2_2;
            void var1_1;
            this.unsafe.putDouble(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean supportsUnsafeByteBufferOperations() {
            if (!super.supportsUnsafeByteBufferOperations()) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("getByte", Long.TYPE);
                clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
                clazz.getMethod("getInt", Long.TYPE);
                clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
                clazz.getMethod("getLong", Long.TYPE);
                clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
                clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
                var1_1.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                return true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(long address) {
            void var1_1;
            return this.unsafe.getByte((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putByte(long address, byte value) {
            void var3_2;
            void var1_1;
            this.unsafe.putByte((long)var1_1, (byte)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getInt(long address) {
            void var1_1;
            return this.unsafe.getInt((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putInt(long address, int value) {
            void var3_2;
            void var1_1;
            this.unsafe.putInt((long)var1_1, (int)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long getLong(long address) {
            void var1_1;
            return this.unsafe.getLong((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putLong(long address, long value) {
            void var3_2;
            void var1_1;
            this.unsafe.putLong((long)var1_1, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void copyMemory(long srcOffset, byte[] target, long targetIndex, long length) {
            void var3_2;
            void var1_1;
            this.unsafe.copyMemory(null, (long)var1_1, var3_2, BYTE_ARRAY_BASE_OFFSET + targetIndex, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void copyMemory(byte[] src, long srcIndex, long targetOffset, long length) {
            void var2_2;
            void var1_1;
            this.unsafe.copyMemory(var1_1, BYTE_ARRAY_BASE_OFFSET + var2_2, null, targetOffset, length);
        }
    }

    private static abstract class MemoryAccessor {
        Unsafe unsafe;

        /*
         * WARNING - void declaration
         */
        MemoryAccessor(Unsafe unsafe) {
            void var1_1;
            this.unsafe = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final long objectFieldOffset(Field field) {
            void var1_1;
            return this.unsafe.objectFieldOffset((Field)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final int arrayBaseOffset(Class<?> clazz) {
            void var1_1;
            return this.unsafe.arrayBaseOffset((Class<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final int arrayIndexScale(Class<?> clazz) {
            void var1_1;
            return this.unsafe.arrayIndexScale((Class<?>)var1_1);
        }

        public abstract Object getStaticObject(Field var1);

        /*
         * WARNING - void declaration
         */
        public boolean supportsUnsafeArrayOperations() {
            if (this.unsafe == null) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("objectFieldOffset", Field.class);
                clazz.getMethod("arrayBaseOffset", Class.class);
                clazz.getMethod("arrayIndexScale", Class.class);
                clazz.getMethod("getInt", Object.class, Long.TYPE);
                clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                clazz.getMethod("getLong", Object.class, Long.TYPE);
                clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                clazz.getMethod("getObject", Object.class, Long.TYPE);
                var1_1.getMethod("putObject", Object.class, Long.TYPE, Object.class);
                return true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }

        public abstract byte getByte(Object var1, long var2);

        public abstract void putByte(Object var1, long var2, byte var4);

        /*
         * WARNING - void declaration
         */
        public final int getInt(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getInt(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void putInt(Object target, long offset, int value) {
            void var2_2;
            void var1_1;
            this.unsafe.putInt(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        public final long getLong(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getLong(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void putLong(Object target, long offset, long value) {
            void var2_2;
            void var1_1;
            this.unsafe.putLong(var1_1, (long)var2_2, value);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract float getFloat(Object var1, long var2);

        public abstract void putFloat(Object var1, long var2, float var4);

        public abstract double getDouble(Object var1, long var2);

        public abstract void putDouble(Object var1, long var2, double var4);

        /*
         * WARNING - void declaration
         */
        public final Object getObject(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getObject(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void putObject(Object target, long offset, Object value) {
            void var2_2;
            void var1_1;
            this.unsafe.putObject(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        public boolean supportsUnsafeByteBufferOperations() {
            if (this.unsafe == null) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("objectFieldOffset", Field.class);
                var1_1.getMethod("getLong", Object.class, Long.TYPE);
                return UnsafeUtil.bufferAddressField() != null;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }

        public abstract byte getByte(long var1);

        public abstract void putByte(long var1, byte var3);

        public abstract int getInt(long var1);

        public abstract void putInt(long var1, int var3);

        public abstract long getLong(long var1);

        public abstract void putLong(long var1, long var3);

        public abstract void copyMemory(long var1, byte[] var3, long var4, long var6);

        public abstract void copyMemory(byte[] var1, long var2, long var4, long var6);
    }
}

