/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.MessageLiteToString;
import androidx.datastore.preferences.protobuf.WireFormat;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;

public final class UnknownFieldSetLite {
    private static final int MIN_CAPACITY = 8;
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    static UnknownFieldSetLite newInstance() {
        return new UnknownFieldSetLite();
    }

    /*
     * WARNING - void declaration
     */
    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite first, UnknownFieldSetLite second) {
        void var3_3;
        void var2_2;
        void var1_1;
        UnknownFieldSetLite unknownFieldSetLite;
        int count = first.count + second.count;
        int[] tags = Arrays.copyOf(first.tags, count);
        System.arraycopy(second.tags, 0, tags, first.count, second.count);
        Object[] objects = Arrays.copyOf(first.objects, count);
        System.arraycopy(second.objects, 0, objects, unknownFieldSetLite.count, var1_1.count);
        return new UnknownFieldSetLite((int)var2_2, (int[])var3_3, objects, true);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    /*
     * WARNING - void declaration
     */
    private UnknownFieldSetLite(int count, int[] tags, Object[] objects, boolean isMutable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.count = var1_1;
        this.tags = var2_2;
        this.objects = var3_3;
        this.isMutable = isMutable;
    }

    public final void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    final void checkMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(CodedOutputStream output) throws IOException {
        block7: for (int i = 0; i < this.count; ++i) {
            void var3_3;
            int tag = this.tags[i];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType((int)var3_3)) {
                case 0: {
                    output.writeUInt64(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 5: {
                    output.writeFixed32(fieldNumber, (Integer)this.objects[i]);
                    continue block7;
                }
                case 1: {
                    output.writeFixed64(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 2: {
                    output.writeBytes(fieldNumber, (ByteString)this.objects[i]);
                    continue block7;
                }
                case 3: {
                    output.writeTag(fieldNumber, 3);
                    ((UnknownFieldSetLite)this.objects[i]).writeTo(output);
                    output.writeTag(fieldNumber, 4);
                    continue block7;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeAsMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.count; ++i) {
            void var3_3;
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i]);
            output.writeRawMessageSetExtension((int)var3_3, (ByteString)this.objects[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void writeAsMessageSetTo(Writer writer) throws IOException {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (int i = this.count - 1; i >= 0; --i) {
                int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i]);
                writer.writeMessageSetItem(fieldNumber, this.objects[i]);
            }
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            void var3_5;
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i]);
            writer.writeMessageSetItem((int)var3_5, this.objects[i]);
        }
    }

    public final void writeTo(Writer writer) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
            for (int i = 0; i < this.count; ++i) {
                UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
            }
            return;
        }
        for (int i = this.count - 1; i >= 0; --i) {
            UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeField(int tag, Object object, Writer writer) throws IOException {
        int n;
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                writer.writeInt64(fieldNumber, (Long)object);
                return;
            }
            case 5: {
                writer.writeFixed32(fieldNumber, (Integer)object);
                return;
            }
            case 1: {
                writer.writeFixed64(fieldNumber, (Long)object);
                return;
            }
            case 2: {
                writer.writeBytes(fieldNumber, (ByteString)object);
                return;
            }
            case 3: {
                void var3_3;
                void var2_2;
                void var1_1;
                if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                    writer.writeStartGroup(fieldNumber);
                    ((UnknownFieldSetLite)object).writeTo(writer);
                    writer.writeEndGroup(fieldNumber);
                    return;
                }
                writer.writeEndGroup(fieldNumber);
                ((UnknownFieldSetLite)var1_1).writeTo(writer);
                var2_2.writeStartGroup((int)var3_3);
                return;
            }
        }
        throw new RuntimeException(InvalidProtocolBufferException.invalidWireType());
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSizeAsMessageSet() {
        void var1_1;
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i = 0; i < this.count; ++i) {
            int n = this.tags[i];
            int fieldNumber = WireFormat.getTagFieldNumber(n);
            size += CodedOutputStream.computeRawMessageSetExtensionSize(n, (ByteString)this.objects[i]);
        }
        this.memoizedSerializedSize = size;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSize() {
        void var1_1;
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        block7: for (int i = 0; i < this.count; ++i) {
            void var3_3;
            int tag = this.tags[i];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType((int)var3_3)) {
                case 0: {
                    size += CodedOutputStream.computeUInt64Size(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 5: {
                    size += CodedOutputStream.computeFixed32Size(fieldNumber, (Integer)this.objects[i]);
                    continue block7;
                }
                case 1: {
                    size += CodedOutputStream.computeFixed64Size(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 2: {
                    size += CodedOutputStream.computeBytesSize(fieldNumber, (ByteString)this.objects[i]);
                    continue block7;
                }
                case 3: {
                    size += (CodedOutputStream.computeTagSize(fieldNumber) << 1) + ((UnknownFieldSetLite)this.objects[i]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = size;
        return (int)var1_1;
    }

    private static boolean tagsEquals(int[] tags1, int[] tags2, int count) {
        for (int i = 0; i < count; ++i) {
            if (tags1[i] == tags2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean objectsEquals(Object[] objects1, Object[] objects2, int count) {
        for (int i = 0; i < count; ++i) {
            if (objects1[i].equals(objects2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownFieldSetLite)) {
            return false;
        }
        UnknownFieldSetLite other = (UnknownFieldSetLite)obj;
        return this.count == other.count && UnknownFieldSetLite.tagsEquals(this.tags, other.tags, this.count) && UnknownFieldSetLite.objectsEquals(this.objects, var1_1.objects, this.count);
    }

    /*
     * WARNING - void declaration
     */
    private static int hashCode(int[] tags, int count) {
        void var2_2;
        int hashCode = 17;
        for (int i = 0; i < count; ++i) {
            hashCode = hashCode * 31 + tags[i];
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int hashCode(Object[] objects, int count) {
        void var2_2;
        int hashCode = 17;
        for (int i = 0; i < count; ++i) {
            hashCode = hashCode * 31 + objects[i].hashCode();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int hashCode = 527 + this.count;
        hashCode = hashCode * 31 + UnknownFieldSetLite.hashCode(this.tags, this.count);
        var1_1 = var1_1 * 31 + UnknownFieldSetLite.hashCode(this.objects, this.count);
        return (int)var1_1;
    }

    final void printWithIndent(StringBuilder buffer, int indent) {
        for (int i = 0; i < this.count; ++i) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i]);
            MessageLiteToString.printField(buffer, indent, String.valueOf(fieldNumber), this.objects[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void storeField(int tag, Object value) {
        void var2_2;
        void var1_1;
        this.checkMutable();
        UnknownFieldSetLite unknownFieldSetLite = this;
        unknownFieldSetLite.ensureCapacity(unknownFieldSetLite.count + 1);
        this.tags[this.count] = var1_1;
        this.objects[this.count] = var2_2;
        ++this.count;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.tags.length) {
            void var2_2;
            int newCapacity = this.count + this.count / 2;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = var1_1;
            }
            if (newCapacity < 8) {
                newCapacity = 8;
            }
            this.tags = Arrays.copyOf(this.tags, newCapacity);
            this.objects = Arrays.copyOf(this.objects, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
        this.checkMutable();
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.storeField(tag, input.readInt64());
                return true;
            }
            case 5: {
                this.storeField(tag, input.readFixed32());
                return true;
            }
            case 1: {
                this.storeField(tag, input.readFixed64());
                return true;
            }
            case 2: {
                this.storeField(tag, input.readBytes());
                return true;
            }
            case 3: {
                void var1_1;
                void var3_3;
                void var2_2;
                UnknownFieldSetLite subFieldSet = new UnknownFieldSetLite();
                subFieldSet.mergeFrom(input);
                var2_2.checkLastTagWas(WireFormat.makeTag((int)var3_3, 4));
                this.storeField((int)var1_1, subFieldSet);
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    /*
     * WARNING - void declaration
     */
    final UnknownFieldSetLite mergeVarintField(int fieldNumber, int value) {
        void var2_2;
        void var1_1;
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag((int)var1_1, 0), (long)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    final UnknownFieldSetLite mergeLengthDelimitedField(int fieldNumber, ByteString value) {
        void var2_2;
        void var1_1;
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag((int)var1_1, 2), var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private UnknownFieldSetLite mergeFrom(CodedInputStream input) throws IOException {
        void var2_2;
        int tag;
        while ((tag = input.readTag()) != 0 && this.mergeFieldFrom((int)var2_2, input)) {
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    final UnknownFieldSetLite mergeFrom(UnknownFieldSetLite other) {
        void var2_2;
        void var1_1;
        if (other.equals(UnknownFieldSetLite.getDefaultInstance())) {
            return this;
        }
        this.checkMutable();
        int newCount = this.count + other.count;
        this.ensureCapacity(newCount);
        System.arraycopy(other.tags, 0, this.tags, this.count, other.count);
        System.arraycopy(other.objects, 0, this.objects, this.count, var1_1.count);
        this.count = var2_2;
        return this;
    }
}

