/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.ExtensionSchema;
import androidx.datastore.preferences.protobuf.FieldInfo;
import androidx.datastore.preferences.protobuf.FieldSet;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.IntArrayList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyFieldLite;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.LongArrayList;
import androidx.datastore.preferences.protobuf.MapFieldSchema;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.UnknownFieldSchema;
import androidx.datastore.preferences.protobuf.UnknownFieldSetLiteSchema;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

@CheckReturnValue
final class SchemaUtil {
    private static final Class<?> GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_FULL_SCHEMA = SchemaUtil.getUnknownFieldSetSchema();
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_LITE_SCHEMA = new UnknownFieldSetLiteSchema();
    private static final int DEFAULT_LOOK_UP_START_NUMBER = 40;

    private SchemaUtil() {
    }

    public static void requireGeneratedMessage(Class<?> messageType) {
        Class<?> clazz;
        if (!(GeneratedMessageLite.class.isAssignableFrom(messageType) || Protobuf.assumeLiteRuntime || GENERATED_MESSAGE_CLASS == null || GENERATED_MESSAGE_CLASS.isAssignableFrom(clazz))) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessage or GeneratedMessageLite");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDouble(int fieldNumber, double value, Writer writer) throws IOException {
        if (Double.doubleToRawLongBits(value) != 0L) {
            void var1_1;
            int n;
            void var3_2;
            var3_2.writeDouble(n, (double)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFloat(int fieldNumber, float value, Writer writer) throws IOException {
        if (Float.floatToRawIntBits(value) != 0) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFloat(n, (float)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeInt64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            void var1_1;
            int n;
            void var3_2;
            var3_2.writeInt64(n, (long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUInt64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            void var1_1;
            int n;
            void var3_2;
            var3_2.writeUInt64(n, (long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSInt64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            void var1_1;
            int n;
            void var3_2;
            var3_2.writeSInt64(n, (long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFixed64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            void var1_1;
            int n;
            void var3_2;
            var3_2.writeFixed64(n, (long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSFixed64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            void var1_1;
            int n;
            void var3_2;
            var3_2.writeSFixed64(n, (long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeInt32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeInt32(n, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUInt32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeUInt32(n, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSInt32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSInt32(n, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFixed32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFixed32(n, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSFixed32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSFixed32(n, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeEnum(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeEnum(n, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBool(int fieldNumber, boolean value, Writer writer) throws IOException {
        if (value) {
            int n;
            void var2_2;
            var2_2.writeBool(n, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeString(int fieldNumber, Object value, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        int n;
        if (value instanceof String) {
            SchemaUtil.writeStringInternal(fieldNumber, (String)value, writer);
            return;
        }
        SchemaUtil.writeBytes(n, (ByteString)var1_1, (Writer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeStringInternal(int fieldNumber, String value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeString(n, (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBytes(int fieldNumber, ByteString value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeBytes(n, (ByteString)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeMessage(int fieldNumber, Object value, Writer writer) throws IOException {
        if (value != null) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeMessage(n, var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDoubleList(int fieldNumber, List<Double> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeDoubleList(n, (List<Double>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFloatList(int fieldNumber, List<Float> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFloatList(n, (List<Float>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeInt64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeUInt64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSInt64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFixed64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFixed64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSFixed64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSFixed64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeInt32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeUInt32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSInt32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFixed32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFixed32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSFixed32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSFixed32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeEnumList(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeEnumList(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBoolList(int fieldNumber, List<Boolean> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeBoolList(n, (List<Boolean>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStringList(int fieldNumber, List<String> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeStringList(n, (List<String>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBytesList(int fieldNumber, List<ByteString> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeBytesList(n, (List<ByteString>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeMessageList(int fieldNumber, List<?> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeMessageList(n, (List<?>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeMessageList(int fieldNumber, List<?> value, Writer writer, Schema schema) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeMessageList(n, (List<?>)var1_1, (Schema)var3_3);
        }
    }

    public static void writeLazyFieldList(int fieldNumber, List<?> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                ((LazyFieldLite)e).writeTo(writer, fieldNumber);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeGroupList(int fieldNumber, List<?> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeGroupList(n, (List<?>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeGroupList(int fieldNumber, List<?> value, Writer writer, Schema schema) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeGroupList(n, (List<?>)var1_1, (Schema)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt64ListNoTag(List<Long> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Long> list2;
                size += CodedOutputStream.computeInt64SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n;
        void var1_1;
        void var2_2;
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeInt64ListNoTag(list);
        if (var2_2 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return n2 + var1_1.size() * CodedOutputStream.computeTagSize(n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt64ListNoTag(List<Long> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Long> list2;
                size += CodedOutputStream.computeUInt64SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n;
        void var3_4;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeUInt64ListNoTag(list);
        if (var2_3 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return (int)(var1_2 + var3_4 * CodedOutputStream.computeTagSize(n));
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt64ListNoTag(List<Long> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Long> list2;
                size += CodedOutputStream.computeSInt64SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n;
        void var3_4;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeSInt64ListNoTag(list);
        if (var2_3 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return (int)(var1_2 + var3_4 * CodedOutputStream.computeTagSize(n));
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeEnumListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeEnumSizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeEnumSizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeEnumList(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var3_4;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeEnumListNoTag(list);
        if (var2_3 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return (int)(var1_2 + var3_4 * CodedOutputStream.computeTagSize(n));
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt32ListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeInt32SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var3_4;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeInt32ListNoTag(list);
        if (var2_3 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return (int)(var1_2 + var3_4 * CodedOutputStream.computeTagSize(n));
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt32ListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeUInt32SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var3_4;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeUInt32ListNoTag(list);
        if (var2_3 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return (int)(var1_2 + var3_4 * CodedOutputStream.computeTagSize(n));
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt32ListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeSInt32SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var3_4;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = SchemaUtil.computeSizeSInt32ListNoTag(list);
        if (var2_3 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(size);
        }
        return (int)(var1_2 + var3_4 * CodedOutputStream.computeTagSize(n));
    }

    static int computeSizeFixed32ListNoTag(List<?> list) {
        return list.size() << 2;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeFixed32List(int fieldNumber, List<?> list, boolean packed) {
        int n;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        if (var2_3 != false) {
            int dataSize = length << 2;
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize((int)var1_2);
        }
        return (int)(var1_2 * CodedOutputStream.computeFixed32Size(n, 0));
    }

    static int computeSizeFixed64ListNoTag(List<?> list) {
        return list.size() << 3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeFixed64List(int fieldNumber, List<?> list, boolean packed) {
        int n;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        if (var2_3 != false) {
            int dataSize = length << 3;
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize((int)var1_2);
        }
        return (int)(var1_2 * CodedOutputStream.computeFixed64Size(n, 0L));
    }

    static int computeSizeBoolListNoTag(List<?> list) {
        return list.size();
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeBoolList(int fieldNumber, List<?> list, boolean packed) {
        int n;
        void var1_2;
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        if (var2_3 != false) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(length);
        }
        return (int)(var1_2 * CodedOutputStream.computeBoolSize(n, true));
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeStringList(int fieldNumber, List<?> list) {
        int n;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        if (list instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)list;
            for (int i = 0; i < length; ++i) {
                Object value = lazyList.getRaw(i);
                if (value instanceof ByteString) {
                    size += CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                    continue;
                }
                size += CodedOutputStream.computeStringSizeNoTag((String)var1_1);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object value = var1_1.get(i);
                if (value instanceof ByteString) {
                    size += CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                    continue;
                }
                size += CodedOutputStream.computeStringSizeNoTag((String)value);
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeMessage(int fieldNumber, Object value, Schema schema) {
        void var2_2;
        void var1_1;
        int n;
        if (value instanceof LazyFieldLite) {
            return CodedOutputStream.computeLazyFieldSize(fieldNumber, (LazyFieldLite)value);
        }
        return CodedOutputStream.computeMessageSize(n, (MessageLite)var1_1, (Schema)var2_2);
    }

    static int computeSizeMessageList(int fieldNumber, List<?> list) {
        int n;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < length; ++i) {
            Object value = list.get(i);
            if (value instanceof LazyFieldLite) {
                size += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)value);
                continue;
            }
            size += CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
        }
        return n;
    }

    static int computeSizeMessageList(int fieldNumber, List<?> list, Schema schema) {
        int n;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < length; ++i) {
            Object value = list.get(i);
            if (value instanceof LazyFieldLite) {
                size += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)value);
                continue;
            }
            size += CodedOutputStream.computeMessageSizeNoTag((MessageLite)value, schema);
        }
        return n;
    }

    static int computeSizeByteStringList(int fieldNumber, List<ByteString> list) {
        int n;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < list.size(); ++i) {
            size += CodedOutputStream.computeBytesSizeNoTag(list.get(i));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeGroupList(int fieldNumber, List<MessageLite> list) {
        void var3_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < length; ++i) {
            size += CodedOutputStream.computeGroupSize(fieldNumber, list.get(i));
        }
        return (int)var3_3;
    }

    static int computeSizeGroupList(int fieldNumber, List<MessageLite> list, Schema schema) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < length; ++i) {
            size += CodedOutputStream.computeGroupSize(fieldNumber, list.get(i), schema);
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean shouldUseTableSwitch(FieldInfo[] fields) {
        FieldInfo[] fieldInfoArray;
        void var2_2;
        void var1_1;
        if (fields.length == 0) {
            return false;
        }
        int lo = fields[0].getFieldNumber();
        int hi = fields[fields.length - 1].getFieldNumber();
        return SchemaUtil.shouldUseTableSwitch((int)var1_1, (int)var2_2, fieldInfoArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean shouldUseTableSwitch(int lo, int hi, int numFields) {
        void var3_3;
        void var2_2;
        int n;
        void var1_1;
        if (hi < 40) {
            return true;
        }
        long tableSpaceCost = (long)var1_1 - (long)n + 1L;
        long lookupSpaceCost = 3L + 2L * (long)numFields;
        long lookupTimeCost = 3L + (long)var2_2;
        return var3_3 + 9L <= lookupSpaceCost + 3L * lookupTimeCost;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetFullSchema() {
        return UNKNOWN_FIELD_SET_FULL_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    /*
     * WARNING - void declaration
     */
    private static UnknownFieldSchema<?, ?> getUnknownFieldSetSchema() {
        try {
            void var0;
            Class<?> clz = SchemaUtil.getUnknownFieldSetSchemaClass();
            if (clz == null) {
                return null;
            }
            return (UnknownFieldSchema)var0.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getGeneratedMessageClass() {
        if (Protobuf.assumeLiteRuntime) {
            return null;
        }
        try {
            return Class.forName("androidx.datastore.preferences.protobuf.GeneratedMessage");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getUnknownFieldSetSchemaClass() {
        if (Protobuf.assumeLiteRuntime) {
            return null;
        }
        try {
            return Class.forName("androidx.datastore.preferences.protobuf.UnknownFieldSetSchema");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Object getMapDefaultEntry(Class<?> clazz, String name) {
        try {
            Class<?> clazz2 = Class.forName(clazz.getName() + "$" + SchemaUtil.toCamelCase(name, true) + "DefaultEntryHolder");
            Field[] fields = clazz2.getDeclaredFields();
            if (fields.length != 1) {
                Class<?> clazz3;
                void var1_1;
                throw new IllegalStateException("Unable to look up map field default entry holder class for " + (String)var1_1 + " in " + clazz3.getName());
            }
            return UnsafeUtil.getStaticObject(fields[0]);
        }
        catch (Throwable t) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static String toCamelCase(String name, boolean capNext) {
        void var2_2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z') {
                if (capNext) {
                    sb.append((char)(c + -32));
                } else {
                    sb.append(c);
                }
                capNext = false;
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                if (i == 0 && !capNext) {
                    sb.append((char)(c - -32));
                } else {
                    sb.append(c);
                }
                capNext = false;
                continue;
            }
            if ('0' <= c && c <= '9') {
                sb.append(c);
            }
            capNext = true;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static boolean safeEquals(Object a, Object b) {
        void var1_1;
        Object object;
        return a == b || a != null && object.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <T> void mergeMap(MapFieldSchema mapFieldSchema, T message, T o, long offset) {
        Object object;
        void var3_3;
        void var1_1;
        void var2_2;
        Object merged = mapFieldSchema.mergeFrom(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(var2_2, offset));
        UnsafeUtil.putObject(var1_1, (long)var3_3, object);
    }

    /*
     * WARNING - void declaration
     */
    static <T, FT extends FieldSet.FieldDescriptorLite<FT>> void mergeExtensions(ExtensionSchema<FT> schema, T message, T other) {
        FieldSet<FT> otherExtensions = schema.getExtensions(other);
        if (!otherExtensions.isEmpty()) {
            void var2_2;
            void var1_1;
            FieldSet<FT> fieldSet;
            fieldSet = ((ExtensionSchema)((Object)fieldSet)).getMutableExtensions(var1_1);
            fieldSet.mergeFrom((FieldSet<FT>)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static <T, UT, UB> void mergeUnknownFields(UnknownFieldSchema<UT, UB> schema, T message, T other) {
        void var2_2;
        void var1_1;
        UnknownFieldSchema<UT, UB> unknownFieldSchema;
        void var3_3;
        UT messageUnknowns = schema.getFromMessage(message);
        UT otherUnknowns = schema.getFromMessage(other);
        void merged = schema.merge(var3_3, otherUnknowns);
        unknownFieldSchema.setToMessage(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    static <UT, UB> UB filterUnknownEnumList(Object containerMessage, int number, List<Integer> enumList, Internal.EnumLiteMap<?> enumMap, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumMap == null) {
            return unknownFields;
        }
        if (enumList instanceof RandomAccess) {
            int writePos = 0;
            int size = enumList.size();
            for (int readPos = 0; readPos < size; ++readPos) {
                int enumValue = enumList.get(readPos);
                if (enumMap.findValueByNumber(enumValue) != null) {
                    if (readPos != writePos) {
                        enumList.set(writePos, enumValue);
                    }
                    ++writePos;
                    continue;
                }
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, enumValue, unknownFields, unknownFieldSchema);
            }
            if (writePos != size) {
                enumList.subList(writePos, size).clear();
            }
        } else {
            void var2_2;
            Iterator it = var2_2.iterator();
            while (it.hasNext()) {
                int enumValue = (Integer)it.next();
                if (enumMap.findValueByNumber(enumValue) != null) continue;
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, enumValue, unknownFields, unknownFieldSchema);
                it.remove();
            }
        }
        return unknownFields;
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    static <UT, UB> UB filterUnknownEnumList(Object containerMessage, int number, List<Integer> enumList, Internal.EnumVerifier enumVerifier, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumVerifier == null) {
            return unknownFields;
        }
        if (enumList instanceof RandomAccess) {
            int writePos = 0;
            int size = enumList.size();
            for (int readPos = 0; readPos < size; ++readPos) {
                int enumValue = enumList.get(readPos);
                if (enumVerifier.isInRange(enumValue)) {
                    if (readPos != writePos) {
                        enumList.set(writePos, enumValue);
                    }
                    ++writePos;
                    continue;
                }
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, enumValue, unknownFields, unknownFieldSchema);
            }
            if (writePos != size) {
                enumList.subList(writePos, size).clear();
            }
        } else {
            void var2_2;
            Iterator it = var2_2.iterator();
            while (it.hasNext()) {
                int enumValue = (Integer)it.next();
                if (enumVerifier.isInRange(enumValue)) continue;
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, enumValue, unknownFields, unknownFieldSchema);
                it.remove();
            }
        }
        return unknownFields;
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    static <UT, UB> UB storeUnknownEnum(Object containerMessage, int number, int enumValue, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (unknownFields == null) {
            Object object;
            unknownFields = unknownFieldSchema.getBuilderFromMessage(object);
        }
        unknownFieldSchema.addVarint(unknownFields, (int)var1_1, (long)var2_2);
        return var3_3;
    }
}

