/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import java.util.logging.Logger;

public final class RuntimeVersion {
    public static final RuntimeDomain OSS_DOMAIN;
    public static final int OSS_MAJOR = 4;
    public static final int OSS_MINOR = 28;
    public static final int OSS_PATCH = 2;
    public static final String OSS_SUFFIX = "";
    public static final RuntimeDomain DOMAIN;
    public static final int MAJOR = 4;
    public static final int MINOR = 28;
    public static final int PATCH = 2;
    public static final String SUFFIX = "";
    private static final String VERSION_STRING;
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public static void validateProtobufGencodeVersion(RuntimeDomain domain, int major, int minor, int patch, String suffix, String location) {
        void var3_3;
        void var2_2;
        void var1_1;
        RuntimeDomain runtimeDomain;
        if (RuntimeVersion.checkDisabled()) {
            return;
        }
        RuntimeVersion.validateProtobufGencodeVersionImpl(runtimeDomain, (int)var1_1, (int)var2_2, (int)var3_3, suffix, location);
    }

    /*
     * WARNING - void declaration
     */
    private static void validateProtobufGencodeVersionImpl(RuntimeDomain domain, int major, int minor, int patch, String suffix, String location) {
        void var3_3;
        void var2_2;
        if (RuntimeVersion.checkDisabled()) {
            return;
        }
        String gencodeVersionString = RuntimeVersion.versionString(major, minor, patch, suffix);
        if (major < 0 || minor < 0 || patch < 0) {
            throw new ProtobufRuntimeVersionException("Invalid gencode version: " + gencodeVersionString);
        }
        if (domain != DOMAIN) {
            RuntimeDomain runtimeDomain;
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime domains when loading %s: gencode %s, runtime %s. Cross-domain usage of Protobuf is not supported.", new Object[]{location, runtimeDomain, DOMAIN}));
        }
        if (major != 4) {
            void var1_1;
            if (var1_1 == 3) {
                logger.warning(String.format(" Protobuf gencode version %s is exactly one major version older than the runtime version %s at %s. Please update the gencode to avoid compatibility violations in the next runtime release.", gencodeVersionString, VERSION_STRING, location));
            } else {
                throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime major versions when loading %s: gencode %s, runtime %s. Same major version is required.", location, gencodeVersionString, VERSION_STRING));
            }
        }
        if (28 < minor || minor == 28 && 2 < patch) {
            throw new ProtobufRuntimeVersionException(String.format("Detected incompatible Protobuf Gencode/Runtime versions when loading %s: gencode %s, runtime %s. Runtime version cannot be older than the linked gencode version.", location, gencodeVersionString, VERSION_STRING));
        }
        if (28 > var2_2 || 2 > var3_3) {
            logger.warning(String.format(" Protobuf gencode version %s is older than the runtime version %s at %s. Please avoid checked-in Protobuf gencode that can be obsolete.", gencodeVersionString, VERSION_STRING, location));
        }
        if (!suffix.equals("")) {
            throw new ProtobufRuntimeVersionException(String.format("Detected mismatched Protobuf Gencode/Runtime version suffixes when loading %s: gencode %s, runtime %s. Version suffixes must be the same.", location, gencodeVersionString, VERSION_STRING));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String versionString(int major, int minor, int patch, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return String.format("%d.%d.%d%s", n, (int)var1_1, (int)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkDisabled() {
        void var0;
        String disableFlag = System.getenv("TEMORARILY_DISABLE_PROTOBUF_VERSION_CHECK");
        return disableFlag != null && var0.equals("true");
    }

    private RuntimeVersion() {
    }

    static {
        DOMAIN = OSS_DOMAIN = RuntimeDomain.PUBLIC;
        VERSION_STRING = RuntimeVersion.versionString(4, 28, 2, "");
        logger = Logger.getLogger(RuntimeVersion.class.getName());
    }

    public static final class ProtobufRuntimeVersionException
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public ProtobufRuntimeVersionException(String message) {
            super((String)var1_1);
            void var1_1;
        }
    }

    public static enum RuntimeDomain {
        GOOGLE_INTERNAL,
        PUBLIC;

    }
}

