/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteOutput;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class RopeByteString
extends ByteString {
    static final int[] minLengthByDepth = new int[]{1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170, 1836311903, Integer.MAX_VALUE};
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    private RopeByteString(ByteString left, ByteString right) {
        void var2_2;
        void var1_1;
        this.left = left;
        this.right = right;
        this.leftLength = left.size();
        this.totalLength = this.leftLength + right.size();
        this.treeDepth = Math.max(var1_1.getTreeDepth(), var2_2.getTreeDepth()) + 1;
    }

    /*
     * WARNING - void declaration
     */
    static ByteString concatenate(ByteString left, ByteString right) {
        void var1_1;
        void var3_4;
        void var2_2;
        ByteString byteString;
        if (right.size() == 0) {
            return left;
        }
        if (left.size() == 0) {
            return right;
        }
        int newLength = left.size() + right.size();
        if (newLength < 128) {
            return RopeByteString.concatenateBytes(left, right);
        }
        if (left instanceof RopeByteString) {
            ByteString newRight;
            RopeByteString leftRope = (RopeByteString)left;
            if (leftRope.right.size() + right.size() < 128) {
                newRight = RopeByteString.concatenateBytes(leftRope.right, right);
                return new RopeByteString(leftRope.left, newRight);
            }
            if (leftRope.left.getTreeDepth() > leftRope.right.getTreeDepth() && leftRope.getTreeDepth() > right.getTreeDepth()) {
                newRight = new RopeByteString(leftRope.right, right);
                return new RopeByteString(leftRope.left, byteString);
            }
        }
        int newDepth = Math.max(byteString.getTreeDepth(), right.getTreeDepth()) + 1;
        if (var2_2 >= RopeByteString.minLength((int)var3_4)) {
            return new RopeByteString(byteString, right);
        }
        return Balancer.access$100(new Balancer(), byteString, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteString concatenateBytes(ByteString left, ByteString right) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteString byteString;
        int leftSize = left.size();
        int rightSize = right.size();
        byte[] bytes = new byte[leftSize + rightSize];
        byteString.copyTo(bytes, 0, 0, leftSize);
        var1_1.copyTo(bytes, 0, (int)var2_2, (int)var3_3);
        return ByteString.wrap(bytes);
    }

    /*
     * WARNING - void declaration
     */
    static RopeByteString newInstanceForTest(ByteString left, ByteString right) {
        void var1_1;
        ByteString byteString;
        return new RopeByteString(byteString, (ByteString)var1_1);
    }

    static int minLength(int depth) {
        int n;
        if (depth >= minLengthByDepth.length) {
            return Integer.MAX_VALUE;
        }
        return minLengthByDepth[n];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte byteAt(int index) {
        void var1_1;
        RopeByteString.checkIndex(index, this.totalLength);
        return this.internalByteAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final byte internalByteAt(int index) {
        void var1_1;
        if (index < this.leftLength) {
            return this.left.internalByteAt(index);
        }
        return this.right.internalByteAt((int)(var1_1 - this.leftLength));
    }

    @Override
    public final int size() {
        return this.totalLength;
    }

    @Override
    public final ByteString.ByteIterator iterator() {
        return new ByteString.AbstractByteIterator(this){
            final PieceIterator pieces;
            ByteString.ByteIterator current;
            final /* synthetic */ RopeByteString this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.pieces = new PieceIterator(this.this$0);
                this.current = this.nextPiece();
            }

            private ByteString.ByteIterator nextPiece() {
                if (this.pieces.hasNext()) {
                    return ((ByteString)this.pieces.next()).iterator();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public byte nextByte() {
                void var1_1;
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                byte b = this.current.nextByte();
                if (!this.current.hasNext()) {
                    this.current = this.nextPiece();
                }
                return (byte)var1_1;
            }
        };
    }

    @Override
    protected final int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected final boolean isBalanced() {
        return this.totalLength >= RopeByteString.minLength(this.treeDepth);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString substring(int beginIndex, int endIndex) {
        void var2_4;
        void var1_2;
        void var3_5;
        int length = RopeByteString.checkRange(beginIndex, endIndex, this.totalLength);
        if (length == 0) {
            return ByteString.EMPTY;
        }
        if (var3_5 == this.totalLength) {
            return this;
        }
        if (endIndex <= this.leftLength) {
            return this.left.substring(beginIndex, endIndex);
        }
        if (beginIndex >= this.leftLength) {
            return this.right.substring(beginIndex - this.leftLength, endIndex - this.leftLength);
        }
        ByteString leftSub = this.left.substring(beginIndex);
        ByteString rightSub = this.right.substring(0, endIndex - this.leftLength);
        return new RopeByteString((ByteString)var1_2, (ByteString)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (sourceOffset + numberToCopy <= this.leftLength) {
            this.left.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
            return;
        }
        if (sourceOffset >= this.leftLength) {
            this.right.copyToInternal(target, sourceOffset - this.leftLength, targetOffset, numberToCopy);
            return;
        }
        int leftLength = this.leftLength - sourceOffset;
        this.left.copyToInternal(target, (int)var2_2, targetOffset, leftLength);
        this.right.copyToInternal((byte[])var1_1, 0, (int)(var3_3 + leftLength), numberToCopy - leftLength);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyTo(ByteBuffer target) {
        void var1_1;
        this.left.copyTo(target);
        this.right.copyTo((ByteBuffer)var1_1);
    }

    @Override
    public final ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<ByteBuffer> asReadOnlyByteBufferList() {
        void var1_1;
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        PieceIterator pieces = new PieceIterator(this);
        while (pieces.hasNext()) {
            void var3_3;
            ByteString.LeafByteString byteString = pieces.next();
            result.add(var3_3.asReadOnlyByteBuffer());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        void var1_1;
        this.left.writeTo(outputStream);
        this.right.writeTo((OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void writeToInternal(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        if (sourceOffset + numberToWrite <= this.leftLength) {
            this.left.writeToInternal(out, sourceOffset, numberToWrite);
            return;
        }
        if (sourceOffset >= this.leftLength) {
            this.right.writeToInternal(out, sourceOffset - this.leftLength, numberToWrite);
            return;
        }
        int numberToWriteInLeft = this.leftLength - sourceOffset;
        this.left.writeToInternal(out, (int)var2_2, numberToWriteInLeft);
        this.right.writeToInternal((OutputStream)var1_1, 0, (int)(var3_3 - numberToWriteInLeft));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void writeTo(ByteOutput output) throws IOException {
        void var1_1;
        this.left.writeTo(output);
        this.right.writeTo((ByteOutput)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void writeToReverse(ByteOutput output) throws IOException {
        void var1_1;
        this.right.writeToReverse(output);
        this.left.writeToReverse((ByteOutput)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final String toStringInternal(Charset charset) {
        void var1_1;
        return new String(this.toByteArray(), (Charset)var1_1);
    }

    @Override
    public final boolean isValidUtf8() {
        int n;
        int leftPartial = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        return (n = this.right.partialIsValidUtf8(n, 0, this.right.size())) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int partialIsValidUtf8(int state, int offset, int length) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = offset + length;
        if (n <= this.leftLength) {
            return this.left.partialIsValidUtf8(state, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialIsValidUtf8(state, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialIsValidUtf8(state, (int)var2_2, leftLength);
        return this.right.partialIsValidUtf8((int)var1_1, 0, (int)(var3_3 - leftLength));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString otherByteString = (ByteString)other;
        if (this.totalLength != otherByteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        int thisHash = this.peekCachedHashCode();
        int thatHash = otherByteString.peekCachedHashCode();
        if (thisHash != 0 && thatHash != 0 && var2_2 != var3_3) {
            return false;
        }
        return this.equalsFragments((ByteString)var1_1);
    }

    private boolean equalsFragments(ByteString other) {
        int thisOffset = 0;
        PieceIterator thisIter = new PieceIterator(this);
        ByteString.LeafByteString thisString = (ByteString.LeafByteString)thisIter.next();
        int thatOffset = 0;
        PieceIterator thatIter = new PieceIterator(other);
        ByteString.LeafByteString thatString = (ByteString.LeafByteString)thatIter.next();
        int pos = 0;
        while (true) {
            int thisRemaining = thisString.size() - thisOffset;
            int thatRemaining = thatString.size() - thatOffset;
            int bytesToCompare = Math.min(thisRemaining, thatRemaining);
            boolean bl = thisOffset == 0 ? thisString.equalsRange(thatString, thatOffset, bytesToCompare) : thatString.equalsRange(thisString, thisOffset, bytesToCompare);
            if (!bl) {
                return false;
            }
            if ((pos += bytesToCompare) >= this.totalLength) {
                if (pos == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (bytesToCompare == thisRemaining) {
                thisOffset = 0;
                thisString = (ByteString.LeafByteString)thisIter.next();
            } else {
                thisOffset += bytesToCompare;
            }
            if (bytesToCompare == thatRemaining) {
                thatOffset = 0;
                thatString = (ByteString.LeafByteString)thatIter.next();
                continue;
            }
            thatOffset += bytesToCompare;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int partialHash(int h, int offset, int length) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = offset + length;
        if (n <= this.leftLength) {
            return this.left.partialHash(h, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialHash(h, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialHash(h, (int)var2_2, leftLength);
        return this.right.partialHash((int)var1_1, 0, (int)(var3_3 - leftLength));
    }

    @Override
    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(((ByteString)this).asReadOnlyByteBufferList(), true);
    }

    @Override
    public final InputStream newInput() {
        return new RopeInputStream();
    }

    final Object writeReplace() {
        return ByteString.wrap(this.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("RopeByteStream instances are not to be serialized directly");
    }

    private class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private ByteString.LeafByteString currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;

        public RopeInputStream() {
            this.initialize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int read(byte[] b, int offset, int length) {
            void var1_2;
            void var3_4;
            void var2_3;
            if (b == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || length > b.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            int bytesRead = this.readSkipInternal(b, (int)var2_3, length);
            if (bytesRead == 0 && (var3_4 > 0 || this.availableInternal() == 0)) {
                return -1;
            }
            return (int)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long skip(long length) {
            void var1_1;
            if (length < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (length > Integer.MAX_VALUE) {
                length = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private int readSkipInternal(byte[] b, int offset, int length) {
            void var3_3;
            int bytesRemaining;
            int count;
            for (bytesRemaining = length; bytesRemaining > 0; bytesRemaining -= count) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) break;
                int n = this.currentPieceSize - this.currentPieceIndex;
                count = Math.min(n, bytesRemaining);
                if (b != null) {
                    this.currentPiece.copyTo(b, this.currentPieceIndex, offset, count);
                    offset += count;
                }
                this.currentPieceIndex += count;
            }
            return (int)(var3_3 - bytesRemaining);
        }

        @Override
        public int read() throws IOException {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        @Override
        public int available() throws IOException {
            return this.availableInternal();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(RopeByteString.this);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = this.currentPiece.size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = this.currentPiece.size();
                    return;
                }
                this.currentPiece = null;
                this.currentPieceSize = 0;
            }
        }

        /*
         * WARNING - void declaration
         */
        private int availableInternal() {
            void var1_1;
            int bytesRead = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return ((ByteString)RopeByteString.this).size() - var1_1;
        }
    }

    private static final class PieceIterator
    implements Iterator<ByteString.LeafByteString> {
        private final ArrayDeque<RopeByteString> breadCrumbs;
        private ByteString.LeafByteString next;

        /*
         * WARNING - void declaration
         */
        private PieceIterator(ByteString root) {
            void var1_1;
            if (root instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)root;
                this.breadCrumbs = new ArrayDeque(rbs.getTreeDepth());
                this.breadCrumbs.push(rbs);
                this.next = this.getLeafByLeft(((RopeByteString)var1_1).left);
                return;
            }
            this.breadCrumbs = null;
            this.next = (ByteString.LeafByteString)var1_1;
        }

        private ByteString.LeafByteString getLeafByLeft(ByteString root) {
            ByteString byteString;
            ByteString pos = root;
            while (pos instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)pos;
                this.breadCrumbs.push(rbs);
                byteString = ((RopeByteString)byteString).left;
            }
            return (ByteString.LeafByteString)byteString;
        }

        /*
         * WARNING - void declaration
         */
        private ByteString.LeafByteString getNextNonEmptyLeaf() {
            void var1_1;
            PieceIterator pieceIterator;
            ByteString.LeafByteString result;
            do {
                if (this.breadCrumbs == null || this.breadCrumbs.isEmpty()) {
                    return null;
                }
                pieceIterator = this;
            } while ((result = pieceIterator.getLeafByLeft(pieceIterator.breadCrumbs.pop().right)).isEmpty());
            return var1_1;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString.LeafByteString next() {
            void var1_1;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ByteString.LeafByteString result = this.next;
            this.next = this.getNextNonEmptyLeaf();
            return var1_1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Balancer {
        private final ArrayDeque<ByteString> prefixesStack = new ArrayDeque();

        private Balancer() {
        }

        /*
         * WARNING - void declaration
         */
        private ByteString balance(ByteString left, ByteString right) {
            void var1_1;
            this.doBalance(left);
            this.doBalance(right);
            ByteString partialString = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                void var2_2;
                ByteString newLeft = this.prefixesStack.pop();
                partialString = new RopeByteString((ByteString)var2_2, partialString);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void doBalance(ByteString root) {
            void var1_1;
            if (root.isBalanced()) {
                this.insert(root);
                return;
            }
            if (root instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)root;
                this.doBalance(rbs.left);
                this.doBalance(((RopeByteString)var1_1).right);
                return;
            }
            throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + var1_1.getClass());
        }

        /*
         * WARNING - void declaration
         */
        private void insert(ByteString byteString) {
            void var1_1;
            int depthBin = this.getDepthBinForLength(byteString.size());
            int binEnd = RopeByteString.minLength(depthBin + 1);
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= binEnd) {
                this.prefixesStack.push(byteString);
                return;
            }
            int binStart = RopeByteString.minLength(depthBin);
            ByteString newTree = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < binStart) {
                ByteString left = this.prefixesStack.pop();
                newTree = new RopeByteString(left, newTree);
            }
            newTree = new RopeByteString(newTree, (ByteString)var1_1);
            while (!this.prefixesStack.isEmpty()) {
                void var3_5;
                int n = this.getDepthBinForLength(newTree.size());
                int left = RopeByteString.minLength(n + 1);
                if (this.prefixesStack.peek().size() >= left) break;
                ByteString left2 = this.prefixesStack.pop();
                newTree = new RopeByteString((ByteString)var3_5, newTree);
            }
            this.prefixesStack.push(newTree);
        }

        /*
         * WARNING - void declaration
         */
        private int getDepthBinForLength(int length) {
            void var1_1;
            int depth = Arrays.binarySearch(minLengthByDepth, length);
            if (depth < 0) {
                depth = -(depth + 1);
                --depth;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ByteString access$100(Balancer x0, ByteString x1, ByteString x2) {
            void var2_2;
            void var1_1;
            return x0.balance((ByteString)var1_1, (ByteString)var2_2);
        }
    }
}

