/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.MessageInfo;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.ProtoSyntax;

@CheckReturnValue
final class RawMessageInfo
implements MessageInfo {
    private static final int IS_PROTO2_BIT = 1;
    private static final int IS_EDITION_BIT = 4;
    private final MessageLite defaultInstance;
    private final String info;
    private final Object[] objects;
    private final int flags;

    /*
     * WARNING - void declaration
     */
    RawMessageInfo(MessageLite defaultInstance, String info, Object[] objects) {
        void var3_5;
        this.defaultInstance = defaultInstance;
        this.info = info;
        this.objects = objects;
        int position = 0;
        ++position;
        char value = info.charAt(0);
        if (value < '\ud800') {
            this.flags = value;
            return;
        }
        int result = value & 0x1FFF;
        int shift = 13;
        while ((value = info.charAt(position++)) >= '\ud800') {
            result |= (value & 0x1FFF) << shift;
            shift += 13;
        }
        this.flags = result | var3_5 << shift;
    }

    final String getStringInfo() {
        return this.info;
    }

    final Object[] getObjects() {
        return this.objects;
    }

    @Override
    public final MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public final ProtoSyntax getSyntax() {
        if ((this.flags & 1) != 0) {
            return ProtoSyntax.PROTO2;
        }
        if ((this.flags & 4) == 4) {
            return ProtoSyntax.EDITIONS;
        }
        return ProtoSyntax.PROTO3;
    }

    @Override
    public final boolean isMessageSetWireFormat() {
        return (this.flags & 2) == 2;
    }
}

