/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.ManifestSchemaFactory;
import androidx.datastore.preferences.protobuf.MessageSchema;
import androidx.datastore.preferences.protobuf.Reader;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.SchemaFactory;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@CheckReturnValue
final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    static boolean assumeLiteRuntime = false;
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void writeTo(T message, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        this.schemaFor(message).writeTo(var1_1, (Writer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void mergeFrom(T message, Reader reader) throws IOException {
        void var2_2;
        void var1_1;
        this.mergeFrom(var1_1, (Reader)var2_2, ExtensionRegistryLite.getEmptyRegistry());
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void mergeFrom(T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.schemaFor(message).mergeFrom(var1_1, (Reader)var2_2, (ExtensionRegistryLite)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void makeImmutable(T message) {
        void var1_1;
        this.schemaFor(message).makeImmutable(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final <T> boolean isInitialized(T message) {
        void var1_1;
        return this.schemaFor(message).isInitialized(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Schema<T> schemaFor(Class<T> messageType) {
        void var2_2;
        Schema<?> previous;
        Internal.checkNotNull(messageType, "messageType");
        Schema<T> schema = (Schema<T>)this.schemaCache.get(messageType);
        if (schema == null && (previous = this.registerSchema(messageType, schema = this.schemaFactory.createSchema(messageType))) != null) {
            void var1_1;
            schema = var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> Schema<T> schemaFor(T message) {
        void var1_1;
        return this.schemaFor((T)var1_1.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public final Schema<?> registerSchema(Class<?> messageType, Schema<?> schema) {
        void var2_2;
        void var1_1;
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return (Schema)this.schemaCache.putIfAbsent((Class<?>)var1_1, (Schema<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    public final Schema<?> registerSchemaOverride(Class<?> messageType, Schema<?> schema) {
        void var2_2;
        void var1_1;
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return (Schema)this.schemaCache.put((Class<?>)var1_1, (Schema<?>)var2_2);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }

    /*
     * WARNING - void declaration
     */
    final int getTotalSchemaSize() {
        void var1_1;
        int result = 0;
        for (Schema schema : this.schemaCache.values()) {
            void var3_3;
            if (!(schema instanceof MessageSchema)) continue;
            result += ((MessageSchema)var3_3).getSchemaSize();
        }
        return (int)var1_1;
    }
}

