/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ArrayDecoders;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.ExtensionLite;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.ExtensionSchema;
import androidx.datastore.preferences.protobuf.FieldSet;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.LazyField;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Reader;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.SchemaUtil;
import androidx.datastore.preferences.protobuf.UnknownFieldSchema;
import androidx.datastore.preferences.protobuf.UnknownFieldSetLite;
import androidx.datastore.preferences.protobuf.WireFormat;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

@CheckReturnValue
final class MessageSetSchema<T>
implements Schema<T> {
    private final MessageLite defaultInstance;
    private final UnknownFieldSchema<?, ?> unknownFieldSchema;
    private final boolean hasExtensions;
    private final ExtensionSchema<?> extensionSchema;

    /*
     * WARNING - void declaration
     */
    private MessageSetSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.unknownFieldSchema = var1_1;
        this.hasExtensions = extensionSchema.hasExtensions(defaultInstance);
        this.extensionSchema = var2_2;
        this.defaultInstance = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static <T> MessageSetSchema<T> newSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        void var2_2;
        void var1_1;
        UnknownFieldSchema<?, ?> unknownFieldSchema2;
        return new MessageSetSchema<T>(unknownFieldSchema2, (ExtensionSchema<?>)var1_1, (MessageLite)var2_2);
    }

    @Override
    public final T newInstance() {
        if (this.defaultInstance instanceof GeneratedMessageLite) {
            return (T)((GeneratedMessageLite)this.defaultInstance).newMutableInstance();
        }
        return (T)this.defaultInstance.newBuilderForType().buildPartial();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(T message, T other) {
        void var3_3;
        Object messageUnknown = this.unknownFieldSchema.getFromMessage(message);
        Object otherUnknown = this.unknownFieldSchema.getFromMessage(other);
        if (!var3_3.equals(otherUnknown)) {
            return false;
        }
        if (this.hasExtensions) {
            void var2_2;
            void var1_1;
            FieldSet<?> messageExtensions = this.extensionSchema.getExtensions(message);
            FieldSet<?> otherExtensions = this.extensionSchema.getExtensions(other);
            return var1_1.equals(var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode(T message) {
        void var2_2;
        int hashCode = this.unknownFieldSchema.getFromMessage(message).hashCode();
        if (this.hasExtensions) {
            void var1_1;
            FieldSet<?> extensions = this.extensionSchema.getExtensions(message);
            hashCode = hashCode * 53 + var1_1.hashCode();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mergeFrom(T message, T other) {
        SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, message, other);
        if (this.hasExtensions) {
            void var2_2;
            void var1_1;
            SchemaUtil.mergeExtensions(this.extensionSchema, var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeTo(T message, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        FieldSet<?> fieldSet = this.extensionSchema.getExtensions(message);
        Iterator<Map.Entry<?, Object>> iterator = fieldSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, Object> extension = iterator.next();
            FieldSet.FieldDescriptorLite fd = (FieldSet.FieldDescriptorLite)extension.getKey();
            if (fd.getLiteJavaType() != WireFormat.JavaType.MESSAGE || fd.isRepeated() || fd.isPacked()) {
                throw new IllegalStateException("Found invalid MessageSet item.");
            }
            if (extension instanceof LazyField.LazyEntry) {
                writer.writeMessageSetItem(fd.getNumber(), ((LazyField.LazyEntry)extension).getField().toByteString());
                continue;
            }
            writer.writeMessageSetItem(fd.getNumber(), extension.getValue());
        }
        MessageSetSchema messageSetSchema = this;
        messageSetSchema.writeUnknownFieldsHelper(messageSetSchema.unknownFieldSchema, var1_1, (Writer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private <UT, UB> void writeUnknownFieldsHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, T message, Writer writer) throws IOException {
        void var3_3;
        void var2_2;
        UnknownFieldSchema<UT, UB> unknownFieldSchema2 = unknownFieldSchema;
        unknownFieldSchema2.writeAsMessageSetTo(unknownFieldSchema2.getFromMessage(var2_2), (Writer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mergeFrom(T message, byte[] data, int position, int limit, ArrayDecoders.Registers registers) throws IOException {
        void var3_3;
        UnknownFieldSetLite unknownFields = ((GeneratedMessageLite)message).unknownFields;
        if (unknownFields == UnknownFieldSetLite.getDefaultInstance()) {
            ((GeneratedMessageLite)message).unknownFields = unknownFields = UnknownFieldSetLite.newInstance();
        }
        FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions = ((GeneratedMessageLite.ExtendableMessage)message).ensureExtensionsAreMutable();
        GeneratedMessageLite.GeneratedExtension extension = null;
        while (position < limit) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            int startTag = registers.int1;
            if (startTag != WireFormat.MESSAGE_SET_ITEM_TAG) {
                if (WireFormat.getTagWireType(startTag) == 2) {
                    extension = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, WireFormat.getTagFieldNumber(startTag));
                    if (extension != null) {
                        position = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(((ExtensionLite)extension).getMessageDefaultInstance().getClass()), data, position, limit, registers);
                        extensions.setField(extension.descriptor, registers.object1);
                        continue;
                    }
                    position = ArrayDecoders.decodeUnknownField(startTag, data, position, limit, unknownFields, registers);
                    continue;
                }
                position = ArrayDecoders.skipField(startTag, data, position, limit, registers);
                continue;
            }
            int typeId = 0;
            ByteString rawBytes = null;
            block5: while (position < limit) {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                int tag = registers.int1;
                int number = WireFormat.getTagFieldNumber(tag);
                int wireType = WireFormat.getTagWireType(tag);
                switch (number) {
                    case 2: {
                        if (wireType != 0) break;
                        position = ArrayDecoders.decodeVarint32(data, position, registers);
                        typeId = registers.int1;
                        extension = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, typeId);
                        continue block5;
                    }
                    case 3: {
                        if (extension != null) {
                            position = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(((ExtensionLite)extension).getMessageDefaultInstance().getClass()), data, position, limit, registers);
                            extensions.setField(extension.descriptor, registers.object1);
                            continue block5;
                        }
                        if (wireType != 2) break;
                        position = ArrayDecoders.decodeBytes(data, position, registers);
                        rawBytes = (ByteString)registers.object1;
                        continue block5;
                    }
                }
                if (tag == WireFormat.MESSAGE_SET_ITEM_END_TAG) break;
                position = ArrayDecoders.skipField(tag, data, position, limit, registers);
            }
            if (rawBytes == null) continue;
            unknownFields.storeField(WireFormat.makeTag(typeId, 2), rawBytes);
        }
        if (var3_3 != limit) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mergeFrom(T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        MessageSetSchema messageSetSchema = this;
        messageSetSchema.mergeFromHelper(messageSetSchema.unknownFieldSchema, this.extensionSchema, var1_1, (Reader)var2_2, (ExtensionRegistryLite)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> void mergeFromHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, ExtensionSchema<ET> extensionSchema, T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        UB unknownFields = unknownFieldSchema.getBuilderFromMessage(message);
        FieldSet<ET> extensions = extensionSchema.getMutableExtensions(message);
        try {
            do {
                int n;
                if ((n = reader.getFieldNumber()) != Integer.MAX_VALUE) continue;
                unknownFieldSchema.setBuilderToMessage(message, unknownFields);
                return;
            } while (this.parseMessageSetItemOrUnknownField(reader, extensionRegistry, extensionSchema, extensions, unknownFieldSchema, unknownFields));
            unknownFieldSchema.setBuilderToMessage(message, unknownFields);
            return;
        }
        catch (Throwable throwable) {
            void var3_4;
            void var1_1;
            var1_1.setBuilderToMessage(var3_4, unknownFields);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void makeImmutable(T message) {
        void var1_1;
        this.unknownFieldSchema.makeImmutable(message);
        this.extensionSchema.makeImmutable(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> boolean parseMessageSetItemOrUnknownField(Reader reader, ExtensionRegistryLite extensionRegistry, ExtensionSchema<ET> extensionSchema, FieldSet<ET> extensions, UnknownFieldSchema<UT, UB> unknownFieldSchema, UB unknownFields) throws IOException {
        void var1_1;
        int n;
        int startTag = reader.getTag();
        if (startTag != WireFormat.MESSAGE_SET_ITEM_TAG) {
            if (WireFormat.getTagWireType(startTag) == 2) {
                Object extension = extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, WireFormat.getTagFieldNumber(startTag));
                if (extension != null) {
                    extensionSchema.parseLengthPrefixedMessageSetItem(reader, extension, extensionRegistry, extensions);
                    return true;
                }
                return unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader, 0);
            }
            return reader.skipField();
        }
        int typeId = 0;
        ByteString rawBytes = null;
        Object extension = null;
        while ((n = reader.getFieldNumber()) != Integer.MAX_VALUE) {
            int tag = reader.getTag();
            if (tag == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                typeId = reader.readUInt32();
                extension = extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, typeId);
                continue;
            }
            if (tag == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                if (extension != null) {
                    extensionSchema.parseLengthPrefixedMessageSetItem(reader, extension, extensionRegistry, extensions);
                    continue;
                }
                rawBytes = reader.readBytes();
                continue;
            }
            if (reader.skipField()) continue;
        }
        if (var1_1.getTag() != WireFormat.MESSAGE_SET_ITEM_END_TAG) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
        if (rawBytes != null) {
            if (extension != null) {
                void var2_2;
                void var3_3;
                var3_3.parseMessageSetItem(rawBytes, extension, (ExtensionRegistryLite)var2_2, extensions);
            } else {
                unknownFieldSchema.addLengthDelimited(unknownFields, typeId, rawBytes);
            }
        }
        return true;
    }

    @Override
    public final boolean isInitialized(T message) {
        FieldSet<?> fieldSet;
        fieldSet = this.extensionSchema.getExtensions(fieldSet);
        return fieldSet.isInitialized();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getSerializedSize(T message) {
        void var2_2;
        MessageSetSchema messageSetSchema = this;
        int size = 0 + messageSetSchema.getUnknownFieldsSerializedSize(messageSetSchema.unknownFieldSchema, message);
        if (this.hasExtensions) {
            void var1_1;
            size += this.extensionSchema.getExtensions(var1_1).getMessageSetSerializedSize();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private <UT, UB> int getUnknownFieldsSerializedSize(UnknownFieldSchema<UT, UB> schema, T message) {
        void var2_2;
        void var1_1;
        UT unknowns = schema.getFromMessage(message);
        return var1_1.getSerializedSizeAsMessageSet(var2_2);
    }
}

