/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ArrayDecoders;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.ExtensionSchema;
import androidx.datastore.preferences.protobuf.FieldInfo;
import androidx.datastore.preferences.protobuf.FieldSet;
import androidx.datastore.preferences.protobuf.FieldType;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.ListFieldSchema;
import androidx.datastore.preferences.protobuf.MapEntryLite;
import androidx.datastore.preferences.protobuf.MapFieldSchema;
import androidx.datastore.preferences.protobuf.MessageInfo;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.NewInstanceSchema;
import androidx.datastore.preferences.protobuf.OneofInfo;
import androidx.datastore.preferences.protobuf.ProtoSyntax;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.RawMessageInfo;
import androidx.datastore.preferences.protobuf.Reader;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.SchemaUtil;
import androidx.datastore.preferences.protobuf.StructuralMessageInfo;
import androidx.datastore.preferences.protobuf.UnknownFieldSchema;
import androidx.datastore.preferences.protobuf.UnknownFieldSetLite;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import androidx.datastore.preferences.protobuf.Utf8;
import androidx.datastore.preferences.protobuf.WireFormat;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.misc.Unsafe;

@CheckReturnValue
final class MessageSchema<T>
implements Schema<T> {
    private static final int INTS_PER_FIELD = 3;
    private static final int OFFSET_BITS = 20;
    private static final int OFFSET_MASK = 1048575;
    private static final int FIELD_TYPE_MASK = 0xFF00000;
    private static final int REQUIRED_MASK = 0x10000000;
    private static final int ENFORCE_UTF8_MASK = 0x20000000;
    private static final int LEGACY_ENUM_IS_CLOSED_MASK = Integer.MIN_VALUE;
    private static final int NO_PRESENCE_SENTINEL = 1048575;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int REQUIRED_BIT = 256;
    private static final int UTF8_CHECK_BIT = 512;
    private static final int CHECK_INITIALIZED_BIT = 1024;
    private static final int LEGACY_ENUM_IS_CLOSED_BIT = 2048;
    private static final int HAS_HAS_BIT = 4096;
    static final int ONEOF_TYPE_OFFSET = 51;
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private final int[] buffer;
    private final Object[] objects;
    private final int minFieldNumber;
    private final int maxFieldNumber;
    private final MessageLite defaultInstance;
    private final boolean hasExtensions;
    private final boolean lite;
    private final ProtoSyntax syntax;
    private final boolean useCachedSizeField;
    private final int[] intArray;
    private final int checkInitializedCount;
    private final int repeatedFieldOffsetStart;
    private final NewInstanceSchema newInstanceSchema;
    private final ListFieldSchema listFieldSchema;
    private final UnknownFieldSchema<?, ?> unknownFieldSchema;
    private final ExtensionSchema<?> extensionSchema;
    private final MapFieldSchema mapFieldSchema;

    /*
     * WARNING - void declaration
     */
    private MessageSchema(int[] buffer, Object[] objects, int minFieldNumber, int maxFieldNumber, MessageLite defaultInstance, ProtoSyntax syntax, boolean useCachedSizeField, int[] intArray, int checkInitialized, int mapFieldPositions, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buffer = var1_1;
        this.objects = var2_2;
        this.minFieldNumber = var3_3;
        this.maxFieldNumber = maxFieldNumber;
        this.lite = defaultInstance instanceof GeneratedMessageLite;
        this.syntax = syntax;
        this.hasExtensions = extensionSchema != null && extensionSchema.hasExtensions(defaultInstance);
        this.useCachedSizeField = useCachedSizeField;
        this.intArray = intArray;
        this.checkInitializedCount = checkInitialized;
        this.repeatedFieldOffsetStart = mapFieldPositions;
        this.newInstanceSchema = newInstanceSchema;
        this.listFieldSchema = listFieldSchema;
        this.unknownFieldSchema = unknownFieldSchema;
        this.extensionSchema = extensionSchema;
        this.defaultInstance = defaultInstance;
        this.mapFieldSchema = mapFieldSchema;
    }

    /*
     * WARNING - void declaration
     */
    static <T> MessageSchema<T> newSchema(Class<T> messageClass, MessageInfo messageInfo, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (messageInfo instanceof RawMessageInfo) {
            return MessageSchema.newSchemaForRawMessageInfo((RawMessageInfo)messageInfo, newInstanceSchema, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
        }
        return MessageSchema.newSchemaForMessageInfo((StructuralMessageInfo)var1_1, (NewInstanceSchema)var2_2, (ListFieldSchema)var3_3, unknownFieldSchema, extensionSchema, mapFieldSchema);
    }

    /*
     * WARNING - void declaration
     */
    static <T> MessageSchema<T> newSchemaForRawMessageInfo(RawMessageInfo messageInfo, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        void var3_3;
        void var2_2;
        void var1_1;
        RawMessageInfo rawMessageInfo;
        int objectsPosition;
        int[] intArray;
        int checkInitialized;
        int mapFieldCount;
        int numEntries;
        int maxFieldNumber;
        int minFieldNumber;
        int oneofCount;
        int result;
        int next;
        String info = messageInfo.getStringInfo();
        int length = info.length();
        int i = 0;
        ++i;
        char c = info.charAt(0);
        if (c >= '\ud800') {
            while (info.charAt(i++) >= '\ud800') {
            }
        }
        if ((next = info.charAt(i++)) >= 55296) {
            result = next & 0x1FFF;
            int shift = 13;
            while (true) {
                char c2 = info.charAt(i++);
                next = c2;
                if (c2 < '\ud800') break;
                result |= (next & 0x1FFF) << shift;
                shift += 13;
            }
            next = result | next << shift;
        }
        if ((result = next) == 0) {
            oneofCount = 0;
            minFieldNumber = 0;
            maxFieldNumber = 0;
            numEntries = 0;
            mapFieldCount = 0;
            checkInitialized = 0;
            intArray = EMPTY_INT_ARRAY;
            objectsPosition = 0;
        } else {
            int shift;
            int result2;
            char c3 = info.charAt(i++);
            next = c3;
            if (c3 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c4 = info.charAt(i++);
                    next = c4;
                    if (c4 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            oneofCount = next;
            char c5 = info.charAt(i++);
            next = c5;
            if (c5 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c6 = info.charAt(i++);
                    next = c6;
                    if (c6 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            int hasBitsCount = next;
            char c7 = info.charAt(i++);
            next = c7;
            if (c7 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c8 = info.charAt(i++);
                    next = c8;
                    if (c8 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            minFieldNumber = next;
            char c9 = info.charAt(i++);
            next = c9;
            if (c9 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c10 = info.charAt(i++);
                    next = c10;
                    if (c10 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            maxFieldNumber = next;
            char c11 = info.charAt(i++);
            next = c11;
            if (c11 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c12 = info.charAt(i++);
                    next = c12;
                    if (c12 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            numEntries = next;
            char c13 = info.charAt(i++);
            next = c13;
            if (c13 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c14 = info.charAt(i++);
                    next = c14;
                    if (c14 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            mapFieldCount = next;
            char c15 = info.charAt(i++);
            next = c15;
            if (c15 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c16 = info.charAt(i++);
                    next = c16;
                    if (c16 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            int repeatedFieldCount = next;
            char c17 = info.charAt(i++);
            next = c17;
            if (c17 >= '\ud800') {
                result2 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c18 = info.charAt(i++);
                    next = c18;
                    if (c18 < '\ud800') break;
                    result2 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result2 | next << shift;
            }
            checkInitialized = next;
            intArray = new int[checkInitialized + mapFieldCount + repeatedFieldCount];
            objectsPosition = (oneofCount << 1) + hasBitsCount;
        }
        Unsafe unsafe = UNSAFE;
        Object[] messageInfoObjects = messageInfo.getObjects();
        int checkInitializedPosition = 0;
        Class<?> messageClass = messageInfo.getDefaultInstance().getClass();
        int[] buffer = new int[numEntries * 3];
        Object[] objects = new Object[numEntries << 1];
        int mapFieldIndex = checkInitialized;
        int repeatedFieldIndex = checkInitialized + mapFieldCount;
        int bufferIndex = 0;
        while (i < length) {
            int presenceMaskShift;
            int presenceFieldOffset;
            int fieldOffset;
            int shift;
            int result3;
            char c19 = info.charAt(i++);
            next = c19;
            if (c19 >= '\ud800') {
                result3 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c20 = info.charAt(i++);
                    next = c20;
                    if (c20 < '\ud800') break;
                    result3 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result3 | next << shift;
            }
            int fieldNumber = next;
            char c21 = info.charAt(i++);
            next = c21;
            if (c21 >= '\ud800') {
                result3 = next & 0x1FFF;
                shift = 13;
                while (true) {
                    char c22 = info.charAt(i++);
                    next = c22;
                    if (c22 < '\ud800') break;
                    result3 |= (next & 0x1FFF) << shift;
                    shift += 13;
                }
                next = result3 | next << shift;
            }
            int fieldTypeWithExtraBits = next;
            int fieldType = fieldTypeWithExtraBits & 0xFF;
            if ((fieldTypeWithExtraBits & 0x400) != 0) {
                intArray[checkInitializedPosition++] = bufferIndex;
            }
            if (fieldType >= 51) {
                Field oneofCaseField;
                Field oneofField;
                char c23 = info.charAt(i++);
                next = c23;
                if (c23 >= '\ud800') {
                    result3 = next & 0x1FFF;
                    shift = 13;
                    while (true) {
                        char c24 = info.charAt(i++);
                        next = c24;
                        if (c24 < '\ud800') break;
                        result3 |= (next & 0x1FFF) << shift;
                        shift += 13;
                    }
                    next = result3 | next << shift;
                }
                int oneofIndex = next;
                int oneofFieldType = fieldType - 51;
                if (oneofFieldType == 9 || oneofFieldType == 17) {
                    objects[(bufferIndex / 3 << 1) + 1] = messageInfoObjects[objectsPosition++];
                } else if (oneofFieldType == 12 && (messageInfo.getSyntax().equals((Object)ProtoSyntax.PROTO2) || (fieldTypeWithExtraBits & 0x800) != 0)) {
                    objects[(bufferIndex / 3 << 1) + 1] = messageInfoObjects[objectsPosition++];
                }
                int index = oneofIndex << 1;
                Object o = messageInfoObjects[index];
                if (o instanceof Field) {
                    oneofField = (Field)o;
                } else {
                    oneofField = MessageSchema.reflectField(messageClass, (String)o);
                    messageInfoObjects[index] = oneofField;
                }
                fieldOffset = (int)unsafe.objectFieldOffset(oneofField);
                o = messageInfoObjects[++index];
                if (o instanceof Field) {
                    oneofCaseField = (Field)o;
                } else {
                    oneofCaseField = MessageSchema.reflectField(messageClass, (String)o);
                    messageInfoObjects[index] = oneofCaseField;
                }
                presenceFieldOffset = (int)unsafe.objectFieldOffset(oneofCaseField);
                presenceMaskShift = 0;
            } else {
                Field field = MessageSchema.reflectField(messageClass, (String)messageInfoObjects[objectsPosition++]);
                if (fieldType == 9 || fieldType == 17) {
                    objects[(bufferIndex / 3 << 1) + 1] = field.getType();
                } else if (fieldType == 27 || fieldType == 49) {
                    objects[(bufferIndex / 3 << 1) + 1] = messageInfoObjects[objectsPosition++];
                } else if (fieldType == 12 || fieldType == 30 || fieldType == 44) {
                    if (messageInfo.getSyntax() == ProtoSyntax.PROTO2 || (fieldTypeWithExtraBits & 0x800) != 0) {
                        objects[(bufferIndex / 3 << 1) + 1] = messageInfoObjects[objectsPosition++];
                    }
                } else if (fieldType == 50) {
                    intArray[mapFieldIndex++] = bufferIndex;
                    objects[bufferIndex / 3 << 1] = messageInfoObjects[objectsPosition++];
                    if ((fieldTypeWithExtraBits & 0x800) != 0) {
                        objects[(bufferIndex / 3 << 1) + 1] = messageInfoObjects[objectsPosition++];
                    }
                }
                fieldOffset = (int)unsafe.objectFieldOffset(field);
                presenceMaskShift = (fieldTypeWithExtraBits & 0x1000) != 0 ? 1 : 0;
                if (presenceMaskShift != 0 && fieldType <= 17) {
                    Field hasBitsField;
                    int hasBitsIndex;
                    int index;
                    Object o;
                    char c25 = info.charAt(i++);
                    presenceFieldOffset = c25;
                    if (c25 >= '\ud800') {
                        int result4 = presenceFieldOffset & 0x1FFF;
                        int shift2 = 13;
                        while (true) {
                            char c26 = info.charAt(i++);
                            presenceFieldOffset = c26;
                            if (c26 < '\ud800') break;
                            result4 |= (presenceFieldOffset & 0x1FFF) << shift2;
                            shift2 += 13;
                        }
                        presenceFieldOffset = result4 | presenceFieldOffset << shift2;
                    }
                    if ((o = messageInfoObjects[index = (oneofCount << 1) + (hasBitsIndex = presenceFieldOffset) / 32]) instanceof Field) {
                        hasBitsField = (Field)o;
                    } else {
                        hasBitsField = MessageSchema.reflectField(messageClass, (String)o);
                        messageInfoObjects[index] = hasBitsField;
                    }
                    presenceFieldOffset = (int)unsafe.objectFieldOffset(hasBitsField);
                    presenceMaskShift = hasBitsIndex % 32;
                } else {
                    presenceFieldOffset = 1048575;
                    presenceMaskShift = 0;
                }
                if (fieldType >= 18 && fieldType <= 49) {
                    intArray[repeatedFieldIndex++] = fieldOffset;
                }
            }
            buffer[bufferIndex++] = fieldNumber;
            buffer[bufferIndex++] = ((fieldTypeWithExtraBits & 0x200) != 0 ? 0x20000000 : 0) | ((fieldTypeWithExtraBits & 0x100) != 0 ? 0x10000000 : 0) | ((fieldTypeWithExtraBits & 0x800) != 0 ? Integer.MIN_VALUE : 0) | fieldType << 20 | fieldOffset;
            buffer[bufferIndex++] = presenceMaskShift << 20 | presenceFieldOffset;
        }
        int n = checkInitialized;
        return new MessageSchema<T>(buffer, objects, minFieldNumber, maxFieldNumber, messageInfo.getDefaultInstance(), rawMessageInfo.getSyntax(), false, intArray, n, n + mapFieldCount, (NewInstanceSchema)var1_1, (ListFieldSchema)var2_2, (UnknownFieldSchema<?, ?>)var3_3, extensionSchema, mapFieldSchema);
    }

    /*
     * WARNING - void declaration
     */
    private static Field reflectField(Class<?> messageClass, String fieldName) {
        try {
            return messageClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            void var2_2;
            Class<?> clazz;
            void var1_1;
            Field[] fields;
            Field[] fieldArray = fields = messageClass.getDeclaredFields();
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
            throw new RuntimeException("Field " + (String)var1_1 + " for " + clazz.getName() + " not found. Known fields are " + Arrays.toString((Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    static <T> MessageSchema<T> newSchemaForMessageInfo(StructuralMessageInfo messageInfo, NewInstanceSchema newInstanceSchema, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        void var3_3;
        void var2_2;
        void var1_1;
        StructuralMessageInfo structuralMessageInfo;
        int maxFieldNumber;
        int minFieldNumber;
        FieldInfo[] fis = messageInfo.getFields();
        if (fis.length == 0) {
            minFieldNumber = 0;
            maxFieldNumber = 0;
        } else {
            minFieldNumber = fis[0].getFieldNumber();
            maxFieldNumber = fis[fis.length - 1].getFieldNumber();
        }
        int numEntries = fis.length;
        int[] buffer = new int[numEntries * 3];
        Object[] objects = new Object[numEntries << 1];
        int mapFieldCount = 0;
        int repeatedFieldCount = 0;
        FieldInfo[] fieldInfoArray = fis;
        int n = fis.length;
        for (int i = 0; i < n; ++i) {
            FieldInfo fi = fieldInfoArray[i];
            if (fi.getType() == FieldType.MAP) {
                ++mapFieldCount;
                continue;
            }
            if (fi.getType().id() < 18 || fi.getType().id() > 49) continue;
            ++repeatedFieldCount;
        }
        int[] mapFieldPositions = mapFieldCount > 0 ? new int[mapFieldCount] : null;
        int[] repeatedFieldOffsets = repeatedFieldCount > 0 ? new int[repeatedFieldCount] : null;
        mapFieldCount = 0;
        repeatedFieldCount = 0;
        int[] checkInitialized = messageInfo.getCheckInitialized();
        if (checkInitialized == null) {
            checkInitialized = EMPTY_INT_ARRAY;
        }
        int checkInitializedIndex = 0;
        int fieldIndex = 0;
        int bufferIndex = 0;
        while (fieldIndex < fis.length) {
            FieldInfo fi = fis[fieldIndex];
            int fieldNumber = fi.getFieldNumber();
            MessageSchema.storeFieldData(fi, buffer, bufferIndex, objects);
            if (checkInitializedIndex < checkInitialized.length && checkInitialized[checkInitializedIndex] == fieldNumber) {
                checkInitialized[checkInitializedIndex++] = bufferIndex;
            }
            if (fi.getType() == FieldType.MAP) {
                mapFieldPositions[mapFieldCount++] = bufferIndex;
            } else if (fi.getType().id() >= 18 && fi.getType().id() <= 49) {
                repeatedFieldOffsets[repeatedFieldCount++] = (int)UnsafeUtil.objectFieldOffset(fi.getField());
            }
            ++fieldIndex;
            bufferIndex += 3;
        }
        if (mapFieldPositions == null) {
            mapFieldPositions = EMPTY_INT_ARRAY;
        }
        if (repeatedFieldOffsets == null) {
            repeatedFieldOffsets = EMPTY_INT_ARRAY;
        }
        int[] combined = new int[checkInitialized.length + mapFieldPositions.length + repeatedFieldOffsets.length];
        System.arraycopy(checkInitialized, 0, combined, 0, checkInitialized.length);
        System.arraycopy(mapFieldPositions, 0, combined, checkInitialized.length, mapFieldPositions.length);
        System.arraycopy(repeatedFieldOffsets, 0, combined, checkInitialized.length + mapFieldPositions.length, repeatedFieldOffsets.length);
        return new MessageSchema<T>(buffer, objects, minFieldNumber, maxFieldNumber, messageInfo.getDefaultInstance(), structuralMessageInfo.getSyntax(), true, combined, checkInitialized.length, checkInitialized.length + mapFieldPositions.length, (NewInstanceSchema)var1_1, (ListFieldSchema)var2_2, (UnknownFieldSchema<?, ?>)var3_3, extensionSchema, mapFieldSchema);
    }

    private static void storeFieldData(FieldInfo fi, int[] buffer, int bufferIndex, Object[] objects) {
        int presenceMaskShift;
        int presenceFieldOffset;
        int fieldOffset;
        int typeId;
        OneofInfo oneof = fi.getOneof();
        if (oneof != null) {
            typeId = fi.getType().id() + 51;
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(oneof.getValueField());
            presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(oneof.getCaseField());
            presenceMaskShift = 0;
        } else {
            FieldType type = fi.getType();
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(fi.getField());
            typeId = type.id();
            if (!type.isList() && !type.isMap()) {
                Field presenceField = fi.getPresenceField();
                presenceFieldOffset = presenceField == null ? 1048575 : (int)UnsafeUtil.objectFieldOffset(presenceField);
                presenceMaskShift = Integer.numberOfTrailingZeros(fi.getPresenceMask());
            } else if (fi.getCachedSizeField() == null) {
                presenceFieldOffset = 0;
                presenceMaskShift = 0;
            } else {
                presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(fi.getCachedSizeField());
                presenceMaskShift = 0;
            }
        }
        buffer[bufferIndex] = fi.getFieldNumber();
        buffer[bufferIndex + 1] = (fi.isEnforceUtf8() ? 0x20000000 : 0) | (fi.isRequired() ? 0x10000000 : 0) | typeId << 20 | fieldOffset;
        var1_1[bufferIndex + 2] = presenceMaskShift << 20 | presenceFieldOffset;
        Class<?> messageFieldClass = fi.getMessageFieldClass();
        if (fi.getMapDefaultEntry() != null) {
            objects[bufferIndex / 3 << 1] = fi.getMapDefaultEntry();
            if (messageFieldClass != null) {
                objects[(bufferIndex / 3 << 1) + 1] = messageFieldClass;
                return;
            }
            if (fi.getEnumVerifier() != null) {
                objects[(bufferIndex / 3 << 1) + 1] = fi.getEnumVerifier();
                return;
            }
        } else {
            if (messageFieldClass != null) {
                objects[(bufferIndex / 3 << 1) + 1] = messageFieldClass;
                return;
            }
            if (fi.getEnumVerifier() != null) {
                FieldInfo fieldInfo;
                var3_3[(var2_2 / 3 << 1) + true] = fieldInfo.getEnumVerifier();
            }
        }
    }

    @Override
    public final T newInstance() {
        return (T)this.newInstanceSchema.newInstance(this.defaultInstance);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(T message, T other) {
        void var3_4;
        int bufferLength = this.buffer.length;
        for (int pos = 0; pos < bufferLength; pos += 3) {
            if (this.equals(message, other, pos)) continue;
            return false;
        }
        Object messageUnknown = this.unknownFieldSchema.getFromMessage(message);
        Object otherUnknown = this.unknownFieldSchema.getFromMessage(other);
        if (!messageUnknown.equals(var3_4)) {
            return false;
        }
        if (this.hasExtensions) {
            void var2_2;
            void var1_1;
            FieldSet<?> messageExtensions = this.extensionSchema.getExtensions(message);
            FieldSet<?> otherExtensions = this.extensionSchema.getExtensions(other);
            return var1_1.equals(var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean equals(T message, T other, int pos) {
        int typeAndOffset = this.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        switch (MessageSchema.type(typeAndOffset)) {
            case 0: {
                return this.arePresentForEquals(message, other, pos) && Double.doubleToLongBits(UnsafeUtil.getDouble(message, offset)) == Double.doubleToLongBits(UnsafeUtil.getDouble(other, offset));
            }
            case 1: {
                return this.arePresentForEquals(message, other, pos) && Float.floatToIntBits(UnsafeUtil.getFloat(message, offset)) == Float.floatToIntBits(UnsafeUtil.getFloat(other, offset));
            }
            case 2: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 3: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 4: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 5: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 6: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 7: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getBoolean(message, offset) == UnsafeUtil.getBoolean(other, offset);
            }
            case 8: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 9: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 10: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 11: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 12: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 13: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 14: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 15: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 16: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 17: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                return SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 50: {
                return SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                void var2_2;
                void var1_1;
                void var3_3;
                return this.isOneofCaseEqual(message, other, (int)var3_3) && SchemaUtil.safeEquals(UnsafeUtil.getObject(var1_1, offset), UnsafeUtil.getObject(var2_2, offset));
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode(T message) {
        void var2_2;
        int hashCode = 0;
        int bufferLength = this.buffer.length;
        block40: for (int pos = 0; pos < bufferLength; pos += 3) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            int entryNumber = this.numberAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    hashCode = hashCode * 53 + Internal.hashLong(Double.doubleToLongBits(UnsafeUtil.getDouble(message, offset)));
                    continue block40;
                }
                case 1: {
                    hashCode = hashCode * 53 + Float.floatToIntBits(UnsafeUtil.getFloat(message, offset));
                    continue block40;
                }
                case 2: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 3: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 4: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 5: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 6: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 7: {
                    hashCode = hashCode * 53 + Internal.hashBoolean(UnsafeUtil.getBoolean(message, offset));
                    continue block40;
                }
                case 8: {
                    hashCode = hashCode * 53 + ((String)UnsafeUtil.getObject(message, offset)).hashCode();
                    continue block40;
                }
                case 9: {
                    int protoHash = 37;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    if (submessage != null) {
                        protoHash = submessage.hashCode();
                    }
                    hashCode = hashCode * 53 + protoHash;
                    continue block40;
                }
                case 10: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 11: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 12: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 13: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 14: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 15: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 16: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 17: {
                    int protoHash = 37;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    if (submessage != null) {
                        protoHash = submessage.hashCode();
                    }
                    hashCode = hashCode * 53 + protoHash;
                    continue block40;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 50: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 51: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(Double.doubleToLongBits(MessageSchema.oneofDoubleAt(message, offset)));
                    continue block40;
                }
                case 52: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Float.floatToIntBits(MessageSchema.oneofFloatAt(message, offset));
                    continue block40;
                }
                case 53: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 54: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 55: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 56: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 57: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 58: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashBoolean(MessageSchema.oneofBooleanAt(message, offset));
                    continue block40;
                }
                case 59: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + ((String)UnsafeUtil.getObject(message, offset)).hashCode();
                    continue block40;
                }
                case 60: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    hashCode = hashCode * 53 + submessage.hashCode();
                    continue block40;
                }
                case 61: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 62: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 63: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 64: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 65: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 66: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 67: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 68: {
                    void var6_8;
                    if (!this.isOneofPresent(message, (int)var6_8, pos)) continue block40;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    hashCode = hashCode * 53 + submessage.hashCode();
                }
            }
        }
        hashCode = hashCode * 53 + this.unknownFieldSchema.getFromMessage(message).hashCode();
        if (this.hasExtensions) {
            void var1_1;
            hashCode = hashCode * 53 + this.extensionSchema.getExtensions(var1_1).hashCode();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mergeFrom(T message, T other) {
        MessageSchema.checkMutable(message);
        if (other == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.buffer.length; i += 3) {
            this.mergeSingleField(message, other, i);
        }
        SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, message, other);
        if (this.hasExtensions) {
            void var2_2;
            void var1_1;
            SchemaUtil.mergeExtensions(this.extensionSchema, var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeSingleField(T message, T other, int pos) {
        int typeAndOffset = this.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        int number = this.numberAt(pos);
        switch (MessageSchema.type(typeAndOffset)) {
            case 0: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putDouble(message, offset, UnsafeUtil.getDouble(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 1: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putFloat(message, offset, UnsafeUtil.getFloat(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 2: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 3: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 4: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 5: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 6: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 7: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putBoolean(message, offset, UnsafeUtil.getBoolean(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 8: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 9: {
                this.mergeMessage(message, other, pos);
                return;
            }
            case 10: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 11: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 12: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 13: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 14: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 15: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 16: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                return;
            }
            case 17: {
                this.mergeMessage(message, other, pos);
                return;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                this.listFieldSchema.mergeListsAt(message, other, offset);
                return;
            }
            case 50: {
                SchemaUtil.mergeMap(this.mapFieldSchema, message, other, offset);
                return;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                if (!this.isOneofPresent(other, number, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setOneofPresent(message, number, pos);
                return;
            }
            case 60: {
                this.mergeOneofMessage(message, other, pos);
                return;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                if (!this.isOneofPresent(other, number, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setOneofPresent(message, number, pos);
                return;
            }
            case 68: {
                void var3_3;
                void var2_2;
                void var1_1;
                this.mergeOneofMessage(var1_1, var2_2, (int)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeMessage(T targetParent, T sourceParent, int pos) {
        void var2_2;
        if (!this.isFieldPresent(sourceParent, pos)) {
            return;
        }
        int n = this.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(n);
        Object source = UNSAFE.getObject(sourceParent, offset);
        if (source == null) {
            throw new IllegalStateException("Source subfield " + this.numberAt(pos) + " is present but null: " + sourceParent);
        }
        Schema fieldSchema = this.getMessageFieldSchema(pos);
        if (!this.isFieldPresent(targetParent, pos)) {
            if (!MessageSchema.isMutable(source)) {
                UNSAFE.putObject(targetParent, offset, source);
            } else {
                Object copyOfSource = fieldSchema.newInstance();
                fieldSchema.mergeFrom(copyOfSource, source);
                UNSAFE.putObject(targetParent, offset, copyOfSource);
            }
            this.setFieldPresent(targetParent, pos);
            return;
        }
        Object target = UNSAFE.getObject(targetParent, offset);
        if (!MessageSchema.isMutable(target)) {
            void var3_4;
            void var1_1;
            Object newInstance = fieldSchema.newInstance();
            fieldSchema.mergeFrom(newInstance, target);
            UNSAFE.putObject(var1_1, offset, newInstance);
            target = var3_4;
        }
        var2_2.mergeFrom(target, source);
    }

    /*
     * WARNING - void declaration
     */
    private void mergeOneofMessage(T targetParent, T sourceParent, int pos) {
        void var2_2;
        int number = this.numberAt(pos);
        if (!this.isOneofPresent(sourceParent, number, pos)) {
            return;
        }
        long offset = MessageSchema.offset(this.typeAndOffsetAt(pos));
        Object source = UNSAFE.getObject(sourceParent, offset);
        if (source == null) {
            throw new IllegalStateException("Source subfield " + this.numberAt(pos) + " is present but null: " + sourceParent);
        }
        Schema fieldSchema = this.getMessageFieldSchema(pos);
        if (!this.isOneofPresent(targetParent, number, pos)) {
            if (!MessageSchema.isMutable(source)) {
                UNSAFE.putObject(targetParent, offset, source);
            } else {
                Object copyOfSource = fieldSchema.newInstance();
                fieldSchema.mergeFrom(copyOfSource, source);
                UNSAFE.putObject(targetParent, offset, copyOfSource);
            }
            this.setOneofPresent(targetParent, number, pos);
            return;
        }
        Object target = UNSAFE.getObject(targetParent, offset);
        if (!MessageSchema.isMutable(target)) {
            void var3_4;
            void var1_1;
            Object newInstance = fieldSchema.newInstance();
            fieldSchema.mergeFrom(newInstance, target);
            UNSAFE.putObject(var1_1, offset, newInstance);
            target = var3_4;
        }
        var2_2.mergeFrom(target, source);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getSerializedSize(T message) {
        void var2_2;
        int size = 0;
        Unsafe unsafe = UNSAFE;
        int currentPresenceFieldOffset = 1048575;
        int currentPresenceField = 0;
        block71: for (int i = 0; i < this.buffer.length; i += 3) {
            int typeAndOffset = this.typeAndOffsetAt(i);
            int fieldType = MessageSchema.type(typeAndOffset);
            int number = this.numberAt(i);
            int presenceMask = 0;
            int presenceMaskAndOffset = this.buffer[i + 2];
            int presenceOrCachedSizeFieldOffset = presenceMaskAndOffset & 0xFFFFF;
            if (fieldType <= 17) {
                if (presenceOrCachedSizeFieldOffset != currentPresenceFieldOffset) {
                    currentPresenceFieldOffset = presenceOrCachedSizeFieldOffset;
                    currentPresenceField = currentPresenceFieldOffset == 1048575 ? 0 : unsafe.getInt(message, currentPresenceFieldOffset);
                }
                presenceMask = 1 << (presenceMaskAndOffset >>> 20);
            }
            long offset = MessageSchema.offset(typeAndOffset);
            int cachedSizeOffset = fieldType >= FieldType.DOUBLE_LIST_PACKED.id() && fieldType <= FieldType.SINT64_LIST_PACKED.id() ? presenceOrCachedSizeFieldOffset : 0;
            switch (fieldType) {
                case 0: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeDoubleSize(number, 0.0);
                    continue block71;
                }
                case 1: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeFloatSize(number, 0.0f);
                    continue block71;
                }
                case 2: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeInt64Size(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 3: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeUInt64Size(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 4: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeInt32Size(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 5: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeFixed64Size(number, 0L);
                    continue block71;
                }
                case 6: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeFixed32Size(number, 0);
                    continue block71;
                }
                case 7: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeBoolSize(number, true);
                    continue block71;
                }
                case 8: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    Object value = unsafe.getObject(message, offset);
                    if (value instanceof ByteString) {
                        size += CodedOutputStream.computeBytesSize(number, (ByteString)value);
                        continue block71;
                    }
                    size += CodedOutputStream.computeStringSize(number, (String)value);
                    continue block71;
                }
                case 9: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    Object value = unsafe.getObject(message, offset);
                    size += SchemaUtil.computeSizeMessage(number, value, this.getMessageFieldSchema(i));
                    continue block71;
                }
                case 10: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    ByteString value = (ByteString)unsafe.getObject(message, offset);
                    size += CodedOutputStream.computeBytesSize(number, value);
                    continue block71;
                }
                case 11: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeUInt32Size(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 12: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeEnumSize(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 13: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeSFixed32Size(number, 0);
                    continue block71;
                }
                case 14: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeSFixed64Size(number, 0L);
                    continue block71;
                }
                case 15: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeSInt32Size(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 16: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeSInt64Size(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 17: {
                    if (!this.isFieldPresent(message, i, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    size += CodedOutputStream.computeGroupSize(number, (MessageLite)unsafe.getObject(message, offset), this.getMessageFieldSchema(i));
                    continue block71;
                }
                case 18: {
                    size += SchemaUtil.computeSizeFixed64List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 19: {
                    size += SchemaUtil.computeSizeFixed32List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 20: {
                    size += SchemaUtil.computeSizeInt64List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 21: {
                    size += SchemaUtil.computeSizeUInt64List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 22: {
                    size += SchemaUtil.computeSizeInt32List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 23: {
                    size += SchemaUtil.computeSizeFixed64List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 24: {
                    size += SchemaUtil.computeSizeFixed32List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 25: {
                    size += SchemaUtil.computeSizeBoolList(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 26: {
                    size += SchemaUtil.computeSizeStringList(number, (List)unsafe.getObject(message, offset));
                    continue block71;
                }
                case 27: {
                    size += SchemaUtil.computeSizeMessageList(number, (List)unsafe.getObject(message, offset), this.getMessageFieldSchema(i));
                    continue block71;
                }
                case 28: {
                    size += SchemaUtil.computeSizeByteStringList(number, (List)unsafe.getObject(message, offset));
                    continue block71;
                }
                case 29: {
                    size += SchemaUtil.computeSizeUInt32List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 30: {
                    size += SchemaUtil.computeSizeEnumList(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 31: {
                    size += SchemaUtil.computeSizeFixed32List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 32: {
                    size += SchemaUtil.computeSizeFixed64List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 33: {
                    size += SchemaUtil.computeSizeSInt32List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 34: {
                    size += SchemaUtil.computeSizeSInt64List(number, (List)unsafe.getObject(message, offset), false);
                    continue block71;
                }
                case 35: {
                    int fieldSize = SchemaUtil.computeSizeFixed64ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 36: {
                    int fieldSize = SchemaUtil.computeSizeFixed32ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 37: {
                    int fieldSize = SchemaUtil.computeSizeInt64ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 38: {
                    int fieldSize = SchemaUtil.computeSizeUInt64ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 39: {
                    int fieldSize = SchemaUtil.computeSizeInt32ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 40: {
                    int fieldSize = SchemaUtil.computeSizeFixed64ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 41: {
                    int fieldSize = SchemaUtil.computeSizeFixed32ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 42: {
                    int fieldSize = SchemaUtil.computeSizeBoolListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 43: {
                    int fieldSize = SchemaUtil.computeSizeUInt32ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 44: {
                    int fieldSize = SchemaUtil.computeSizeEnumListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 45: {
                    int fieldSize = SchemaUtil.computeSizeFixed32ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 46: {
                    int fieldSize = SchemaUtil.computeSizeFixed64ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 47: {
                    int fieldSize = SchemaUtil.computeSizeSInt32ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 48: {
                    int fieldSize = SchemaUtil.computeSizeSInt64ListNoTag((List)unsafe.getObject(message, offset));
                    if (fieldSize <= 0) continue block71;
                    if (this.useCachedSizeField) {
                        unsafe.putInt(message, cachedSizeOffset, fieldSize);
                    }
                    size += CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
                    continue block71;
                }
                case 49: {
                    size += SchemaUtil.computeSizeGroupList(number, (List)unsafe.getObject(message, offset), this.getMessageFieldSchema(i));
                    continue block71;
                }
                case 50: {
                    size += this.mapFieldSchema.getSerializedSize(number, unsafe.getObject(message, offset), this.getMapFieldDefaultEntry(i));
                    continue block71;
                }
                case 51: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeDoubleSize(number, 0.0);
                    continue block71;
                }
                case 52: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeFloatSize(number, 0.0f);
                    continue block71;
                }
                case 53: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeInt64Size(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 54: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeUInt64Size(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 55: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeInt32Size(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 56: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeFixed64Size(number, 0L);
                    continue block71;
                }
                case 57: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeFixed32Size(number, 0);
                    continue block71;
                }
                case 58: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeBoolSize(number, true);
                    continue block71;
                }
                case 59: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    Object value = unsafe.getObject(message, offset);
                    if (value instanceof ByteString) {
                        size += CodedOutputStream.computeBytesSize(number, (ByteString)value);
                        continue block71;
                    }
                    size += CodedOutputStream.computeStringSize(number, (String)value);
                    continue block71;
                }
                case 60: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    Object value = unsafe.getObject(message, offset);
                    size += SchemaUtil.computeSizeMessage(number, value, this.getMessageFieldSchema(i));
                    continue block71;
                }
                case 61: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeBytesSize(number, (ByteString)unsafe.getObject(message, offset));
                    continue block71;
                }
                case 62: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeUInt32Size(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 63: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeEnumSize(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 64: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeSFixed32Size(number, 0);
                    continue block71;
                }
                case 65: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeSFixed64Size(number, 0L);
                    continue block71;
                }
                case 66: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeSInt32Size(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 67: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeSInt64Size(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 68: {
                    if (!this.isOneofPresent(message, number, i)) continue block71;
                    size += CodedOutputStream.computeGroupSize(number, (MessageLite)unsafe.getObject(message, offset), this.getMessageFieldSchema(i));
                }
            }
        }
        MessageSchema messageSchema = this;
        size += messageSchema.getUnknownFieldsSerializedSize(messageSchema.unknownFieldSchema, message);
        if (this.hasExtensions) {
            void var1_1;
            size += this.extensionSchema.getExtensions(var1_1).getSerializedSize();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private <UT, UB> int getUnknownFieldsSerializedSize(UnknownFieldSchema<UT, UB> schema, T message) {
        void var2_2;
        void var1_1;
        UT unknowns = schema.getFromMessage(message);
        return var1_1.getSerializedSize(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeTo(T message, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            this.writeFieldsInDescendingOrder(message, writer);
            return;
        }
        this.writeFieldsInAscendingOrder(var1_1, (Writer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void writeFieldsInAscendingOrder(T message, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        FieldSet<?> extensions;
        Iterator<Map.Entry<?, Object>> extensionIterator = null;
        Map.Entry<?, Object> nextExtension = null;
        if (this.hasExtensions && !(extensions = this.extensionSchema.getExtensions(message)).isEmpty()) {
            extensionIterator = extensions.iterator();
            nextExtension = extensionIterator.next();
        }
        int currentPresenceFieldOffset = 1048575;
        int currentPresenceField = 0;
        int bufferLength = this.buffer.length;
        Unsafe unsafe = UNSAFE;
        block71: for (int pos = 0; pos < bufferLength; pos += 3) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            int number = this.numberAt(pos);
            int fieldType = MessageSchema.type(typeAndOffset);
            int presenceMask = 0;
            if (fieldType <= 17) {
                int presenceMaskAndOffset = this.buffer[pos + 2];
                int presenceFieldOffset = presenceMaskAndOffset & 0xFFFFF;
                if (presenceFieldOffset != currentPresenceFieldOffset) {
                    currentPresenceFieldOffset = presenceFieldOffset;
                    currentPresenceField = currentPresenceFieldOffset == 1048575 ? 0 : unsafe.getInt(message, presenceFieldOffset);
                }
                presenceMask = 1 << (presenceMaskAndOffset >>> 20);
            }
            while (nextExtension != null && this.extensionSchema.extensionNumber(nextExtension) <= number) {
                this.extensionSchema.serializeExtension(writer, nextExtension);
                nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
            }
            long offset = MessageSchema.offset(typeAndOffset);
            switch (fieldType) {
                case 0: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeDouble(number, MessageSchema.doubleAt(message, offset));
                    continue block71;
                }
                case 1: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeFloat(number, MessageSchema.floatAt(message, offset));
                    continue block71;
                }
                case 2: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeInt64(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 3: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeUInt64(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 4: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeInt32(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 5: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeFixed64(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 6: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeFixed32(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 7: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeBool(number, MessageSchema.booleanAt(message, offset));
                    continue block71;
                }
                case 8: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    this.writeString(number, unsafe.getObject(message, offset), writer);
                    continue block71;
                }
                case 9: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    Object value = unsafe.getObject(message, offset);
                    writer.writeMessage(number, value, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 10: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeBytes(number, (ByteString)unsafe.getObject(message, offset));
                    continue block71;
                }
                case 11: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeUInt32(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 12: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeEnum(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 13: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeSFixed32(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 14: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeSFixed64(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 15: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeSInt32(number, unsafe.getInt(message, offset));
                    continue block71;
                }
                case 16: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeSInt64(number, unsafe.getLong(message, offset));
                    continue block71;
                }
                case 17: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) continue block71;
                    writer.writeGroup(number, unsafe.getObject(message, offset), this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 18: {
                    SchemaUtil.writeDoubleList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 19: {
                    SchemaUtil.writeFloatList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 20: {
                    SchemaUtil.writeInt64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 21: {
                    SchemaUtil.writeUInt64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 22: {
                    SchemaUtil.writeInt32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 23: {
                    SchemaUtil.writeFixed64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 24: {
                    SchemaUtil.writeFixed32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 25: {
                    SchemaUtil.writeBoolList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 26: {
                    SchemaUtil.writeStringList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer);
                    continue block71;
                }
                case 27: {
                    SchemaUtil.writeMessageList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 28: {
                    SchemaUtil.writeBytesList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer);
                    continue block71;
                }
                case 29: {
                    SchemaUtil.writeUInt32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 30: {
                    SchemaUtil.writeEnumList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 31: {
                    SchemaUtil.writeSFixed32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 32: {
                    SchemaUtil.writeSFixed64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 33: {
                    SchemaUtil.writeSInt32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 34: {
                    SchemaUtil.writeSInt64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, false);
                    continue block71;
                }
                case 35: {
                    SchemaUtil.writeDoubleList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 36: {
                    SchemaUtil.writeFloatList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 37: {
                    SchemaUtil.writeInt64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 38: {
                    SchemaUtil.writeUInt64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 39: {
                    SchemaUtil.writeInt32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 40: {
                    SchemaUtil.writeFixed64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 41: {
                    SchemaUtil.writeFixed32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 42: {
                    SchemaUtil.writeBoolList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 43: {
                    SchemaUtil.writeUInt32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 44: {
                    SchemaUtil.writeEnumList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 45: {
                    SchemaUtil.writeSFixed32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 46: {
                    SchemaUtil.writeSFixed64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 47: {
                    SchemaUtil.writeSInt32List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 48: {
                    SchemaUtil.writeSInt64List(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, true);
                    continue block71;
                }
                case 49: {
                    SchemaUtil.writeGroupList(this.numberAt(pos), (List)unsafe.getObject(message, offset), writer, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 50: {
                    this.writeMapHelper(writer, number, unsafe.getObject(message, offset), pos);
                    continue block71;
                }
                case 51: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeDouble(number, MessageSchema.oneofDoubleAt(message, offset));
                    continue block71;
                }
                case 52: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFloat(number, MessageSchema.oneofFloatAt(message, offset));
                    continue block71;
                }
                case 53: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt64(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 54: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt64(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 55: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt32(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 56: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed64(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 57: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed32(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 58: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBool(number, MessageSchema.oneofBooleanAt(message, offset));
                    continue block71;
                }
                case 59: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    this.writeString(number, unsafe.getObject(message, offset), writer);
                    continue block71;
                }
                case 60: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    Object value = unsafe.getObject(message, offset);
                    writer.writeMessage(number, value, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 61: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBytes(number, (ByteString)unsafe.getObject(message, offset));
                    continue block71;
                }
                case 62: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt32(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 63: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeEnum(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 64: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed32(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 65: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed64(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 66: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt32(number, MessageSchema.oneofIntAt(message, offset));
                    continue block71;
                }
                case 67: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt64(number, MessageSchema.oneofLongAt(message, offset));
                    continue block71;
                }
                case 68: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeGroup(number, unsafe.getObject(message, offset), this.getMessageFieldSchema(pos));
                }
            }
        }
        while (nextExtension != null) {
            this.extensionSchema.serializeExtension(writer, nextExtension);
            nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
        }
        MessageSchema messageSchema = this;
        messageSchema.writeUnknownInMessageTo(messageSchema.unknownFieldSchema, var1_1, (Writer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void writeFieldsInDescendingOrder(T message, Writer writer) throws IOException {
        FieldSet<?> extensions;
        MessageSchema messageSchema = this;
        messageSchema.writeUnknownInMessageTo(messageSchema.unknownFieldSchema, message, writer);
        Iterator<Map.Entry<?, Object>> extensionIterator = null;
        Map.Entry<?, Object> nextExtension = null;
        if (this.hasExtensions && !(extensions = this.extensionSchema.getExtensions(message)).isEmpty()) {
            extensionIterator = extensions.descendingIterator();
            nextExtension = extensionIterator.next();
        }
        block71: for (int pos = this.buffer.length - 3; pos >= 0; pos -= 3) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            int number = this.numberAt(pos);
            while (nextExtension != null && this.extensionSchema.extensionNumber(nextExtension) > number) {
                this.extensionSchema.serializeExtension(writer, nextExtension);
                nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
            }
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeDouble(number, MessageSchema.doubleAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 1: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFloat(number, MessageSchema.floatAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 2: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 3: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeUInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 4: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeInt32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 5: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFixed64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 6: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFixed32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 7: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeBool(number, MessageSchema.booleanAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 8: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    this.writeString(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 9: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    Object value = UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
                    writer.writeMessage(number, value, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 10: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeBytes(number, (ByteString)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 11: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeUInt32(number, MessageSchema.intAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 12: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeEnum(number, MessageSchema.intAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 13: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSFixed32(number, MessageSchema.intAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 14: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSFixed64(number, MessageSchema.longAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 15: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSInt32(number, MessageSchema.intAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 16: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSInt64(number, MessageSchema.longAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 17: {
                    void value;
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeGroup(number, UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 18: {
                    void value;
                    SchemaUtil.writeDoubleList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 19: {
                    void value;
                    SchemaUtil.writeFloatList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 20: {
                    void value;
                    SchemaUtil.writeInt64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 21: {
                    void value;
                    SchemaUtil.writeUInt64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 22: {
                    void value;
                    SchemaUtil.writeInt32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 23: {
                    void value;
                    SchemaUtil.writeFixed64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 24: {
                    void value;
                    SchemaUtil.writeFixed32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 25: {
                    void value;
                    SchemaUtil.writeBoolList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 26: {
                    void value;
                    SchemaUtil.writeStringList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer);
                    continue block71;
                }
                case 27: {
                    void value;
                    SchemaUtil.writeMessageList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 28: {
                    void value;
                    SchemaUtil.writeBytesList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer);
                    continue block71;
                }
                case 29: {
                    void value;
                    SchemaUtil.writeUInt32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 30: {
                    void value;
                    SchemaUtil.writeEnumList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 31: {
                    void value;
                    SchemaUtil.writeSFixed32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 32: {
                    void value;
                    SchemaUtil.writeSFixed64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 33: {
                    void value;
                    SchemaUtil.writeSInt32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 34: {
                    void value;
                    SchemaUtil.writeSInt64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, false);
                    continue block71;
                }
                case 35: {
                    void value;
                    SchemaUtil.writeDoubleList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 36: {
                    void value;
                    SchemaUtil.writeFloatList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 37: {
                    void value;
                    SchemaUtil.writeInt64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 38: {
                    void value;
                    SchemaUtil.writeUInt64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 39: {
                    void value;
                    SchemaUtil.writeInt32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 40: {
                    void value;
                    SchemaUtil.writeFixed64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 41: {
                    void value;
                    SchemaUtil.writeFixed32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 42: {
                    void value;
                    SchemaUtil.writeBoolList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 43: {
                    void value;
                    SchemaUtil.writeUInt32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 44: {
                    void value;
                    SchemaUtil.writeEnumList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 45: {
                    void value;
                    SchemaUtil.writeSFixed32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 46: {
                    void value;
                    SchemaUtil.writeSFixed64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 47: {
                    void value;
                    SchemaUtil.writeSInt32List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 48: {
                    void value;
                    SchemaUtil.writeSInt64List(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, true);
                    continue block71;
                }
                case 49: {
                    void value;
                    SchemaUtil.writeGroupList(this.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 50: {
                    void value;
                    this.writeMapHelper(writer, number, UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), pos);
                    continue block71;
                }
                case 51: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeDouble(number, MessageSchema.oneofDoubleAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 52: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFloat(number, MessageSchema.oneofFloatAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 53: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 54: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 55: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 56: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 57: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 58: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBool(number, MessageSchema.oneofBooleanAt(message, MessageSchema.offset((int)value)));
                    continue block71;
                }
                case 59: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    this.writeString(number, UnsafeUtil.getObject(message, MessageSchema.offset((int)value)), writer);
                    continue block71;
                }
                case 60: {
                    void value;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    Object value2 = UnsafeUtil.getObject(message, MessageSchema.offset((int)value));
                    writer.writeMessage(number, value2, this.getMessageFieldSchema(pos));
                    continue block71;
                }
                case 61: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBytes(number, (ByteString)UnsafeUtil.getObject(message, MessageSchema.offset((int)var6_7)));
                    continue block71;
                }
                case 62: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset((int)var6_7)));
                    continue block71;
                }
                case 63: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeEnum(number, MessageSchema.oneofIntAt(message, MessageSchema.offset((int)var6_7)));
                    continue block71;
                }
                case 64: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset((int)var6_7)));
                    continue block71;
                }
                case 65: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset((int)var6_7)));
                    continue block71;
                }
                case 66: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset((int)var6_7)));
                    continue block71;
                }
                case 67: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset((int)var6_7)));
                    continue block71;
                }
                case 68: {
                    void var6_7;
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeGroup(number, UnsafeUtil.getObject(message, MessageSchema.offset((int)var6_7)), this.getMessageFieldSchema(pos));
                }
            }
        }
        while (nextExtension != null) {
            this.extensionSchema.serializeExtension(writer, nextExtension);
            nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> void writeMapHelper(Writer writer, int number, Object mapField, int pos) throws IOException {
        if (mapField != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            var1_1.writeMap((int)var2_2, this.mapFieldSchema.forMapMetadata(this.getMapFieldDefaultEntry(pos)), this.mapFieldSchema.forMapData(var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private <UT, UB> void writeUnknownInMessageTo(UnknownFieldSchema<UT, UB> schema, T message, Writer writer) throws IOException {
        void var3_3;
        void var2_2;
        UnknownFieldSchema<UT, UB> unknownFieldSchema = schema;
        unknownFieldSchema.writeTo(unknownFieldSchema.getFromMessage(var2_2), (Writer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mergeFrom(T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        MessageSchema.checkMutable(message);
        MessageSchema messageSchema = this;
        messageSchema.mergeFromHelper(messageSchema.unknownFieldSchema, this.extensionSchema, var1_1, (Reader)var2_2, (ExtensionRegistryLite)var3_3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> void mergeFromHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, ExtensionSchema<ET> extensionSchema, T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        unknownFields = null;
        extensions = null;
        block79: while (true) {
            number = reader.getFieldNumber();
            pos = this.positionForFieldNumber(number);
            if (pos >= 0) ** GOTO lbl44
            if (number == 0x7FFFFFFF) {
            }
            ** GOTO lbl-1000
            {
                block102: {
                    catch (Throwable var2_3) {
                        for (i = this.checkInitializedCount; i < this.repeatedFieldOffsetStart; ++i) {
                            unknownFields = this.filterMapUnknownEnumValues(message, this.intArray[i], unknownFields, unknownFieldSchema, message);
                        }
                        if (unknownFields != null) {
                            var1_1.setBuilderToMessage(var3_4, unknownFields);
                        }
                        throw var2_3;
                    }
                    for (i = this.checkInitializedCount; i < this.repeatedFieldOffsetStart; ++i) {
                        unknownFields = this.filterMapUnknownEnumValues(message, this.intArray[i], unknownFields, unknownFieldSchema, message);
                    }
                    if (unknownFields != null) {
                        unknownFieldSchema.setBuilderToMessage(message, unknownFields);
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        extension = this.hasExtensions == false ? null : extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, number);
                        if (extension != null) {
                            if (extensions == null) {
                                extensions = extensionSchema.getMutableExtensions(message);
                            }
                            unknownFields = extensionSchema.parseExtension(message, reader, extension, extensionRegistry, extensions, unknownFields, unknownFieldSchema);
                            continue;
                        }
                        if (unknownFieldSchema.shouldDiscardUnknownFields(reader)) {
                            if (reader.skipField()) {
                                continue;
                            }
                            break block102;
                        }
                        if (unknownFields == null) {
                            unknownFields = unknownFieldSchema.getBuilderFromMessage(message);
                        }
                        if (unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader, 0)) continue;
                    }
                }
                for (i = this.checkInitializedCount; i < this.repeatedFieldOffsetStart; ++i) {
                    unknownFields = this.filterMapUnknownEnumValues(message, this.intArray[i], unknownFields, unknownFieldSchema, message);
                }
                if (unknownFields != null) {
                    unknownFieldSchema.setBuilderToMessage(message, unknownFields);
                }
                return;
lbl44:
                // 1 sources

                typeAndOffset = this.typeAndOffsetAt(pos);
                switch (MessageSchema.type(typeAndOffset)) {
                    case 0: {
                        UnsafeUtil.putDouble(message, MessageSchema.offset(typeAndOffset), reader.readDouble());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 1: {
                        UnsafeUtil.putFloat(message, MessageSchema.offset(typeAndOffset), reader.readFloat());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 2: {
                        UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readInt64());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 3: {
                        UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readUInt64());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 4: {
                        UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readInt32());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 5: {
                        UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readFixed64());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 6: {
                        UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readFixed32());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 7: {
                        UnsafeUtil.putBoolean(message, MessageSchema.offset(typeAndOffset), reader.readBool());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 8: {
                        this.readString(message, typeAndOffset, reader);
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 9: {
                        current = (MessageLite)this.mutableMessageFieldForMerge(message, pos);
                        reader.mergeMessageField(current, this.getMessageFieldSchema(pos), extensionRegistry);
                        this.storeMessageField(message, pos, current);
                        continue block79;
                    }
                    case 10: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readBytes());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 11: {
                        UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readUInt32());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 12: {
                        enumValue = reader.readEnum();
                        enumVerifier = this.getEnumFieldVerifier(pos);
                        if (enumVerifier == null || enumVerifier.isInRange(enumValue)) {
                            UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), enumValue);
                            this.setFieldPresent(message, pos);
                            continue block79;
                        }
                        unknownFields = SchemaUtil.storeUnknownEnum(message, number, enumValue, unknownFields, unknownFieldSchema);
                        continue block79;
                    }
                    case 13: {
                        UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readSFixed32());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 14: {
                        UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readSFixed64());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 15: {
                        UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readSInt32());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 16: {
                        UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readSInt64());
                        this.setFieldPresent(message, pos);
                        continue block79;
                    }
                    case 17: {
                        current = (MessageLite)this.mutableMessageFieldForMerge(message, pos);
                        reader.mergeGroupField(current, this.getMessageFieldSchema(pos), extensionRegistry);
                        this.storeMessageField(message, pos, current);
                        continue block79;
                    }
                    case 18: {
                        reader.readDoubleList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 19: {
                        reader.readFloatList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 20: {
                        reader.readInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 21: {
                        reader.readUInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 22: {
                        reader.readInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 23: {
                        reader.readFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 24: {
                        reader.readFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 25: {
                        reader.readBoolList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 26: {
                        this.readStringList(message, typeAndOffset, reader);
                        continue block79;
                    }
                    case 27: {
                        this.readMessageList(message, typeAndOffset, reader, this.getMessageFieldSchema(pos), extensionRegistry);
                        continue block79;
                    }
                    case 28: {
                        reader.readBytesList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 29: {
                        reader.readUInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 30: {
                        enumList = this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset));
                        reader.readEnumList(enumList);
                        unknownFields = SchemaUtil.filterUnknownEnumList(message, number, enumList, this.getEnumFieldVerifier(pos), unknownFields, unknownFieldSchema);
                        continue block79;
                    }
                    case 31: {
                        reader.readSFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 32: {
                        reader.readSFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 33: {
                        reader.readSInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 34: {
                        reader.readSInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 35: {
                        reader.readDoubleList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 36: {
                        reader.readFloatList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 37: {
                        reader.readInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 38: {
                        reader.readUInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 39: {
                        reader.readInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 40: {
                        reader.readFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 41: {
                        reader.readFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 42: {
                        reader.readBoolList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 43: {
                        reader.readUInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 44: {
                        enumList = this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset));
                        reader.readEnumList(enumList);
                        unknownFields = SchemaUtil.filterUnknownEnumList(message, number, enumList, this.getEnumFieldVerifier(pos), unknownFields, unknownFieldSchema);
                        continue block79;
                    }
                    case 45: {
                        reader.readSFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 46: {
                        reader.readSFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 47: {
                        reader.readSInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 48: {
                        reader.readSInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                        continue block79;
                    }
                    case 49: {
                        this.readGroupList(message, MessageSchema.offset(typeAndOffset), reader, this.getMessageFieldSchema(pos), extensionRegistry);
                        continue block79;
                    }
                    case 50: {
                        this.mergeMap(message, pos, this.getMapFieldDefaultEntry(pos), extensionRegistry, reader);
                        continue block79;
                    }
                    case 51: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readDouble());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 52: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)Float.valueOf(reader.readFloat()));
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 53: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readInt64());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 54: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readUInt64());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 55: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readInt32());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 56: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readFixed64());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 57: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readFixed32());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 58: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readBool());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 59: {
                        this.readString(message, typeAndOffset, reader);
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 60: {
                        current = (MessageLite)this.mutableOneofMessageFieldForMerge(message, number, pos);
                        reader.mergeMessageField(current, this.getMessageFieldSchema(pos), extensionRegistry);
                        this.storeOneofMessageField(message, number, pos, current);
                        continue block79;
                    }
                    case 61: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readBytes());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 62: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readUInt32());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 63: {
                        enumValue = reader.readEnum();
                        enumVerifier = this.getEnumFieldVerifier(pos);
                        if (enumVerifier == null || enumVerifier.isInRange(enumValue)) {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)enumValue);
                            this.setOneofPresent(message, number, pos);
                            continue block79;
                        }
                        unknownFields = SchemaUtil.storeUnknownEnum(message, number, enumValue, unknownFields, unknownFieldSchema);
                        continue block79;
                    }
                    case 64: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSFixed32());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 65: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSFixed64());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 66: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSInt32());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 67: {
                        UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSInt64());
                        this.setOneofPresent(message, number, pos);
                        continue block79;
                    }
                    case 68: {
                        current = (MessageLite)this.mutableOneofMessageFieldForMerge(message, number, pos);
                        reader.mergeGroupField(current, this.getMessageFieldSchema(pos), extensionRegistry);
                        this.storeOneofMessageField(message, number, pos, current);
                        continue block79;
                    }
                }
                if (unknownFields == null) {
                    unknownFields = unknownFieldSchema.getBuilderFromMessage(message);
                }
                if (unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader, 0)) continue;
                for (i = this.checkInitializedCount; i < this.repeatedFieldOffsetStart; ++i) {
                    unknownFields = this.filterMapUnknownEnumValues(message, this.intArray[i], unknownFields, unknownFieldSchema, message);
                }
                if (unknownFields != null) {
                    unknownFieldSchema.setBuilderToMessage(message, unknownFields);
                }
                return;
                {
                    catch (InvalidProtocolBufferException.InvalidWireTypeException v0) {}
                    if (!unknownFieldSchema.shouldDiscardUnknownFields(reader)) ** GOTO lbl-1000
                    if (reader.skipField()) continue;
                }
                for (i = this.checkInitializedCount; i < this.repeatedFieldOffsetStart; ++i) {
                    unknownFields = this.filterMapUnknownEnumValues(message, this.intArray[i], unknownFields, unknownFieldSchema, message);
                }
                if (unknownFields != null) {
                    unknownFieldSchema.setBuilderToMessage(message, unknownFields);
                }
                return;
lbl-1000:
                // 1 sources

                {
                    if (unknownFields == null) {
                        unknownFields = unknownFieldSchema.getBuilderFromMessage(message);
                    }
                    if (!unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader, 0)) ** break;
                    continue;
                }
                for (i = this.checkInitializedCount; i < this.repeatedFieldOffsetStart; ++i) {
                    unknownFields = this.filterMapUnknownEnumValues(message, this.intArray[i], unknownFields, unknownFieldSchema, message);
                }
                if (unknownFields != null) {
                    unknownFieldSchema.setBuilderToMessage(message, unknownFields);
                }
                return;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    static UnknownFieldSetLite getMutableUnknownFields(Object message) {
        void var1_1;
        UnknownFieldSetLite unknownFields = ((GeneratedMessageLite)message).unknownFields;
        if (unknownFields == UnknownFieldSetLite.getDefaultInstance()) {
            ((GeneratedMessageLite)var0).unknownFields = unknownFields = UnknownFieldSetLite.newInstance();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int decodeMapEntryValue(byte[] data, int position, int limit, WireFormat.FieldType fieldType, Class<?> messageType, ArrayDecoders.Registers registers) throws IOException {
        void var2_2;
        switch (fieldType) {
            case BOOL: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                registers.object1 = registers.long1 != 0L;
                break;
            }
            case BYTES: {
                position = ArrayDecoders.decodeBytes(data, position, registers);
                break;
            }
            case DOUBLE: {
                registers.object1 = ArrayDecoders.decodeDouble(data, position);
                position += 8;
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                registers.object1 = ArrayDecoders.decodeFixed32(data, position);
                position += 4;
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                registers.object1 = ArrayDecoders.decodeFixed64(data, position);
                position += 8;
                break;
            }
            case FLOAT: {
                registers.object1 = Float.valueOf(ArrayDecoders.decodeFloat(data, position));
                position += 4;
                break;
            }
            case ENUM: 
            case INT32: 
            case UINT32: {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                registers.object1 = registers.int1;
                break;
            }
            case INT64: 
            case UINT64: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                registers.object1 = registers.long1;
                break;
            }
            case MESSAGE: {
                void var3_3;
                position = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(messageType), data, position, (int)var3_3, registers);
                break;
            }
            case SINT32: {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                registers.object1 = CodedInputStream.decodeZigZag32(registers.int1);
                break;
            }
            case SINT64: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                registers.object1 = CodedInputStream.decodeZigZag64(registers.long1);
                break;
            }
            case STRING: {
                void var1_1;
                position = ArrayDecoders.decodeStringRequireUtf8((byte[])var1_1, position, registers);
                break;
            }
            default: {
                throw new RuntimeException("unsupported field type.");
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> int decodeMapEntry(byte[] data, int position, int limit, MapEntryLite.Metadata<K, V> metadata, Map<K, V> target, ArrayDecoders.Registers registers) throws IOException {
        void var2_2;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0 || length > limit - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int end = position + length;
        Object key = metadata.defaultKey;
        Object value = metadata.defaultValue;
        block4: while (position < end) {
            int tag;
            if ((tag = data[position++]) < 0) {
                position = ArrayDecoders.decodeVarint32(tag, data, position, registers);
                tag = registers.int1;
            }
            int fieldNumber = tag >>> 3;
            int wireType = tag & 7;
            switch (fieldNumber) {
                case 1: {
                    if (wireType != metadata.keyType.getWireType()) break;
                    position = this.decodeMapEntryValue(data, position, limit, metadata.keyType, null, registers);
                    key = registers.object1;
                    continue block4;
                }
                case 2: {
                    if (wireType != metadata.valueType.getWireType()) break;
                    position = this.decodeMapEntryValue(data, position, limit, metadata.valueType, metadata.defaultValue.getClass(), registers);
                    value = registers.object1;
                    continue block4;
                }
            }
            position = ArrayDecoders.skipField(tag, data, position, limit, registers);
        }
        if (var2_2 != end) {
            throw InvalidProtocolBufferException.parseFailure();
        }
        target.put(key, value);
        return end;
    }

    /*
     * WARNING - void declaration
     */
    private int parseRepeatedField(T message, byte[] data, int position, int limit, int tag, int number, int wireType, int bufferPosition, long typeAndOffset, int fieldType, long fieldOffset, ArrayDecoders.Registers registers) throws IOException {
        void var3_3;
        Internal.ProtobufList<Integer> list = (Internal.ProtobufList<Integer>)UNSAFE.getObject(message, fieldOffset);
        if (!list.isModifiable()) {
            int size = list.size();
            list = list.mutableCopyWithCapacity(size == 0 ? 10 : size << 1);
            UNSAFE.putObject(message, fieldOffset, list);
        }
        switch (fieldType) {
            case 18: 
            case 35: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedDoubleList(data, position, list, registers);
                    break;
                }
                if (wireType != 1) break;
                position = ArrayDecoders.decodeDoubleList(tag, data, position, limit, list, registers);
                break;
            }
            case 19: 
            case 36: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedFloatList(data, position, list, registers);
                    break;
                }
                if (wireType != 5) break;
                position = ArrayDecoders.decodeFloatList(tag, data, position, limit, list, registers);
                break;
            }
            case 20: 
            case 21: 
            case 37: 
            case 38: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedVarint64List(data, position, list, registers);
                    break;
                }
                if (wireType != 0) break;
                position = ArrayDecoders.decodeVarint64List(tag, data, position, limit, list, registers);
                break;
            }
            case 22: 
            case 29: 
            case 39: 
            case 43: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedVarint32List(data, position, list, registers);
                    break;
                }
                if (wireType != 0) break;
                position = ArrayDecoders.decodeVarint32List(tag, data, position, limit, list, registers);
                break;
            }
            case 23: 
            case 32: 
            case 40: 
            case 46: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedFixed64List(data, position, list, registers);
                    break;
                }
                if (wireType != 1) break;
                position = ArrayDecoders.decodeFixed64List(tag, data, position, limit, list, registers);
                break;
            }
            case 24: 
            case 31: 
            case 41: 
            case 45: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedFixed32List(data, position, list, registers);
                    break;
                }
                if (wireType != 5) break;
                position = ArrayDecoders.decodeFixed32List(tag, data, position, limit, list, registers);
                break;
            }
            case 25: 
            case 42: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedBoolList(data, position, list, registers);
                    break;
                }
                if (wireType != 0) break;
                position = ArrayDecoders.decodeBoolList(tag, data, position, limit, list, registers);
                break;
            }
            case 26: {
                if (wireType != 2) break;
                if ((typeAndOffset & 0x20000000L) == 0L) {
                    position = ArrayDecoders.decodeStringList(tag, data, position, limit, list, registers);
                    break;
                }
                position = ArrayDecoders.decodeStringListRequireUtf8(tag, data, position, limit, list, registers);
                break;
            }
            case 27: {
                if (wireType != 2) break;
                position = ArrayDecoders.decodeMessageList(this.getMessageFieldSchema(bufferPosition), tag, data, position, limit, list, registers);
                break;
            }
            case 28: {
                if (wireType != 2) break;
                position = ArrayDecoders.decodeBytesList(tag, data, position, limit, list, registers);
                break;
            }
            case 30: 
            case 44: {
                void var1_1;
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedVarint32List(data, position, list, registers);
                } else {
                    if (wireType != 0) break;
                    position = ArrayDecoders.decodeVarint32List(tag, data, position, limit, list, registers);
                }
                SchemaUtil.filterUnknownEnumList((Object)var1_1, number, list, this.getEnumFieldVerifier(bufferPosition), null, this.unknownFieldSchema);
                break;
            }
            case 33: 
            case 47: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedSInt32List(data, position, list, registers);
                    break;
                }
                if (wireType != 0) break;
                position = ArrayDecoders.decodeSInt32List(tag, data, position, limit, list, registers);
                break;
            }
            case 34: 
            case 48: {
                if (wireType == 2) {
                    position = ArrayDecoders.decodePackedSInt64List(data, position, list, registers);
                    break;
                }
                if (wireType != 0) break;
                position = ArrayDecoders.decodeSInt64List(tag, data, position, limit, list, registers);
                break;
            }
            case 49: {
                void var2_2;
                if (wireType != 3) break;
                position = ArrayDecoders.decodeGroupList(this.getMessageFieldSchema(bufferPosition), tag, (byte[])var2_2, position, limit, list, registers);
            }
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> int parseMapField(T message, byte[] data, int position, int limit, int bufferPosition, long fieldOffset, ArrayDecoders.Registers registers) throws IOException {
        void var3_3;
        void var2_2;
        Unsafe unsafe = UNSAFE;
        Object mapDefaultEntry = this.getMapFieldDefaultEntry(bufferPosition);
        Object mapField = unsafe.getObject(message, fieldOffset);
        if (this.mapFieldSchema.isImmutable(mapField)) {
            void var1_1;
            Object oldMapField = mapField;
            mapField = this.mapFieldSchema.newMapField(mapDefaultEntry);
            this.mapFieldSchema.mergeFrom(mapField, oldMapField);
            unsafe.putObject(var1_1, fieldOffset, mapField);
        }
        return this.decodeMapEntry((byte[])var2_2, (int)var3_3, limit, this.mapFieldSchema.forMapMetadata(mapDefaultEntry), this.mapFieldSchema.forMutableMapData(mapField), registers);
    }

    /*
     * WARNING - void declaration
     */
    private int parseOneofField(T message, byte[] data, int position, int limit, int tag, int number, int wireType, int typeAndOffset, int fieldType, long fieldOffset, int bufferPosition, ArrayDecoders.Registers registers) throws IOException {
        void var3_3;
        Unsafe unsafe = UNSAFE;
        long oneofCaseOffset = this.buffer[bufferPosition + 2] & 0xFFFFF;
        switch (fieldType) {
            case 51: {
                if (wireType != 1) break;
                unsafe.putObject(message, fieldOffset, ArrayDecoders.decodeDouble(data, position));
                position += 8;
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 52: {
                if (wireType != 5) break;
                unsafe.putObject(message, fieldOffset, Float.valueOf(ArrayDecoders.decodeFloat(data, position)));
                position += 4;
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 53: 
            case 54: {
                if (wireType != 0) break;
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                unsafe.putObject(message, fieldOffset, registers.long1);
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 55: 
            case 62: {
                if (wireType != 0) break;
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                unsafe.putObject(message, fieldOffset, registers.int1);
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 56: 
            case 65: {
                if (wireType != 1) break;
                unsafe.putObject(message, fieldOffset, ArrayDecoders.decodeFixed64(data, position));
                position += 8;
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 57: 
            case 64: {
                if (wireType != 5) break;
                unsafe.putObject(message, fieldOffset, ArrayDecoders.decodeFixed32(data, position));
                position += 4;
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 58: {
                if (wireType != 0) break;
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                unsafe.putObject(message, fieldOffset, registers.long1 != 0L);
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 59: {
                if (wireType != 2) break;
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                int length = registers.int1;
                if (length == 0) {
                    unsafe.putObject(message, fieldOffset, "");
                } else {
                    if ((typeAndOffset & 0x20000000) != 0) {
                        int n = position;
                        if (!Utf8.isValidUtf8(data, n, n + length)) {
                            throw InvalidProtocolBufferException.invalidUtf8();
                        }
                    }
                    String value = new String(data, position, length, Internal.UTF_8);
                    unsafe.putObject(message, fieldOffset, value);
                    position += length;
                }
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 60: {
                int length;
                if (length != 2) break;
                Object current = this.mutableOneofMessageFieldForMerge(message, number, bufferPosition);
                position = ArrayDecoders.mergeMessageField(current, this.getMessageFieldSchema(bufferPosition), data, position, limit, registers);
                this.storeOneofMessageField(message, number, bufferPosition, current);
                break;
            }
            case 61: {
                void current;
                if (current != 2) break;
                position = ArrayDecoders.decodeBytes(data, position, registers);
                unsafe.putObject(message, fieldOffset, registers.object1);
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 63: {
                void current;
                if (current != false) break;
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                int enumValue = registers.int1;
                Internal.EnumVerifier enumVerifier = this.getEnumFieldVerifier(bufferPosition);
                if (enumVerifier == null || enumVerifier.isInRange(enumValue)) {
                    unsafe.putObject(message, fieldOffset, enumValue);
                    unsafe.putInt(message, oneofCaseOffset, number);
                    break;
                }
                MessageSchema.getMutableUnknownFields(message).storeField(tag, enumValue);
                break;
            }
            case 66: {
                int enumValue;
                if (enumValue != false) break;
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                unsafe.putObject(message, fieldOffset, CodedInputStream.decodeZigZag32(registers.int1));
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 67: {
                int enumValue;
                if (enumValue != false) break;
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                unsafe.putObject(message, fieldOffset, CodedInputStream.decodeZigZag64(registers.long1));
                unsafe.putInt(message, oneofCaseOffset, number);
                break;
            }
            case 68: {
                void var1_1;
                void var2_2;
                int enumValue;
                if (enumValue != 3) break;
                Object current = this.mutableOneofMessageFieldForMerge(message, number, bufferPosition);
                int endTag = tag & 0xFFFFFFF8 | 4;
                position = ArrayDecoders.mergeGroupField(current, this.getMessageFieldSchema(bufferPosition), (byte[])var2_2, position, limit, endTag, registers);
                this.storeOneofMessageField(var1_1, number, bufferPosition, current);
            }
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Schema getMessageFieldSchema(int pos) {
        void var2_2;
        int index = pos / 3 << 1;
        Schema<Class> schema = (Schema<Class>)this.objects[index];
        if (schema != null) {
            return schema;
        }
        this.objects[var1_1] = schema = Protobuf.getInstance().schemaFor((Class)this.objects[index + 1]);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object getMapFieldDefaultEntry(int pos) {
        void var1_1;
        return this.objects[var1_1 / 3 << 1];
    }

    /*
     * WARNING - void declaration
     */
    private Internal.EnumVerifier getEnumFieldVerifier(int pos) {
        void var1_1;
        return (Internal.EnumVerifier)this.objects[(var1_1 / 3 << 1) + true];
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    final int parseMessage(T message, byte[] data, int position, int limit, int endDelimited, ArrayDecoders.Registers registers) throws IOException {
        void var3_3;
        MessageSchema.checkMutable(message);
        Unsafe unsafe = UNSAFE;
        int currentPresenceFieldOffset = 1048575;
        int currentPresenceField = 0;
        int tag = 0;
        int oldNumber = -1;
        int pos = 0;
        block16: while (position < limit) {
            if ((tag = data[position++]) < 0) {
                position = ArrayDecoders.decodeVarint32(tag, data, position, registers);
                tag = registers.int1;
            }
            int number = tag >>> 3;
            int wireType = tag & 7;
            pos = number > oldNumber ? this.positionForFieldNumber(number, pos / 3) : this.positionForFieldNumber(number);
            oldNumber = number;
            if (pos == -1) {
                pos = 0;
            } else {
                int endTag;
                void current3;
                int typeAndOffset = this.buffer[pos + 1];
                int fieldType = MessageSchema.type(typeAndOffset);
                long fieldOffset = MessageSchema.offset(typeAndOffset);
                if (fieldType <= 17) {
                    int presenceMaskAndOffset = this.buffer[pos + 2];
                    int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
                    int presenceFieldOffset = presenceMaskAndOffset & 0xFFFFF;
                    if (presenceFieldOffset != currentPresenceFieldOffset) {
                        if (currentPresenceFieldOffset != 1048575) {
                            unsafe.putInt(message, currentPresenceFieldOffset, currentPresenceField);
                        }
                        currentPresenceFieldOffset = presenceFieldOffset;
                        currentPresenceField = presenceFieldOffset == 1048575 ? 0 : unsafe.getInt(message, presenceFieldOffset);
                    }
                    switch (fieldType) {
                        case 0: {
                            if (wireType != 1) break;
                            UnsafeUtil.putDouble(message, fieldOffset, ArrayDecoders.decodeDouble(data, position));
                            position += 8;
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 1: {
                            if (wireType != 5) break;
                            UnsafeUtil.putFloat(message, fieldOffset, ArrayDecoders.decodeFloat(data, position));
                            position += 4;
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 2: 
                        case 3: {
                            if (wireType != 0) break;
                            position = ArrayDecoders.decodeVarint64(data, position, registers);
                            unsafe.putLong(message, fieldOffset, registers.long1);
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 4: 
                        case 11: {
                            if (wireType != 0) break;
                            position = ArrayDecoders.decodeVarint32(data, position, registers);
                            unsafe.putInt(message, fieldOffset, registers.int1);
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 5: 
                        case 14: {
                            if (wireType != 1) break;
                            unsafe.putLong(message, fieldOffset, ArrayDecoders.decodeFixed64(data, position));
                            position += 8;
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 6: 
                        case 13: {
                            if (wireType != 5) break;
                            unsafe.putInt(message, fieldOffset, ArrayDecoders.decodeFixed32(data, position));
                            position += 4;
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 7: {
                            if (wireType != 0) break;
                            position = ArrayDecoders.decodeVarint64(data, position, registers);
                            UnsafeUtil.putBoolean(message, fieldOffset, registers.long1 != 0L);
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 8: {
                            if (wireType != 2) break;
                            position = MessageSchema.isEnforceUtf8(typeAndOffset) ? ArrayDecoders.decodeStringRequireUtf8(data, position, registers) : ArrayDecoders.decodeString(data, position, registers);
                            unsafe.putObject(message, fieldOffset, registers.object1);
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 9: {
                            if (wireType != 2) break;
                            Object current2 = this.mutableMessageFieldForMerge(message, pos);
                            position = ArrayDecoders.mergeMessageField(current2, this.getMessageFieldSchema(pos), data, position, limit, registers);
                            this.storeMessageField(message, pos, current2);
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 10: {
                            if (current3 != 2) break;
                            position = ArrayDecoders.decodeBytes(data, position, registers);
                            unsafe.putObject(message, fieldOffset, registers.object1);
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 12: {
                            if (current3 != false) break;
                            position = ArrayDecoders.decodeVarint32(data, position, registers);
                            int enumValue = registers.int1;
                            Internal.EnumVerifier enumVerifier = this.getEnumFieldVerifier(pos);
                            if (!MessageSchema.isLegacyEnumIsClosed(typeAndOffset) || enumVerifier == null || enumVerifier.isInRange(enumValue)) {
                                unsafe.putInt(message, fieldOffset, enumValue);
                                currentPresenceField |= presenceMask;
                                continue block16;
                            }
                            MessageSchema.getMutableUnknownFields(message).storeField(tag, enumValue);
                            continue block16;
                        }
                        case 15: {
                            int enumValue;
                            if (enumValue != false) break;
                            position = ArrayDecoders.decodeVarint32(data, position, registers);
                            unsafe.putInt(message, fieldOffset, CodedInputStream.decodeZigZag32(registers.int1));
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 16: {
                            int enumValue;
                            if (enumValue != false) break;
                            position = ArrayDecoders.decodeVarint64(data, position, registers);
                            unsafe.putLong(message, fieldOffset, CodedInputStream.decodeZigZag64(registers.long1));
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                        case 17: {
                            void enumVerifier;
                            int enumValue;
                            if (enumValue != 3) break;
                            Object current3 = this.mutableMessageFieldForMerge(message, pos);
                            endTag = enumVerifier << 3 | 4;
                            position = ArrayDecoders.mergeGroupField(current3, this.getMessageFieldSchema(pos), data, position, limit, endTag, registers);
                            this.storeMessageField(message, pos, current3);
                            currentPresenceField |= presenceMask;
                            continue block16;
                        }
                    }
                } else if (fieldType == 27) {
                    if (current3 == 2) {
                        Internal.ProtobufList list = (Internal.ProtobufList)unsafe.getObject(message, fieldOffset);
                        if (!list.isModifiable()) {
                            int size = list.size();
                            list = list.mutableCopyWithCapacity(size == 0 ? 10 : size << 1);
                            unsafe.putObject(message, fieldOffset, list);
                        }
                        position = ArrayDecoders.decodeMessageList(this.getMessageFieldSchema(pos), tag, data, position, limit, list, registers);
                        continue;
                    }
                } else if (fieldType <= 49) {
                    int oldPosition = position;
                    if ((position = this.parseRepeatedField(message, data, position, limit, tag, endTag, (int)current3, pos, typeAndOffset, fieldType, fieldOffset, registers)) != oldPosition) continue;
                } else if (fieldType == 50) {
                    if (current3 == 2) {
                        int oldPosition = position;
                        if ((position = this.parseMapField(message, data, position, limit, pos, fieldOffset, registers)) != oldPosition) continue;
                    }
                } else {
                    int oldPosition = position;
                    if ((position = this.parseOneofField(message, data, position, limit, tag, endTag, (int)current3, typeAndOffset, fieldType, fieldOffset, pos, registers)) != oldPosition) continue;
                }
            }
            if (tag == endDelimited && endDelimited != 0) break;
            if (this.hasExtensions && registers.extensionRegistry != ExtensionRegistryLite.getEmptyRegistry()) {
                position = ArrayDecoders.decodeExtensionOrUnknownField(tag, data, position, limit, message, this.defaultInstance, this.unknownFieldSchema, registers);
                continue;
            }
            position = ArrayDecoders.decodeUnknownField(tag, data, position, limit, MessageSchema.getMutableUnknownFields(message), registers);
        }
        if (currentPresenceFieldOffset != 1048575) {
            unsafe.putInt(message, currentPresenceFieldOffset, currentPresenceField);
        }
        UnknownFieldSetLite unknownFields = null;
        for (int i = this.checkInitializedCount; i < this.repeatedFieldOffsetStart; ++i) {
            unknownFields = this.filterMapUnknownEnumValues(message, this.intArray[i], unknownFields, this.unknownFieldSchema, message);
        }
        if (unknownFields != null) {
            void var1_1;
            this.unknownFieldSchema.setBuilderToMessage(var1_1, unknownFields);
        }
        if (endDelimited == 0 ? position != limit : position > limit || tag != endDelimited) {
            throw InvalidProtocolBufferException.parseFailure();
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Object mutableMessageFieldForMerge(T message, int pos) {
        void var2_3;
        Schema fieldSchema = this.getMessageFieldSchema(pos);
        long offset = MessageSchema.offset(this.typeAndOffsetAt(pos));
        if (!this.isFieldPresent(message, pos)) {
            return fieldSchema.newInstance();
        }
        Object current = UNSAFE.getObject(message, offset);
        if (MessageSchema.isMutable(current)) {
            return current;
        }
        Object newMessage = fieldSchema.newInstance();
        if (current != null) {
            void var1_1;
            void var3_4;
            var3_4.mergeFrom(newMessage, var1_1);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private void storeMessageField(T message, int pos, Object field) {
        void var2_2;
        void var1_1;
        void var3_3;
        UNSAFE.putObject(message, MessageSchema.offset(this.typeAndOffsetAt(pos)), var3_3);
        this.setFieldPresent(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Object mutableOneofMessageFieldForMerge(T message, int fieldNumber, int pos) {
        void var2_3;
        void var3_4;
        Schema fieldSchema = this.getMessageFieldSchema(pos);
        if (!this.isOneofPresent(message, fieldNumber, pos)) {
            return fieldSchema.newInstance();
        }
        Object current = UNSAFE.getObject(message, MessageSchema.offset(this.typeAndOffsetAt((int)var3_4)));
        if (MessageSchema.isMutable(current)) {
            return current;
        }
        Object newMessage = fieldSchema.newInstance();
        if (current != null) {
            void var1_1;
            fieldSchema.mergeFrom(newMessage, var1_1);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private void storeOneofMessageField(T message, int fieldNumber, int pos, Object field) {
        void var3_3;
        void var2_2;
        void var1_1;
        UNSAFE.putObject(message, MessageSchema.offset(this.typeAndOffsetAt(pos)), field);
        this.setOneofPresent(var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mergeFrom(T message, byte[] data, int position, int limit, ArrayDecoders.Registers registers) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.parseMessage(var1_1, (byte[])var2_2, (int)var3_3, limit, 0, registers);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void makeImmutable(T message) {
        if (!MessageSchema.isMutable(message)) {
            return;
        }
        if (message instanceof GeneratedMessageLite) {
            GeneratedMessageLite generatedMessage = (GeneratedMessageLite)message;
            generatedMessage.clearMemoizedSerializedSize();
            generatedMessage.clearMemoizedHashCode();
            generatedMessage.markImmutable();
        }
        int bufferLength = this.buffer.length;
        block6: for (int pos = 0; pos < bufferLength; pos += 3) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 9: 
                case 17: {
                    if (!this.isFieldPresent(message, pos)) continue block6;
                    this.getMessageFieldSchema(pos).makeImmutable(UNSAFE.getObject(message, offset));
                    continue block6;
                }
                case 60: 
                case 68: {
                    if (!this.isOneofPresent(message, this.numberAt(pos), pos)) continue block6;
                    this.getMessageFieldSchema(pos).makeImmutable(UNSAFE.getObject(message, offset));
                    continue block6;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    this.listFieldSchema.makeImmutableListAt(message, offset);
                    continue block6;
                }
                case 50: {
                    Object mapField = UNSAFE.getObject(message, offset);
                    if (mapField == null) continue block6;
                    UNSAFE.putObject(message, offset, this.mapFieldSchema.toImmutable(mapField));
                }
            }
        }
        this.unknownFieldSchema.makeImmutable(message);
        if (this.hasExtensions) {
            void var1_1;
            this.extensionSchema.makeImmutable(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> void mergeMap(Object message, int pos, Object mapDefaultEntry, ExtensionRegistryLite extensionRegistry, Reader reader) throws IOException {
        void var3_4;
        void var2_3;
        long offset = MessageSchema.offset(this.typeAndOffsetAt(pos));
        Object mapField = UnsafeUtil.getObject(message, offset);
        if (mapField == null) {
            mapField = this.mapFieldSchema.newMapField(mapDefaultEntry);
            UnsafeUtil.putObject(message, offset, mapField);
        } else if (this.mapFieldSchema.isImmutable(mapField)) {
            void var1_1;
            Object oldMapField = mapField;
            mapField = this.mapFieldSchema.newMapField(mapDefaultEntry);
            this.mapFieldSchema.mergeFrom(mapField, oldMapField);
            UnsafeUtil.putObject(var1_1, offset, mapField);
        }
        reader.readMap(this.mapFieldSchema.forMutableMapData(var2_3), this.mapFieldSchema.forMapMetadata(var3_4), extensionRegistry);
    }

    /*
     * WARNING - void declaration
     */
    private <UT, UB> UB filterMapUnknownEnumValues(Object message, int pos, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema, Object containerMessage) {
        void var3_3;
        void var1_1;
        void var2_2;
        int fieldNumber = this.numberAt(pos);
        long offset = MessageSchema.offset(this.typeAndOffsetAt(pos));
        Object mapField = UnsafeUtil.getObject(message, offset);
        if (mapField == null) {
            return unknownFields;
        }
        Internal.EnumVerifier enumVerifier = this.getEnumFieldVerifier(pos);
        if (enumVerifier == null) {
            return unknownFields;
        }
        Map<?, ?> mapData = this.mapFieldSchema.forMutableMapData(mapField);
        var3_3 = this.filterUnknownEnumMap((int)var2_2, fieldNumber, (Map)var1_1, enumVerifier, var3_3, unknownFieldSchema, containerMessage);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private <K, V, UT, UB> UB filterUnknownEnumMap(int pos, int number, Map<K, V> mapData, Internal.EnumVerifier enumVerifier, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema, Object containerMessage) {
        MapEntryLite.Metadata<?, ?> metadata = this.mapFieldSchema.forMapMetadata(this.getMapFieldDefaultEntry(pos));
        Iterator<Map.Entry<K, V>> it = mapData.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            if (enumVerifier.isInRange((Integer)entry.getValue())) continue;
            if (unknownFields == null) {
                unknownFields = unknownFieldSchema.getBuilderFromMessage(containerMessage);
            }
            int n = MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue());
            ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(n);
            CodedOutputStream codedOutput = codedBuilder.getCodedOutput();
            try {
                MapEntryLite.writeTo(codedOutput, metadata, entry.getKey(), entry.getValue());
            }
            catch (IOException e) {
                void var1_3;
                throw new RuntimeException((Throwable)var1_3);
            }
            unknownFieldSchema.addLengthDelimited(unknownFields, number, codedBuilder.build());
            it.remove();
        }
        return unknownFields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isInitialized(T message) {
        void var1_1;
        int currentPresenceFieldOffset = 1048575;
        int currentPresenceField = 0;
        block6: for (int i = 0; i < this.checkInitializedCount; ++i) {
            int pos = this.intArray[i];
            int number = this.numberAt(pos);
            int typeAndOffset = this.typeAndOffsetAt(pos);
            int presenceMaskAndOffset = this.buffer[pos + 2];
            int presenceFieldOffset = presenceMaskAndOffset & 0xFFFFF;
            int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
            if (presenceFieldOffset != currentPresenceFieldOffset && (currentPresenceFieldOffset = presenceFieldOffset) != 1048575) {
                currentPresenceField = UNSAFE.getInt(message, presenceFieldOffset);
            }
            if (MessageSchema.isRequired(typeAndOffset) && !this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask)) {
                return false;
            }
            switch (MessageSchema.type(typeAndOffset)) {
                case 9: 
                case 17: {
                    if (!this.isFieldPresent(message, pos, currentPresenceFieldOffset, currentPresenceField, presenceMask) || MessageSchema.isInitialized(message, typeAndOffset, this.getMessageFieldSchema(pos))) continue block6;
                    return false;
                }
                case 27: 
                case 49: {
                    if (this.isListInitialized(message, typeAndOffset, pos)) continue block6;
                    return false;
                }
                case 60: 
                case 68: {
                    if (!this.isOneofPresent(message, number, pos) || MessageSchema.isInitialized(message, typeAndOffset, this.getMessageFieldSchema(pos))) continue block6;
                    return false;
                }
                case 50: {
                    if (this.isMapInitialized(message, typeAndOffset, pos)) continue block6;
                    return false;
                }
            }
        }
        return !this.hasExtensions || this.extensionSchema.getExtensions(var1_1).isInitialized();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isInitialized(Object message, int typeAndOffset, Schema schema) {
        Object object;
        void var2_2;
        void var1_1;
        Object nested = UnsafeUtil.getObject(message, MessageSchema.offset((int)var1_1));
        return var2_2.isInitialized(object);
    }

    private <N> boolean isListInitialized(Object message, int typeAndOffset, int pos) {
        List list = (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
        if (list.isEmpty()) {
            return true;
        }
        Schema schema = this.getMessageFieldSchema(pos);
        for (int i = 0; i < list.size(); ++i) {
            Object nested = list.get(i);
            if (schema.isInitialized(nested)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMapInitialized(T message, int typeAndOffset, int pos) {
        Iterator iterator;
        Map<?, ?> map = this.mapFieldSchema.forMapData(UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
        if (map.isEmpty()) {
            return true;
        }
        MapEntryLite.Metadata<?, ?> mapDefaultEntry = this.getMapFieldDefaultEntry(pos);
        mapDefaultEntry = this.mapFieldSchema.forMapMetadata(mapDefaultEntry);
        if (mapDefaultEntry.valueType.getJavaType() != WireFormat.JavaType.MESSAGE) {
            return true;
        }
        Schema<Class<?>> schema = null;
        for (Object nested : iterator.values()) {
            void var3_5;
            if (schema == null) {
                schema = Protobuf.getInstance().schemaFor(nested.getClass());
            }
            if (schema.isInitialized((Class<?>)var3_5)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void writeString(int fieldNumber, Object value, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        if (value instanceof String) {
            writer.writeString(fieldNumber, (String)value);
            return;
        }
        var3_3.writeBytes((int)var1_1, (ByteString)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void readString(Object message, int typeAndOffset, Reader reader) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (MessageSchema.isEnforceUtf8(typeAndOffset)) {
            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readStringRequireUtf8());
            return;
        }
        if (this.lite) {
            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readString());
            return;
        }
        UnsafeUtil.putObject(var1_1, MessageSchema.offset((int)var2_2), (Object)var3_3.readBytes());
    }

    /*
     * WARNING - void declaration
     */
    private void readStringList(Object message, int typeAndOffset, Reader reader) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        if (MessageSchema.isEnforceUtf8(typeAndOffset)) {
            reader.readStringListRequireUtf8(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
            return;
        }
        var3_3.readStringList(this.listFieldSchema.mutableListAt(var1_1, MessageSchema.offset((int)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    private <E> void readMessageList(Object message, int typeAndOffset, Reader reader, Schema<E> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        void var3_3;
        long offset = MessageSchema.offset(typeAndOffset);
        var3_3.readMessageList(this.listFieldSchema.mutableListAt(var1_1, offset), schema, extensionRegistry);
    }

    /*
     * WARNING - void declaration
     */
    private <E> void readGroupList(Object message, long offset, Reader reader, Schema<E> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var2_2;
        void var1_1;
        reader.readGroupList(this.listFieldSchema.mutableListAt(var1_1, (long)var2_2), schema, extensionRegistry);
    }

    /*
     * WARNING - void declaration
     */
    private int numberAt(int pos) {
        void var1_1;
        return this.buffer[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private int typeAndOffsetAt(int pos) {
        void var1_1;
        return this.buffer[var1_1 + true];
    }

    /*
     * WARNING - void declaration
     */
    private int presenceMaskAndOffsetAt(int pos) {
        void var1_1;
        return this.buffer[var1_1 + 2];
    }

    private static int type(int value) {
        return (value & 0xFF00000) >>> 20;
    }

    private static boolean isRequired(int value) {
        return (value & 0x10000000) != 0;
    }

    private static boolean isEnforceUtf8(int value) {
        return (value & 0x20000000) != 0;
    }

    private static boolean isLegacyEnumIsClosed(int value) {
        return (value & Integer.MIN_VALUE) != 0;
    }

    private static long offset(int value) {
        return value & 0xFFFFF;
    }

    private static boolean isMutable(Object message) {
        if (message == null) {
            return false;
        }
        if (message instanceof GeneratedMessageLite) {
            Object object;
            return ((GeneratedMessageLite)object).isMutable();
        }
        return true;
    }

    private static void checkMutable(Object message) {
        if (!MessageSchema.isMutable(message)) {
            Object object;
            throw new IllegalArgumentException("Mutating immutable message: " + object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T> double doubleAt(T message, long offset) {
        void var1_1;
        return UnsafeUtil.getDouble(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> float floatAt(T message, long offset) {
        void var1_1;
        return UnsafeUtil.getFloat(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> int intAt(T message, long offset) {
        void var1_1;
        return UnsafeUtil.getInt(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> long longAt(T message, long offset) {
        void var1_1;
        return UnsafeUtil.getLong(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> boolean booleanAt(T message, long offset) {
        void var1_1;
        return UnsafeUtil.getBoolean(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> double oneofDoubleAt(T message, long offset) {
        void var1_1;
        return (Double)UnsafeUtil.getObject(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> float oneofFloatAt(T message, long offset) {
        void var1_1;
        return ((Float)UnsafeUtil.getObject(message, (long)var1_1)).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    private static <T> int oneofIntAt(T message, long offset) {
        void var1_1;
        return (Integer)UnsafeUtil.getObject(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> long oneofLongAt(T message, long offset) {
        void var1_1;
        return (Long)UnsafeUtil.getObject(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> boolean oneofBooleanAt(T message, long offset) {
        void var1_1;
        return (Boolean)UnsafeUtil.getObject(message, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean arePresentForEquals(T message, T other, int pos) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.isFieldPresent(var1_1, pos) == this.isFieldPresent(var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFieldPresent(T message, int pos, int presenceFieldOffset, int presenceField, int presenceMask) {
        if (presenceFieldOffset == 1048575) {
            void var2_2;
            void var1_1;
            return this.isFieldPresent(var1_1, (int)var2_2);
        }
        return (presenceField & presenceMask) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFieldPresent(T message, int pos) {
        void var2_2;
        void var3_3;
        void var1_1;
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        long l = presenceMaskAndOffset & 0xFFFFF;
        if (l == 1048575L) {
            int typeAndOffset = this.typeAndOffsetAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    return Double.doubleToRawLongBits(UnsafeUtil.getDouble(message, offset)) != 0L;
                }
                case 1: {
                    return Float.floatToRawIntBits(UnsafeUtil.getFloat(message, offset)) != 0;
                }
                case 2: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 3: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 4: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 5: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 6: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 7: {
                    return UnsafeUtil.getBoolean(message, offset);
                }
                case 8: {
                    Object value = UnsafeUtil.getObject(message, offset);
                    if (value instanceof String) {
                        return !((String)value).isEmpty();
                    }
                    if (value instanceof ByteString) {
                        return !ByteString.EMPTY.equals(var1_1);
                    }
                    throw new IllegalArgumentException();
                }
                case 9: {
                    return UnsafeUtil.getObject(var1_1, offset) != null;
                }
                case 10: {
                    return !ByteString.EMPTY.equals(UnsafeUtil.getObject(var1_1, offset));
                }
                case 11: {
                    return UnsafeUtil.getInt(var1_1, offset) != 0;
                }
                case 12: {
                    return UnsafeUtil.getInt(var1_1, offset) != 0;
                }
                case 13: {
                    return UnsafeUtil.getInt(var1_1, offset) != 0;
                }
                case 14: {
                    return UnsafeUtil.getLong(var1_1, offset) != 0L;
                }
                case 15: {
                    return UnsafeUtil.getInt(var1_1, offset) != 0;
                }
                case 16: {
                    return UnsafeUtil.getLong(var1_1, offset) != 0L;
                }
                case 17: {
                    return UnsafeUtil.getObject(var1_1, offset) != null;
                }
            }
            throw new IllegalArgumentException();
        }
        int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
        return (UnsafeUtil.getInt(var1_1, (long)(var3_3 & 0xFFFFF)) & var2_2) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private void setFieldPresent(T message, int pos) {
        void var2_2;
        void var1_1;
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        long presenceFieldOffset = presenceMaskAndOffset & 0xFFFFF;
        if (presenceFieldOffset == 1048575L) {
            return;
        }
        int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
        UnsafeUtil.putInt(message, presenceFieldOffset, UnsafeUtil.getInt(var1_1, presenceFieldOffset) | var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOneofPresent(T message, int fieldNumber, int pos) {
        void var2_2;
        void var3_3;
        void var1_1;
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        return UnsafeUtil.getInt(var1_1, (long)(var3_3 & 0xFFFFF)) == var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOneofCaseEqual(T message, T other, int pos) {
        void var3_3;
        void var2_2;
        void var1_1;
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        return UnsafeUtil.getInt(var1_1, (long)(presenceMaskAndOffset & 0xFFFFF)) == UnsafeUtil.getInt(var2_2, (long)(var3_3 & 0xFFFFF));
    }

    /*
     * WARNING - void declaration
     */
    private void setOneofPresent(T message, int fieldNumber, int pos) {
        void var2_2;
        void var3_3;
        void var1_1;
        int presenceMaskAndOffset = this.presenceMaskAndOffsetAt(pos);
        UnsafeUtil.putInt(var1_1, (long)(var3_3 & 0xFFFFF), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int positionForFieldNumber(int number) {
        if (number >= this.minFieldNumber && number <= this.maxFieldNumber) {
            void var1_1;
            return this.slowPositionForFieldNumber((int)var1_1, 0);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private int positionForFieldNumber(int number, int min) {
        if (number >= this.minFieldNumber && number <= this.maxFieldNumber) {
            void var2_2;
            void var1_1;
            return this.slowPositionForFieldNumber((int)var1_1, (int)var2_2);
        }
        return -1;
    }

    private int slowPositionForFieldNumber(int number, int min) {
        int max = this.buffer.length / 3 - 1;
        while (min <= max) {
            int mid = max + min >>> 1;
            int pos = mid * 3;
            int midFieldNumber = this.numberAt(pos);
            if (number == midFieldNumber) {
                return pos;
            }
            if (number < midFieldNumber) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return -1;
    }

    final int getSchemaSize() {
        return this.buffer.length * 3;
    }
}

