/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Internal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class MapFieldLite<K, V>
extends LinkedHashMap<K, V> {
    private boolean isMutable = true;
    private static final MapFieldLite<?, ?> EMPTY_MAP_FIELD = new MapFieldLite();

    private MapFieldLite() {
    }

    /*
     * WARNING - void declaration
     */
    private MapFieldLite(Map<K, V> mapData) {
        super(var1_1);
        void var1_1;
    }

    public static <K, V> MapFieldLite<K, V> emptyMapField() {
        return EMPTY_MAP_FIELD;
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeFrom(MapFieldLite<K, V> other) {
        this.ensureMutable();
        if (!other.isEmpty()) {
            void var1_1;
            this.putAll((Map<? extends K, ? extends V>)var1_1);
        }
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return super.entrySet();
    }

    @Override
    public final void clear() {
        this.ensureMutable();
        super.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(K key, V value) {
        void var2_2;
        void var1_1;
        this.ensureMutable();
        Internal.checkNotNull(key);
        Internal.checkNotNull(value);
        return super.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final V put(Map.Entry<K, V> entry) {
        void var1_1;
        return this.put(entry.getKey(), var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        void var1_1;
        this.ensureMutable();
        MapFieldLite.checkForNullKeysAndValues(m);
        super.putAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V remove(Object key) {
        void var1_1;
        this.ensureMutable();
        return super.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void checkForNullKeysAndValues(Map<?, ?> m) {
        for (Object key : m.keySet()) {
            void var2_2;
            Internal.checkNotNull(key);
            Internal.checkNotNull(m.get(var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equals(Object a, Object b) {
        void var1_1;
        Object object;
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        return object.equals(var1_1);
    }

    static <K, V> boolean equals(Map<K, V> a, Map<K, V> b) {
        Object object;
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry entry : object.entrySet()) {
            if (!b.containsKey(entry.getKey())) {
                return false;
            }
            if (MapFieldLite.equals(entry.getValue(), b.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        void var1_1;
        return object instanceof Map && MapFieldLite.equals(this, (Map)var1_1);
    }

    private static int calculateHashCodeForObject(Object a) {
        Object object;
        if (a instanceof byte[]) {
            return Internal.hashCode((byte[])a);
        }
        if (a instanceof Internal.EnumLite) {
            throw new UnsupportedOperationException();
        }
        return object.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> int calculateHashCodeForMap(Map<K, V> a) {
        void var1_1;
        Object object;
        int result = 0;
        for (Map.Entry entry : object.entrySet()) {
            result += MapFieldLite.calculateHashCodeForObject(entry.getKey()) ^ MapFieldLite.calculateHashCodeForObject(entry.getValue());
        }
        return (int)var1_1;
    }

    @Override
    public final int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this);
    }

    private static Object copy(Object object) {
        Object object2;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            Object data = byArray;
            return Arrays.copyOf(byArray, ((Object)object2).length);
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Map<K, V> copy(Map<K, V> map) {
        void var1_1;
        Object object;
        LinkedHashMap result = new LinkedHashMap((map.size() << 2) / 3 + 1);
        for (Map.Entry entry : object.entrySet()) {
            result.put(entry.getKey(), MapFieldLite.copy(entry.getValue()));
        }
        return var1_1;
    }

    public final MapFieldLite<K, V> mutableCopy() {
        if (this.isEmpty()) {
            return new MapFieldLite<K, V>();
        }
        return new MapFieldLite<K, V>(this);
    }

    public final void makeImmutable() {
        this.isMutable = false;
    }

    public final boolean isMutable() {
        return this.isMutable;
    }

    private void ensureMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        EMPTY_MAP_FIELD.makeImmutable();
    }
}

