/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.FieldSet;
import androidx.datastore.preferences.protobuf.MapFieldLite;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class MapEntryLite<K, V> {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private final K key;
    private final V value;

    /*
     * WARNING - void declaration
     */
    private MapEntryLite(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.metadata = new Metadata<K, V>((WireFormat.FieldType)var1_1, defaultKey, (WireFormat.FieldType)var3_3, defaultValue);
        this.key = var2_2;
        this.value = defaultValue;
    }

    /*
     * WARNING - void declaration
     */
    private MapEntryLite(Metadata<K, V> metadata, K key, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.metadata = var1_1;
        this.key = var2_2;
        this.value = var3_3;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> MapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        WireFormat.FieldType fieldType;
        return new MapEntryLite<void, void>(fieldType, var1_1, (WireFormat.FieldType)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void writeTo(CodedOutputStream output, Metadata<K, V> metadata, K key, V value) throws IOException {
        void var3_3;
        void var1_1;
        CodedOutputStream codedOutputStream;
        void var2_2;
        FieldSet.writeElement(output, metadata.keyType, 1, var2_2);
        FieldSet.writeElement(codedOutputStream, var1_1.valueType, 2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> int computeSerializedSize(Metadata<K, V> metadata, K key, V value) {
        void var2_2;
        Metadata<K, V> metadata2;
        void var1_1;
        return FieldSet.computeElementSize(metadata.keyType, 1, var1_1) + FieldSet.computeElementSize(metadata2.valueType, 2, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static <T> T parseField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type, T value) throws IOException {
        CodedInputStream codedInputStream;
        void var2_2;
        switch (type) {
            case MESSAGE: {
                void var1_1;
                void var3_3;
                MessageLite.Builder subBuilder = ((MessageLite)var3_3).toBuilder();
                input.readMessage(subBuilder, (ExtensionRegistryLite)var1_1);
                return (T)var2_2.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(input.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(codedInputStream, (WireFormat.FieldType)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public void serializeTo(CodedOutputStream output, int fieldNumber, K key, V value) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        output.writeTag((int)var2_2, 2);
        output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(this.metadata, key, value));
        MapEntryLite.writeTo((CodedOutputStream)var1_1, this.metadata, var3_3, value);
    }

    /*
     * WARNING - void declaration
     */
    public int computeMessageSize(int fieldNumber, K key, V value) {
        void var3_3;
        void var2_2;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(MapEntryLite.computeSerializedSize(this.metadata, var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Map.Entry<K, V> parseEntry(ByteString bytes, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var2_2;
        return MapEntryLite.parseEntry(bytes.newCodedInput(), this.metadata, (ExtensionRegistryLite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Map.Entry<K, V> parseEntry(CodedInputStream input, Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        int tag;
        Object key = metadata.defaultKey;
        Object value = metadata.defaultValue;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                key = MapEntryLite.parseField(input, extensionRegistry, metadata.keyType, key);
                continue;
            }
            if (tag == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                value = MapEntryLite.parseField(input, extensionRegistry, metadata.valueType, value);
                continue;
            }
            if (input.skipField(tag)) continue;
        }
        return new AbstractMap.SimpleImmutableEntry(var3_3, value);
    }

    /*
     * WARNING - void declaration
     */
    public void parseInto(MapFieldLite<K, V> map, CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        void var2_2;
        int tag;
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        Object key = this.metadata.defaultKey;
        Object value = this.metadata.defaultValue;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                key = MapEntryLite.parseField(input, extensionRegistry, this.metadata.keyType, key);
                continue;
            }
            if (tag == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                value = MapEntryLite.parseField(input, extensionRegistry, this.metadata.valueType, value);
                continue;
            }
            if (input.skipField(tag)) continue;
        }
        input.checkLastTagWas(0);
        var2_2.popLimit(oldLimit);
        var1_1.put(key, value);
    }

    Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    static class Metadata<K, V> {
        public final WireFormat.FieldType keyType;
        public final K defaultKey;
        public final WireFormat.FieldType valueType;
        public final V defaultValue;

        /*
         * WARNING - void declaration
         */
        public Metadata(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.keyType = var1_1;
            this.defaultKey = var2_2;
            this.valueType = var3_3;
            this.defaultValue = defaultValue;
        }
    }
}

