/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.ExtensionSchemas;
import androidx.datastore.preferences.protobuf.GeneratedMessageInfoFactory;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.ListFieldSchemas;
import androidx.datastore.preferences.protobuf.MapFieldSchemas;
import androidx.datastore.preferences.protobuf.MessageInfo;
import androidx.datastore.preferences.protobuf.MessageInfoFactory;
import androidx.datastore.preferences.protobuf.MessageSchema;
import androidx.datastore.preferences.protobuf.MessageSetSchema;
import androidx.datastore.preferences.protobuf.NewInstanceSchemas;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.SchemaFactory;
import androidx.datastore.preferences.protobuf.SchemaUtil;

@CheckReturnValue
final class ManifestSchemaFactory
implements SchemaFactory {
    private final MessageInfoFactory messageInfoFactory;
    private static final MessageInfoFactory EMPTY_FACTORY = new MessageInfoFactory(){

        @Override
        public boolean isSupported(Class<?> clazz) {
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            throw new IllegalStateException("This should never be called.");
        }
    };

    public ManifestSchemaFactory() {
        this(ManifestSchemaFactory.getDefaultMessageInfoFactory());
    }

    /*
     * WARNING - void declaration
     */
    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory) {
        void var1_1;
        this.messageInfoFactory = (MessageInfoFactory)Internal.checkNotNull(var1_1, "messageInfoFactory");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Schema<T> createSchema(Class<T> messageType) {
        void var2_2;
        void var1_1;
        SchemaUtil.requireGeneratedMessage(messageType);
        MessageInfo messageInfo = this.messageInfoFactory.messageInfoFor(messageType);
        if (messageInfo.isMessageSetWireFormat()) {
            if (ManifestSchemaFactory.useLiteRuntime(messageType)) {
                return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), messageInfo.getDefaultInstance());
            }
            return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetFullSchema(), ExtensionSchemas.full(), messageInfo.getDefaultInstance());
        }
        return ManifestSchemaFactory.newSchema(var1_1, (MessageInfo)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Schema<T> newSchema(Class<T> messageType, MessageInfo messageInfo) {
        void var1_1;
        Class<T> clazz;
        if (ManifestSchemaFactory.useLiteRuntime(messageType)) {
            return MessageSchema.newSchema(messageType, messageInfo, NewInstanceSchemas.lite(), ListFieldSchemas.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ManifestSchemaFactory.allowExtensions(messageInfo) ? ExtensionSchemas.lite() : null, MapFieldSchemas.lite());
        }
        return MessageSchema.newSchema(clazz, messageInfo, NewInstanceSchemas.full(), ListFieldSchemas.full(), SchemaUtil.unknownFieldSetFullSchema(), ManifestSchemaFactory.allowExtensions((MessageInfo)var1_1) ? ExtensionSchemas.full() : null, MapFieldSchemas.full());
    }

    private static boolean allowExtensions(MessageInfo messageInfo) {
        MessageInfo messageInfo2;
        switch (messageInfo2.getSyntax()) {
            case PROTO3: {
                return false;
            }
        }
        return true;
    }

    private static MessageInfoFactory getDefaultMessageInfoFactory() {
        return new CompositeMessageInfoFactory(GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory());
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        if (Protobuf.assumeLiteRuntime) {
            return EMPTY_FACTORY;
        }
        try {
            Class<?> clazz = Class.forName("androidx.datastore.preferences.protobuf.DescriptorMessageInfoFactory");
            return (MessageInfoFactory)clazz.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return EMPTY_FACTORY;
        }
    }

    private static boolean useLiteRuntime(Class<?> messageType) {
        Class<?> clazz;
        return Protobuf.assumeLiteRuntime || GeneratedMessageLite.class.isAssignableFrom(clazz);
    }

    private static class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        /*
         * WARNING - void declaration
         */
        CompositeMessageInfoFactory(MessageInfoFactory ... factories) {
            void var1_1;
            this.factories = var1_1;
        }

        @Override
        public boolean isSupported(Class<?> clazz) {
            MessageInfoFactory[] messageInfoFactoryArray = this.factories;
            int n = this.factories.length;
            for (int i = 0; i < n; ++i) {
                MessageInfoFactory messageInfoFactory = messageInfoFactoryArray[i];
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            void var1_1;
            MessageInfoFactory[] messageInfoFactoryArray = this.factories;
            int n = this.factories.length;
            for (int i = 0; i < n; ++i) {
                MessageInfoFactory factory = messageInfoFactoryArray[i];
                if (!factory.isSupported(clazz)) continue;
                return factory.messageInfoFor(clazz);
            }
            throw new UnsupportedOperationException("No factory is available for message type: " + var1_1.getName());
        }
    }
}

