/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractProtobufList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class LongArrayList
extends AbstractProtobufList<Long>
implements Internal.LongList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final LongArrayList EMPTY_LIST = new LongArrayList(new long[0], 0, false);
    private long[] array;
    private int size;

    public static LongArrayList emptyList() {
        return EMPTY_LIST;
    }

    LongArrayList() {
        this(new long[10], 0, true);
    }

    /*
     * WARNING - void declaration
     */
    private LongArrayList(long[] other, int size, boolean isMutable) {
        super((boolean)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.array = var1_1;
        this.size = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= var2_2 - var1_1;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongArrayList)) {
            return super.equals(o);
        }
        LongArrayList other = (LongArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        long[] arr = other.array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == arr[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = result * 31 + Internal.hashLong(this.array[i]);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Internal.LongList mutableCopyWithCapacity(int capacity) {
        void var1_1;
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new LongArrayList(Arrays.copyOf(this.array, (int)var1_1), this.size, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Long get(int index) {
        void var1_1;
        return this.getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getLong(int index) {
        void var1_1;
        this.ensureIndexInRange(index);
        return this.array[var1_1];
    }

    @Override
    public final int indexOf(Object element) {
        if (!(element instanceof Long)) {
            return -1;
        }
        long unboxedElement = (Long)element;
        int numElems = this.size();
        for (int i = 0; i < numElems; ++i) {
            if (this.array[i] != unboxedElement) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        return this.indexOf(var1_1) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Long set(int index, Long element) {
        void var2_2;
        void var1_1;
        return this.setLong((int)var1_1, var2_2.longValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long setLong(int index, long element) {
        void var2_2;
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        long previousValue = this.array[index];
        this.array[var1_1] = var2_2;
        return previousValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(Long element) {
        void var1_1;
        this.addLong(var1_1.longValue());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, Long element) {
        void var2_2;
        void var1_1;
        this.addLong((int)var1_1, var2_2.longValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addLong(long element) {
        void var1_1;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            void var3_3;
            int n = this.size * 3 / 2 + 1;
            long[] newArray = new long[n];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = var3_3;
        }
        this.array[this.size++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void addLong(int index, long element) {
        void var2_2;
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int n = this.size * 3 / 2 + 1;
            long[] newArray = new long[n];
            System.arraycopy(this.array, 0, newArray, 0, index);
            System.arraycopy(this.array, index, newArray, index + 1, this.size - index);
            this.array = newArray;
        }
        this.array[var1_1] = var2_2;
        ++this.size;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        void var1_1;
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof LongArrayList)) {
            return super.addAll(collection);
        }
        LongArrayList list = (LongArrayList)collection;
        if (list.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < list.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list.array, 0, this.array, this.size, var1_1.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Long remove(int index) {
        void var2_2;
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        long value = this.array[index];
        if (index < this.size - 1) {
            void var1_1;
            System.arraycopy(this.array, index + 1, this.array, index, this.size - var1_1 - 1);
        }
        --this.size;
        ++this.modCount;
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            void var1_1;
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage((int)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String makeOutOfBoundsExceptionMessage(int index) {
        void var1_1;
        return "Index:" + (int)var1_1 + ", Size:" + this.size;
    }
}

