/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractProtobufList;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList(false);
    @Deprecated
    public static final LazyStringList EMPTY = EMPTY_LIST;
    private final List<Object> list;

    public static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    /*
     * WARNING - void declaration
     */
    private LazyStringArrayList(boolean isMutable) {
        super((boolean)var1_1);
        void var1_1;
        this.list = Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList(int initialCapacity) {
        this(new ArrayList<Object>((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList(LazyStringList from) {
        void var1_1;
        this.list = new ArrayList<Object>(from.size());
        this.addAll((Collection<? extends String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList(List<String> from) {
        this(new ArrayList<Object>((Collection<Object>)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private LazyStringArrayList(ArrayList<Object> list) {
        void var1_1;
        this.list = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList mutableCopyWithCapacity(int capacity) {
        void var1_2;
        if (capacity < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> newList = new ArrayList<Object>(capacity);
        newList.addAll(this.list);
        return new LazyStringArrayList((ArrayList<Object>)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String get(int index) {
        void var3_4;
        void var2_2;
        ByteString bs;
        Object o = this.list.get(index);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            bs = (ByteString)o;
            String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
                this.list.set(index, s);
            }
            return s;
        }
        byte[] ba = (byte[])bs;
        String s = Internal.toStringUtf8(ba);
        if (Internal.isValidUtf8((byte[])var2_2)) {
            void var1_1;
            this.list.set((int)var1_1, s);
        }
        return var3_4;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String set(int index, String s) {
        void var2_3;
        void var1_1;
        this.ensureIsMutable();
        Object object = this.list.set((int)var1_1, var2_3);
        return LazyStringArrayList.asString(object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, String element) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        this.list.add((int)var1_1, var2_2);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private void add(int index, ByteString element) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        this.list.add((int)var1_1, var2_2);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private void add(int index, byte[] element) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        this.list.add((int)var1_1, var2_2);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @CanIgnoreReturnValue
    public boolean add(String element) {
        void var1_1;
        this.ensureIsMutable();
        this.list.add(var1_1);
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(ByteString element) {
        void var1_1;
        this.ensureIsMutable();
        this.list.add(var1_1);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(byte[] element) {
        void var1_1;
        this.ensureIsMutable();
        this.list.add(var1_1);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends String> c) {
        void var1_1;
        LazyStringArrayList lazyStringArrayList = this;
        return lazyStringArrayList.addAll(lazyStringArrayList.size(), (Collection<? extends String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        void var1_1;
        void var2_2;
        void collection;
        this.ensureIsMutable();
        collection = c instanceof LazyStringList ? ((LazyStringList)c).getUnderlyingElements() : collection;
        boolean ret = this.list.addAll(index, (Collection<Object>)var2_2);
        ++this.modCount;
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllByteString(Collection<? extends ByteString> values) {
        void var1_2;
        this.ensureIsMutable();
        boolean ret = this.list.addAll(values);
        ++this.modCount;
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllByteArray(Collection<byte[]> c) {
        void var1_2;
        this.ensureIsMutable();
        boolean ret = this.list.addAll(c);
        ++this.modCount;
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String remove(int index) {
        void var1_2;
        this.ensureIsMutable();
        Object o = this.list.remove(index);
        ++this.modCount;
        return LazyStringArrayList.asString(var1_2);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getRaw(int index) {
        void var1_1;
        return this.list.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteString getByteString(int index) {
        void var3_3;
        void var2_2;
        Object o = this.list.get(index);
        ByteString b = LazyStringArrayList.asByteString(o);
        if (b != var2_2) {
            void var1_1;
            this.list.set((int)var1_1, b);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getByteArray(int index) {
        void var3_3;
        void var2_2;
        Object o = this.list.get(index);
        byte[] b = LazyStringArrayList.asByteArray(o);
        if (b != var2_2) {
            void var1_1;
            this.list.set((int)var1_1, b);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(int index, ByteString s) {
        void var2_2;
        void var1_1;
        this.setAndReturn((int)var1_1, (ByteString)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Object setAndReturn(int index, ByteString s) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        return this.list.set((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(int index, byte[] s) {
        void var2_2;
        void var1_1;
        this.setAndReturn((int)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Object setAndReturn(int index, byte[] s) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        return this.list.set((int)var1_1, var2_2);
    }

    private static String asString(Object o) {
        Object object;
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            return ((ByteString)o).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    private static ByteString asByteString(Object o) {
        Object object;
        if (o instanceof ByteString) {
            return (ByteString)o;
        }
        if (o instanceof String) {
            return ByteString.copyFromUtf8((String)o);
        }
        return ByteString.copyFrom((byte[])object);
    }

    private static byte[] asByteArray(Object o) {
        Object object;
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof String) {
            return Internal.toByteArray((String)o);
        }
        return ((ByteString)object).toByteArray();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mergeFrom(LazyStringList other) {
        Iterator<?> iterator;
        this.ensureIsMutable();
        for (Object o : iterator.getUnderlyingElements()) {
            void var2_2;
            if (o instanceof byte[]) {
                byte[] b = (byte[])o;
                void v0 = var2_2;
                this.list.add(Arrays.copyOf((byte[])v0, ((void)v0).length));
                continue;
            }
            this.list.add(var2_2);
        }
    }

    @Override
    public List<byte[]> asByteArrayList() {
        return new ByteArrayListView(this);
    }

    @Override
    public List<ByteString> asByteStringList() {
        return new ByteStringListView(this);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$000(LazyStringArrayList x0, int x1, byte[] x2) {
        void var2_2;
        void var1_1;
        return x0.setAndReturn((int)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(LazyStringArrayList x0, int x1, byte[] x2) {
        void var2_2;
        void var1_1;
        x0.add((int)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$300(LazyStringArrayList x0, int x1, ByteString x2) {
        void var2_2;
        void var1_1;
        return x0.setAndReturn((int)var1_1, (ByteString)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(LazyStringArrayList x0, int x1, ByteString x2) {
        void var2_2;
        void var1_1;
        x0.add((int)var1_1, (ByteString)var2_2);
    }

    private static class ByteStringListView
    extends AbstractList<ByteString>
    implements RandomAccess {
        private final LazyStringArrayList list;

        /*
         * WARNING - void declaration
         */
        ByteStringListView(LazyStringArrayList list) {
            void var1_1;
            this.list = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteString get(int index) {
            void var1_1;
            return this.list.getByteString((int)var1_1);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteString set(int index, ByteString s) {
            void var1_2;
            void var2_3;
            Object o = LazyStringArrayList.access$300(this.list, index, (ByteString)var2_3);
            ++this.modCount;
            return LazyStringArrayList.asByteString(var1_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(int index, ByteString s) {
            void var2_2;
            void var1_1;
            LazyStringArrayList.access$500(this.list, (int)var1_1, (ByteString)var2_2);
            ++this.modCount;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteString remove(int index) {
            void var1_2;
            String o = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteString(var1_2);
        }
    }

    private static class ByteArrayListView
    extends AbstractList<byte[]>
    implements RandomAccess {
        private final LazyStringArrayList list;

        /*
         * WARNING - void declaration
         */
        ByteArrayListView(LazyStringArrayList list) {
            void var1_1;
            this.list = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] get(int index) {
            void var1_1;
            return this.list.getByteArray((int)var1_1);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] set(int index, byte[] s) {
            void var1_2;
            void var2_3;
            Object o = LazyStringArrayList.access$000(this.list, index, (byte[])var2_3);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(var1_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(int index, byte[] s) {
            void var2_2;
            void var1_1;
            LazyStringArrayList.access$200(this.list, (int)var1_1, (byte[])var2_2);
            ++this.modCount;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] remove(int index) {
            void var1_2;
            String o = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(var1_2);
        }
    }
}

