/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;

public class LazyFieldLite {
    private ByteString delayedBytes;
    private ExtensionRegistryLite extensionRegistry;
    protected volatile MessageLite value;
    private volatile ByteString memoizedBytes;

    /*
     * WARNING - void declaration
     */
    public LazyFieldLite(ExtensionRegistryLite extensionRegistry, ByteString bytes) {
        void var2_2;
        void var1_1;
        LazyFieldLite.checkArguments(extensionRegistry, bytes);
        this.extensionRegistry = var1_1;
        this.delayedBytes = var2_2;
    }

    public LazyFieldLite() {
    }

    /*
     * WARNING - void declaration
     */
    public static LazyFieldLite fromValue(MessageLite value) {
        void var1_1;
        MessageLite messageLite;
        LazyFieldLite lf = new LazyFieldLite();
        lf.setValue(messageLite);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var3_3;
        if (this == o) {
            return true;
        }
        if (!(o instanceof LazyFieldLite)) {
            return false;
        }
        LazyFieldLite other = (LazyFieldLite)o;
        MessageLite value1 = this.value;
        MessageLite value2 = other.value;
        if (value1 == null && value2 == null) {
            return this.toByteString().equals(other.toByteString());
        }
        if (value1 != null && value2 != null) {
            return value1.equals(value2);
        }
        if (value1 != null) {
            void var2_2;
            void var1_1;
            return value1.equals(var1_1.getValue(var2_2.getDefaultInstanceForType()));
        }
        return this.getValue(value2.getDefaultInstanceForType()).equals(var3_3);
    }

    public int hashCode() {
        return 1;
    }

    public boolean containsDefaultInstance() {
        return this.memoizedBytes == ByteString.EMPTY || this.value == null && (this.delayedBytes == null || this.delayedBytes == ByteString.EMPTY);
    }

    public void clear() {
        this.delayedBytes = null;
        this.value = null;
        this.memoizedBytes = null;
    }

    /*
     * WARNING - void declaration
     */
    public void set(LazyFieldLite other) {
        this.delayedBytes = other.delayedBytes;
        this.value = other.value;
        this.memoizedBytes = other.memoizedBytes;
        if (other.extensionRegistry != null) {
            void var1_1;
            this.extensionRegistry = var1_1.extensionRegistry;
        }
    }

    /*
     * WARNING - void declaration
     */
    public MessageLite getValue(MessageLite defaultInstance) {
        void var1_1;
        this.ensureInitialized((MessageLite)var1_1);
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public MessageLite setValue(MessageLite value) {
        void var2_2;
        void var1_1;
        MessageLite originalValue = this.value;
        this.delayedBytes = null;
        this.memoizedBytes = null;
        this.value = var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void merge(LazyFieldLite other) {
        void var1_1;
        if (other.containsDefaultInstance()) {
            return;
        }
        if (this.containsDefaultInstance()) {
            this.set(other);
            return;
        }
        if (this.extensionRegistry == null) {
            this.extensionRegistry = other.extensionRegistry;
        }
        if (this.delayedBytes != null && other.delayedBytes != null) {
            this.delayedBytes = this.delayedBytes.concat(other.delayedBytes);
            return;
        }
        if (this.value == null && other.value != null) {
            this.setValue(LazyFieldLite.mergeValueAndBytes(other.value, this.delayedBytes, this.extensionRegistry));
            return;
        }
        if (this.value != null && other.value == null) {
            LazyFieldLite lazyFieldLite = this;
            lazyFieldLite.setValue(LazyFieldLite.mergeValueAndBytes(lazyFieldLite.value, other.delayedBytes, other.extensionRegistry));
            return;
        }
        LazyFieldLite lazyFieldLite = this;
        lazyFieldLite.setValue(lazyFieldLite.value.toBuilder().mergeFrom(var1_1.value).build());
    }

    /*
     * WARNING - void declaration
     */
    public void mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        if (this.containsDefaultInstance()) {
            this.setByteString(input.readBytes(), extensionRegistry);
            return;
        }
        if (this.extensionRegistry == null) {
            this.extensionRegistry = extensionRegistry;
        }
        if (this.delayedBytes != null) {
            LazyFieldLite lazyFieldLite = this;
            lazyFieldLite.setByteString(lazyFieldLite.delayedBytes.concat(input.readBytes()), this.extensionRegistry);
            return;
        }
        try {
            void var2_2;
            void var1_1;
            LazyFieldLite lazyFieldLite = this;
            lazyFieldLite.setValue(lazyFieldLite.value.toBuilder().mergeFrom((CodedInputStream)var1_1, (ExtensionRegistryLite)var2_2).build());
            return;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static MessageLite mergeValueAndBytes(MessageLite value, ByteString otherBytes, ExtensionRegistryLite extensionRegistry) {
        try {
            void var2_2;
            void var1_1;
            return value.toBuilder().mergeFrom((ByteString)var1_1, (ExtensionRegistryLite)var2_2).build();
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            MessageLite messageLite;
            return messageLite;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setByteString(ByteString bytes, ExtensionRegistryLite extensionRegistry) {
        void var2_2;
        void var1_1;
        LazyFieldLite.checkArguments(extensionRegistry, bytes);
        this.delayedBytes = var1_1;
        this.extensionRegistry = var2_2;
        this.value = null;
        this.memoizedBytes = null;
    }

    public int getSerializedSize() {
        if (this.memoizedBytes != null) {
            return this.memoizedBytes.size();
        }
        if (this.delayedBytes != null) {
            return this.delayedBytes.size();
        }
        if (this.value != null) {
            return this.value.getSerializedSize();
        }
        return 0;
    }

    public ByteString toByteString() {
        if (this.memoizedBytes != null) {
            return this.memoizedBytes;
        }
        if (this.delayedBytes != null) {
            return this.delayedBytes;
        }
        LazyFieldLite lazyFieldLite = this;
        synchronized (lazyFieldLite) {
            if (this.memoizedBytes != null) {
                return this.memoizedBytes;
            }
            this.memoizedBytes = this.value == null ? ByteString.EMPTY : this.value.toByteString();
            return this.memoizedBytes;
        }
    }

    /*
     * WARNING - void declaration
     */
    void writeTo(Writer writer, int fieldNumber) throws IOException {
        void var2_2;
        void var1_1;
        if (this.memoizedBytes != null) {
            writer.writeBytes(fieldNumber, this.memoizedBytes);
            return;
        }
        if (this.delayedBytes != null) {
            writer.writeBytes(fieldNumber, this.delayedBytes);
            return;
        }
        if (this.value != null) {
            writer.writeMessage(fieldNumber, this.value);
            return;
        }
        var1_1.writeBytes((int)var2_2, ByteString.EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    protected void ensureInitialized(MessageLite defaultInstance) {
        if (this.value != null) {
            return;
        }
        LazyFieldLite lazyFieldLite = this;
        synchronized (lazyFieldLite) {
            if (this.value != null) {
                return;
            }
            try {
                if (this.delayedBytes != null) {
                    void var3_4;
                    MessageLite parsedValue = defaultInstance.getParserForType().parseFrom(this.delayedBytes, this.extensionRegistry);
                    this.value = var3_4;
                    this.memoizedBytes = this.delayedBytes;
                } else {
                    this.value = defaultInstance;
                    this.memoizedBytes = ByteString.EMPTY;
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                void var1_1;
                this.value = var1_1;
                this.memoizedBytes = ByteString.EMPTY;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkArguments(ExtensionRegistryLite extensionRegistry, ByteString bytes) {
        void var1_1;
        if (extensionRegistry == null) {
            throw new NullPointerException("found null ExtensionRegistry");
        }
        if (var1_1 == null) {
            throw new NullPointerException("found null ByteString");
        }
    }
}

