/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.Java8Compatibility;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Utf8;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public final class Internal {
    static final Charset US_ASCII = Charset.forName("US-ASCII");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
    public static final CodedInputStream EMPTY_CODED_INPUT_STREAM = CodedInputStream.newInstance(EMPTY_BYTE_ARRAY);

    private Internal() {
    }

    static <T> T checkNotNull(T obj) {
        T t;
        if (obj == null) {
            throw new NullPointerException();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    static <T> T checkNotNull(T obj, String message) {
        T t;
        if (obj == null) {
            void var1_1;
            throw new NullPointerException((String)var1_1);
        }
        return t;
    }

    public static String stringDefaultValue(String bytes) {
        String string;
        return new String(string.getBytes(ISO_8859_1), UTF_8);
    }

    public static ByteString bytesDefaultValue(String bytes) {
        return ByteString.copyFrom(bytes.getBytes(ISO_8859_1));
    }

    public static byte[] byteArrayDefaultValue(String bytes) {
        return bytes.getBytes(ISO_8859_1);
    }

    public static ByteBuffer byteBufferDefaultValue(String bytes) {
        return ByteBuffer.wrap(Internal.byteArrayDefaultValue(bytes));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer copyByteBuffer(ByteBuffer source) {
        void var1_1;
        ByteBuffer byteBuffer;
        ByteBuffer temp = source.duplicate();
        ((Buffer)temp).clear();
        ByteBuffer result = ByteBuffer.allocate(temp.capacity());
        result.put(byteBuffer);
        ((Buffer)result).clear();
        return var1_1;
    }

    public static boolean isValidUtf8(ByteString byteString) {
        return byteString.isValidUtf8();
    }

    public static boolean isValidUtf8(byte[] byteArray) {
        return Utf8.isValidUtf8(byteArray);
    }

    public static byte[] toByteArray(String value) {
        return value.getBytes(UTF_8);
    }

    public static String toStringUtf8(byte[] bytes) {
        byte[] byArray;
        return new String(byArray, UTF_8);
    }

    public static int hashLong(long n) {
        long l = n;
        return (int)(l ^ l >>> 32);
    }

    public static int hashBoolean(boolean b) {
        if (b) {
            return 1231;
        }
        return 1237;
    }

    public static int hashEnum(EnumLite e) {
        return e.getNumber();
    }

    /*
     * WARNING - void declaration
     */
    public static int hashEnumList(List<? extends EnumLite> list) {
        void var1_1;
        Iterator<? extends EnumLite> iterator;
        int hash = 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            EnumLite e = (EnumLite)iterator.next();
            hash = hash * 31 + Internal.hashEnum((EnumLite)var2_2);
        }
        return (int)var1_1;
    }

    public static boolean equals(List<byte[]> a, List<byte[]> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Arrays.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int hashCode(List<byte[]> list) {
        void var1_1;
        Iterator<byte[]> iterator;
        int hash = 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            byte[] bytes = (byte[])iterator.next();
            hash = hash * 31 + Internal.hashCode((byte[])var2_2);
        }
        return (int)var1_1;
    }

    public static int hashCode(byte[] bytes) {
        byte[] byArray;
        return Internal.hashCode(bytes, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    static int hashCode(byte[] bytes, int offset, int length) {
        void var0_1;
        void var2_3;
        void var1_2;
        int h = Internal.partialHash(length, bytes, (int)var1_2, (int)var2_3);
        if (h == 0) {
            return 1;
        }
        return (int)var0_1;
    }

    static int partialHash(int h, byte[] bytes, int offset, int length) {
        int n;
        for (int i = offset; i < offset + length; ++i) {
            h = h * 31 + bytes[i];
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsByteBuffer(ByteBuffer a, ByteBuffer b) {
        void var1_1;
        ByteBuffer byteBuffer;
        if (a.capacity() != b.capacity()) {
            return false;
        }
        ByteBuffer aDuplicate = a.duplicate();
        Java8Compatibility.clear(aDuplicate);
        ByteBuffer bDuplicate = b.duplicate();
        Java8Compatibility.clear(bDuplicate);
        return byteBuffer.equals(var1_1);
    }

    public static boolean equalsByteBuffer(List<ByteBuffer> a, List<ByteBuffer> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Internal.equalsByteBuffer(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int hashCodeByteBuffer(List<ByteBuffer> list) {
        void var1_1;
        Iterator<ByteBuffer> iterator;
        int hash = 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            ByteBuffer bytes = (ByteBuffer)iterator.next();
            hash = hash * 31 + Internal.hashCodeByteBuffer((ByteBuffer)var2_2);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int hashCodeByteBuffer(ByteBuffer bytes) {
        void var0_1;
        if (bytes.hasArray()) {
            int h = Internal.partialHash(bytes.capacity(), bytes.array(), bytes.arrayOffset(), bytes.capacity());
            if (h == 0) {
                return 1;
            }
            return h;
        }
        int bufferSize = bytes.capacity() > 4096 ? 4096 : bytes.capacity();
        byte[] buffer = new byte[bufferSize];
        ByteBuffer duplicated = bytes.duplicate();
        Java8Compatibility.clear(duplicated);
        int h = bytes.capacity();
        while (duplicated.remaining() > 0) {
            int length = duplicated.remaining() <= bufferSize ? duplicated.remaining() : bufferSize;
            duplicated.get(buffer, 0, length);
            h = Internal.partialHash(h, buffer, 0, length);
        }
        if (h == 0) {
            return 1;
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends MessageLite> T getDefaultInstance(Class<T> clazz) {
        try {
            Method method = clazz.getMethod("getDefaultInstance", new Class[0]);
            return (T)((MessageLite)method.invoke((Object)method, new Object[0]));
        }
        catch (Exception e) {
            void var1_2;
            Class<T> clazz2;
            throw new RuntimeException("Failed to get default instance for " + clazz2, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static Object mergeMessage(Object destination, Object source) {
        void var1_1;
        return ((MessageLite)destination).toBuilder().mergeFrom((MessageLite)var1_1).buildPartial();
    }

    public static interface FloatList
    extends ProtobufList<Float> {
        public float getFloat(int var1);

        public void addFloat(float var1);

        @CanIgnoreReturnValue
        public float setFloat(int var1, float var2);

        public FloatList mutableCopyWithCapacity(int var1);
    }

    public static interface DoubleList
    extends ProtobufList<Double> {
        public double getDouble(int var1);

        public void addDouble(double var1);

        @CanIgnoreReturnValue
        public double setDouble(int var1, double var2);

        public DoubleList mutableCopyWithCapacity(int var1);
    }

    public static interface LongList
    extends ProtobufList<Long> {
        public long getLong(int var1);

        public void addLong(long var1);

        @CanIgnoreReturnValue
        public long setLong(int var1, long var2);

        public LongList mutableCopyWithCapacity(int var1);
    }

    public static interface BooleanList
    extends ProtobufList<Boolean> {
        public boolean getBoolean(int var1);

        public void addBoolean(boolean var1);

        @CanIgnoreReturnValue
        public boolean setBoolean(int var1, boolean var2);

        public BooleanList mutableCopyWithCapacity(int var1);
    }

    public static interface IntList
    extends ProtobufList<Integer> {
        public int getInt(int var1);

        public void addInt(int var1);

        @CanIgnoreReturnValue
        public int setInt(int var1, int var2);

        public IntList mutableCopyWithCapacity(int var1);
    }

    public static interface ProtobufList<E>
    extends List<E>,
    RandomAccess {
        public void makeImmutable();

        public boolean isModifiable();

        public ProtobufList<E> mutableCopyWithCapacity(int var1);
    }

    public static class MapAdapter<K, V, RealValue>
    extends AbstractMap<K, V> {
        private final Map<K, RealValue> realMap;
        private final Converter<RealValue, V> valueConverter;

        /*
         * WARNING - void declaration
         */
        public static <T extends EnumLite> Converter<Integer, T> newEnumConverter(EnumLiteMap<T> enumMap, T unrecognizedValue) {
            void var1_1;
            EnumLiteMap<T> enumLiteMap;
            return new Converter<Integer, T>((EnumLite)var1_1){
                final /* synthetic */ EnumLite val$unrecognizedValue;
                {
                    this.val$unrecognizedValue = enumLite;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public T doForward(Integer value) {
                    void var1_1;
                    Object result = enumLiteMap.findValueByNumber(value);
                    if (result == null) {
                        return this.val$unrecognizedValue;
                    }
                    return var1_1;
                }

                @Override
                public Integer doBackward(T value) {
                    return value.getNumber();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        public MapAdapter(Map<K, RealValue> realMap, Converter<RealValue, V> valueConverter) {
            void var2_2;
            void var1_1;
            this.realMap = var1_1;
            this.valueConverter = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            RealValue result = this.realMap.get(key);
            if (result == null) {
                return null;
            }
            return this.valueConverter.doForward(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(K key, V value) {
            void var1_1;
            void var2_2;
            RealValue oldValue = this.realMap.put(key, this.valueConverter.doBackward(var2_2));
            if (oldValue == null) {
                return null;
            }
            return this.valueConverter.doForward(var1_1);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            MapAdapter mapAdapter = this;
            return mapAdapter.new SetAdapter(mapAdapter.realMap.entrySet());
        }

        private class EntryAdapter
        implements Map.Entry<K, V> {
            private final Map.Entry<K, RealValue> realEntry;

            /*
             * WARNING - void declaration
             */
            public EntryAdapter(Map.Entry<K, RealValue> realEntry) {
                void var2_2;
                this.realEntry = var2_2;
            }

            @Override
            public K getKey() {
                return this.realEntry.getKey();
            }

            @Override
            public V getValue() {
                return MapAdapter.this.valueConverter.doForward(this.realEntry.getValue());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public V setValue(V value) {
                void var1_1;
                Object oldValue = this.realEntry.setValue(MapAdapter.this.valueConverter.doBackward(value));
                if (oldValue == null) {
                    return null;
                }
                return MapAdapter.this.valueConverter.doForward(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean equals(Object o) {
                void var1_1;
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry other = (Map.Entry)o;
                return this.getKey().equals(var1_1.getKey()) && this.getValue().equals(this.getValue());
            }

            @Override
            public int hashCode() {
                return this.realEntry.hashCode();
            }
        }

        private class IteratorAdapter
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, RealValue>> realIterator;

            /*
             * WARNING - void declaration
             */
            public IteratorAdapter(Iterator<Map.Entry<K, RealValue>> realIterator) {
                void var2_2;
                this.realIterator = var2_2;
            }

            @Override
            public boolean hasNext() {
                return this.realIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return new EntryAdapter(this.realIterator.next());
            }

            @Override
            public void remove() {
                this.realIterator.remove();
            }
        }

        private class SetAdapter
        extends AbstractSet<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, RealValue>> realSet;

            /*
             * WARNING - void declaration
             */
            public SetAdapter(Set<Map.Entry<K, RealValue>> realSet) {
                void var2_2;
                this.realSet = var2_2;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new IteratorAdapter(this.realSet.iterator());
            }

            @Override
            public int size() {
                return this.realSet.size();
            }
        }

        public static interface Converter<A, B> {
            public B doForward(A var1);

            public A doBackward(B var1);
        }
    }

    public static class ListAdapter<F, T>
    extends AbstractList<T> {
        private final List<F> fromList;
        private final Converter<F, T> converter;

        /*
         * WARNING - void declaration
         */
        public ListAdapter(List<F> fromList, Converter<F, T> converter) {
            void var2_2;
            void var1_1;
            this.fromList = var1_1;
            this.converter = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T get(int index) {
            void var1_1;
            return this.converter.convert(this.fromList.get((int)var1_1));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        public static interface Converter<F, T> {
            public T convert(F var1);
        }
    }

    public static class IntListAdapter<T>
    extends AbstractList<T> {
        private final IntList fromList;
        private final IntConverter<T> converter;

        /*
         * WARNING - void declaration
         */
        public IntListAdapter(IntList fromList, IntConverter<T> converter) {
            void var2_2;
            void var1_1;
            this.fromList = var1_1;
            this.converter = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T get(int index) {
            void var1_1;
            return this.converter.convert(this.fromList.getInt((int)var1_1));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        public static interface IntConverter<T> {
            public T convert(int var1);
        }
    }

    public static interface EnumVerifier {
        public boolean isInRange(int var1);
    }

    public static interface EnumLiteMap<T extends EnumLite> {
        public T findValueByNumber(int var1);
    }

    public static interface EnumLite {
        public int getNumber();
    }
}

