/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.JavaType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public final class FieldType
extends Enum<FieldType> {
    public static final /* enum */ FieldType DOUBLE;
    public static final /* enum */ FieldType FLOAT;
    public static final /* enum */ FieldType INT64;
    public static final /* enum */ FieldType UINT64;
    public static final /* enum */ FieldType INT32;
    public static final /* enum */ FieldType FIXED64;
    public static final /* enum */ FieldType FIXED32;
    public static final /* enum */ FieldType BOOL;
    public static final /* enum */ FieldType STRING;
    public static final /* enum */ FieldType MESSAGE;
    public static final /* enum */ FieldType BYTES;
    public static final /* enum */ FieldType UINT32;
    public static final /* enum */ FieldType ENUM;
    public static final /* enum */ FieldType SFIXED32;
    public static final /* enum */ FieldType SFIXED64;
    public static final /* enum */ FieldType SINT32;
    public static final /* enum */ FieldType SINT64;
    public static final /* enum */ FieldType GROUP;
    public static final /* enum */ FieldType DOUBLE_LIST;
    public static final /* enum */ FieldType FLOAT_LIST;
    public static final /* enum */ FieldType INT64_LIST;
    public static final /* enum */ FieldType UINT64_LIST;
    public static final /* enum */ FieldType INT32_LIST;
    public static final /* enum */ FieldType FIXED64_LIST;
    public static final /* enum */ FieldType FIXED32_LIST;
    public static final /* enum */ FieldType BOOL_LIST;
    public static final /* enum */ FieldType STRING_LIST;
    public static final /* enum */ FieldType MESSAGE_LIST;
    public static final /* enum */ FieldType BYTES_LIST;
    public static final /* enum */ FieldType UINT32_LIST;
    public static final /* enum */ FieldType ENUM_LIST;
    public static final /* enum */ FieldType SFIXED32_LIST;
    public static final /* enum */ FieldType SFIXED64_LIST;
    public static final /* enum */ FieldType SINT32_LIST;
    public static final /* enum */ FieldType SINT64_LIST;
    public static final /* enum */ FieldType DOUBLE_LIST_PACKED;
    public static final /* enum */ FieldType FLOAT_LIST_PACKED;
    public static final /* enum */ FieldType INT64_LIST_PACKED;
    public static final /* enum */ FieldType UINT64_LIST_PACKED;
    public static final /* enum */ FieldType INT32_LIST_PACKED;
    public static final /* enum */ FieldType FIXED64_LIST_PACKED;
    public static final /* enum */ FieldType FIXED32_LIST_PACKED;
    public static final /* enum */ FieldType BOOL_LIST_PACKED;
    public static final /* enum */ FieldType UINT32_LIST_PACKED;
    public static final /* enum */ FieldType ENUM_LIST_PACKED;
    public static final /* enum */ FieldType SFIXED32_LIST_PACKED;
    public static final /* enum */ FieldType SFIXED64_LIST_PACKED;
    public static final /* enum */ FieldType SINT32_LIST_PACKED;
    public static final /* enum */ FieldType SINT64_LIST_PACKED;
    public static final /* enum */ FieldType GROUP_LIST;
    public static final /* enum */ FieldType MAP;
    private final JavaType javaType;
    private final int id;
    private final Collection collection;
    private final Class<?> elementType;
    private final boolean primitiveScalar;
    private static final FieldType[] VALUES;
    private static final Type[] EMPTY_TYPES;
    private static final /* synthetic */ FieldType[] $VALUES;

    public static FieldType[] values() {
        return (FieldType[])$VALUES.clone();
    }

    public static FieldType valueOf(String name) {
        String string;
        return Enum.valueOf(FieldType.class, string);
    }

    /*
     * WARNING - void declaration
     */
    private FieldType(int id, Collection collection, JavaType javaType) {
        void var1_2;
        void var3_4;
        this.id = var3_4;
        this.collection = collection;
        this.javaType = javaType;
        switch (collection) {
            case MAP: {
                this.elementType = javaType.getBoxedType();
                break;
            }
            case VECTOR: {
                this.elementType = javaType.getBoxedType();
                break;
            }
            default: {
                this.elementType = null;
            }
        }
        boolean primitiveScalar = false;
        if (collection == Collection.SCALAR) {
            switch (javaType) {
                case BYTE_STRING: 
                case MESSAGE: 
                case STRING: {
                    break;
                }
                default: {
                    primitiveScalar = true;
                }
            }
        }
        this.primitiveScalar = var1_2;
    }

    public final int id() {
        return this.id;
    }

    public final JavaType getJavaType() {
        return this.javaType;
    }

    public final boolean isPacked() {
        return Collection.PACKED_VECTOR.equals((Object)this.collection);
    }

    public final boolean isPrimitiveScalar() {
        return this.primitiveScalar;
    }

    public final boolean isScalar() {
        return this.collection == Collection.SCALAR;
    }

    public final boolean isList() {
        return this.collection.isList();
    }

    public final boolean isMap() {
        return this.collection == Collection.MAP;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidForField(Field field) {
        void var1_1;
        if (Collection.VECTOR.equals((Object)this.collection)) {
            return this.isValidForList(field);
        }
        return this.javaType.getType().isAssignableFrom(var1_1.getType());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidForList(Field field) {
        void var1_1;
        void var3_3;
        void var2_2;
        Type listParameter;
        Class<?> clazz = field.getType();
        if (!this.javaType.getType().isAssignableFrom(clazz)) {
            return false;
        }
        Type[] types = EMPTY_TYPES;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        }
        if (!((listParameter = FieldType.getListParameter(var2_2, (Type[])var3_3)) instanceof Class)) {
            return true;
        }
        return this.elementType.isAssignableFrom((Class)var1_1);
    }

    public static FieldType forId(int id) {
        int n;
        if (id < 0 || id >= VALUES.length) {
            return null;
        }
        return VALUES[n];
    }

    /*
     * WARNING - void declaration
     */
    private static Type getGenericSuperList(Class<?> clazz) {
        Class<?> clazz2;
        Type[] typeArray = clazz.getGenericInterfaces();
        Type[] typeArray2 = typeArray;
        typeArray2 = typeArray;
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            ParameterizedType parameterizedType;
            Class rawType;
            Type genericInterface = typeArray2[i];
            if (!(genericInterface instanceof ParameterizedType) || !List.class.isAssignableFrom(rawType = (Class)(parameterizedType = (ParameterizedType)genericInterface).getRawType())) continue;
            return genericInterface;
        }
        Type type = clazz2.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            void var3_5;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom((Class<?>)var3_5)) {
                return typeArray2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Type getListParameter(Class<?> clazz, Type[] realTypes) {
        void var1_1;
        block0: while (clazz != List.class) {
            Class<?>[] classArray;
            Type genericType = FieldType.getGenericSuperList(clazz);
            if (genericType instanceof ParameterizedType) {
                void var3_3;
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type[] superArgs = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < superArgs.length; ++i) {
                    Type superArg = superArgs[i];
                    if (!(superArg instanceof TypeVariable)) continue;
                    TypeVariable<Class<T>>[] clazzParams = clazz.getTypeParameters();
                    if (realTypes.length != clazzParams.length) {
                        throw new RuntimeException("Type array mismatch");
                    }
                    boolean foundReplacement = false;
                    for (int j = 0; j < clazzParams.length; ++j) {
                        Type realType;
                        if (superArg != clazzParams[j]) continue;
                        superArgs[i] = realType = realTypes[j];
                        foundReplacement = true;
                        break;
                    }
                    if (foundReplacement) continue;
                    throw new RuntimeException("Unable to find replacement for " + superArg);
                }
                Class<?> parent = (Class<?>)classArray.getRawType();
                realTypes = var3_3;
                clazz = parent;
                continue;
            }
            realTypes = EMPTY_TYPES;
            classArray = clazz.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> iface = classArray[i];
                if (!List.class.isAssignableFrom(iface)) continue;
                clazz = iface;
                continue block0;
            }
            clazz = clazz.getSuperclass();
        }
        if (realTypes.length != 1) {
            throw new RuntimeException("Unable to identify parameter type for List<T>");
        }
        return var1_1[0];
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        DOUBLE = new FieldType(0, Collection.SCALAR, JavaType.DOUBLE);
        FLOAT = new FieldType(1, Collection.SCALAR, JavaType.FLOAT);
        INT64 = new FieldType(2, Collection.SCALAR, JavaType.LONG);
        UINT64 = new FieldType(3, Collection.SCALAR, JavaType.LONG);
        INT32 = new FieldType(4, Collection.SCALAR, JavaType.INT);
        FIXED64 = new FieldType(5, Collection.SCALAR, JavaType.LONG);
        FIXED32 = new FieldType(6, Collection.SCALAR, JavaType.INT);
        BOOL = new FieldType(7, Collection.SCALAR, JavaType.BOOLEAN);
        STRING = new FieldType(8, Collection.SCALAR, JavaType.STRING);
        MESSAGE = new FieldType(9, Collection.SCALAR, JavaType.MESSAGE);
        BYTES = new FieldType(10, Collection.SCALAR, JavaType.BYTE_STRING);
        UINT32 = new FieldType(11, Collection.SCALAR, JavaType.INT);
        ENUM = new FieldType(12, Collection.SCALAR, JavaType.ENUM);
        SFIXED32 = new FieldType(13, Collection.SCALAR, JavaType.INT);
        SFIXED64 = new FieldType(14, Collection.SCALAR, JavaType.LONG);
        SINT32 = new FieldType(15, Collection.SCALAR, JavaType.INT);
        SINT64 = new FieldType(16, Collection.SCALAR, JavaType.LONG);
        GROUP = new FieldType(17, Collection.SCALAR, JavaType.MESSAGE);
        DOUBLE_LIST = new FieldType(18, Collection.VECTOR, JavaType.DOUBLE);
        FLOAT_LIST = new FieldType(19, Collection.VECTOR, JavaType.FLOAT);
        INT64_LIST = new FieldType(20, Collection.VECTOR, JavaType.LONG);
        UINT64_LIST = new FieldType(21, Collection.VECTOR, JavaType.LONG);
        INT32_LIST = new FieldType(22, Collection.VECTOR, JavaType.INT);
        FIXED64_LIST = new FieldType(23, Collection.VECTOR, JavaType.LONG);
        FIXED32_LIST = new FieldType(24, Collection.VECTOR, JavaType.INT);
        BOOL_LIST = new FieldType(25, Collection.VECTOR, JavaType.BOOLEAN);
        STRING_LIST = new FieldType(26, Collection.VECTOR, JavaType.STRING);
        MESSAGE_LIST = new FieldType(27, Collection.VECTOR, JavaType.MESSAGE);
        BYTES_LIST = new FieldType(28, Collection.VECTOR, JavaType.BYTE_STRING);
        UINT32_LIST = new FieldType(29, Collection.VECTOR, JavaType.INT);
        ENUM_LIST = new FieldType(30, Collection.VECTOR, JavaType.ENUM);
        SFIXED32_LIST = new FieldType(31, Collection.VECTOR, JavaType.INT);
        SFIXED64_LIST = new FieldType(32, Collection.VECTOR, JavaType.LONG);
        SINT32_LIST = new FieldType(33, Collection.VECTOR, JavaType.INT);
        SINT64_LIST = new FieldType(34, Collection.VECTOR, JavaType.LONG);
        DOUBLE_LIST_PACKED = new FieldType(35, Collection.PACKED_VECTOR, JavaType.DOUBLE);
        FLOAT_LIST_PACKED = new FieldType(36, Collection.PACKED_VECTOR, JavaType.FLOAT);
        INT64_LIST_PACKED = new FieldType(37, Collection.PACKED_VECTOR, JavaType.LONG);
        UINT64_LIST_PACKED = new FieldType(38, Collection.PACKED_VECTOR, JavaType.LONG);
        INT32_LIST_PACKED = new FieldType(39, Collection.PACKED_VECTOR, JavaType.INT);
        FIXED64_LIST_PACKED = new FieldType(40, Collection.PACKED_VECTOR, JavaType.LONG);
        FIXED32_LIST_PACKED = new FieldType(41, Collection.PACKED_VECTOR, JavaType.INT);
        BOOL_LIST_PACKED = new FieldType(42, Collection.PACKED_VECTOR, JavaType.BOOLEAN);
        UINT32_LIST_PACKED = new FieldType(43, Collection.PACKED_VECTOR, JavaType.INT);
        ENUM_LIST_PACKED = new FieldType(44, Collection.PACKED_VECTOR, JavaType.ENUM);
        SFIXED32_LIST_PACKED = new FieldType(45, Collection.PACKED_VECTOR, JavaType.INT);
        SFIXED64_LIST_PACKED = new FieldType(46, Collection.PACKED_VECTOR, JavaType.LONG);
        SINT32_LIST_PACKED = new FieldType(47, Collection.PACKED_VECTOR, JavaType.INT);
        SINT64_LIST_PACKED = new FieldType(48, Collection.PACKED_VECTOR, JavaType.LONG);
        GROUP_LIST = new FieldType(49, Collection.VECTOR, JavaType.MESSAGE);
        MAP = new FieldType(50, Collection.MAP, JavaType.VOID);
        $VALUES = new FieldType[]{DOUBLE, FLOAT, INT64, UINT64, INT32, FIXED64, FIXED32, BOOL, STRING, MESSAGE, BYTES, UINT32, ENUM, SFIXED32, SFIXED64, SINT32, SINT64, GROUP, DOUBLE_LIST, FLOAT_LIST, INT64_LIST, UINT64_LIST, INT32_LIST, FIXED64_LIST, FIXED32_LIST, BOOL_LIST, STRING_LIST, MESSAGE_LIST, BYTES_LIST, UINT32_LIST, ENUM_LIST, SFIXED32_LIST, SFIXED64_LIST, SINT32_LIST, SINT64_LIST, DOUBLE_LIST_PACKED, FLOAT_LIST_PACKED, INT64_LIST_PACKED, UINT64_LIST_PACKED, INT32_LIST_PACKED, FIXED64_LIST_PACKED, FIXED32_LIST_PACKED, BOOL_LIST_PACKED, UINT32_LIST_PACKED, ENUM_LIST_PACKED, SFIXED32_LIST_PACKED, SFIXED64_LIST_PACKED, SINT32_LIST_PACKED, SINT64_LIST_PACKED, GROUP_LIST, MAP};
        EMPTY_TYPES = new Type[0];
        FieldType[] values = FieldType.values();
        VALUES = new FieldType[values.length];
        for (void type : var0) {
            void var3_3;
            FieldType.VALUES[type.id] = var3_3;
        }
    }

    static enum Collection {
        SCALAR(false),
        VECTOR(true),
        PACKED_VECTOR(true),
        MAP(false);

        private final boolean isList;

        /*
         * WARNING - void declaration
         */
        private Collection(boolean isList) {
            void var3_3;
            this.isList = var3_3;
        }

        public final boolean isList() {
            return this.isList;
        }
    }
}

