/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyField;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.MessageLiteOrBuilder;
import androidx.datastore.preferences.protobuf.SmallSortedMap;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet<?> DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap();
    }

    private FieldSet(boolean dummy) {
        this(SmallSortedMap.newFieldMap());
        this.makeImmutable();
    }

    /*
     * WARNING - void declaration
     */
    private FieldSet(SmallSortedMap<T, Object> fields) {
        void var1_1;
        this.fields = var1_1;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder();
    }

    final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        int n = this.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            void var3_3;
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            if (!(entry.getValue() instanceof GeneratedMessageLite)) continue;
            ((GeneratedMessageLite)var3_3.getValue()).makeImmutable();
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public final boolean isImmutable() {
        return this.isImmutable;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        return this.fields.equals(var1_1.fields);
    }

    public final int hashCode() {
        return this.fields.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final FieldSet<T> clone() {
        void var1_1;
        FieldSet<FieldDescriptorLite> clone = FieldSet.newFieldSet();
        int n = this.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        clone.hasLazyField = this.hasLazyField;
        return var1_1;
    }

    public final void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            void var1_1;
            SmallSortedMap<T, Object> result = FieldSet.cloneAllFieldsMap(this.fields, false, true);
            if (this.fields.isImmutable()) {
                result.makeImmutable();
            }
            return var1_1;
        }
        if (this.fields.isImmutable()) {
            return this.fields;
        }
        return Collections.unmodifiableMap(this.fields);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> fields, boolean copyList, boolean resolveLazyFields) {
        void var3_5;
        SmallSortedMap result = SmallSortedMap.newFieldMap();
        int n = fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            FieldSet.cloneFieldEntry(result, fields.getArrayEntryAt(i), (boolean)copyList, (boolean)resolveLazyFields);
        }
        for (Map.Entry<T, Object> entry : fields.getOverflowEntries()) {
            void var0_2;
            FieldSet.cloneFieldEntry(result, var0_2, (boolean)copyList, (boolean)resolveLazyFields);
        }
        return var3_5;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends FieldDescriptorLite<T>> void cloneFieldEntry(Map<T, Object> map, Map.Entry<T, Object> entry, boolean copyList, boolean resolveLazyFields) {
        void var1_1;
        Map<T, Object> map2;
        void var2_2;
        void var3_3;
        FieldDescriptorLite key = (FieldDescriptorLite)entry.getKey();
        Object value = entry.getValue();
        if (var3_3 != false && value instanceof LazyField) {
            map.put(key, ((LazyField)value).getValue());
            return;
        }
        if (var2_2 != false && value instanceof List) {
            map.put(key, new ArrayList((List)value));
            return;
        }
        map2.put(key, var1_1);
    }

    public final Iterator<Map.Entry<T, Object>> iterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    final Iterator<Map.Entry<T, Object>> descendingIterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
        }
        return this.fields.descendingEntrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasField(T descriptor) {
        void var1_1;
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getField(T descriptor) {
        void var1_1;
        Object o = this.fields.get(descriptor);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setField(T descriptor, Object value) {
        void var2_2;
        void var1_1;
        if (descriptor.isRepeated()) {
            void var3_3;
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll((List)((Object)value));
            for (Object element : newList) {
                this.verifyType(descriptor, element);
            }
            value = var3_3;
        } else {
            this.verifyType(descriptor, value);
        }
        if (value instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void clearField(T descriptor) {
        void var1_1;
        this.fields.remove(var1_1);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getRepeatedFieldCount(T descriptor) {
        void var1_1;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value = this.getField(descriptor);
        if (value == null) {
            return 0;
        }
        return ((List)var1_1).size();
    }

    /*
     * WARNING - void declaration
     */
    public final Object getRepeatedField(T descriptor, int index) {
        void var2_2;
        void var1_1;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value = this.getField(descriptor);
        if (value == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)var1_1).get((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRepeatedField(T descriptor, int index, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object list = this.getField(descriptor);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyType(var1_1, value);
        ((List)list).set((int)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void addRepeatedField(T descriptor, Object value) {
        void var2_2;
        void var3_3;
        ArrayList list;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(descriptor, value);
        Object existingValue = this.getField(descriptor);
        if (existingValue == null) {
            void var1_1;
            list = new ArrayList();
            this.fields.put(var1_1, (Object)list);
        } else {
            list = list;
        }
        var3_3.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyType(T descriptor, Object value) {
        if (!FieldSet.isValidType(descriptor.getLiteType(), value)) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), var1_1.getLiteType().getJavaType(), var2_2.getClass().getName()}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isValidType(WireFormat.FieldType type, Object value) {
        WireFormat.FieldType fieldType;
        Internal.checkNotNull(value);
        switch (fieldType.getJavaType()) {
            case INT: {
                return value instanceof Integer;
            }
            case LONG: {
                return value instanceof Long;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case BYTE_STRING: {
                return value instanceof ByteString || value instanceof byte[];
            }
            case ENUM: {
                return value instanceof Integer || value instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                void var1_1;
                return value instanceof MessageLite || var1_1 instanceof LazyField;
            }
        }
        return false;
    }

    public final boolean isInitialized() {
        int n = this.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (descriptor.isRepeated()) {
                List list = (List)entry.getValue();
                int listSize = list.size();
                for (int i = 0; i < listSize; ++i) {
                    Object e = list.get(i);
                    if (FieldSet.isMessageFieldValueInitialized(e)) continue;
                    return false;
                }
            } else {
                List list;
                return FieldSet.isMessageFieldValueInitialized(list.getValue());
            }
        }
        return true;
    }

    private static boolean isMessageFieldValueInitialized(Object value) {
        Object object;
        if (value instanceof MessageLiteOrBuilder) {
            return ((MessageLiteOrBuilder)value).isInitialized();
        }
        if (object instanceof LazyField) {
            return true;
        }
        throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type, boolean isPacked) {
        WireFormat.FieldType fieldType;
        if (isPacked) {
            return 2;
        }
        return fieldType.getWireType();
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeFrom(FieldSet<T> other) {
        int n = other.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            this.mergeFromField(other.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : other.fields.getOverflowEntries()) {
            void var1_1;
            this.mergeFromField((Map.Entry<T, Object>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object cloneIfMutable(Object value) {
        Object object;
        if (value instanceof byte[]) {
            void var1_1;
            byte[] byArray = (byte[])value;
            Object bytes = byArray;
            byte[] copy = new byte[byArray.length];
            System.arraycopy(bytes, 0, copy, 0, ((Object)object).length);
            return var1_1;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeFromField(Map.Entry<T, Object> entry) {
        block9: {
            void var1_1;
            void var2_2;
            void var3_3;
            block6: {
                block8: {
                    Object value;
                    Object otherValue;
                    FieldDescriptorLite descriptor;
                    block7: {
                        descriptor = (FieldDescriptorLite)entry.getKey();
                        otherValue = entry.getValue();
                        boolean isLazyField = otherValue instanceof LazyField;
                        if (descriptor.isRepeated()) {
                            if (isLazyField) {
                                throw new IllegalStateException("Lazy fields can not be repeated");
                            }
                            ArrayList value2 = this.getField(descriptor);
                            if (value2 == null) {
                                value2 = new ArrayList();
                            }
                            for (Object element : (List)otherValue) {
                                void var3_4;
                                ((List)value2).add(FieldSet.cloneIfMutable(var3_4));
                            }
                            this.fields.put((T)descriptor, (Object)value2);
                            return;
                        }
                        if (descriptor.getLiteJavaType() != WireFormat.JavaType.MESSAGE) break block6;
                        value = this.getField(descriptor);
                        if (value != null) break block7;
                        this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
                        if (var3_3 == false) break block8;
                        this.hasLazyField = true;
                        break block9;
                    }
                    if (otherValue instanceof LazyField) {
                        otherValue = ((LazyField)otherValue).getValue();
                    }
                    value = descriptor.internalMergeFrom(((MessageLite)value).toBuilder(), (MessageLite)otherValue).build();
                    this.fields.put((T)descriptor, value);
                }
                return;
            }
            if (var3_3 != false) {
                throw new IllegalStateException("Lazy fields must be message-valued");
            }
            this.fields.put(var2_2, FieldSet.cloneIfMutable(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type, boolean checkUtf8) throws IOException {
        void var1_1;
        CodedInputStream codedInputStream;
        if (checkUtf8) {
            return WireFormat.readPrimitiveField(input, type, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(codedInputStream, (WireFormat.FieldType)var1_1, WireFormat.Utf8Validation.LOOSE);
    }

    public final void writeTo(CodedOutputStream output) throws IOException {
        int n = this.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeMessageSetTo(CodedOutputStream output) throws IOException {
        int n = this.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            FieldSet fieldSet = this;
            fieldSet.writeMessageSetTo(fieldSet.fields.getArrayEntryAt(i), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var2_3;
            this.writeMessageSetTo((Map.Entry<T, Object>)var2_3, output);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream output) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Object value = entry.getValue();
            if (value instanceof LazyField) {
                ByteString valueBytes = ((LazyField)value).toByteString();
                output.writeRawMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (ByteString)var3_3);
                return;
            }
            output.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)var3_3);
            return;
        }
        FieldSet.writeField(var3_3, var1_1.getValue(), (CodedOutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void writeElement(CodedOutputStream output, WireFormat.FieldType type, int number, Object value) throws IOException {
        void var3_3;
        void var1_1;
        CodedOutputStream codedOutputStream;
        void var2_2;
        if (type == WireFormat.FieldType.GROUP) {
            output.writeGroup(number, (MessageLite)value);
            return;
        }
        output.writeTag((int)var2_2, FieldSet.getWireFormatForFieldType(type, false));
        FieldSet.writeElementNoTag(codedOutputStream, (WireFormat.FieldType)var1_1, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type, Object value) throws IOException {
        void var1_1;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var1_1.ordinal()]) {
            case 1: {
                output.writeDoubleNoTag((Double)value);
                return;
            }
            case 2: {
                output.writeFloatNoTag(((Float)value).floatValue());
                return;
            }
            case 3: {
                output.writeInt64NoTag((Long)value);
                return;
            }
            case 4: {
                output.writeUInt64NoTag((Long)value);
                return;
            }
            case 5: {
                output.writeInt32NoTag((Integer)value);
                return;
            }
            case 6: {
                output.writeFixed64NoTag((Long)value);
                return;
            }
            case 7: {
                output.writeFixed32NoTag((Integer)value);
                return;
            }
            case 8: {
                output.writeBoolNoTag((Boolean)value);
                return;
            }
            case 9: {
                output.writeGroupNoTag((MessageLite)value);
                return;
            }
            case 10: {
                output.writeMessageNoTag((MessageLite)value);
                return;
            }
            case 11: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeStringNoTag((String)value);
                return;
            }
            case 12: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeByteArrayNoTag((byte[])value);
                return;
            }
            case 13: {
                output.writeUInt32NoTag((Integer)value);
                return;
            }
            case 14: {
                output.writeSFixed32NoTag((Integer)value);
                return;
            }
            case 15: {
                output.writeSFixed64NoTag((Long)value);
                return;
            }
            case 16: {
                output.writeSInt32NoTag((Integer)value);
                return;
            }
            case 17: {
                output.writeSInt64NoTag((Long)value);
                return;
            }
            case 18: {
                void var2_2;
                CodedOutputStream codedOutputStream;
                if (value instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value).getNumber());
                    return;
                }
                codedOutputStream.writeEnumNoTag((Integer)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void writeField(FieldDescriptorLite<?> descriptor, Object value, CodedOutputStream output) throws IOException {
        void var3_5;
        void var2_4;
        void var1_3;
        void var4_6;
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List valueList = (List)value;
            int valueListSize = valueList.size();
            if (descriptor.isPacked()) {
                int i;
                Object element;
                if (valueList.isEmpty()) {
                    return;
                }
                output.writeTag(number, 2);
                int dataSize = 0;
                for (i = 0; i < valueListSize; dataSize += FieldSet.computeElementSizeNoTag(type, element), ++i) {
                    element = valueList.get(i);
                }
                output.writeUInt32NoTag(dataSize);
                for (i = 0; i < valueListSize; ++i) {
                    Object element2 = valueList.get(i);
                    FieldSet.writeElementNoTag(output, type, element2);
                }
                return;
            } else {
                int i = 0;
                while (true) {
                    if (i >= valueListSize) {
                        return;
                    }
                    Object element = valueList.get(i);
                    FieldSet.writeElement(output, type, (int)var4_6, element);
                    ++i;
                }
            }
        }
        if (var1_3 instanceof LazyField) {
            FieldSet.writeElement(output, type, (int)var4_6, ((LazyField)var1_3).getValue());
            return;
        }
        FieldSet.writeElement((CodedOutputStream)var2_4, (WireFormat.FieldType)var3_5, (int)var4_6, var1_3);
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSize() {
        void var1_1;
        int size = 0;
        int n = this.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMessageSetSerializedSize() {
        void var1_1;
        int size = 0;
        int n = this.fields.getNumArrayEntries();
        for (int i = 0; i < n; ++i) {
            FieldSet fieldSet = this;
            size += fieldSet.getMessageSetSerializedSize(fieldSet.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var2_3;
            size += this.getMessageSetSerializedSize((Map.Entry<T, Object>)var2_3);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        void var3_3;
        void var2_2;
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object value = entry.getValue();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            void var1_1;
            if (value instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)var1_1.getKey()).getNumber(), (MessageLite)value);
        }
        return FieldSet.computeFieldSize(var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static int computeElementSize(WireFormat.FieldType type, int number, Object value) {
        void var2_2;
        WireFormat.FieldType fieldType;
        void var1_1;
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type == WireFormat.FieldType.GROUP) {
            tagSize <<= 1;
        }
        return (int)(var1_1 + FieldSet.computeElementSizeNoTag(fieldType, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static int computeElementSizeNoTag(WireFormat.FieldType type, Object value) {
        WireFormat.FieldType fieldType;
        switch (fieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value);
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value);
            }
            case STRING: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value);
            }
            case MESSAGE: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
            }
            case ENUM: {
                void var1_1;
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)var1_1);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    /*
     * WARNING - void declaration
     */
    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value) {
        void var1_3;
        void var3_5;
        void var2_4;
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            void var0_2;
            List valueList = (List)value;
            int valueListSize = valueList.size();
            if (descriptor.isPacked()) {
                if (valueList.isEmpty()) {
                    return 0;
                }
                int dataSize = 0;
                for (int i = 0; i < valueListSize; ++i) {
                    Object element = valueList.get(i);
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(dataSize);
            }
            int size = 0;
            for (int i = 0; i < valueListSize; ++i) {
                Object element = valueList.get(i);
                size += FieldSet.computeElementSize(type, number, element);
            }
            return (int)var0_2;
        }
        return FieldSet.computeElementSize((WireFormat.FieldType)var2_4, (int)var3_5, var1_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SmallSortedMap access$100(SmallSortedMap x0, boolean x1, boolean x2) {
        void var2_2;
        void var1_1;
        return FieldSet.cloneAllFieldsMap(x0, (boolean)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$302(FieldSet x0, boolean x1) {
        void var1_1;
        x0.hasLazyField = var1_1;
        return x0.hasLazyField;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$500(WireFormat.FieldType x0, Object x1) {
        void var1_1;
        return FieldSet.isValidType(x0, var1_1);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap());
        }

        /*
         * WARNING - void declaration
         */
        private Builder(SmallSortedMap<T, Object> fields) {
            void var1_1;
            this.fields = var1_1;
            this.isMutable = true;
        }

        public final FieldSet<T> build() {
            return this.buildImpl(false);
        }

        public final FieldSet<T> buildPartial() {
            return this.buildImpl(true);
        }

        /*
         * WARNING - void declaration
         */
        private FieldSet<T> buildImpl(boolean partial) {
            void var1_2;
            void var2_3;
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap fieldsForBuild = this.fields;
            if (this.hasNestedBuilders) {
                fieldsForBuild = FieldSet.access$100(this.fields, false, false);
                Builder.replaceBuilders(fieldsForBuild, partial);
            }
            FieldSet fieldSet = new FieldSet((SmallSortedMap)var2_3);
            FieldSet.access$302(fieldSet, this.hasLazyField);
            return var1_2;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> fieldMap, boolean partial) {
            SmallSortedMap<T, Object> object;
            int n = fieldMap.getNumArrayEntries();
            for (int i = 0; i < n; ++i) {
                Builder.replaceBuilders(fieldMap.getArrayEntryAt(i), (boolean)partial);
            }
            for (Map.Entry<T, Object> entry : object.getOverflowEntries()) {
                Builder.replaceBuilders(entry, (boolean)partial);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry, boolean partial) {
            void var1_1;
            Map.Entry<T, Object> entry2;
            Map.Entry<T, Object> entry3 = entry;
            entry3.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry3.getKey(), entry2.getValue(), (boolean)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T descriptor, Object value, boolean partial) {
            void var1_1;
            if (value == null) {
                return value;
            }
            if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                void var2_2;
                if (descriptor.isRepeated()) {
                    Object object;
                    if (!(value instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + value.getClass());
                    }
                    Object list = (List)value;
                    for (int i = 0; i < list.size(); ++i) {
                        Object oldElement = list.get(i);
                        Object newElement = Builder.replaceBuilder(oldElement, partial);
                        if (newElement == oldElement) continue;
                        if (list == value) {
                            list = new ArrayList(list);
                        }
                        list.set(i, newElement);
                    }
                    return object;
                }
                return Builder.replaceBuilder(value, (boolean)var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static Object replaceBuilder(Object value, boolean partial) {
            Object object;
            void var1_1;
            if (!(value instanceof MessageLite.Builder)) {
                return value;
            }
            Object builder = (MessageLite.Builder)value;
            if (var1_1 != false) {
                return builder.buildPartial();
            }
            return object.build();
        }

        /*
         * WARNING - void declaration
         */
        public static <T extends FieldDescriptorLite<T>> Builder<T> fromFieldSet(FieldSet<T> fieldSet) {
            void var1_1;
            FieldSet<T> fieldSet2;
            Builder<T> builder = new Builder<T>(FieldSet.access$100(((FieldSet)fieldSet).fields, true, false));
            new Builder<T>(FieldSet.access$100(((FieldSet)fieldSet).fields, true, false)).hasLazyField = ((FieldSet)fieldSet2).hasLazyField;
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                void var1_1;
                SmallSortedMap result = FieldSet.access$100(this.fields, false, true);
                if (this.fields.isImmutable()) {
                    result.makeImmutable();
                } else {
                    Builder.replaceBuilders(result, true);
                }
                return var1_1;
            }
            if (this.fields.isImmutable()) {
                return this.fields;
            }
            return Collections.unmodifiableMap(this.fields);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean hasField(T descriptor) {
            void var1_1;
            if (descriptor.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        public final Object getField(T descriptor) {
            void var2_2;
            void var1_1;
            Object value = this.getFieldAllowBuilders(descriptor);
            return Builder.replaceBuilders(var1_1, var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        final Object getFieldAllowBuilders(T descriptor) {
            void var1_1;
            Object o = this.fields.get(descriptor);
            if (o instanceof LazyField) {
                return ((LazyField)o).getValue();
            }
            return var1_1;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.access$100(this.fields, true, false);
                this.isMutable = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void setField(T descriptor, Object value) {
            void var1_1;
            void var2_2;
            this.ensureIsMutable();
            if (descriptor.isRepeated()) {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList newList = new ArrayList((List)value);
                int newListSize = newList.size();
                for (int i = 0; i < newListSize; ++i) {
                    Object element = newList.get(i);
                    this.verifyType(descriptor, element);
                    this.hasNestedBuilders = this.hasNestedBuilders || element instanceof MessageLite.Builder;
                }
            } else {
                this.verifyType(descriptor, var2_2);
            }
            if (var2_2 instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || var2_2 instanceof MessageLite.Builder;
            this.fields.put(var1_1, (Object)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void clearField(T descriptor) {
            void var1_1;
            this.ensureIsMutable();
            this.fields.remove(var1_1);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int getRepeatedFieldCount(T descriptor) {
            void var1_1;
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedFieldCount() can only be called on repeated fields.");
            }
            Object value = this.getFieldAllowBuilders(descriptor);
            if (value == null) {
                return 0;
            }
            return ((List)var1_1).size();
        }

        /*
         * WARNING - void declaration
         */
        public final Object getRepeatedField(T descriptor, int index) {
            void var2_2;
            Object object;
            if (this.hasNestedBuilders) {
                this.ensureIsMutable();
            }
            object = this.getRepeatedFieldAllowBuilders(object, (int)var2_2);
            return Builder.replaceBuilder(object, true);
        }

        /*
         * WARNING - void declaration
         */
        final Object getRepeatedFieldAllowBuilders(T descriptor, int index) {
            void var2_2;
            void var1_1;
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object value = this.getFieldAllowBuilders(descriptor);
            if (value == null) {
                throw new IndexOutOfBoundsException();
            }
            return ((List)var1_1).get((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void setRepeatedField(T descriptor, int index, Object value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            Object list = this.getFieldAllowBuilders(descriptor);
            if (list == null) {
                throw new IndexOutOfBoundsException();
            }
            this.verifyType(var1_1, value);
            ((List)list).set((int)var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public final void addRepeatedField(T descriptor, Object value) {
            void var2_2;
            void var3_3;
            ArrayList list;
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            this.verifyType(descriptor, value);
            Object existingValue = this.getFieldAllowBuilders(descriptor);
            if (existingValue == null) {
                void var1_1;
                list = new ArrayList();
                this.fields.put(var1_1, (Object)list);
            } else {
                list = list;
            }
            var3_3.add(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void verifyType(T descriptor, Object value) {
            if (!FieldSet.access$500(descriptor.getLiteType(), value)) {
                void var2_2;
                void var1_1;
                if (descriptor.getLiteType().getJavaType() == WireFormat.JavaType.MESSAGE && value instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), var1_1.getLiteType().getJavaType(), var2_2.getClass().getName()}));
            }
        }

        public final boolean isInitialized() {
            int n = this.fields.getNumArrayEntries();
            for (int i = 0; i < n; ++i) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void mergeFrom(FieldSet<T> other) {
            this.ensureIsMutable();
            int n = ((FieldSet)other).fields.getNumArrayEntries();
            for (int i = 0; i < n; ++i) {
                this.mergeFromField(((FieldSet)other).fields.getArrayEntryAt(i));
            }
            for (Map.Entry entry : ((FieldSet)other).fields.getOverflowEntries()) {
                void var1_1;
                this.mergeFromField((Map.Entry<T, Object>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private void mergeFromField(Map.Entry<T, Object> entry) {
            void var3_4;
            MessageLite messageLite;
            void var2_2;
            FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
            Object otherValue = entry.getValue();
            boolean isLazyField = otherValue instanceof LazyField;
            if (descriptor.isRepeated()) {
                if (isLazyField) {
                    throw new IllegalStateException("Lazy fields can not be repeated");
                }
                ArrayList<Object> value = (ArrayList<Object>)this.getFieldAllowBuilders(descriptor);
                List otherList = (List)otherValue;
                int otherListSize = otherList.size();
                if (value == null) {
                    value = new ArrayList<Object>(otherListSize);
                    this.fields.put((T)descriptor, (Object)value);
                }
                int i = 0;
                while (i < otherListSize) {
                    Object element = otherList.get(i);
                    value.add(FieldSet.cloneIfMutable(element));
                    ++i;
                }
                return;
            }
            if (var2_2.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                Object value = this.getFieldAllowBuilders(var2_2);
                if (value == null) {
                    this.fields.put(var2_2, FieldSet.cloneIfMutable(messageLite));
                    if (var3_4 == false) return;
                    this.hasLazyField = true;
                    return;
                }
                if (messageLite instanceof LazyField) {
                    messageLite = ((LazyField)((Object)messageLite)).getValue();
                }
                if (value instanceof MessageLite.Builder) {
                    var2_2.internalMergeFrom((MessageLite.Builder)value, messageLite);
                    return;
                }
                value = var2_2.internalMergeFrom(((MessageLite)value).toBuilder(), messageLite).build();
                this.fields.put(var2_2, value);
                return;
            }
            if (var3_4 != false) {
                throw new IllegalStateException("Lazy fields must be message-valued");
            }
            this.fields.put(var2_2, FieldSet.cloneIfMutable(messageLite));
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

