/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.FieldType;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.OneofInfo;
import java.lang.reflect.Field;

@CheckReturnValue
final class FieldInfo
implements Comparable<FieldInfo> {
    private final Field field;
    private final FieldType type;
    private final Class<?> messageClass;
    private final int fieldNumber;
    private final Field presenceField;
    private final int presenceMask;
    private final boolean required;
    private final boolean enforceUtf8;
    private final OneofInfo oneof;
    private final Field cachedSizeField;
    private final Class<?> oneofStoredType;
    private final Object mapDefaultEntry;
    private final Internal.EnumVerifier enumVerifier;

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forField(Field field, int fieldNumber, FieldType fieldType, boolean enforceUtf8) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        if (fieldType == FieldType.MESSAGE_LIST || fieldType == FieldType.GROUP_LIST) {
            throw new IllegalStateException("Shouldn't be called for repeated message fields.");
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, (boolean)var3_3, null, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forPackedField(Field field, int fieldNumber, FieldType fieldType, Field cachedSizeField) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        if (fieldType == FieldType.MESSAGE_LIST || fieldType == FieldType.GROUP_LIST) {
            throw new IllegalStateException("Shouldn't be called for repeated message fields.");
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, false, null, null, null, null, (Field)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forRepeatedMessageField(Field field, int fieldNumber, FieldType fieldType, Class<?> messageClass) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(messageClass, "messageClass");
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, (Class<?>)var3_3, null, 0, false, false, null, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forFieldWithEnumVerifier(Field field, int fieldNumber, FieldType fieldType, Internal.EnumVerifier enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, false, null, null, null, (Internal.EnumVerifier)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forPackedFieldWithEnumVerifier(Field field, int fieldNumber, FieldType fieldType, Internal.EnumVerifier enumVerifier, Field cachedSizeField) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, false, null, null, null, (Internal.EnumVerifier)var3_3, cachedSizeField);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forExplicitPresenceField(Field field, int fieldNumber, FieldType fieldType, Field presenceField, int presenceMask, boolean enforceUtf8, Internal.EnumVerifier enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(presenceField, "presenceField");
        if (presenceField != null && !FieldInfo.isExactlyOneBitSet(presenceMask)) {
            throw new IllegalArgumentException("presenceMask must have exactly one bit set: " + presenceMask);
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, (Field)var3_3, presenceMask, false, enforceUtf8, null, null, null, enumVerifier, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forOneofMemberField(int fieldNumber, FieldType fieldType, OneofInfo oneof, Class<?> oneofStoredType, boolean enforceUtf8, Internal.EnumVerifier enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(oneof, "oneof");
        Internal.checkNotNull(oneofStoredType, "oneofStoredType");
        if (!fieldType.isScalar()) {
            throw new IllegalArgumentException("Oneof is only supported for scalar fields. Field " + fieldNumber + " is of type " + (Object)((Object)fieldType));
        }
        return new FieldInfo(null, n, (FieldType)var1_1, null, null, 0, false, enforceUtf8, (OneofInfo)var2_2, (Class<?>)var3_3, null, enumVerifier, null);
    }

    private static void checkFieldNumber(int fieldNumber) {
        if (fieldNumber <= 0) {
            int n;
            throw new IllegalArgumentException("fieldNumber must be positive: " + n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forLegacyRequiredField(Field field, int fieldNumber, FieldType fieldType, Field presenceField, int presenceMask, boolean enforceUtf8, Internal.EnumVerifier enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(presenceField, "presenceField");
        if (presenceField != null && !FieldInfo.isExactlyOneBitSet(presenceMask)) {
            throw new IllegalArgumentException("presenceMask must have exactly one bit set: " + presenceMask);
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, (Field)var3_3, presenceMask, true, enforceUtf8, null, null, null, enumVerifier, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forMapField(Field field, int fieldNumber, Object mapDefaultEntry, Internal.EnumVerifier enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        Internal.checkNotNull(mapDefaultEntry, "mapDefaultEntry");
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field2, (int)var1_1, FieldType.MAP, null, null, 0, false, true, null, null, var2_2, (Internal.EnumVerifier)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    private FieldInfo(Field field, int fieldNumber, FieldType type, Class<?> messageClass, Field presenceField, int presenceMask, boolean required, boolean enforceUtf8, OneofInfo oneof, Class<?> oneofStoredType, Object mapDefaultEntry, Internal.EnumVerifier enumVerifier, Field cachedSizeField) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.field = var1_1;
        this.type = var3_3;
        this.messageClass = messageClass;
        this.fieldNumber = var2_2;
        this.presenceField = presenceField;
        this.presenceMask = presenceMask;
        this.required = required;
        this.enforceUtf8 = enforceUtf8;
        this.oneof = oneof;
        this.oneofStoredType = oneofStoredType;
        this.mapDefaultEntry = mapDefaultEntry;
        this.enumVerifier = enumVerifier;
        this.cachedSizeField = cachedSizeField;
    }

    public final int getFieldNumber() {
        return this.fieldNumber;
    }

    public final Field getField() {
        return this.field;
    }

    public final FieldType getType() {
        return this.type;
    }

    public final OneofInfo getOneof() {
        return this.oneof;
    }

    public final Class<?> getOneofStoredType() {
        return this.oneofStoredType;
    }

    public final Internal.EnumVerifier getEnumVerifier() {
        return this.enumVerifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(FieldInfo o) {
        void var1_1;
        return this.fieldNumber - var1_1.fieldNumber;
    }

    public final Class<?> getListElementType() {
        return this.messageClass;
    }

    public final Field getPresenceField() {
        return this.presenceField;
    }

    public final Object getMapDefaultEntry() {
        return this.mapDefaultEntry;
    }

    public final int getPresenceMask() {
        return this.presenceMask;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final boolean isEnforceUtf8() {
        return this.enforceUtf8;
    }

    public final Field getCachedSizeField() {
        return this.cachedSizeField;
    }

    public final Class<?> getMessageFieldClass() {
        switch (this.type) {
            case MESSAGE: 
            case GROUP: {
                if (this.field != null) {
                    return this.field.getType();
                }
                return this.oneofStoredType;
            }
            case MESSAGE_LIST: 
            case GROUP_LIST: {
                return this.messageClass;
            }
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static boolean isExactlyOneBitSet(int value) {
        if (value != 0) {
            int n;
            int n2 = n;
            if ((n2 & n2 - 1) == 0) {
                return true;
            }
        }
        return false;
    }

    public static final class Builder {
        private Field field;
        private FieldType type;
        private int fieldNumber;
        private Field presenceField;
        private int presenceMask;
        private boolean required;
        private boolean enforceUtf8;
        private OneofInfo oneof;
        private Class<?> oneofStoredType;
        private Object mapDefaultEntry;
        private Internal.EnumVerifier enumVerifier;
        private Field cachedSizeField;

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withField(Field field) {
            void var1_1;
            if (this.oneof != null) {
                throw new IllegalStateException("Cannot set field when building a oneof.");
            }
            this.field = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withType(FieldType type) {
            void var1_1;
            this.type = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withFieldNumber(int fieldNumber) {
            void var1_1;
            this.fieldNumber = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withPresence(Field presenceField, int presenceMask) {
            void var2_2;
            void var1_1;
            this.presenceField = (Field)Internal.checkNotNull(var1_1, "presenceField");
            this.presenceMask = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withOneof(OneofInfo oneof, Class<?> oneofStoredType) {
            void var2_2;
            void var1_1;
            if (this.field != null || this.presenceField != null) {
                throw new IllegalStateException("Cannot set oneof when field or presenceField have been provided");
            }
            this.oneof = var1_1;
            this.oneofStoredType = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withRequired(boolean required) {
            void var1_1;
            this.required = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withMapDefaultEntry(Object mapDefaultEntry) {
            void var1_1;
            this.mapDefaultEntry = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withEnforceUtf8(boolean enforceUtf8) {
            void var1_1;
            this.enforceUtf8 = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withEnumVerifier(Internal.EnumVerifier enumVerifier) {
            void var1_1;
            this.enumVerifier = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withCachedSizeField(Field cachedSizeField) {
            void var1_1;
            this.cachedSizeField = var1_1;
            return this;
        }

        public final FieldInfo build() {
            if (this.oneof != null) {
                return FieldInfo.forOneofMemberField(this.fieldNumber, this.type, this.oneof, this.oneofStoredType, this.enforceUtf8, this.enumVerifier);
            }
            if (this.mapDefaultEntry != null) {
                return FieldInfo.forMapField(this.field, this.fieldNumber, this.mapDefaultEntry, this.enumVerifier);
            }
            if (this.presenceField != null) {
                if (this.required) {
                    return FieldInfo.forLegacyRequiredField(this.field, this.fieldNumber, this.type, this.presenceField, this.presenceMask, this.enforceUtf8, this.enumVerifier);
                }
                return FieldInfo.forExplicitPresenceField(this.field, this.fieldNumber, this.type, this.presenceField, this.presenceMask, this.enforceUtf8, this.enumVerifier);
            }
            if (this.enumVerifier != null) {
                if (this.cachedSizeField == null) {
                    return FieldInfo.forFieldWithEnumVerifier(this.field, this.fieldNumber, this.type, this.enumVerifier);
                }
                return FieldInfo.forPackedFieldWithEnumVerifier(this.field, this.fieldNumber, this.type, this.enumVerifier, this.cachedSizeField);
            }
            if (this.cachedSizeField == null) {
                return FieldInfo.forField(this.field, this.fieldNumber, this.type, this.enforceUtf8);
            }
            return FieldInfo.forPackedField(this.field, this.fieldNumber, this.type, this.cachedSizeField);
        }
    }
}

